/* BenesFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;
import org.grinvin.graphs.Annotation;
import org.grinvin.graphs.Embedding;
import org.grinvin.graphs.Graph;
import org.grinvin.graphs.Vertex;

/**
 * Factory for butterflies of given dimension.
 */
public class BenesFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding, Annotation annotation) {
        int r = ((Integer)values[0]).intValue(); //r = dimension
	int rows = 1 << r;
        int order = rows*(2*r+1);
	Vertex[] vertices = new Vertex[order];
        embedding.setDimension(2);
	for(int i = 0; i <= 2*r; i++)
	    for(int j = 0; j < rows; j++){
		double[] coords = new double[2];
		coords[0] = i*1.0/r - 1;
		coords[1] = j*2.0/(rows-1) - 1;
		vertices[i*rows + j] = graph.addNewVertex();
		embedding.setCoordinates(vertices[i*rows + j], coords);
	    }

	for(int i = 0; i < r; i++){
	    int mask = 1 << (r-1-i);
	    for(int j = 0; j < rows; j++){
		graph.addNewEdge(vertices[i*rows + j], vertices[(i+1)*rows + j]);
		graph.addNewEdge(vertices[i*rows + j], vertices[(i+1)*rows + (j^mask)]);
		graph.addNewEdge(vertices[(2*r-i)*rows + j], vertices[(2*r-i-1)*rows + j]);
		graph.addNewEdge(vertices[(2*r-i)*rows + j], vertices[(2*r-i-1)*rows + (j^mask)]);
	    }
	}
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        int dimension = ((Integer)values[0]).intValue();
        if (dimension < 1 || dimension > 12)
            throw new FactoryParameterException("Dimension should be between 1 and 12.");
    }
}
