/* WheelGraphFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.Embedding;
import org.grinvin.Graph;
import org.grinvin.Vertex;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;


/**
 * Factory for wheel graphs of the given order.
 */
public class WheelGraphFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding) {
        int order = ((Integer)values[0]).intValue();
        Vertex[] vertices = createCycle(graph, embedding, order-1);
        Vertex hub = graph.addNewVertex(null);
        for (int i=1; i < order; i++)
            graph.addNewEdge(vertices[i-1], hub, null);
        for (int i=1; i < order-1; i++)
            graph.addNewEdge(vertices[i-1], vertices[i], null);
        graph.addNewEdge(vertices[order-2], vertices[0], null);
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        if (((Integer)values[0]).intValue() < 4)
            throw new FactoryParameterException("Order should be at least 4");
    }
    
}
