/* LCFFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.Embedding;
import org.grinvin.Graph;
import org.grinvin.Vertex;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;
import org.grinvin.params.IntegerList;


/**
 * Factory for graph with LCF notation.
 */
public class LCFFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding) {
        int order = ((Integer)values[0]).intValue();
        IntegerList lcf = (IntegerList)values[1];
        int exponent = ((Integer)values[2]).intValue();
        
        //create hamiltonian cycle
        Vertex[] vertices = createCycle(graph, embedding, order);
        for (int i=1; i < order; i++)
            graph.addNewEdge(vertices[i-1], vertices[i], null);
        graph.addNewEdge(vertices[order-1], vertices[0], null);
        
        //add other edges
        int i = order;
        for(int j=0; j<exponent; j++)
            for(int k=0; k<lcf.getLength(); k++){
                if(!graph.areAdjacent(vertices[i%order], vertices[(i-lcf.getIntegerAt(k)+order)%order]))
                    graph.addNewEdge(vertices[i%order], vertices[(i-lcf.getIntegerAt(k)+order)%order],null);
                i--;
            }
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        if (((Integer)values[0]).intValue() < 3)
            throw new FactoryParameterException("Order should be at least 3");
        if (((IntegerList)values[1]).getLength() < 0)
            throw new FactoryParameterException("LCF notation should contain only integers seperated by commas");
    }
    
}
