/* GearGraphFactory.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.factories.graphs.standard;

import org.grinvin.Embedding;
import org.grinvin.Graph;
import org.grinvin.Vertex;
import org.grinvin.factories.FactoryParameterException;
import org.grinvin.factories.graphs.AbstractGraphFactory;

/**
 * Factory that creates gear graphs with the given number of spokes.
 */
public class GearGraphFactory extends AbstractGraphFactory {
    
    //
    @Override
    protected void createGraph(Graph graph, Embedding embedding) {
        int spokes = ((Integer)values[0]).intValue();
        Vertex[] vertices = createCycle(graph, embedding, spokes);
        Vertex hub = graph.addNewVertex(null);
        // add the spokes
        for (int i=0; i < spokes; i++)
            graph.addNewEdge(vertices[i], hub, null);
        // add extra vertex on every edge of the cycle
        for (int i=1; i < spokes; i++) {
            Vertex v = graph.addNewVertex(null);
            double first[] = embedding.getCoordinates(vertices[i-1]);
            double second[] = embedding.getCoordinates(vertices[i]);
            embedding.setCoordinates(v, new double[] { (first[0] + second[0]) / 2, (first[1] + second[1]) / 2 });
            graph.addNewEdge(vertices[i-1], v, null);
            graph.addNewEdge(v, vertices[i], null);
        }
        Vertex v = graph.addNewVertex(null);
        double first[] = embedding.getCoordinates(vertices[spokes-1]);
        double second[] = embedding.getCoordinates(vertices[0]);
        embedding.setCoordinates(v, new double[] { (first[0] + second[0]) / 2, (first[1] + second[1]) / 2 });
        graph.addNewEdge(vertices[spokes-1], v, null);
        graph.addNewEdge(v, vertices[0], null);
    }
    
    //
    @Override
    protected void checkParameters(Object[] values) throws FactoryParameterException {
        super.checkParameters(values);
        if (((Integer)values[0]).intValue() < 3)
            throw new FactoryParameterException("Order should be at least 3");
    }
    
    
}
