/* EmbeddingSaver.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io.graphs;

import java.io.IOException;
import java.io.OutputStream;

import org.grinvin.graphs.EmbeddingView;
import org.grinvin.graphs.Vertex;
import org.grinvin.io.LoaderSaverHelper;

import org.jdom.DocType;
import org.jdom.Element;

/**
 * Saves a {@link EmbeddingView} as a <tt>embedding.xml</tt>-section
 * onto an output stream.
 */
public class EmbeddingSaver {
    
    //
    private EmbeddingSaver() { }
    
    /**
     * Convert the given embedding to a JDOM-element.
     */
    public static Element toElement(EmbeddingView embedding) {
        
        Element element = new Element("embedding");
        element.setAttribute("dimension", Integer.toString(embedding.getDimension()));
        
        // vertex coordinates
        for (Vertex v: embedding.getPeer().vertices()) {
            Element vertex = new Element("coordinates");
            vertex.setAttribute("id", Integer.toString(v.getIndex()));
            double[] c = embedding.getCoordinates(v);
            for (double d : c) {
                Element coord = new Element("double");
                coord.setAttribute("value", Double.toString(d));
                vertex.addContent(coord);
            }
            element.addContent(vertex);
        }
        return element;
    }
    
    /**
     * Save the embedding graph onto the output stream.
     * @param out Output stream to which the result shall be written.
     */
    public static void save(EmbeddingView embedding, OutputStream out) throws IOException{
        LoaderSaverHelper.outputXML(toElement(embedding), new DocType("embedding", "-//GrInvIn IO//Embedding 1.0//EN", "http://downloads.grinvin.org/dtds/io/embedding-1.0.dtd"), out);
    }
    
}
