/* GraphListElementCellRenderer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.components.render;

import java.awt.Color;

import org.grinvin.graphs.GraphBundleView;
import org.grinvin.graphs.GraphURI;
import org.grinvin.gui.icons.MissingGraphIconFactory;
import org.grinvin.gui.icons.SelectUnselectIcon;
import org.grinvin.list.graphs.GraphListElement;

/**
 * Renderer to render {@link GraphListElement} objects in a {@link be.ugent.caagt.swirl.lists.CellList}.
 */
public class GraphListElementCellRenderer extends AbstractGrinvinCellListCellRenderer {
    
    /**
     * Return the singleton instance of this type.
     */
    public static GraphListElementCellRenderer getInstance() {
        return INSTANCE;
    }
    
    //
    private static final GraphListElementCellRenderer INSTANCE
            = new GraphListElementCellRenderer();
    
    //
    public SelectUnselectIcon createIcon(Object value, int size) {
        GraphBundleView bundle = getGraphListElement(value).getBundle();
        if(bundle != null) {
            return bundle.getGraphIconFactory().createIcon(bundle, size);
        } else {
            return MissingGraphIconFactory.getInstance().createIcon(null, size);
        }
    }
    
    //
    protected Color getIconBackgroundColor(Object value) {
        return GraphURI.getType(getGraphListElement(value).getURI()).getIconBackgroundColor();
    }
    
    //
    protected String getName(Object value) {
        return getGraphListElement(value).getName();
    }
    
    //
    protected String getDescription(Object value) {
        return getGraphListElement(value).getDescription();
    }
    
    //
    private GraphListElement getGraphListElement(Object value) {
        if (value instanceof GraphListElement) {
            return (GraphListElement)value;
        } else {
            throw new IllegalArgumentException("GraphListElementCellRenderer can only be used with lists of GraphListElement");
        }
    }
    
}
