/* GuidesButton.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.guides;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.JToggleButton;
import javax.swing.Popup;
import javax.swing.PopupFactory;

import org.grinvin.gred.GraphPanel;

/**
 * Button that displays a popup to change the guides for a panel and
 * that has the corresponding guides as an icon.
 */
public class GuidesButton extends JToggleButton implements ItemListener, GuidesListener {
    
    //
    private static final ResourceBundle BUNDLE =
            ResourceBundle.getBundle("org.grinvin.gred.editor");
    
    private GuidesPanel guides;
    
    private Popup popup;
    
    private GraphPanel panel;
    
    /** Creates a new instance of GuidesButton */
    public GuidesButton(GraphPanel panel) {
        super();
        this.panel = panel;
        guides = new GuidesPanel(panel, this);
        guides.doLayout();
        panel.addGuidesListener(this);
        setIcon(panel.getGuides().getButtonIcon());
        setSelected(false);
        setToolTipText(BUNDLE.getString("guidesTool.title"));
        addItemListener(this);
    }

    public void guidesChanged() {
        setIcon(panel.getGuides().getButtonIcon());
    }

    public void itemStateChanged(ItemEvent e) {
        if(e.getStateChange() == ItemEvent.SELECTED){
            popup = PopupFactory.getSharedInstance().getPopup(this, guides, getLocationOnScreen().x - (guides.getPreferredSize().width - getWidth())/2, getLocationOnScreen().y + getHeight());
            popup.show();
        } else
            popup.hide();
    }
    
}
