/* GraphGeneratorInstance.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.generators.graphs;

import org.grinvin.generators.GeneratorException;

/**
 * Represents a particular instance of a generator, i.e., a generator for
 * which all parameters have been assigned a value.
 */
public interface GraphGeneratorInstance {
    
    // TODO: more methods
    
    /**
     * Return a string that uniquely identifies this instance.
     */
    public String getId();
    
    /**
     * Return a name which can be used to display this instance. This name
     * is for instance used when displaying this instance in a list.
     */
    public String getName();
    
    /**
     * Return a textual description for this instance.
     */
    public String getDescription();
    
    /**
     * Generate graph bundles to the given sink.
     */
    public void generate(GraphGeneratorSink sink) throws GeneratorException;
    
}
