/* MainInvariantConfigurationPanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.conjecture.engine;

import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

import org.grinvin.worksheet.ConjecturingComboBoxModel;

/**
 * A standard configuration panel for an {@link InequalityEngine} that allows the selection of a main invariant.
 */
public class MainInvariantConfigurationPanel extends JPanel implements ListDataListener {
    
    private final ResourceBundle rbundle = ResourceBundle.getBundle("org.grinvin.worksheet.worksheetwindow");
    
    //
    private final ConjecturingComboBoxModel comboBoxModel;
    
    //
    private final JComboBox comboBox;
    
    //
    private final InequalityEngine engine;
    
    /** Creates a new instance of MainInvariantConfigurationPanel */
    public MainInvariantConfigurationPanel(InequalityEngine engine, ConjecturingComboBoxModel comboBoxModel) {
        add(new JLabel(rbundle.getString("config.maininvariant") + ": "));
        this.engine = engine;
        this.comboBoxModel = comboBoxModel;
        comboBoxModel.addListDataListener(this);
        comboBox = new JComboBox(comboBoxModel);
        comboBox.setPrototypeDisplayValue("Maximum degree of even size (long)");
        add(comboBox);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        comboBox.setEnabled(enabled);
    }

    public void intervalAdded(ListDataEvent e) {
        engine.setMainInvariant(comboBoxModel.getSelectedItem());
    }

    public void intervalRemoved(ListDataEvent e) {
        engine.setMainInvariant(comboBoxModel.getSelectedItem());
    }

    public void contentsChanged(ListDataEvent e) {
        engine.setMainInvariant(comboBoxModel.getSelectedItem());
    }
}
