/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.EmptyNodeSet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.FragmentValue;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.sort.LocalOrderComparer;
import com.icl.saxon.sort.NodeOrderComparer;
import java.util.StringTokenizer;
import java.util.Vector;

public class Id
extends Function {
    private DocumentInfo boundDocument = null;

    public String getName() {
        return "id";
    }

    public int getDataType() {
        return 4;
    }

    public boolean isContextDocumentNodeSet() {
        return true;
    }

    public Expression simplify() throws XPathException {
        this.checkArgumentCount(1, 1);
        this.argument[0] = this.argument[0].simplify();
        return this;
    }

    public NodeSetValue evaluateAsNodeSet(Context context) throws XPathException {
        return this.findId(this.argument[0].evaluate(context), context);
    }

    public Value evaluate(Context context) throws XPathException {
        return this.evaluateAsNodeSet(context);
    }

    public int getDependencies() {
        if (this.boundDocument != null) {
            return 0;
        }
        return 136;
    }

    public Expression reduce(int n, Context context) throws XPathException {
        Id id = new Id();
        id.addArgument(this.argument[0].reduce(n, context));
        id.setStaticContext(this.getStaticContext());
        if (this.boundDocument == null && (n & 0x88) != 0) {
            id.boundDocument = context.getContextNodeInfo().getDocumentRoot();
        }
        return id;
    }

    private NodeSetValue findId(Value value, Context context) throws XPathException {
        Vector<NodeInfo> vector = null;
        DocumentInfo documentInfo = this.boundDocument == null ? context.getContextNodeInfo().getDocumentRoot() : this.boundDocument;
        if (value instanceof NodeSetValue && !(value instanceof FragmentValue) && !(value instanceof FragmentValue)) {
            NodeEnumeration nodeEnumeration = ((NodeSetValue)value).enumerate();
            while (nodeEnumeration.hasMoreElements()) {
                NodeInfo nodeInfo = nodeEnumeration.nextElement();
                String string = nodeInfo.getStringValue();
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreTokens()) {
                    NodeInfo nodeInfo2 = documentInfo.selectID(stringTokenizer.nextToken());
                    if (nodeInfo2 == null) continue;
                    if (vector == null) {
                        vector = new Vector(2);
                    }
                    vector.addElement(nodeInfo2);
                }
            }
        } else {
            String string = value.asString();
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                NodeInfo nodeInfo = documentInfo.selectID(stringTokenizer.nextToken());
                if (nodeInfo == null) continue;
                if (vector == null) {
                    vector = new Vector<NodeInfo>(2);
                }
                vector.addElement(nodeInfo);
            }
        }
        if (vector == null) {
            return new EmptyNodeSet();
        }
        if (vector.size() == 1) {
            return new SingletonNodeSet((NodeInfo)vector.elementAt(0));
        }
        return new NodeSetExtent(vector, (NodeOrderComparer)LocalOrderComparer.getInstance());
    }
}

