/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.charcode;

import com.icl.saxon.Loader;
import com.icl.saxon.charcode.ASCIICharacterSet;
import com.icl.saxon.charcode.CP1250CharacterSet;
import com.icl.saxon.charcode.CP1251CharacterSet;
import com.icl.saxon.charcode.CharacterSet;
import com.icl.saxon.charcode.KOI8RCharacterSet;
import com.icl.saxon.charcode.Latin1CharacterSet;
import com.icl.saxon.charcode.Latin2CharacterSet;
import com.icl.saxon.charcode.PluggableCharacterSet;
import com.icl.saxon.charcode.UnicodeCharacterSet;
import java.util.Properties;

public class CharacterSetFactory {
    public static CharacterSet getCharacterSet(Properties properties) {
        CharacterSet characterSet;
        String string = properties.getProperty("encoding");
        if (string == null) {
            string = "UTF8";
        }
        if (string.equalsIgnoreCase("utf-8")) {
            string = "UTF8";
        }
        if ((characterSet = CharacterSetFactory.makeCharacterSet(string)) == null) {
            characterSet = new ASCIICharacterSet();
        }
        return characterSet;
    }

    public static CharacterSet makeCharacterSet(String string) {
        if (string.equalsIgnoreCase("ASCII")) {
            return new ASCIICharacterSet();
        }
        if (string.equalsIgnoreCase("US-ASCII")) {
            return new ASCIICharacterSet();
        }
        if (string.equalsIgnoreCase("iso-8859-1")) {
            return new Latin1CharacterSet();
        }
        if (string.equalsIgnoreCase("iso-8859-2")) {
            return new Latin2CharacterSet();
        }
        if (string.equalsIgnoreCase("utf-8")) {
            return new UnicodeCharacterSet();
        }
        if (string.equalsIgnoreCase("UTF8")) {
            return new UnicodeCharacterSet();
        }
        if (string.equalsIgnoreCase("KOI8-R")) {
            return new KOI8RCharacterSet();
        }
        if (string.equalsIgnoreCase("cp1251")) {
            return new CP1251CharacterSet();
        }
        if (string.equalsIgnoreCase("windows-1251")) {
            return new CP1251CharacterSet();
        }
        if (string.equalsIgnoreCase("cp1250")) {
            return new CP1250CharacterSet();
        }
        if (string.equalsIgnoreCase("windows-1250")) {
            return new CP1250CharacterSet();
        }
        String string2 = null;
        try {
            Object object;
            string2 = System.getProperty("encoding." + string);
            if (string2 == null) {
                string2 = string;
            }
            if ((object = Loader.getInstance(string2)) instanceof PluggableCharacterSet) {
                return (PluggableCharacterSet)object;
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load " + string2);
        }
        return null;
    }
}

