package com.clarkware.junitperf;

/**
 * The <code>ConstantTimer</code> is a <code>Timer</code>
 * with a constant delay.
 * 
 * @author <a href="mailto:mike@clarkware.com">Mike Clark</a>
 * @author <a href="http://www.clarkware.com">Clarkware Consulting, Inc.</a>
 *
 * @see com.clarkware.junitperf.Timer
 */

public class ConstantTimer implements Timer {

	private final long _delay;

	/**
	 * Constructs a <code>ConstantTimer</code> with the
	 * specified delay.
	 *
	 * @param delay Delay (ms).
	 */
	public ConstantTimer(long delay) {
		_delay = delay;
	}

	/**
	 * Returns the timer delay.
	 *
	 * @return Delay (ms).
	 */
    public long getDelay() {
		return _delay;
	}
}
