#ifndef JTHREAD_H__
#define JTHREAD_H__

#include <sys/time.h>
#include <jni.h>
#include <jvmpi.h>
#include <timerstack.h>
#include <hash.h>
#include <jmp.h>
#include <cls.h>
#include <method.h>

/** This is the structure used for a java thread. */ 
struct jthread {
    char* thread_name;       /** The name of the thread. */
    char* group_name;        /** The name of the thread group. */
    char* parent_name;       /** The name of the parent thread. */
    jobjectID thread_id;     /** The id of the thread. */
    JNIEnv* env_id;          /** The environment id of the thread. */
    jint state;              /** The last known state of the thread. */
    timerstack* timerstack;
};

/** Create a new thread structure with the given attributes. */
jthread* jthread_new (const char* thread_name, const char* group_name, 
		      const char* parent_name, jobjectID thread_id,
		      JNIEnv* env_id, timerstack *s);

/** Delete the given thread structure. */
void jthread_free (jthread* t);

/** The hash function for threads. */
size_t jthread_jmphash_func (void* c, size_t len);

/** Check if two threads are equal.
 *  return 0 if the threads are equal.
 */
int jthread_cmp_func (void* c1, void* c2);

/** Get the environment id of the given thread. */
JNIEnv* jthread_get_env_id (jthread* t);

/** Set the environment id of the given thread. */
void jthread_set_env_id (jthread* t, JNIEnv* env_id);

/** The given thread has entered a method at time tv. 
 */
void jthread_method_entry (timerstack* s, method *m, jlong tval);

/** The given thread has exited from a method.
 */
void jthread_method_exit(timerstack* s, jmethodID method_id,
			 jlong tval, JNIEnv* env);

/** The given thread has is waiting for a monitor. */
void jthread_contenation_enter (timerstack* s,
				obj* monitor,
				jlong tval);

/** The given thread got the monitor it was waiting for. */
void jthread_contenation_entered (timerstack* s,
				  obj* monitor, 
				  jlong tval);

/** Get the name of the given thread. */
char* jthread_get_thread_name (jthread* t);

/** Get the name of the group for the given thread. */
char* jthread_get_group_name (jthread* t);

/** Get the name of the parent for the given thread. */
char* jthread_get_parent_name (jthread* t);

#endif   /* JTHREAD_H__ */

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
