#include <gtk/gtk.h>
#include <eventconfig.h>
#include <jmp.h>
#include <jmp-config.h>

/* Dialog for filter options */
static GtkWidget *dialog;

/* Called when OK or Quit button of the options dialog is pressed */
static void event_close_dialog (GtkWidget *widget, gpointer data) {
    gtk_widget_hide (dialog);
}

static gint delete_event (GtkWidget *widget, GdkEvent *event, 
			  gpointer data) {
    gtk_widget_hide (dialog);
    return TRUE;
}

static void object_event_changed (GtkWidget *w, gpointer fm) {
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) {
	enable_object_events ();
	run_object_dump ();
    } else {
	disable_object_events ();
    }
}

static void method_event_changed (GtkWidget *w, gpointer fm) {
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) {
	enable_method_events ();
    } else {
	disable_method_events ();
    }
}

static void monitor_event_changed (GtkWidget *w, gpointer fm) {
    if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (w))) {
	enable_monitor_events ();
    } else {
	disable_monitor_events ();
    }
}

static void add_check_button (GtkWidget* box, char* text, int active, GCallback func) {
    GtkWidget *w = gtk_check_button_new_with_label (text);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), active);
    gtk_box_pack_start (GTK_BOX (box), w, FALSE,FALSE,0);
    gtk_signal_connect (GTK_OBJECT (w), "toggled",
			GTK_SIGNAL_FUNC (func), (gpointer)NULL);
}

void event_window (GtkObject *ignored) {
    if (dialog == NULL) {
	GtkWidget *b = gtk_vbox_new (TRUE,0), *b2;
	GtkWidget *w;
	
	dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
			    GTK_SIGNAL_FUNC (delete_event), NULL);
	gtk_window_set_title (GTK_WINDOW (dialog),
			      _("Java Memory Profiler - Event Options"));
	gtk_window_set_modal (GTK_WINDOW (dialog),TRUE);
	gtk_container_set_border_width (GTK_CONTAINER (dialog),10);
	
	add_check_button (b, _("Enable object tracing"), 
			  tracing_objects (), (GCallback)object_event_changed);
	add_check_button (b, _("Enable method tracing"), 
			  tracing_methods (), (GCallback)method_event_changed);
	add_check_button (b, _("Enable monitor tracing"), 
			  tracing_monitors (), (GCallback)monitor_event_changed);

	/* Ok and Quit button */
	b2 = gtk_hbutton_box_new ();
	w = gtk_button_new_with_label (_("OK"));
	gtk_signal_connect (GTK_OBJECT (w),"clicked",
			    GTK_SIGNAL_FUNC (event_close_dialog),
			    (gpointer)TRUE);
	gtk_box_pack_start (GTK_BOX (b2), w, FALSE,FALSE,0);
	gtk_box_pack_start (GTK_BOX (b), b2, FALSE,FALSE,0);
	gtk_container_add (GTK_CONTAINER (dialog), b);
    }	
    gtk_widget_show_all (dialog);	
}

/** destroy the event configuration dialog.
 */
void event_window_destroy () {
    if (dialog)
	gtk_widget_destroy (dialog);
    dialog = NULL;
}


/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
