# Detect product
function sun_j2sdk_detect() {
    local found=
    case "$archive_name" in
	"j2sdk-1_3_1_"[0-9][0-9]"-linux-i586.bin")
	    j2se_version="1.3.1+${archive_name:12:2}"
	    j2se_expected_min_size=54 # 56259 kB
	    found=true
	    ;;
	"j2sdk-1_4_1_03-linux-i586.bin")
	    j2se_version=1.4.1+03
	    j2se_expected_min_size=77 # 79515 kB
	    found=true
	    ;;
	"j2sdk-1_4_2-linux-i586.bin")
	    j2se_version=1.4.2
	    j2se_expected_min_size=87 # 89150 kB
	    found=true
	    ;;
	"j2sdk-1_4_2_"[0-9][0-9]"-linux-i586.bin")
	    j2se_version="1.4.2+${archive_name:12:2}"
	    j2se_expected_min_size=87 # 89281 kB
	    found=true
	    ;;
	"jdk-1_5_0-beta2-linux-i586.bin")
	    j2se_version=1.5.0+beta2
	    j2se_expected_min_size=122 # 125899 kB
	    found=true
	    ;;
    esac
    if [[ -n "$found" ]]; then
	cat << EOF

Detected product:
    Java(TM) Software Development Kit (J2SDK)
    Standard Edition, Version $j2se_version
    Sun Microsystems(TM), Inc.
EOF
	if read_yn "Is this correct [Y/n]: "; then
	    j2se_found=true
	    j2se_release="${j2se_version:0:3}"
	    j2se_required_space=$(( $j2se_expected_min_size * 2 + 20 ))
	    j2se_vendor="sun"
	    j2se_title="Java(TM) 2 SDK, Standard Edition, Sun Microsystems(TM)"
	    j2sdk_run
	fi
    fi
}

j2se_detect_sun_j2sdk=sun_j2sdk_detect
