# read_yn <prompt>
function read_yn() {
    local prompt="$1"
    while true; do
	read -e -n 1 -p "$prompt" reply
	case "$reply" in
	    "" | "y" | "Y")
		return 0
		;;
	    "N" | "n")
		return 1
		;;
	esac
    done
}


# diskusage <path>: prints size in MB
function diskusage() {
    local path="$1"
    read size dummy < <( du -sm "$path" )
    echo "$size"
}


# diskfree <minimum size in MB>
function diskfree() {
    local size="$1"
    local dummy="$tmp/dummy"
    echo -n "Checking free diskspace:"
    dd if=/dev/zero of="$dummy" bs=1M count="$size" 2> /dev/null || true
    local real_size="$( diskusage "$dummy" )"
    rm -f "$dummy"
    if [ "$real_size" -ge "$size" ]; then
	echo " done."
    else
	cat >&2 << EOF


Error: Not enough free disk space in "$tmp".

You need at least $size MB, but only $real_size MB are free. Note: You
can specify an alternate directory by setting the environment variable
TMPDIR.

EOF
	error_exit
    fi
}


# extract_bin <file> <expected_min_size> <dest>
function extract_bin() {
    local file="$1"
    local expected_min_size="$2"
    local dest="$3"
    cat << EOF

In the next step, the binary file will be extracted. Probably a
license agreement will be displayed. Please read this agreement
carefully. If you do not agree to the displayed license terms, the
package will not be built.

EOF
    read -e -p "Press [Return] to continue: " dummy
    echo
    local extract_dir="$tmp/extract"
    mkdir "$extract_dir"
    cd "$extract_dir"
    echo
    
    if ! sh "$archive_path"; then
	cat << EOF

WARNING: The package installation script exited with an error
value. Usually, this means, that the installation failed for some
reason. But in some cases there is no problem and you can continue
creating the Debian package.

Please check if there are any error messages. Press [Return] to
continue or Ctrl-C to abort.

EOF
	read
    fi
    echo
    echo -n "Testing extracted archive..."
    local size="$( diskusage "$extract_dir" )"
    if [ "$size" -lt "$expected_min_size" ]; then
	cat << EOF

Invalid size ($size MB) of extracted archive. Probably you have not
enough free disc space in the temporary directory. Note: You can
specify an alternate directory by setting the environment variable
TMPDIR.

EOF
	error_exit
    else
	cd "$extract_dir"
	files=(*)
	if [ "${#files[*]}" -ne 1 ]; then
	    cat << EOF

Exptected one file, but found the following ${#files[*]} files:
    ${files[*]}

EOF
	    error_exit
	fi
	mv "$files" "$dest"
	echo -e " okay.\n"
    fi
}


function read_maintainer_info() {
    if [ -z "$maintainer_name" ]; then
	cat << EOF

Please enter your full name. This value will be used in the maintainer
field of the created package.

EOF
	while true; do
	    read -e -p "Full name: " maintainer_name
	    [ -n "$maintainer_name" ] && break
	done
    fi
 
    if [ -z "$maintainer_email" ]; then
	cat << EOF

Please enter a valid email address or press return to accept the
default value. This address will be used in the maintainer field of
the created package.

EOF
	local default_email=
	if [ -r "/etc/mailname" ]; then
	    default_email="$( id -un )@$( cat /etc/mailname )"
	else
	    default_email="$( id -un )@$( hostname --fqdn )"
	fi
	read -e -p "Email [$default_email]: " maintainer_email
	if [ -z "$maintainer_email" ]; then
	    maintainer_email="$default_email"
	fi
    fi
}
