# Detect product
function blackdown_j2re_detect() {
    local found=
    case "$archive_name" in
	"j2re-1.3.1-02b-FCS-linux-i386.bin")
	    j2se_version=1.3.1+02b
	    j2se_expected_min_size=35 # 35882 kB
	    found=true
	    ;;
	"j2re-1.4.1-01-linux-i586-gcc2.95.bin")
	    j2se_version=1.4.1+01
	    j2se_expected_min_size=51 # 52631 kB
	    found=true
	    ;;
	"j2re-1.4.1-01-linux-i586-gcc3.2.bin")
	    j2se_version=1.4.1+01
	    j2se_expected_min_size=48 # 49988 kB
	    found=true
	    ;;
	"j2re-1.4.2-rc1-linux-i586-gcc2.95.bin")
	    j2se_version=1.4.2+rc1
	    j2se_expected_min_size=48 # 49988 kB
	    found=true
	    ;;
	"j2re-1.4.2-rc1-linux-i586-gcc3.2.bin")
	    j2se_version=1.4.2+rc1
	    j2se_expected_min_size=48 # 49988 kB
	    found=true
	    ;;
    esac
    if [[ -n "$found" ]]; then
	cat << EOF

Detected product:
    Java(TM) Runtime Environment (J2RE)
    Standard Edition, Version $j2se_version
    Blackdown Java-Linux
EOF
	if read_yn "Is this correct [Y/n]: "; then
	    j2se_found=true
	    j2se_release="${j2se_version:0:3}"
	    j2se_required_space=$(( $j2se_expected_min_size * 2 + 20 ))
	    j2se_vendor="blackdown"
	    j2se_title="Java(TM) 2 RE, Standard Edition, Blackdown"
	    j2re_run
	fi
    fi
}

j2se_detect_blackdown_j2re=blackdown_j2re_detect
