rem *******************************************************************************
rem  Copyright (c) 2000, 2003 IBM Corporation and others.
rem  All rights reserved. This program and the accompanying materials 
rem  are made available under the terms of the Common Public License v1.0
rem  which accompanies this distribution, and is available at
rem  http://www.eclipse.org/legal/cpl-v10.html
rem  
rem  Contributors:
rem      IBM Corporation - initial API and implementation
rem      Kevin Cornell (Rational Software Corporation)
rem ********************************************************************** 
rem 
rem  Usage: sh build.sh [<optional switches>] [clean]
rem 
rem    where the optional switches are:
rem        -output <PROGRAM_OUTPUT>  - executable filename ("eclipse")
rem        -name   <PROGRAM_NAME>    - title of launcher   ("Eclipse")
rem        -os     <DEFAULT_OS>      - default Eclipse "-os" value (qnx) 
rem        -arch   <DEFAULT_OS_ARCH> - default Eclipse "-arch" value (x86) 
rem        -ws     <DEFAULT_WS>      - default Eclipse "-ws" value (photon) 
rem 
rem 
rem     This script can also be invoked with the "clean" argument.
rem
rem NOTE: The C compiler needs to be setup. This script has been
rem       tested against Microsoft Visual C and C++ Compiler 6.0.
rem	
rem Uncomment the lines below and edit MSVC_HOME to point to the
rem correct root directory of the compiler installation, if you
rem want this to be done by this script.
rem 
rem ******
rem if not "%MSVC_HOME%" == "" goto MAKE
rem set MSVC_HOME=k:\dev\products\msvc60\vc98
rem call %MSVC_HOME%\bin\vcvars32.bat
@echo off

:MAKE

rem --------------------------
rem Define default values for environment variables used in the makefiles.
rem --------------------------
set programOutput=eclipse.exe
set programName=Eclipse
set defaultOS=win32
set defaultOSArch=x86
set defaultWS=win32
set makefile=make_win.mak
set OS=Windows

rem --------------------------
rem Parse the command line arguments and override the default values.
rem --------------------------
set extraArgs=
:WHILE
if "%1" == "" goto WHILE_END
    if "%2" == ""       goto LAST_ARG

    if "%1" == "-os" (
		set defaultOS=%2
		shift
		goto NEXT )
    if "%1" == "-arch" (
		set defaultOSArch=%2
		shift
		goto NEXT )
    if "%1" == "-ws" (
		set defaultWS=%2
		shift
		goto NEXT )
    if "%1" == "-output" (
		set programOutput=%2
		shift
		goto NEXT )
    if "%1" == "-name" (
		set programName=%2
		shift
		goto NEXT )

:LAST_ARG
        set extraArgs=%extraArgs% %1

:NEXT
    shift
    goto WHILE
:WHILE_END

rem --------------------------
rem Set up environment variables needed by the makefile.
rem --------------------------
set PROGRAM_OUTPUT=%programOutput%
set PROGRAM_NAME=%programName%
set DEFAULT_OS=%defaultOS%
set DEFAULT_OS_ARCH=%defaultOSArch%
set DEFAULT_WS=%defaultWS%

rem --------------------------
rem Run nmake to build the executable.
rem --------------------------
if "%extraArgs%" == "" goto MAKE_ALL

nmake -f %makefile% %extraArgs%
goto DONE

:MAKE_ALL
echo Building %OS% launcher. Defaults: -os %DEFAULT_OS% -arch %DEFAULT_OS_ARCH% -ws %DEFAULT_WS%
nmake -f %makefile% clean
nmake -f %makefile%
goto DONE


:DONE
