/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.team.internal.ftp.client;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;

import org.eclipse.team.internal.ftp.*;
import org.eclipse.team.internal.ftp.Policy;

class PassiveDataConnection extends DataConnection {
	private InetAddress address;
	private int port;

	/**
	 * Creates a data transfer manager.
	 * @param address the remote address to connect to
	 * @param port the remote port to connect to
	 */
	public PassiveDataConnection(InetAddress address, int port) {
		this.address = address;
		this.port = port;
	}
	
	protected Socket openSocket() throws FTPException {
		try {
			return new Socket(address, port);
		} catch (IOException e) {
			throw new FTPCommunicationException(Policy.bind("FTPClient.CannotOpenPassiveDataConnection"), e); //$NON-NLS-1$
		}
	}
}
