/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.Iterator;
import org.eclipse.jface.text.source.IAnnotationModel;


/**
 * Filters problems based on their types.
 */
public class JavaAnnotationIterator implements Iterator {
			
	private Iterator fIterator;
	private IJavaAnnotation fNext;
	private boolean fSkipIrrelevants;
	
	public JavaAnnotationIterator(IAnnotationModel model, boolean skipIrrelevants) {
		fIterator= model.getAnnotationIterator();
		fSkipIrrelevants= skipIrrelevants;
		skip();
	}
	
	private void skip() {
		while (fIterator.hasNext()) {
			Object next= fIterator.next();
			if (next instanceof IJavaAnnotation) {
				IJavaAnnotation a= (IJavaAnnotation) next;
				if (fSkipIrrelevants) {
					if (a.isRelevant()) {
						fNext= a;
						return;
					}
				} else {
					fNext= a;
					return;
				}
			}
		}
		fNext= null;
	}
	
	/*
	 * @see Iterator#hasNext()
	 */
	public boolean hasNext() {
		return fNext != null;
	}

	/*
	 * @see Iterator#next()
	 */
	public Object next() {
		try {
			return fNext;
		} finally {
			skip();
		}
	}

	/*
	 * @see Iterator#remove()
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}
}
