/*******************************************************************************
 * Copyright (c) 2000, 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.texteditor.ITextEditor;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;

/**
 * Open a class on a Test method.
 */
public class OpenTestAction extends OpenEditorAction {
	
	private String fMethodName;
	private ISourceRange fRange;
	
	/**
	 * Constructor for OpenTestAction.
	 */
	public OpenTestAction(TestRunnerViewPart testRunner, String className, String method) {
		super(testRunner, className);
		WorkbenchHelp.setHelp(this, IJUnitHelpContextIds.OPENTEST_ACTION);
		fMethodName= method;
	}
	
	public OpenTestAction(TestRunnerViewPart testRunner, String className) {
		this(testRunner, className, null);
	}

	protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
		IType type= project.findType(className);
		if (type == null) 
			return null;
		
		if (fMethodName == null)
			return type;
			
		IMethod method= findMethod(type);
		if (method == null) {
			ITypeHierarchy typeHierarchy= type.newSupertypeHierarchy(null);
			IType[] types= typeHierarchy.getAllSuperclasses(type);
			for (int i= 0; i < types.length; i++) {
				method= findMethod(types[i]);
				if (method != null)
					break;
			}
		}
		if (method != null)
			fRange= method.getNameRange();
		return method;
	}
	
	IMethod findMethod(IType type) throws JavaModelException {
		IMethod method= type.getMethod(fMethodName, new String[0]);
		if (method != null && method.exists())
			return method;
		return null;
	}
	
	protected void reveal(ITextEditor textEditor) {
		if (fRange != null)
			textEditor.selectAndReveal(fRange.getOffset(), fRange.getLength());
	}

	public boolean isEnabled() {
		try {
			return getLaunchedProject().findType(getClassName()) != null;
		} catch (JavaModelException e) {
		}
		return false;
	}
}
