/****************************************************************************
**
** Copyright (C) 2002-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef RESOLVDIALOGIMPL_H
#define RESOLVDIALOGIMPL_H

#include "config.h"

#include <qptrvector.h>
#include <qptrstack.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qiconset.h>
#include <qcommonstyle.h>
#include <qapplication.h>

#include "ResolvDialog.h"
#include "ProgressDialog.h"

class ResolvDialogImpl : public ResolvDialog {
   Q_OBJECT

 public:

   ResolvDialogImpl( QString,
	 const QIconSet &,
	 QWidget * = 0,
	 WFlags = 0,
	 QString = "");

   virtual ~ResolvDialogImpl();
   void init(const QIconSet &,QString &);

 private slots:

   void writeFile();
   void clear(int,int);
   void unselected(int,int);
   void selected(int,int,QString);
   void unSelectedBlock(int,int,int);
   void selectedBlock(int,int,int);
   void cancelRead();

   void nextClicked();
   void previousClicked();

   void enterWhatsThisMode();


 protected:

   bool eventFilter(QObject*,QEvent*);

 private:

   class SplitterStyle : public QCommonStyle {
    public:
      SplitterStyle(ResolvDialogImpl * rdi) : QCommonStyle(),dlg(rdi) {}
	 
	 void drawPrimitive(PrimitiveElement pe, QPainter *p,
	       const QRect &r, const QColorGroup &cg, SFlags flags = Style_Default,
	       const QStyleOption &StyleOption = QStyleOption::Default) const;
	 
	 int pixelMetric(PixelMetric metric, const QWidget *widget) const {
	    return ((metric == PM_SplitterWidth) ? SPLITTER_WIDTH :
		  QApplication::style().pixelMetric(metric, widget));
	 }
	 
	 void polishPopupMenu ( QPopupMenu * p) {QApplication::style().polishPopupMenu(p);}
	 
    private:
	 // Disabled copy constructor and operator=
	 SplitterStyle(const SplitterStyle &);
	 SplitterStyle& operator=(const SplitterStyle &);
	 
	 ResolvDialogImpl * dlg;
	 static const unsigned int SPLITTER_WIDTH;
   };
   friend class SplitterStyle;

   class Reference {
    public:
      Reference() {}
      ~Reference() {}

      int fileTable;
      int line;
   };

   // Sun Forte 5.3 does not allow embedded classes access to protected
   // or private data without explict 'friend' statements.
   class Block;
   friend class Block;

   class Block {
    public:
      Block();
      ~Block();
      int from;
      int to;
      int pos; 
      int* fileMap[2];
      Reference* mergeMap;
      QString oriTxt;
   };

   class CBlock {
    public:
      CBlock(int,int);
      ~CBlock() {}
      int from;
      int to;
   };

   void render();
   void addLine(unsigned int);
   void initBlock();
   void setCurrentBlock(int,int);
   int appendLine(int,int);
   bool setFile();

   QPtrVector<Block> m_blockVector;
   QPtrStack<Block> m_blockTracker;
   Block* m_currentBlock;
   QPtrVector<CBlock> m_conflictVector;

   unsigned int m_originPos;
   QString m_fileName;

   bool m_stop;
   int m_linesTotal;

};

#endif // RESOLVDIALOGIMPL_H

