/****************************************************************************
**
** Copyright (C) 2001-2006 Frank Hemer <frank@hemer.org>,
**                         Tilo Riemer <riemer@crossvc.com>,
**                         Jose Hernandez <joseh@tesco.net>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** CrossVC is available under two different licenses:
**
** If CrossVC is linked against the GPLed version of Qt 
** CrossVC is released under the terms of GPL also.
**
** If CrossVC is linked against a nonGPLed version of Qt 
** CrossVC is released under the terms of the 
** CrossVC License for non-Unix platforms (CLNU)
**
**
** CrossVC License for non-Unix platforms (CLNU):
**
** Redistribution and use in binary form, without modification, 
** are permitted provided that the following conditions are met:
**
** 1. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 2. It is not permitted to distribute the binary package under a name
**    different than CrossVC.
** 3. The name of the authors may not be used to endorse or promote
**    products derived from this software without specific prior written
**    permission.
** 4. The source code is the creative property of the authors.
**    Extensions and development under the terms of the Gnu Public License
**    are limited to the Unix platform. Any distribution or compilation of 
**    the source code against libraries licensed other than gpl requires 
**    the written permission of the authors.
**
**
** THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR 
** IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
** WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
** ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY 
** DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE 
** GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS 
** INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
** NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
** SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**
**
** CrossVC License for Unix platforms:
**
** This program is free software; you can redistribute it and/or modify 
** it under the terms of the GNU General Public License as published by 
** the Free Software Foundation, version 2 of the License.
** This program is distributed in 
** the hope that it will be useful, but WITHOUT ANY WARRANTY; without 
** even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
** PARTICULAR PURPOSE.
**
** See the GNU General Public License version 2 for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software Foundation,
** Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef COMMANDINTERFACE_H
#define COMMANDINTERFACE_H

#include "config.h"


#include <qstring.h>
#include "CvsBuffer.h"

static const bool NOROOT = true;

// never interactive commands:
static const int CVS_NOT_INTERACTIVE_CMD = 255;
static const int CVS_LOG_CMD = 200;

// external commands:
static const int CVS_LOGINANDOUT_CMD = 210;

// interactive commands:
static const int CVS_Y_N                           =  0;
static const int CVS_RELEASE_CMD                   =  1;
static const int CVS_RELEASE_D_CMD                 =  2;
static const int CVS_UNEDIT_CMD                    =  3;
static const int CVS_EDIT_CMD                      =  4;
static const int CVS_STATUS_CMD                    =  5;
static const int CVS_STATUS_FILES_CMD              =  6;
static const int CVS_UPDATE_DIR_CMD                =  7;
static const int CVS_UPDATE_FILES_CMD              =  8;
static const int CVS_ANNOTATE_GREP_LINE_CMD        =  9;
static const int CVS_ANNOTATE_GREP_LINES_CMD       = 10;
static const int CVS_COMMIT_CMD                    = 11;
static const int CVS_HISTORY_CMD                   = 12;
static const int CVS_DIFF_CMD                      = 13;
static const int CVS_DIFF_SBS_CMD                  = 14;
static const int CVS_DIFF_EXT_CMD                  = 15;
static const int CVS_ANNOTATE_CMD                  = 16;
static const int CVS_CHECKOUT_CMD                  = 17;
static const int CVS_IMPORT_CMD                    = 18;
static const int CVS_TAG_CMD                       = 19;
static const int CVS_LOG_DIR_CMD                   = 20;
static const int CVS_RENAME_CMD                    = 21;
static const int CVS_REMOVE_CMD                    = 22;
static const int CVS_REMOVE_AND_RENAME_CMD         = 23;
static const int CVS_ADD_CMD                       = 24;
static const int CVS_QUERY_UPDATE_CMD              = 25;
static const int CVS_QUERY_UPDATE_ALL_CMD          = 26;
static const int CVS_EDIT_REVISION_CMD             = 27;
static const int CVS_MERGE_REV_INTO_CMD            = 28;
static const int CVS_RESURRECT_CMD                 = 29;
static const int CVS_SHOW_EDITORS_CMD              = 30;
static const int CVS_SHOW_WATCHERS_CMD             = 31;
static const int CVS_MERGE_DIR_CMD                 = 32;
static const int CVS_MERGE_FILES_CMD               = 33;
static const int CVS_LOCKFILE_CMD                  = 34;
static const int CVS_UNLOCKFILE_CMD                = 35;
static const int CVS_HBROWSEMODULES_CMD            = 36;
static const int CVS_MBROWSEMODULES_CMD            = 37;
static const int CVS_EXPORT_CMD                    = 38;
static const int CVS_REMOVEDIR_CMD                 = 39;
static const int CVS_AUTOUPDATE_DIR_CMD            = 40;
static const int CVS_AUTOUPDATE_DIR_NO_PRUNE_CMD   = 41;
static const int CVS_CHECKOUT_NO_PRUNE_CMD         = 42;
static const int CVS_MERGE_DIR_NO_PRUNE_CMD        = 43;
static const int CVS_UPDATE_VIRTUAL_DIR_CMD        = 44;
static const int CVS_MOVE_FILES_CMD                = 45;
static const int CVS_REVERT_DIR_CMD                = 46;
static const int CVS_REVERT_FILES_CMD              = 47;
static const int CVS_GET_TAG_INFO_PROJECT_CMD      = 48;
static const int CVS_GET_TAG_INFO_FILES_CMD        = 49;
static const int CVS_RLSBROWSEMODULES_CMD          = 50;

class CvsControl;

class CommandInterface {

 public:
   void initCommandInterface( CvsControl *p);
   void callInteractive( QString& topModule, 
	 QString& dir,
	 QString& cvsRoot,
	 QString& repository,
	 int cmd,
	 QString& cvsRsh,
	 bool noroot=false);

   virtual ~CommandInterface() {}
   virtual void afterCall(int cmd,CvsBuffer *m_pCvsBuffer,bool failed=false) = 0;

 protected:
   virtual void cvsCallStarted();

 private:
   static CvsControl *pCvsControl;
};

#endif

