
package org.apache.commons.httpclient;

import java.io.*;
import java.util.Map;
import junit.framework.*;


public class TestStreams extends TestCase {

    public TestStreams(String testName) {
        super(testName);
    }

    public void testChunkedInputStream() throws IOException {
        String correct = "10; this is comments\r\n1234567890123456\r\n5\r\n12345\r\n0\r\nFooter1: abcde\r\nFooter2: fghij\r\n";
        HttpMethod method = new SimpleHttpMethod();
        InputStream in = new ChunkedInputStream(new ByteArrayInputStream(correct.getBytes()), method);
        byte[] buffer = new byte[300];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int len;
        while ((len = in.read(buffer)) > 0) {
            out.write(buffer, 0, len);
        }
        String result = new String(out.toByteArray());
        assertEquals(result, "123456789012345612345");
        Header footer = method.getResponseFooter("footer1");
        assertEquals(footer.getValue(), "abcde");
        footer = method.getResponseFooter("footer2");
        assertEquals(footer.getValue(), "fghij");
    }

    public void testContentLengthInputStream() throws IOException {
        String correct = "1234567890123456";
        InputStream in = new ContentLengthInputStream(new ByteArrayInputStream(correct.getBytes()), 10);
        byte[] buffer = new byte[50];
        int len = in.read(buffer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(buffer, 0, len);
        String result = new String(out.toByteArray());
        assertEquals(result, "1234567890");
    }

    // ------------------------------------------------------- TestCase Methods

    public static Test suite() {
        return new TestSuite(TestHeader.class);
    }

    // ------------------------------------------------------------------- Main
    public static void main(String args[]) {
        String[] testCaseName = { TestStreams.class.getName() };
        junit.textui.TestRunner.main(testCaseName);
    }
}

