/*
 * $Header: /home/cvspublic/jakarta-commons/httpclient/src/examples/TrivialApp.java,v 1.1 2002/08/14 01:41:57 jsdever Exp $
 * $Revision: 1.1 $
 * $Date: 2002/08/14 01:41:57 $
 * 
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "HttpClient", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */

import org.apache.commons.httpclient.*;
import org.apache.commons.httpclient.methods.*;
import java.net.*;
import java.io.*;

/**
 * 
 * This is a simple text mode application that demonstrates
 * how to use the Jakarta HttpClient API.
 * 
 * @author <a href="mailto:jsdever@apache.org">Jeff Dever</a>
 *
 */
public class TrivialApp
{

    private static final void printUsage()
    {
        System.out.println("Usage: java -classpath <classpath> [-Dorg.apache.commons.logging.simplelog.defaultlog=<loglevel>] SimpleApp <url>");
        System.out.println("<classpath> - must contain the commons-httpclient.jar and commons-logging.jar");
        System.out.println("<loglevel> - one of error, warn, info, debug, trace");
        System.out.println("<url> - some valid URL");
        System.out.println();
    }

	public static void main(String[] args)
	{
        if (args.length < 1){
            printUsage();
            System.exit(-1);
        }

        URL url = null;
        try{
            url = new URL(args[0]);
        }catch (MalformedURLException murle){
            System.out.println("<url> argument '" + url
                    + "' is not a valid URL");
            System.exit(-2);
        }

        //create a singular HttpClient object
        HttpClient client = new HttpClient();

        //start a session with the webserver
        client.startSession(url);
        
        //can set the timeout for any connections
        client.setTimeout(30000 /* milliseconds */);

        //create a method object
        HttpMethod method = new GetMethod(url.getPath());

        //turn follow redirects off
        method.setFollowRedirects(false);

        //turn strict mode on
        method.setStrictMode(false);
 
        //execute the method
        try{
            client.executeMethod(method);
        }catch (IOException ioe){
            System.out.println("Unable to connect to '" +
                    url + "'");
            System.exit(-3);
        }catch (HttpException httpe){
            System.out.println("Http error connecting to '" +
                    url + "'");
            System.exit(-4);
        }

        //get the request headers
        Header[] requestHeaders = method.getRequestHeaders();

        //get the response headers
        Header[] responseHeaders = method.getResponseHeaders();

        //get the response body
        byte[] responseBody = method.getResponseBody();

        //write out the request headers
        System.out.println("*** Request Headers ***");
        for (int i=0; i<requestHeaders.length; i++){
            System.out.print(requestHeaders[i]);
        }

        //write out the response headers
        System.out.println("*** Response Headers ***");
        for (int i=0; i<responseHeaders.length; i++){
            System.out.print(responseHeaders[i]);
        }
        
        System.exit(0);
    }
}
