/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSBeforeLoadEvent.h"

#include "BeforeLoadEvent.h"
#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSBeforeLoadEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBeforeLoadEventTableValues[3] =
{
    { "url", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeLoadEventUrl), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsBeforeLoadEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBeforeLoadEventTable = { 4, 3, JSBeforeLoadEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBeforeLoadEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBeforeLoadEventConstructorTable = { 1, 0, JSBeforeLoadEventConstructorTableValues, 0 };
class JSBeforeLoadEventConstructor : public DOMConstructorObject {
public:
    JSBeforeLoadEventConstructor(JSC::ExecState*, JSC::Structure*, JSDOMGlobalObject*);

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), AnonymousSlotCount, &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSBeforeLoadEventConstructor::s_info = { "BeforeLoadEventConstructor", &DOMConstructorObject::s_info, &JSBeforeLoadEventConstructorTable, 0 };

JSBeforeLoadEventConstructor::JSBeforeLoadEventConstructor(ExecState* exec, Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSBeforeLoadEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSBeforeLoadEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBeforeLoadEventConstructor, JSDOMWrapper>(exec, &JSBeforeLoadEventConstructorTable, this, propertyName, slot);
}

bool JSBeforeLoadEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBeforeLoadEventConstructor, JSDOMWrapper>(exec, &JSBeforeLoadEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSBeforeLoadEventPrototypeTableValues[2] =
{
    { "initBeforeLoadEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsBeforeLoadEventPrototypeFunctionInitBeforeLoadEvent), (intptr_t)4 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSBeforeLoadEventPrototypeTable = { 2, 1, JSBeforeLoadEventPrototypeTableValues, 0 };
const ClassInfo JSBeforeLoadEventPrototype::s_info = { "BeforeLoadEventPrototype", &JSC::JSObjectWithGlobalObject::s_info, &JSBeforeLoadEventPrototypeTable, 0 };

JSObject* JSBeforeLoadEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSBeforeLoadEvent>(exec, globalObject);
}

bool JSBeforeLoadEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSBeforeLoadEventPrototypeTable, this, propertyName, slot);
}

bool JSBeforeLoadEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSBeforeLoadEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSBeforeLoadEvent::s_info = { "BeforeLoadEvent", &JSEvent::s_info, &JSBeforeLoadEventTable, 0 };

JSBeforeLoadEvent::JSBeforeLoadEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<BeforeLoadEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
    ASSERT(inherits(&s_info));
}

JSObject* JSBeforeLoadEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSBeforeLoadEventPrototype(exec->globalData(), globalObject, JSBeforeLoadEventPrototype::createStructure(exec->globalData(), JSEventPrototype::self(exec, globalObject)));
}

bool JSBeforeLoadEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSBeforeLoadEvent, Base>(exec, &JSBeforeLoadEventTable, this, propertyName, slot);
}

bool JSBeforeLoadEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSBeforeLoadEvent, Base>(exec, &JSBeforeLoadEventTable, this, propertyName, descriptor);
}

JSValue jsBeforeLoadEventUrl(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSBeforeLoadEvent* castedThis = static_cast<JSBeforeLoadEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    BeforeLoadEvent* imp = static_cast<BeforeLoadEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->url());
    return result;
}


JSValue jsBeforeLoadEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSBeforeLoadEvent* domObject = static_cast<JSBeforeLoadEvent*>(asObject(slotBase));
    return JSBeforeLoadEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSBeforeLoadEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSBeforeLoadEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsBeforeLoadEventPrototypeFunctionInitBeforeLoadEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSBeforeLoadEvent::s_info))
        return throwVMTypeError(exec);
    JSBeforeLoadEvent* castedThis = static_cast<JSBeforeLoadEvent*>(asObject(thisValue));
    BeforeLoadEvent* imp = static_cast<BeforeLoadEvent*>(castedThis->impl());
    const String& type(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& url(ustringToString(exec->argument(3).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->initBeforeLoadEvent(type, canBubble, cancelable, url);
    return JSValue::encode(jsUndefined());
}


}
