/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGZoomEvent.h"

#include <wtf/GetPtr.h>

#include "JSSVGPoint.h"
#include "JSSVGRect.h"
#include "SVGZoomEvent.h"

#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGZoomEvent)

/* Hash table */

static const HashTableValue JSSVGZoomEventTableValues[6] =
{
    { "zoomRectScreen", DontDelete|ReadOnly, (intptr_t)jsSVGZoomEventZoomRectScreen, (intptr_t)0 },
    { "previousScale", DontDelete|ReadOnly, (intptr_t)jsSVGZoomEventPreviousScale, (intptr_t)0 },
    { "previousTranslate", DontDelete|ReadOnly, (intptr_t)jsSVGZoomEventPreviousTranslate, (intptr_t)0 },
    { "newScale", DontDelete|ReadOnly, (intptr_t)jsSVGZoomEventNewScale, (intptr_t)0 },
    { "newTranslate", DontDelete|ReadOnly, (intptr_t)jsSVGZoomEventNewTranslate, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGZoomEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSSVGZoomEventTableValues, 0 };
#else
    { 17, 15, JSSVGZoomEventTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGZoomEventPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGZoomEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGZoomEventPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGZoomEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGZoomEventPrototype::s_info = { "SVGZoomEventPrototype", 0, &JSSVGZoomEventPrototypeTable, 0 };

JSObject* JSSVGZoomEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGZoomEvent>(exec, globalObject);
}

const ClassInfo JSSVGZoomEvent::s_info = { "SVGZoomEvent", &JSUIEvent::s_info, &JSSVGZoomEventTable, 0 };

JSSVGZoomEvent::JSSVGZoomEvent(PassRefPtr<Structure> structure, PassRefPtr<SVGZoomEvent> impl, SVGElement* context)
    : JSUIEvent(structure, impl)
{
}

JSObject* JSSVGZoomEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGZoomEventPrototype(JSSVGZoomEventPrototype::createStructure(JSUIEventPrototype::self(exec, globalObject)));
}

bool JSSVGZoomEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGZoomEvent, Base>(exec, &JSSVGZoomEventTable, this, propertyName, slot);
}

JSValuePtr jsSVGZoomEventZoomRectScreen(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGZoomEvent* imp = static_cast<SVGZoomEvent*>(static_cast<JSSVGZoomEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->zoomRectScreen()).get(), 0);
}

JSValuePtr jsSVGZoomEventPreviousScale(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGZoomEvent* imp = static_cast<SVGZoomEvent*>(static_cast<JSSVGZoomEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->previousScale());
}

JSValuePtr jsSVGZoomEventPreviousTranslate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGZoomEvent* imp = static_cast<SVGZoomEvent*>(static_cast<JSSVGZoomEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp->previousTranslate()).get(), 0);
}

JSValuePtr jsSVGZoomEventNewScale(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGZoomEvent* imp = static_cast<SVGZoomEvent*>(static_cast<JSSVGZoomEvent*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->newScale());
}

JSValuePtr jsSVGZoomEventNewTranslate(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGZoomEvent* imp = static_cast<SVGZoomEvent*>(static_cast<JSSVGZoomEvent*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, JSSVGStaticPODTypeWrapper<FloatPoint>::create(imp->newTranslate()).get(), 0);
}


}

#endif // ENABLE(SVG)
