/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGRectElement.h"

#include <wtf/GetPtr.h>

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGRectElement.h"
#include "SVGStringList.h"

#include <runtime/Error.h>
#include <runtime/JSString.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGRectElement)

/* Hash table */

static const HashTableValue JSSVGRectElementTableValues[18] =
{
    { "x", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementX, (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementY, (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementWidth, (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementHeight, (intptr_t)0 },
    { "rx", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRx, (intptr_t)0 },
    { "ry", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRy, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGRectElementXmllang, (intptr_t)setJSSVGRectElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGRectElementXmlspace, (intptr_t)setJSSVGRectElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGRectElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGRectElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 8191, JSSVGRectElementTableValues, 0 };
#else
    { 69, 63, JSSVGRectElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGRectElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGRectElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGRectElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGRectElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGRectElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGRectElementPrototype::s_info = { "SVGRectElementPrototype", 0, &JSSVGRectElementPrototypeTable, 0 };

JSObject* JSSVGRectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRectElement>(exec, globalObject);
}

bool JSSVGRectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGRectElementPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGRectElement::s_info = { "SVGRectElement", &JSSVGElement::s_info, &JSSVGRectElementTable, 0 };

JSSVGRectElement::JSSVGRectElement(PassRefPtr<Structure> structure, PassRefPtr<SVGRectElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGRectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGRectElementPrototype(JSSVGRectElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGRectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGRectElementX(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementY(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementWidth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementHeight(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementRx(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->rxAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementRy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedLength> obj = imp->ryAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValuePtr jsSVGRectElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValuePtr jsSVGRectElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->systemLanguage()), imp);
}

JSValuePtr jsSVGRectElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmllang());
}

JSValuePtr jsSVGRectElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return jsString(exec, imp->xmlspace());
}

JSValuePtr jsSVGRectElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->style()));
}

JSValuePtr jsSVGRectElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGRectElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->nearestViewportElement()));
}

JSValuePtr jsSVGRectElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGRectElement::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSSVGRectElement, Base>(exec, propertyName, value, &JSSVGRectElementTable, this, slot);
}

void setJSSVGRectElementXmllang(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(thisObject)->impl());
    imp->setXmllang(value->toString(exec));
}

void setJSSVGRectElementXmlspace(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    SVGRectElement* imp = static_cast<SVGRectElement*>(static_cast<JSSVGRectElement*>(thisObject)->impl());
    imp->setXmlspace(value->toString(exec));
}

JSValuePtr jsSVGRectElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());
    const UString& extension = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValuePtr jsSVGRectElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());
    const UString& name = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValuePtr jsSVGRectElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValuePtr jsSVGRectElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGRectElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValuePtr jsSVGRectElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGRectElement::s_info))
        return throwError(exec, TypeError);
    JSSVGRectElement* castedThisObj = static_cast<JSSVGRectElement*>(asObject(thisValue));
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(exec, 0));


    JSC::JSValuePtr result = toJS(exec, JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
