/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG) && ENABLE(SVG_FILTERS)

#include "SVGElement.h"
#include "JSSVGFEDistantLightElement.h"

#include <wtf/GetPtr.h>

#include "JSSVGAnimatedNumber.h"
#include "SVGFEDistantLightElement.h"


using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEDistantLightElement)

/* Hash table */

static const HashTableValue JSSVGFEDistantLightElementTableValues[3] =
{
    { "azimuth", DontDelete|ReadOnly, (intptr_t)jsSVGFEDistantLightElementAzimuth, (intptr_t)0 },
    { "elevation", DontDelete|ReadOnly, (intptr_t)jsSVGFEDistantLightElementElevation, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEDistantLightElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSSVGFEDistantLightElementTableValues, 0 };
#else
    { 5, 3, JSSVGFEDistantLightElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGFEDistantLightElementPrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGFEDistantLightElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEDistantLightElementPrototypeTableValues, 0 };
#else
    { 1, 0, JSSVGFEDistantLightElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEDistantLightElementPrototype::s_info = { "SVGFEDistantLightElementPrototype", 0, &JSSVGFEDistantLightElementPrototypeTable, 0 };

JSObject* JSSVGFEDistantLightElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEDistantLightElement>(exec, globalObject);
}

const ClassInfo JSSVGFEDistantLightElement::s_info = { "SVGFEDistantLightElement", &JSSVGElement::s_info, &JSSVGFEDistantLightElementTable, 0 };

JSSVGFEDistantLightElement::JSSVGFEDistantLightElement(PassRefPtr<Structure> structure, PassRefPtr<SVGFEDistantLightElement> impl)
    : JSSVGElement(structure, impl)
{
}

JSObject* JSSVGFEDistantLightElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEDistantLightElementPrototype(JSSVGFEDistantLightElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEDistantLightElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEDistantLightElement, Base>(exec, &JSSVGFEDistantLightElementTable, this, propertyName, slot);
}

JSValuePtr jsSVGFEDistantLightElementAzimuth(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDistantLightElement* imp = static_cast<SVGFEDistantLightElement*>(static_cast<JSSVGFEDistantLightElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->azimuthAnimated();
    return toJS(exec, obj.get(), imp);
}

JSValuePtr jsSVGFEDistantLightElementElevation(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGFEDistantLightElement* imp = static_cast<SVGFEDistantLightElement*>(static_cast<JSSVGFEDistantLightElement*>(asObject(slot.slotBase()))->impl());
    RefPtr<SVGAnimatedNumber> obj = imp->elevationAnimated();
    return toJS(exec, obj.get(), imp);
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FILTERS)
