/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"


#if ENABLE(SVG)

#include "SVGElement.h"
#include "JSSVGElementInstanceList.h"

#include <wtf/GetPtr.h>

#include "JSSVGElementInstance.h"
#include "SVGElementInstance.h"
#include "SVGElementInstanceList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGElementInstanceList)

/* Hash table */

static const HashTableValue JSSVGElementInstanceListTableValues[2] =
{
    { "length", DontDelete|ReadOnly, (intptr_t)jsSVGElementInstanceListLength, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGElementInstanceListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGElementInstanceListTableValues, 0 };
#else
    { 2, 1, JSSVGElementInstanceListTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGElementInstanceListPrototypeTableValues[2] =
{
    { "item", DontDelete|Function, (intptr_t)jsSVGElementInstanceListPrototypeFunctionItem, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSSVGElementInstanceListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGElementInstanceListPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGElementInstanceListPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGElementInstanceListPrototype::s_info = { "SVGElementInstanceListPrototype", 0, &JSSVGElementInstanceListPrototypeTable, 0 };

JSObject* JSSVGElementInstanceListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGElementInstanceList>(exec, globalObject);
}

bool JSSVGElementInstanceListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGElementInstanceListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSSVGElementInstanceList::s_info = { "SVGElementInstanceList", 0, &JSSVGElementInstanceListTable, 0 };

JSSVGElementInstanceList::JSSVGElementInstanceList(PassRefPtr<Structure> structure, PassRefPtr<SVGElementInstanceList> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSSVGElementInstanceList::~JSSVGElementInstanceList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSSVGElementInstanceList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGElementInstanceListPrototype(JSSVGElementInstanceListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSSVGElementInstanceList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGElementInstanceList, Base>(exec, &JSSVGElementInstanceListTable, this, propertyName, slot);
}

JSValuePtr jsSVGElementInstanceListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    SVGElementInstanceList* imp = static_cast<SVGElementInstanceList*>(static_cast<JSSVGElementInstanceList*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValuePtr jsSVGElementInstanceListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSSVGElementInstanceList::s_info))
        return throwError(exec, TypeError);
    JSSVGElementInstanceList* castedThisObj = static_cast<JSSVGElementInstanceList*>(asObject(thisValue));
    SVGElementInstanceList* imp = static_cast<SVGElementInstanceList*>(castedThisObj->impl());
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->item(index)));
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, SVGElementInstanceList* object)
{
    return getDOMObjectWrapper<JSSVGElementInstanceList>(exec, object);
}
SVGElementInstanceList* toSVGElementInstanceList(JSC::JSValuePtr value)
{
    return value->isObject(&JSSVGElementInstanceList::s_info) ? static_cast<JSSVGElementInstanceList*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SVG)
