/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMessagePort.h"

#include <wtf/GetPtr.h>

#include "Event.h"
#include "EventListener.h"
#include "Frame.h"
#include "JSDOMGlobalObject.h"
#include "JSEvent.h"
#include "JSEventListener.h"
#include "JSMessagePort.h"
#include "MessagePort.h"
#include "PlatformString.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMessagePort)

/* Hash table */

static const HashTableValue JSMessagePortTableValues[5] =
{
    { "active", DontDelete|ReadOnly, (intptr_t)jsMessagePortActive, (intptr_t)0 },
    { "onmessage", DontDelete, (intptr_t)jsMessagePortOnmessage, (intptr_t)setJSMessagePortOnmessage },
    { "onclose", DontDelete, (intptr_t)jsMessagePortOnclose, (intptr_t)setJSMessagePortOnclose },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMessagePortConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMessagePortTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSMessagePortTableValues, 0 };
#else
    { 8, 7, JSMessagePortTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMessagePortConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMessagePortConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMessagePortConstructorTableValues, 0 };
#else
    { 1, 0, JSMessagePortConstructorTableValues, 0 };
#endif

class JSMessagePortConstructor : public DOMObject {
public:
    JSMessagePortConstructor(ExecState* exec)
        : DOMObject(JSMessagePortConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSMessagePortPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSMessagePortConstructor::s_info = { "MessagePortConstructor", 0, &JSMessagePortConstructorTable, 0 };

bool JSMessagePortConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessagePortConstructor, DOMObject>(exec, &JSMessagePortConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSMessagePortPrototypeTableValues[8] =
{
    { "postMessage", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionPostMessage, (intptr_t)2 },
    { "startConversation", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionStartConversation, (intptr_t)1 },
    { "start", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionStart, (intptr_t)0 },
    { "close", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionClose, (intptr_t)0 },
    { "addEventListener", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionAddEventListener, (intptr_t)3 },
    { "removeEventListener", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionRemoveEventListener, (intptr_t)3 },
    { "dispatchEvent", DontDelete|Function, (intptr_t)jsMessagePortPrototypeFunctionDispatchEvent, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMessagePortPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSMessagePortPrototypeTableValues, 0 };
#else
    { 18, 15, JSMessagePortPrototypeTableValues, 0 };
#endif

static const HashTable* getJSMessagePortPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessagePortPrototypeTable);
}
const ClassInfo JSMessagePortPrototype::s_info = { "MessagePortPrototype", 0, 0, getJSMessagePortPrototypeTable };

JSObject* JSMessagePortPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMessagePort>(exec, globalObject);
}

bool JSMessagePortPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, getJSMessagePortPrototypeTable(exec), this, propertyName, slot);
}

static const HashTable* getJSMessagePortTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSMessagePortTable);
}
const ClassInfo JSMessagePort::s_info = { "MessagePort", 0, 0, getJSMessagePortTable };

JSMessagePort::JSMessagePort(PassRefPtr<Structure> structure, PassRefPtr<MessagePort> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMessagePort::~JSMessagePort()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMessagePort::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMessagePortPrototype(JSMessagePortPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSMessagePort::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMessagePort, Base>(exec, getJSMessagePortTable(exec), this, propertyName, slot);
}

JSValuePtr jsMessagePortActive(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MessagePort* imp = static_cast<MessagePort*>(static_cast<JSMessagePort*>(asObject(slot.slotBase()))->impl());
    return jsBoolean(imp->active());
}

JSValuePtr jsMessagePortOnmessage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MessagePort* imp = static_cast<MessagePort*>(static_cast<JSMessagePort*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onmessage())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsMessagePortOnclose(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MessagePort* imp = static_cast<MessagePort*>(static_cast<JSMessagePort*>(asObject(slot.slotBase()))->impl());
    if (JSUnprotectedEventListener* listener = static_cast<JSUnprotectedEventListener*>(imp->onclose())) {
        if (JSObject* listenerObj = listener->listenerObj())
            return listenerObj;
    }
    return jsNull();
}

JSValuePtr jsMessagePortConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMessagePort*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSMessagePort::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSMessagePort, Base>(exec, propertyName, value, getJSMessagePortTable(exec), this, slot);
}

void setJSMessagePortOnmessage(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    MessagePort* imp = static_cast<MessagePort*>(static_cast<JSMessagePort*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnmessage(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

void setJSMessagePortOnclose(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    MessagePort* imp = static_cast<MessagePort*>(static_cast<JSMessagePort*>(thisObject)->impl());
    JSDOMGlobalObject* globalObject = toJSDOMGlobalObject(imp->scriptExecutionContext());
    if (!globalObject)
        return;
    imp->setOnclose(globalObject->findOrCreateJSUnprotectedEventListener(exec, value, true));
}

JSValuePtr JSMessagePort::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSMessagePortConstructor>(exec);
}

JSValuePtr jsMessagePortPrototypeFunctionPostMessage(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& message = args.at(exec, 0)->toString(exec);

    int argsCount = args.size();
    if (argsCount < 2) {
        imp->postMessage(message, ec);
        setDOMException(exec, ec);
        return jsUndefined();
    }

    MessagePort* messagePort = toMessagePort(args.at(exec, 1));

    imp->postMessage(message, messagePort, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsMessagePortPrototypeFunctionStartConversation(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    return castedThisObj->startConversation(exec, args);
}

JSValuePtr jsMessagePortPrototypeFunctionStart(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());

    imp->start();
    return jsUndefined();
}

JSValuePtr jsMessagePortPrototypeFunctionClose(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());

    imp->close();
    return jsUndefined();
}

JSValuePtr jsMessagePortPrototypeFunctionAddEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    return castedThisObj->addEventListener(exec, args);
}

JSValuePtr jsMessagePortPrototypeFunctionRemoveEventListener(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    return castedThisObj->removeEventListener(exec, args);
}

JSValuePtr jsMessagePortPrototypeFunctionDispatchEvent(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMessagePort::s_info))
        return throwError(exec, TypeError);
    JSMessagePort* castedThisObj = static_cast<JSMessagePort*>(asObject(thisValue));
    MessagePort* imp = static_cast<MessagePort*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    Event* evt = toEvent(args.at(exec, 0));


    JSC::JSValuePtr result = jsBoolean(imp->dispatchEvent(evt, ec));
    setDOMException(exec, ec);
    return result;
}

JSC::JSValuePtr toJS(JSC::ExecState* exec, MessagePort* object)
{
    return getDOMObjectWrapper<JSMessagePort>(exec, object);
}
MessagePort* toMessagePort(JSC::JSValuePtr value)
{
    return value->isObject(&JSMessagePort::s_info) ? static_cast<JSMessagePort*>(asObject(value))->impl() : 0;
}

}
