/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSMediaList.h"

#include <wtf/GetPtr.h>

#include <runtime/PropertyNameArray.h>
#include "KURL.h"
#include "MediaList.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMediaList)

/* Hash table */

static const HashTableValue JSMediaListTableValues[4] =
{
    { "mediaText", DontDelete, (intptr_t)jsMediaListMediaText, (intptr_t)setJSMediaListMediaText },
    { "length", DontDelete|ReadOnly, (intptr_t)jsMediaListLength, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsMediaListConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaListTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 15, JSMediaListTableValues, 0 };
#else
    { 9, 7, JSMediaListTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSMediaListConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaListConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSMediaListConstructorTableValues, 0 };
#else
    { 1, 0, JSMediaListConstructorTableValues, 0 };
#endif

class JSMediaListConstructor : public DOMObject {
public:
    JSMediaListConstructor(ExecState* exec)
        : DOMObject(JSMediaListConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSMediaListPrototype::self(exec, exec->lexicalGlobalObject()), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSMediaListConstructor::s_info = { "MediaListConstructor", 0, &JSMediaListConstructorTable, 0 };

bool JSMediaListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaListConstructor, DOMObject>(exec, &JSMediaListConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSMediaListPrototypeTableValues[4] =
{
    { "item", DontDelete|Function, (intptr_t)jsMediaListPrototypeFunctionItem, (intptr_t)1 },
    { "deleteMedium", DontDelete|Function, (intptr_t)jsMediaListPrototypeFunctionDeleteMedium, (intptr_t)1 },
    { "appendMedium", DontDelete|Function, (intptr_t)jsMediaListPrototypeFunctionAppendMedium, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSMediaListPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSMediaListPrototypeTableValues, 0 };
#else
    { 8, 7, JSMediaListPrototypeTableValues, 0 };
#endif

const ClassInfo JSMediaListPrototype::s_info = { "MediaListPrototype", 0, &JSMediaListPrototypeTable, 0 };

JSObject* JSMediaListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaList>(exec, globalObject);
}

bool JSMediaListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSMediaListPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSMediaList::s_info = { "MediaList", 0, &JSMediaListTable, 0 };

JSMediaList::JSMediaList(PassRefPtr<Structure> structure, PassRefPtr<MediaList> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSMediaList::~JSMediaList()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSMediaList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSMediaListPrototype(JSMediaListPrototype::createStructure(globalObject->objectPrototype()));
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSMediaListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSMediaList, Base>(exec, &JSMediaListTable, this, propertyName, slot);
}

bool JSMediaList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<MediaList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValuePtr jsMediaListMediaText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MediaList* imp = static_cast<MediaList*>(static_cast<JSMediaList*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->mediaText());
}

JSValuePtr jsMediaListLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    MediaList* imp = static_cast<MediaList*>(static_cast<JSMediaList*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValuePtr jsMediaListConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSMediaList*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSMediaList::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    lookupPut<JSMediaList, Base>(exec, propertyName, value, &JSMediaListTable, this, slot);
}

void setJSMediaListMediaText(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    MediaList* imp = static_cast<MediaList*>(static_cast<JSMediaList*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setMediaText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void JSMediaList::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<MediaList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValuePtr JSMediaList::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSMediaListConstructor>(exec);
}

JSValuePtr jsMediaListPrototypeFunctionItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(asObject(thisValue));
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->item(index));
    return result;
}

JSValuePtr jsMediaListPrototypeFunctionDeleteMedium(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(asObject(thisValue));
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& oldMedium = args.at(exec, 0)->toString(exec);

    imp->deleteMedium(oldMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsMediaListPrototypeFunctionAppendMedium(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSMediaList::s_info))
        return throwError(exec, TypeError);
    JSMediaList* castedThisObj = static_cast<JSMediaList*>(asObject(thisValue));
    MediaList* imp = static_cast<MediaList*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& newMedium = args.at(exec, 0)->toString(exec);

    imp->appendMedium(newMedium, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}


JSValuePtr JSMediaList::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSMediaList* thisObj = static_cast<JSMediaList*>(asObject(slot.slotBase()));
    return jsStringOrNull(exec, thisObj->impl()->item(slot.index()));
}
JSC::JSValuePtr toJS(JSC::ExecState* exec, MediaList* object)
{
    return getDOMObjectWrapper<JSMediaList>(exec, object);
}
MediaList* toMediaList(JSC::JSValuePtr value)
{
    return value->isObject(&JSMediaList::s_info) ? static_cast<JSMediaList*>(asObject(value))->impl() : 0;
}

}
