/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSNavigator.h"

#include <wtf/GetPtr.h>

#include "JSMimeTypeArray.h"
#include "JSPluginArray.h"
#include "MimeTypeArray.h"
#include "Navigator.h"
#include "PlatformString.h"
#include "PluginArray.h"

using namespace KJS;

namespace WebCore {

/* Hash table */

static const HashEntry JSNavigatorTableEntries[] =
{
    { "appVersion", JSNavigator::AppVersionAttrNum, DontDelete|ReadOnly, 0, &JSNavigatorTableEntries[17] },
    { "appCodeName", JSNavigator::AppCodeNameAttrNum, DontDelete|ReadOnly, 0, &JSNavigatorTableEntries[16] },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "productSub", JSNavigator::ProductSubAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "language", JSNavigator::LanguageAttrNum, DontDelete|ReadOnly, 0, &JSNavigatorTableEntries[13] },
    { "appName", JSNavigator::AppNameAttrNum, DontDelete|ReadOnly, 0, &JSNavigatorTableEntries[14] },
    { "vendorSub", JSNavigator::VendorSubAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "vendor", JSNavigator::VendorAttrNum, DontDelete|ReadOnly, 0, 0 },
    { 0, 0, 0, 0, 0 },
    { "mimeTypes", JSNavigator::MimeTypesAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "userAgent", JSNavigator::UserAgentAttrNum, DontDelete|ReadOnly, 0, &JSNavigatorTableEntries[15] },
    { "platform", JSNavigator::PlatformAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "plugins", JSNavigator::PluginsAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "product", JSNavigator::ProductAttrNum, DontDelete|ReadOnly, 0, 0 },
    { "cookieEnabled", JSNavigator::CookieEnabledAttrNum, DontDelete|ReadOnly, 0, 0 }
};

static const HashTable JSNavigatorTable = 
{
    2, 18, JSNavigatorTableEntries, 13
};

/* Hash table for prototype */

static const HashEntry JSNavigatorPrototypeTableEntries[] =
{
    { "javaEnabled", JSNavigator::JavaEnabledFuncNum, DontDelete|Function, 0, 0 }
};

static const HashTable JSNavigatorPrototypeTable = 
{
    2, 1, JSNavigatorPrototypeTableEntries, 1
};

const ClassInfo JSNavigatorPrototype::info = { "NavigatorPrototype", 0, &JSNavigatorPrototypeTable, 0 };

JSObject* JSNavigatorPrototype::self(ExecState* exec)
{
    return KJS::cacheGlobalObject<JSNavigatorPrototype>(exec, "[[JSNavigator.prototype]]");
}

bool JSNavigatorPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSNavigatorPrototypeFunction, JSObject>(exec, &JSNavigatorPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSNavigator::info = { "Navigator", 0, &JSNavigatorTable, 0 };

JSNavigator::JSNavigator(ExecState* exec, Navigator* impl)
    : m_impl(impl)
{
    setPrototype(JSNavigatorPrototype::self(exec));
}

JSNavigator::~JSNavigator()
{
    ScriptInterpreter::forgetDOMObject(m_impl.get());
}

bool JSNavigator::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSNavigator, KJS::DOMObject>(exec, &JSNavigatorTable, this, propertyName, slot);
}

JSValue* JSNavigator::getValueProperty(ExecState* exec, int token) const
{
    switch (token) {
    case AppCodeNameAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->appCodeName());
    }
    case AppNameAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->appName());
    }
    case AppVersionAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->appVersion());
    }
    case LanguageAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->language());
    }
    case UserAgentAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->userAgent());
    }
    case PlatformAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->platform());
    }
    case PluginsAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return toJS(exec, WTF::getPtr(imp->plugins()));
    }
    case MimeTypesAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return toJS(exec, WTF::getPtr(imp->mimeTypes()));
    }
    case ProductAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->product());
    }
    case ProductSubAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->productSub());
    }
    case VendorAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->vendor());
    }
    case VendorSubAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsString(imp->vendorSub());
    }
    case CookieEnabledAttrNum: {
        Navigator* imp = static_cast<Navigator*>(impl());

        return jsBoolean(imp->cookieEnabled());
    }
    }
    return 0;
}

JSValue* JSNavigatorPrototypeFunction::callAsFunction(ExecState* exec, JSObject* thisObj, const List& args)
{
    if (!thisObj->inherits(&JSNavigator::info))
      return throwError(exec, TypeError);

    Navigator* imp = static_cast<Navigator*>(static_cast<JSNavigator*>(thisObj)->impl());

    switch (id) {
    case JSNavigator::JavaEnabledFuncNum: {


        KJS::JSValue* result = jsBoolean(imp->javaEnabled());
        return result;
    }
    }
    return 0;
}
KJS::JSValue* toJS(KJS::ExecState* exec, Navigator* obj)
{
    return KJS::cacheDOMObject<Navigator, JSNavigator>(exec, obj);
}
Navigator* toNavigator(KJS::JSValue* val)
{
    return val->isObject(&JSNavigator::info) ? static_cast<JSNavigator*>(val)->impl() : 0;
}

}
