/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_zoomctrl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:09:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #include "hintids.hxx"

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SVX_ZOOMITEM_HXX //autogen
#include <bf_svx/zoomitem.hxx>
#endif

#include "swtypes.hxx"
#include "zoomctrl.hxx"
namespace binfilter {


/*N*/ SFX_IMPL_STATUSBAR_CONTROL( SwZoomControl, SvxZoomItem );


/*N*/ SwZoomControl::SwZoomControl( USHORT nId,
/*N*/ 								  StatusBar& rStb,
/*N*/ 								  SfxBindings& rBind ) :
/*N*/ 	SvxZoomStatusBarControl( nId, rStb, rBind )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SwZoomControl::~SwZoomControl()
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SwZoomControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 								  const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if(SFX_ITEM_AVAILABLE == eState && pState->ISA( SfxStringItem ))
/*N*/ 	{
/*?*/ 		sPreviewZoom = ((const SfxStringItem*)pState)->GetValue();
/*?*/ 		GetStatusBar().SetItemText( GetId(), sPreviewZoom );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		sPreviewZoom = aEmptyStr;
/*N*/ 		SvxZoomStatusBarControl::StateChanged(nSID, eState, pState);
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SwZoomControl::Paint( const UserDrawEvent& rUsrEvt )
//STRIP001 {
//STRIP001 	if(!sPreviewZoom.Len())
//STRIP001 		SvxZoomStatusBarControl::Paint(rUsrEvt);
//STRIP001 	else
//STRIP001 		GetStatusBar().SetItemText( GetId(), sPreviewZoom );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SwZoomControl::Command( const CommandEvent& rCEvt )
//STRIP001 {
//STRIP001 	if(!sPreviewZoom.Len())
//STRIP001 		SvxZoomStatusBarControl::Command(rCEvt);
//STRIP001 }



}
