/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_barcfg.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:13:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _TOOLS_DEBUG_HXX
// auto strip #include <tools/debug.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UNO_ANY_HXX_
// auto strip #include <com/sun/star/uno/Any.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
// auto strip #include <com/sun/star/uno/Sequence.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#include "barcfg.hxx"
namespace binfilter {

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;

/*N*/ #define C2U(cChar) OUString::createFromAscii(cChar)

/*N*/ #define SEL_TYPE_TABLE_TEXT		0
/*N*/ #define SEL_TYPE_LIST_TEXT      1
/*N*/ #define SEL_TYPE_TABLE_LIST     2
/*N*/ #define SEL_TYPE_BEZIER         3
/*N*/ #define SEL_TYPE_GRAPHIC		4

/* ---------------------------------------------------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ SwToolbarConfigItem::SwToolbarConfigItem( BOOL bWeb ) :
/*N*/     ConfigItem(bWeb ? C2U("Office.WriterWeb/ObjectBar") :  C2U("Office.Writer/ObjectBar"),
/*N*/         CONFIG_MODE_DELAYED_UPDATE|CONFIG_MODE_RELEASE_TREE)
/*N*/ {
/*N*/ 	for(USHORT i = 0; i <= SEL_TYPE_GRAPHIC; i++ )
/*N*/ 		aTbxIdArray[i] = (USHORT)-1;
/*N*/ 
/*N*/ 	Sequence<OUString> aNames = GetPropertyNames();
/*N*/ 	Sequence<Any> aValues = GetProperties(aNames);
/*N*/ 	const Any* pValues = aValues.getConstArray();
/*N*/ 	DBG_ASSERT(aValues.getLength() == aNames.getLength(), "GetProperties failed")
/*N*/ 	if(aValues.getLength() == aNames.getLength())
/*N*/ 	{
/*N*/ 		for(int nProp = 0; nProp < aNames.getLength(); nProp++)
/*N*/ 		{
/*N*/ 			if(pValues[nProp].hasValue())
/*N*/ 			{
/*N*/ 				sal_Int32 nVal;
/*N*/ 				pValues[nProp] >>= nVal;
/*N*/ 				aTbxIdArray[nProp] = (sal_uInt16)nVal;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ }
/* ---------------------------------------------------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ SwToolbarConfigItem::~SwToolbarConfigItem()
/*N*/ {
/*N*/ }
/* ---------------------------------------------------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ sal_Int32 lcl_getArrayIndex(int nSelType)
/*N*/ {
/*N*/ 	sal_Int32 nRet = -1;
/*N*/ 	if(nSelType & SwWrtShell::SEL_NUM)
/*N*/ 	{
/*N*/ 		if(nSelType & SwWrtShell::SEL_TBL)
/*?*/ 			nRet = SEL_TYPE_TABLE_LIST;
/*N*/ 		else
/*N*/ 			nRet = SEL_TYPE_LIST_TEXT;
/*N*/ 	}
/*N*/ 	else if(nSelType & SwWrtShell::SEL_TBL)
/*N*/ 		nRet = SEL_TYPE_TABLE_TEXT;
/*N*/ 	else if(nSelType & SwWrtShell::SEL_BEZ)
/*?*/ 		nRet = SEL_TYPE_BEZIER;
/*N*/ 	else if(nSelType & SwWrtShell::SEL_GRF)
/*?*/ 		nRet = SEL_TYPE_GRAPHIC;
/*N*/ 	return nRet;
/*N*/ }
/* -----------------------------10.10.00 14:38--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void SwToolbarConfigItem::SetTopToolbar( sal_Int32 nSelType, USHORT nBarId )
/*N*/ {
/*N*/ 	sal_Int32 nProp = lcl_getArrayIndex(nSelType);
/*N*/ 	if(nProp >= 0)
/*N*/ 	{
/*?*/ 		aTbxIdArray[nProp] = nBarId;
/*?*/ 		SetModified();
/*N*/ 	}
/*N*/ }
/* ---------------------------------------------------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ sal_uInt16 SwToolbarConfigItem::GetTopToolbar( sal_Int32 nSelType )
/*N*/ {
/*N*/ 	sal_Int32 nProp = lcl_getArrayIndex(nSelType);
/*N*/ 	if(nProp >= 0)
/*N*/ 		return aTbxIdArray[nProp];
/*N*/ 	else
/*N*/ 		return 0xffff;
/*N*/ }
/* -----------------------------10.10.00 13:33--------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ Sequence<OUString> SwToolbarConfigItem::GetPropertyNames()
/*N*/ {
/*N*/ 	static const char* aPropNames[] =
/*N*/ 	{
/*N*/ 		"Selection/Table",                   //  SEL_TYPE_TABLE_TEXT
/*N*/ 		"Selection/NumberedList",            //  SEL_TYPE_LIST_TEXT
/*N*/ 		"Selection/NumberedList_InTable",     //  SEL_TYPE_TABLE_LIST
/*N*/ 		"Selection/BezierObject",   		//  SEL_TYPE_BEZIER
/*N*/ 		"Selection/Graphic"					//SEL_TYPE_GRAPHIC
/*N*/ 	};
/*N*/ 	const int nCount = 5;
/*N*/ 	Sequence<OUString> aNames(nCount);
/*N*/ 	OUString* pNames = aNames.getArray();
/*N*/ 	for(int i = 0; i < nCount; i++)
/*N*/ 		pNames[i] = OUString::createFromAscii(aPropNames[i]);
/*N*/ 	return aNames;
/*N*/ }
/* -----------------------------10.10.00 13:36--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 void SwToolbarConfigItem::Commit()
//STRIP001 {
//STRIP001 	Sequence<OUString> aNames = GetPropertyNames();
//STRIP001 
//STRIP001 	OUString* pNames = aNames.getArray();
//STRIP001 	Sequence<Any> aValues(aNames.getLength());
//STRIP001 	Any* pValues = aValues.getArray();
//STRIP001 
//STRIP001 	const Type& rType = ::getBooleanCppuType();
//STRIP001 	for(int nProp = 0; nProp < aNames.getLength(); nProp++)
//STRIP001 		pValues[nProp] <<= (sal_Int32) (aTbxIdArray[nProp] == 0xffff ? -1 : aTbxIdArray[nProp]);
//STRIP001 	PutProperties(aNames, aValues);
//STRIP001 }

}
