/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_xcpoly.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:39:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #include <math.h>
//STRIP001 #include <tools/debug.hxx>
//STRIP001 #include <vcl/poly.hxx>
//STRIP001 #include "xcpoly.hxx"
//STRIP001 
//STRIP001 #define GLOBALOVERFLOW
//STRIP001 
//STRIP001 
//STRIP001 DBG_NAME( XClipPolygon )
//STRIP001 DBG_NAME( XClipPolyPolygon )
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    XClipPolygon::Inside
//STRIP001 |*
//STRIP001 |*    Beschreibung		Prueft, ob Punkt sich 'innerhalb' einer Kante
//STRIP001 |*						befindet
//STRIP001 |*    Ersterstellung    03.05.95 KA
//STRIP001 |*    Letzte Aenderung  03.05.95 KA
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 BOOL XClipPolygon::Inside(const Point& rPoint, XCPolyEdge eEdge)
//STRIP001 {
//STRIP001 	return 	eEdge == EDGE_LEFT 	? 	rPoint.X() >= aRect.Left() :
//STRIP001 			eEdge == EDGE_TOP 	? 	rPoint.Y() >= aRect.Top() :
//STRIP001 			eEdge == EDGE_RIGHT	? 	rPoint.X() <= aRect.Right()
//STRIP001 								:	rPoint.Y() <= aRect.Bottom();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    XClipPolygon::Intersect
//STRIP001 |*
//STRIP001 |*    Beschreibung		Bildet Schnittpunkt einer Kante mit einer Geraden,
//STRIP001 |* 						die durch zwei Punkte definiert ist
//STRIP001 |*    Ersterstellung    03.05.95 KA
//STRIP001 |*    Letzte Aenderung  03.05.95 KA
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 Point XClipPolygon::Intersect(const Point& rPoint1, const Point& rPoint2, XCPolyEdge eEdge)
//STRIP001 {
//STRIP001 	double 	fX1, fX2;
//STRIP001 	double 	fY1, fY2;
//STRIP001 	double  fX, fY;
//STRIP001 
//STRIP001 
//STRIP001 	if (eEdge == EDGE_LEFT || eEdge == EDGE_RIGHT)
//STRIP001 	{
//STRIP001 		fX = eEdge == EDGE_LEFT ? aRect.Left() : aRect.Right();
//STRIP001 
//STRIP001 		if (rPoint1.X() < rPoint2.X())
//STRIP001 		{
//STRIP001 			fX1 = rPoint1.X(); fY1 = rPoint1.Y();
//STRIP001 			fX2 = rPoint2.X(); fY2 = rPoint2.Y();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			fX1 = rPoint2.X(); fY1 = rPoint2.Y();
//STRIP001 			fX2 = rPoint1.X(); fY2 = rPoint1.Y();
//STRIP001 		}
//STRIP001 
//STRIP001 		fY =	(double)(fY2 - fY1) / (double)(fX2 - fX1) *
//STRIP001 				(double)(fX - fX1) +
//STRIP001 				(double)fY1 + 0.5;
//STRIP001 
//STRIP001 		return Point((long)fX, (long)fY);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		fX = eEdge == EDGE_TOP ? aRect.Top() : aRect.Bottom();
//STRIP001 
//STRIP001 		if (rPoint1.Y() < rPoint2.Y())
//STRIP001 		{
//STRIP001 			fX1 = rPoint1.Y(); fY1 = rPoint1.X();
//STRIP001 			fX2 = rPoint2.Y(); fY2 = rPoint2.X();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			fX1 = rPoint2.Y(); fY1 = rPoint2.X();
//STRIP001 			fX2 = rPoint1.Y(); fY2 = rPoint1.X();
//STRIP001 		}
//STRIP001 
//STRIP001 		fY =	(double)(fY2 - fY1) / (double)(fX2 - fX1) *
//STRIP001 				(double)(fX - fX1) +
//STRIP001 				(double)fY1 + 0.5;
//STRIP001 
//STRIP001 		return Point((long)fY, (long)fX);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    XClipPolygon::ClipEdge
//STRIP001 |*
//STRIP001 |*    Beschreibung		Clipped das uebergebene Polygon an der Kante
//STRIP001 |*
//STRIP001 |*    Ersterstellung    03.05.95 KA
//STRIP001 |*    Letzte Aenderung  03.05.95 KA
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 Polygon	XClipPolygon::ClipEdge(const Polygon& rPoly, XCPolyEdge eEdge)
//STRIP001 {
//STRIP001 	Polygon	aOutPoly(0);
//STRIP001 	USHORT 	nOutSize 	= 0;
//STRIP001 	USHORT	nInSize		= rPoly.GetSize();
//STRIP001 	USHORT	i;
//STRIP001 	Point	aPointP;
//STRIP001 	Point	aPointS;
//STRIP001 
//STRIP001 
//STRIP001 	if (nInSize > 2)
//STRIP001 	{
//STRIP001 		aPointS = rPoly.GetPoint(nInSize - 1);
//STRIP001 
//STRIP001 		for (i = 0; i < nInSize; i++)
//STRIP001 		{
//STRIP001 			aPointP = rPoly.GetPoint(i);
//STRIP001 
//STRIP001 			if (Inside(aPointP, eEdge))
//STRIP001 			{
//STRIP001 				if (Inside(aPointS, eEdge))
//STRIP001 				{
//STRIP001 					aOutPoly.SetSize(++nOutSize);
//STRIP001 					aOutPoly.SetPoint(aPointP, nOutSize - 1);
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					aOutPoly.SetSize(nOutSize += 2);
//STRIP001 					aOutPoly.SetPoint(Intersect(aPointS, aPointP, eEdge), nOutSize - 2);
//STRIP001 					aOutPoly.SetPoint(aPointP, nOutSize - 1);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if (Inside(aPointS, eEdge))
//STRIP001 			{
//STRIP001 				aOutPoly.SetSize(++nOutSize);
//STRIP001 				aOutPoly.SetPoint(Intersect(aPointS, aPointP, eEdge), nOutSize - 1);
//STRIP001 			}
//STRIP001 
//STRIP001 			aPointS = aPointP;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aOutPoly;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    XClipPolygon::GetClippedPolygon
//STRIP001 |*
//STRIP001 |*    Beschreibung		Clipped das uebergebene Polygon an allen Kanten;
//STRIP001 |*						gibt das am Rechteck geclippte Polygon zurueck
//STRIP001 |*
//STRIP001 |*    Ersterstellung    03.05.95 KA
//STRIP001 |*    Letzte Aenderung  03.05.95 KA
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 Polygon	XClipPolygon::GetClippedPolygon()
//STRIP001 {
//STRIP001 	Polygon aTempPoly =	ClipEdge(
//STRIP001 							ClipEdge(
//STRIP001 								ClipEdge(
//STRIP001 									ClipEdge(aInPoly,
//STRIP001 									EDGE_LEFT),
//STRIP001 								EDGE_TOP),
//STRIP001 							EDGE_RIGHT),
//STRIP001 						EDGE_BOTTOM);
//STRIP001 
//STRIP001 
//STRIP001 	// Post-Processing, um ungueltige Polygone zu vermeiden
//STRIP001 	// und doppelte Punkte zu unterdruecken
//STRIP001 	Polygon aOutPoly(0);
//STRIP001 	USHORT	i;
//STRIP001 	USHORT	nCount = 1;
//STRIP001 	USHORT	nSize = aTempPoly.GetSize();
//STRIP001 	Point	aLeastPoint;
//STRIP001 	Point	aLastPoint;
//STRIP001 	Point	aTempPoint;
//STRIP001 
//STRIP001 
//STRIP001 	if (nSize > 2)
//STRIP001 	{
//STRIP001 		aOutPoly.SetSize(nCount++);
//STRIP001 		aOutPoly[0] = aLeastPoint = aTempPoly[0];
//STRIP001 
//STRIP001 
//STRIP001 		// letzten und vorletzten Punkt ermitteln
//STRIP001 		if ((aLastPoint = aTempPoly[1]) != aLeastPoint)
//STRIP001 		{
//STRIP001 			aOutPoly.SetSize(nCount++);
//STRIP001 			aOutPoly[1] = aLastPoint;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aLastPoint = aLeastPoint;
//STRIP001 
//STRIP001 
//STRIP001 		// jeden neuen Punkt mit dem letzten und vorletzten Punkt
//STRIP001 		// vergleichen und entsprechend setzen oder nicht
//STRIP001 		nSize--;
//STRIP001 		for (i = 2; i < nSize; i++)
//STRIP001 		{
//STRIP001 			aTempPoint = aTempPoly[i];
//STRIP001 
//STRIP001 			if ((aTempPoint != aLastPoint) && (aTempPoint != aLeastPoint))
//STRIP001 			{
//STRIP001 				aOutPoly.SetSize(nCount++);
//STRIP001 				aOutPoly[nCount - 2] = aTempPoint;
//STRIP001 
//STRIP001 				aLeastPoint = aLastPoint;
//STRIP001 				aLastPoint	= aTempPoint;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		// letzter Punkt im Polygon darf nicht mit erstem Punkt zusammenfallen
//STRIP001 		if ((aTempPoint = aTempPoly[nSize]) != aOutPoly[0])
//STRIP001 		{
//STRIP001 			aOutPoly.SetSize(nCount);
//STRIP001 			aOutPoly[nCount - 1] = aTempPoint;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	return aOutPoly;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*    XClipPolyPolygon::GetClippedPolyPolygon
//STRIP001 |*
//STRIP001 |*    Beschreibung		Clipped das uebergebene PolyPolygon an allen Kanten;
//STRIP001 |*						gibt das am Rechteck geclippte PolyPolygon zurueck
//STRIP001 |*
//STRIP001 |*    Ersterstellung    09.05.95 KA
//STRIP001 |*    Letzte Aenderung  09.05.95 KA
//STRIP001 |*
//STRIP001 *************************************************************************/
//STRIP001 
//STRIP001 PolyPolygon	XClipPolyPolygon::GetClippedPolyPolygon()
//STRIP001 {
//STRIP001 	USHORT		nCount = aInPolyPoly.Count();
//STRIP001 	PolyPolygon	aOutPolyPoly;
//STRIP001 	Polygon		aOutPoly;
//STRIP001 	USHORT		i;
//STRIP001 
//STRIP001 		USHORT 	j;
//STRIP001 		Point	aP;
//STRIP001 
//STRIP001 	aOutPolyPoly.Clear();
//STRIP001 
//STRIP001 	for (i = 0; i < nCount; i++)
//STRIP001 	{
//STRIP001 		XClipPolygon aClipPoly(aInPolyPoly.GetObject(i), aRect);
//STRIP001 		aOutPoly = aClipPoly.GetClippedPolygon();
//STRIP001 
//STRIP001 		for (j = 0; j < aOutPoly.GetSize(); j++)
//STRIP001 		{
//STRIP001 			aP = aOutPoly[j];
//STRIP001 		}
//STRIP001 
//STRIP001 
//STRIP001 		if (aOutPoly.GetSize() > 2)
//STRIP001 			aOutPolyPoly.Insert(aOutPoly);
//STRIP001 	}
//STRIP001 
//STRIP001 	return aOutPolyPoly;
//STRIP001 }


}
