/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_transfrm.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:12:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#define ITEMID_SIZE	0

#ifndef _SHL_HXX //autogen
#include <tools/shl.hxx>
#endif

#ifndef _SFXAPP_HXX //autogen
#include <bf_sfx2/app.hxx>
#endif

#ifndef _SVDVIEW_HXX //autogen
#include "svdview.hxx"
#endif
#ifndef _SVDOBJ_HXX //autogen
#include "svdobj.hxx"
#endif
#ifndef _SVDPAGV_HXX //autogen
#include "svdpagv.hxx"
#endif
#ifndef _SVDOTEXT_HXX //autogen
#include "svdotext.hxx"
#endif
#ifndef _SDERITM_HXX //autogen
#include "sderitm.hxx"
#endif

#include <svxids.hrc>
#include "dialogs.hrc"
#include "transfrm.hrc"
#include "sizeitem.hxx"

#include "transfrm.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "svxenum.hxx"
#include "anchorid.hxx"

#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif

#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif

#ifndef _AEITEM_HXX //autogen
#include <svtools/aeitem.hxx>
#endif
namespace binfilter {

// Toleranz fuer WorkingArea
//STRIP001 #define DIFF 1000
//STRIP001 
//STRIP001 // static ----------------------------------------------------------------
//STRIP001 
//STRIP001 static USHORT pPosRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_TRANSFORM_POS_X,
//STRIP001 	SID_ATTR_TRANSFORM_POS_Y,
//STRIP001 	SID_ATTR_TRANSFORM_PROTECT_POS,
//STRIP001 	SID_ATTR_TRANSFORM_PROTECT_POS,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_ANCHOR,
//STRIP001 	SID_ATTR_TRANSFORM_VERT_ORIENT,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pSizeRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_TRANSFORM_WIDTH,
//STRIP001 	SID_ATTR_TRANSFORM_SIZE_POINT,
//STRIP001 	SID_ATTR_TRANSFORM_PROTECT_POS,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_AUTOWIDTH,
//STRIP001 	SID_ATTR_TRANSFORM_AUTOHEIGHT,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pPosSizeRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_TRANSFORM_POS_X,
//STRIP001 	SID_ATTR_TRANSFORM_POS_Y,
//STRIP001 	SID_ATTR_TRANSFORM_PROTECT_POS,
//STRIP001 	SID_ATTR_TRANSFORM_PROTECT_POS,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_ANCHOR,
//STRIP001 	SID_ATTR_TRANSFORM_VERT_ORIENT,
//STRIP001 	SID_ATTR_TRANSFORM_WIDTH,
//STRIP001 	SID_ATTR_TRANSFORM_SIZE_POINT,
//STRIP001 	SID_ATTR_TRANSFORM_PROTECT_POS,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_AUTOWIDTH,
//STRIP001 	SID_ATTR_TRANSFORM_AUTOHEIGHT,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pAngleRanges[] =
//STRIP001 {
//STRIP001 	SID_ATTR_TRANSFORM_ROT_X,
//STRIP001 	SID_ATTR_TRANSFORM_ANGLE,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 static USHORT pSlantRanges[] =
//STRIP001 {
//STRIP001 	SDRATTR_ECKENRADIUS,
//STRIP001 	SDRATTR_ECKENRADIUS,
//STRIP001 	SID_ATTR_TRANSFORM_SHEAR,
//STRIP001 	SID_ATTR_TRANSFORM_SHEAR_VERTICAL,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	SID_ATTR_TRANSFORM_INTERN,
//STRIP001 	0
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 // Funktion ConvertRect
//STRIP001 Rectangle lcl_ConvertRect( const Rectangle& rInRect, USHORT nDigits, MapUnit ePoolUnit, FieldUnit eDlgUnit )
//STRIP001 {
//STRIP001 	Rectangle aRect;
//STRIP001 	aRect.Left()   = MetricField::ConvertValue( rInRect.Left(), nDigits, ePoolUnit, eDlgUnit );
//STRIP001 	aRect.Right()  = MetricField::ConvertValue( rInRect.Right(), nDigits, ePoolUnit, eDlgUnit );
//STRIP001 	aRect.Top()    = MetricField::ConvertValue( rInRect.Top(), nDigits, ePoolUnit, eDlgUnit );
//STRIP001 	aRect.Bottom() = MetricField::ConvertValue( rInRect.Bottom(), nDigits, ePoolUnit, eDlgUnit );
//STRIP001 	return( aRect );
//STRIP001 }
//STRIP001 
//STRIP001 // Funktion ConvertPoint
//STRIP001 Point lcl_ConvertPoint( Point aInPt, USHORT nDigits, MapUnit ePoolUnit, FieldUnit eDlgUnit )
//STRIP001 {
//STRIP001 	Point aPt;
//STRIP001 	aPt.X() = MetricField::ConvertValue( aInPt.X(), nDigits, ePoolUnit, eDlgUnit );
//STRIP001 	aPt.Y() = MetricField::ConvertValue( aInPt.Y(), nDigits, ePoolUnit, eDlgUnit );
//STRIP001 	return( aPt );
//STRIP001 }
//STRIP001 
//STRIP001 // Funktion ScaleRect (Beruecksichtigung des Massstabes)
//STRIP001 void lcl_ScaleRect( Rectangle& aRect, Fraction aUIScale )
//STRIP001 {
//STRIP001 	aRect.Left()      = Fraction( aRect.Left() )   / aUIScale;
//STRIP001 	aRect.Right()     = Fraction( aRect.Right() )  / aUIScale;
//STRIP001 	aRect.Top()       = Fraction( aRect.Top() )    / aUIScale;
//STRIP001 	aRect.Bottom()    = Fraction( aRect.Bottom() ) / aUIScale;
//STRIP001 }
//STRIP001 
//STRIP001 // Funktion ScalePoint (Beruecksichtigung des Massstabes)
//STRIP001 void lcl_ScalePoint( Point& aPt, Fraction aUIScale )
//STRIP001 {
//STRIP001 	aPt.X() = Fraction( aPt.X() ) / aUIScale;
//STRIP001 	aPt.Y() = Fraction( aPt.Y() ) / aUIScale;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Konstruktor des Tab-Dialogs: Fuegt die Seiten zum Dialog hinzu
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxTransformTabDialog::SvxTransformTabDialog( Window* pParent, const SfxItemSet* pAttr,
//STRIP001 								const SdrView* pSdrView, USHORT nAnchorTypes ) :
//STRIP001 	SfxTabDialog( pParent, ResId( RID_SVXDLG_TRANSFORM, DIALOG_MGR() ), pAttr ),
//STRIP001 	pView       ( pSdrView ),
//STRIP001 	nAnchorCtrls(nAnchorTypes)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 
//STRIP001 	AddTabPage( RID_SVXPAGE_POSITION_SIZE, SvxPositionSizeTabPage::Create,
//STRIP001 							SvxPositionSizeTabPage::GetRanges );
//STRIP001 	AddTabPage( RID_SVXPAGE_ANGLE, SvxAngleTabPage::Create,
//STRIP001 							SvxAngleTabPage::GetRanges );
//STRIP001 	AddTabPage( RID_SVXPAGE_SLANT, SvxSlantTabPage::Create,
//STRIP001 							SvxSlantTabPage::GetRanges );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxTransformTabDialog::~SvxTransformTabDialog()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxTransformTabDialog::PageCreated( USHORT nId, SfxTabPage &rPage )
//STRIP001 {
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case RID_SVXPAGE_POSITION_SIZE:
//STRIP001 			( (SvxPositionSizeTabPage&) rPage ).SetView( pView );
//STRIP001 			( (SvxPositionSizeTabPage&) rPage ).Construct();
//STRIP001 			if( nAnchorCtrls & SVX_OBJ_NORESIZE )
//STRIP001 				( (SvxPositionSizeTabPage&) rPage ).DisableResize();
//STRIP001 
//STRIP001 			if( nAnchorCtrls & SVX_OBJ_NOPROTECT )
//STRIP001 				( (SvxPositionSizeTabPage&) rPage ).DisableProtect();
//STRIP001 
//STRIP001 			if(nAnchorCtrls & 0x00ff )
//STRIP001 				( (SvxPositionSizeTabPage&) rPage ).ShowAnchorCtrls(nAnchorCtrls);
//STRIP001 		break;
//STRIP001 
//STRIP001 		case RID_SVXPAGE_ANGLE:
//STRIP001 			( (SvxAngleTabPage&) rPage ).SetView( pView );
//STRIP001 			( (SvxAngleTabPage&) rPage ).Construct();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case RID_SVXPAGE_SLANT:
//STRIP001 			( (SvxSlantTabPage&) rPage ).SetView( pView );
//STRIP001 			( (SvxSlantTabPage&) rPage ).Construct();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*      Dialog zum Aendern der Position des Drehwinkels und des Drehwinkels
//STRIP001 |*      der Grafikobjekte
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxAngleTabPage::SvxAngleTabPage( Window* pParent, const SfxItemSet& rInAttrs  ) :
//STRIP001 	SvxTabPage              ( pParent, ResId( RID_SVXPAGE_ANGLE, DIALOG_MGR() ), rInAttrs ),
//STRIP001 	aFlPosition				( this, ResId( FL_POSITION ) ),
//STRIP001 	aFtPosX                 ( this, ResId( FT_POS_X ) ),
//STRIP001 	aMtrPosX                ( this, ResId( MTR_FLD_POS_X ) ),
//STRIP001 	aFtPosY                 ( this, ResId( FT_POS_Y ) ),
//STRIP001 	aMtrPosY                ( this, ResId( MTR_FLD_POS_Y ) ),
//STRIP001 	aFtPosPresets			( this, ResId(FT_POSPRESETS) ),	
//STRIP001 	aCtlRect                ( this, ResId( CTL_RECT ) ),
//STRIP001 	
//STRIP001 	aFlAngle                ( this, ResId( FL_ANGLE ) ),
//STRIP001 	aFtAngle                ( this, ResId( FT_ANGLE ) ),
//STRIP001 	aMtrAngle               ( this, ResId( MTR_FLD_ANGLE ) ),
//STRIP001 	aFtAnglePresets			( this, ResId(FT_ANGLEPRESETS) ),	
//STRIP001 	aCtlAngle               ( this, ResId( CTL_ANGLE ),
//STRIP001 								RP_RB, 200, 80, CS_ANGLE ),
//STRIP001 	rOutAttrs               ( rInAttrs )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 //!     SetExchangeSupport(); noch nicht
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SID_ATTR_TRANSFORM_POS_X );
//STRIP001 
//STRIP001 	aMtrAngle.SetModifyHdl( LINK( this, SvxAngleTabPage, ModifiedHdl ) );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAngleTabPage::Construct()
//STRIP001 {
//STRIP001 	// Setzen des Rechtecks
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 	eDlgUnit = GetModuleFieldUnit( &GetItemSet() );
//STRIP001 	SetFieldUnit( aMtrPosX, eDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( aMtrPosY, eDlgUnit, TRUE );
//STRIP001 
//STRIP001 	if( eDlgUnit == FUNIT_MILE ||
//STRIP001 		eDlgUnit == FUNIT_KM )
//STRIP001 	{
//STRIP001 		aMtrPosX.SetDecimalDigits( 3 );
//STRIP001 		aMtrPosY.SetDecimalDigits( 3 );
//STRIP001 	}
//STRIP001 
//STRIP001 	aRect = pView->GetAllMarkedRect();
//STRIP001 	pView->GetPageViewPvNum( 0 )->LogicToPagePos( aRect );
//STRIP001 
//STRIP001 	// Ankerposition beachten (Writer)
//STRIP001 	const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 	if( rMarkList.GetMarkCount() >= 1 )
//STRIP001 	{
//STRIP001 		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 		aAnchorPos = pObj->GetAnchorPos();
//STRIP001 
//STRIP001 		if( aAnchorPos != Point( 0, 0 ) ) // -> Writer
//STRIP001 		{
//STRIP001 			aRect.Left() -= aAnchorPos.X();
//STRIP001 			aRect.Right() -= aAnchorPos.X();
//STRIP001 			aRect.Top() -= aAnchorPos.Y();
//STRIP001 			aRect.Bottom() -= aAnchorPos.Y();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Massstab
//STRIP001 	Fraction aUIScale = pView->GetModel()->GetUIScale();
//STRIP001 	lcl_ScaleRect( aRect, aUIScale );
//STRIP001 
//STRIP001 	// Umrechnung auf UI-Unit
//STRIP001 	int nDigits = aMtrPosX.GetDecimalDigits();
//STRIP001 	aRect = lcl_ConvertRect( aRect, nDigits, (MapUnit) ePoolUnit, eDlgUnit );
//STRIP001 
//STRIP001 	if( !pView->IsRotateAllowed() )
//STRIP001 	{
//STRIP001 		aFlPosition.Disable();
//STRIP001 		aFtPosX.Disable();
//STRIP001 		aMtrPosX.Disable();
//STRIP001 		aFtPosY.Disable();
//STRIP001 		aMtrPosY.Disable();
//STRIP001 		aFtPosPresets.Disable();
//STRIP001 		aCtlRect.Disable();
//STRIP001 		aFlAngle.Disable();
//STRIP001 		aFtAngle.Disable();
//STRIP001 		aMtrAngle.Disable();
//STRIP001 		aFtAnglePresets.Disable();
//STRIP001 		aCtlAngle.Disable();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxAngleTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 
//STRIP001 	if(aMtrAngle.IsValueModified()
//STRIP001 		|| aMtrPosX.IsValueModified()
//STRIP001 		|| aMtrPosY.IsValueModified())
//STRIP001 	{
//STRIP001 		rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_ANGLE ),
//STRIP001 						aMtrAngle.GetValue() ) );
//STRIP001 
//STRIP001 		Fraction aUIScale = pView->GetModel()->GetUIScale();
//STRIP001 		long nTmp = GetCoreValue( aMtrPosX, ePoolUnit );
//STRIP001 		nTmp += aAnchorPos.X();
//STRIP001 		nTmp = Fraction( nTmp ) * aUIScale;
//STRIP001 		rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_ROT_X ), nTmp ) );
//STRIP001 
//STRIP001 		nTmp = GetCoreValue( aMtrPosY, ePoolUnit );
//STRIP001 		nTmp += aAnchorPos.Y();
//STRIP001 		nTmp = Fraction( nTmp ) * aUIScale;
//STRIP001 		rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_ROT_Y ), nTmp ) );
//STRIP001 
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAngleTabPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_ROT_X );
//STRIP001 
//STRIP001 	Fraction aUIScale = pView->GetModel()->GetUIScale();
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - aAnchorPos.X();;
//STRIP001 		nTmp = Fraction( nTmp ) / aUIScale;
//STRIP001 		SetMetricValue( aMtrPosX, nTmp, ePoolUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrPosX.SetText( String() );
//STRIP001 
//STRIP001 	pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_ROT_Y );
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - aAnchorPos.Y();;
//STRIP001 		nTmp = Fraction( nTmp ) / aUIScale;
//STRIP001 		SetMetricValue( aMtrPosY, nTmp, ePoolUnit );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aMtrPosX.SetText( String() );
//STRIP001 	pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_ANGLE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 		aMtrAngle.SetValue( ( (const SfxInt32Item*)pItem )->GetValue() );
//STRIP001 	else
//STRIP001 		aMtrAngle.SetText( String() );
//STRIP001 	aMtrAngle.SaveValue();
//STRIP001 
//STRIP001 	ModifiedHdl( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxAngleTabPage::Create( Window* pWindow,
//STRIP001 									 const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxAngleTabPage( pWindow, rOutAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxAngleTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pAngleRanges );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAngleTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxAngleTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxAngleTabPage::PointChanged( Window* pWindow, RECT_POINT eRP )
//STRIP001 {
//STRIP001 	if( pWindow == &aCtlRect )
//STRIP001 	{
//STRIP001 		switch( eRP )
//STRIP001 		{
//STRIP001 			case RP_LT:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Left(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Top(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_MT:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Center().X(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Top(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_RT:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Right(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Top(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_LM:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Left(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Center().Y(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_MM:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Center().X(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Center().Y(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_RM:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Right(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Center().Y(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_LB:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Left(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Bottom(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_MB:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Center().X(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Bottom(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 			case RP_RB:
//STRIP001 				aMtrPosX.SetUserValue( aRect.Right(), FUNIT_NONE );
//STRIP001 				aMtrPosY.SetUserValue( aRect.Bottom(), FUNIT_NONE );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( pWindow == &aCtlAngle )
//STRIP001 	{
//STRIP001 		switch( eRP )
//STRIP001 		{
//STRIP001 			case RP_LT: aMtrAngle.SetUserValue( 13500, FUNIT_NONE ); break;
//STRIP001 			case RP_MT: aMtrAngle.SetUserValue(  9000, FUNIT_NONE ); break;
//STRIP001 			case RP_RT: aMtrAngle.SetUserValue(  4500, FUNIT_NONE ); break;
//STRIP001 			case RP_LM: aMtrAngle.SetUserValue( 18000, FUNIT_NONE ); break;
//STRIP001 			case RP_RM: aMtrAngle.SetUserValue(     0, FUNIT_NONE ); break;
//STRIP001 			case RP_LB: aMtrAngle.SetUserValue( 22500, FUNIT_NONE ); break;
//STRIP001 			case RP_MB: aMtrAngle.SetUserValue( 27000, FUNIT_NONE ); break;
//STRIP001 			case RP_RB: aMtrAngle.SetUserValue( 31500, FUNIT_NONE ); break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxAngleTabPage, ModifiedHdl, void *, p )
//STRIP001 {
//STRIP001 	// Setzen des Winkels im AngleControl
//STRIP001 	switch( aMtrAngle.GetValue() )
//STRIP001 	{
//STRIP001 		case 13500: aCtlAngle.SetActualRP( RP_LT ); break;
//STRIP001 		case  9000: aCtlAngle.SetActualRP( RP_MT ); break;
//STRIP001 		case  4500: aCtlAngle.SetActualRP( RP_RT ); break;
//STRIP001 		case 18000: aCtlAngle.SetActualRP( RP_LM ); break;
//STRIP001 		case     0: aCtlAngle.SetActualRP( RP_RM ); break;
//STRIP001 		case 22500: aCtlAngle.SetActualRP( RP_LB ); break;
//STRIP001 		case 27000: aCtlAngle.SetActualRP( RP_MB ); break;
//STRIP001 		case 31500: aCtlAngle.SetActualRP( RP_RB ); break;
//STRIP001 		default:    aCtlAngle.SetActualRP( RP_MM ); break;
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*      Dialog zum Aendern des Eckenradius und zum Schraegstellen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxSlantTabPage::SvxSlantTabPage( Window* pParent, const SfxItemSet& rInAttrs  ) :
//STRIP001 	SvxTabPage              ( pParent, ResId( RID_SVXPAGE_SLANT, DIALOG_MGR() ), rInAttrs ),
//STRIP001 
//STRIP001 	aFlRadius               ( this, ResId( FL_RADIUS ) ),
//STRIP001 	aFtRadius               ( this, ResId( FT_RADIUS ) ),
//STRIP001 	aMtrRadius              ( this, ResId( MTR_FLD_RADIUS ) ),
//STRIP001 	aFlAngle                ( this, ResId( FL_SLANT ) ),
//STRIP001 	aFtAngle                ( this, ResId( FT_ANGLE ) ),
//STRIP001 	aMtrAngle               ( this, ResId( MTR_FLD_ANGLE ) ),
//STRIP001 	rOutAttrs               ( rInAttrs )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	ePoolUnit = pPool->GetMetric( SID_ATTR_TRANSFORM_POS_X );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSlantTabPage::Construct()
//STRIP001 {
//STRIP001 	// Setzen des Rechtecks
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 	eDlgUnit = GetModuleFieldUnit( &GetItemSet() );
//STRIP001 	SetFieldUnit( aMtrRadius, eDlgUnit, TRUE );
//STRIP001 
//STRIP001 	aRect = pView->GetAllMarkedRect();
//STRIP001 	pView->GetPageViewPvNum( 0 )->LogicToPagePos( aRect );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SvxSlantTabPage, ModifiedHdl, void *, p )
//STRIP001 {
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxSlantTabPage, ModifiedHdl, void *, p )
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxSlantTabPage::FillItemSet( SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	BOOL  bModified = FALSE;
//STRIP001 	INT32 nValue = 0L;
//STRIP001 
//STRIP001 	String aStr = aMtrRadius.GetText();
//STRIP001 	if( aStr != aMtrRadius.GetSavedValue() )
//STRIP001 	{
//STRIP001 		Fraction aUIScale = pView->GetModel()->GetUIScale();
//STRIP001 		long nTmp = GetCoreValue( aMtrRadius, ePoolUnit );
//STRIP001 		nTmp = Fraction( nTmp ) * aUIScale;
//STRIP001 
//STRIP001 		rAttrs.Put( SdrEckenradiusItem( nTmp ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	aStr = aMtrAngle.GetText();
//STRIP001 	if( aStr != aMtrAngle.GetSavedValue() )
//STRIP001 	{
//STRIP001 		nValue = aMtrAngle.GetValue();
//STRIP001 		rAttrs.Put( SfxInt32Item( SID_ATTR_TRANSFORM_SHEAR, nValue ) );
//STRIP001 		bModified = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bModified )
//STRIP001 	{
//STRIP001 		// Referenzpunkt setzen
//STRIP001 		// #75897#
//STRIP001 		Rectangle aObjectRect(pView->GetAllMarkedRect());
//STRIP001 		pView->GetPageViewPvNum(0)->LogicToPagePos(aObjectRect);
//STRIP001 		Point aPt = aObjectRect.Center();
//STRIP001 
//STRIP001 		rAttrs.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR_X, aPt.X()));
//STRIP001 		rAttrs.Put(SfxInt32Item(SID_ATTR_TRANSFORM_SHEAR_Y, aPt.Y()));
//STRIP001 		
//STRIP001 		// Referenzpunkt setzen
//STRIP001 //		Point aPt = aRect.Center();
//STRIP001 //		rAttrs.Put( SfxInt32Item( SID_ATTR_TRANSFORM_SHEAR_X, aPt.X() ) );
//STRIP001 //	rAttrs.Put( SfxInt32Item( SID_ATTR_TRANSFORM_SHEAR_Y, aPt.Y() ) );
//STRIP001 
//STRIP001 		rAttrs.Put( SfxBoolItem( SID_ATTR_TRANSFORM_SHEAR_VERTICAL, FALSE ) );
//STRIP001 	}
//STRIP001 	return( bModified );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSlantTabPage::Reset( const SfxItemSet& rAttrs )
//STRIP001 {
//STRIP001 	// Wenn die View selektierte Objekte besitzt, muessen entspr. Items,
//STRIP001 	// die SFX_ITEM_DEFAULT sind, disabled werden
//STRIP001 	BOOL bMarkedObj = pView->HasMarkedObj();
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 	// Eckenradius
//STRIP001 //A	if( bMarkedObj && SFX_ITEM_DEFAULT == rAttrs.GetItemState( SDRATTR_ECKENRADIUS ) )
//STRIP001 //A	{
//STRIP001 	if( !pView->IsEdgeRadiusAllowed() )
//STRIP001 	{
//STRIP001 		aFlRadius.Disable();
//STRIP001 		aFtRadius.Disable();
//STRIP001 		aMtrRadius.Disable();
//STRIP001 		aMtrRadius.SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pItem = GetItem( rAttrs, SDRATTR_ECKENRADIUS );
//STRIP001 
//STRIP001 		if( pItem )
//STRIP001 		{
//STRIP001 			Fraction aUIScale = pView->GetModel()->GetUIScale();
//STRIP001 			long nTmp = ( (const SdrEckenradiusItem*)pItem )->GetValue();
//STRIP001 			nTmp = Fraction( nTmp ) / aUIScale;
//STRIP001 			SetMetricValue( aMtrRadius, nTmp, ePoolUnit );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aMtrRadius.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrRadius.SaveValue();
//STRIP001 
//STRIP001 	// Schraegstellen: Winkel
//STRIP001 	//SfxItemState eState = rAttrs.GetItemState( SID_ATTR_TRANSFORM_SHEAR );
//STRIP001 	//if( ( bMarkedObj && SFX_ITEM_DEFAULT == eState ) ||
//STRIP001 	if( !pView->IsShearAllowed() )
//STRIP001 	{
//STRIP001 		aFlAngle.Disable();
//STRIP001 		aFtAngle.Disable();
//STRIP001 		aMtrAngle.Disable();
//STRIP001 		aMtrAngle.SetText( String() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pItem = GetItem( rAttrs, SID_ATTR_TRANSFORM_SHEAR );
//STRIP001 
//STRIP001 		if( pItem )
//STRIP001 			aMtrAngle.SetValue( ( (const SfxInt32Item*)pItem )->GetValue() );
//STRIP001 		else
//STRIP001 			aMtrAngle.SetText( String() );
//STRIP001 	}
//STRIP001 	aMtrAngle.SaveValue();
//STRIP001 
//STRIP001 	ModifiedHdl( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxSlantTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxSlantTabPage( pWindow, rOutAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxSlantTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pSlantRanges );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSlantTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxRectangleItem* pRectItem = NULL;
//STRIP001 
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_ATTR_TRANSFORM_INTERN ) , FALSE,
//STRIP001 									(const SfxPoolItem**) &pRectItem ) )
//STRIP001 	{
//STRIP001 		aRect = pRectItem->GetValue();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxSlantTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxSlantTabPage::PointChanged( Window* pWindow, RECT_POINT eRP )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |*      Dialog for changing position and size of graphic objects
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SvxPositionSizeTabPage::SvxPositionSizeTabPage( Window* pParent, const SfxItemSet& rInAttrs  ) :
//STRIP001 	SvxTabPage      ( pParent, ResId( RID_SVXPAGE_POSITION_SIZE, DIALOG_MGR() ), rInAttrs ),
//STRIP001 	maFlPosition		( this, ResId( FL_POSITION ) ),
//STRIP001 	maFtPosX			( this, ResId( FT_POS_X ) ),
//STRIP001 	maMtrPosX			( this, ResId( MTR_FLD_POS_X ) ),
//STRIP001 	maFtPosY			( this, ResId( FT_POS_Y ) ),
//STRIP001 	maMtrPosY			( this, ResId( MTR_FLD_POS_Y ) ),
//STRIP001 	maFlProtect			( this, ResId( FL_PROTECT) ),
//STRIP001 	maTsbPosProtect     ( this, ResId( TSB_POSPROTECT ) ),
//STRIP001 	maFtPosReference	( this, ResId( FT_POSREFERENCE ) ),
//STRIP001 	maCtlPos            ( this, ResId( CTL_POSRECT ), RP_LT ),
//STRIP001 	maAnchorBox      ( this, ResId( FL_ANCHOR ) ),
//STRIP001 	maFtAnchor       ( this, ResId( FT_ANCHOR ) ),
//STRIP001 	maDdLbAnchor     ( this, ResId( LB_ANCHOR ) ),
//STRIP001 	maFtOrient       ( this, ResId( FT_ORIENT ) ),
//STRIP001 	maDdLbOrient     ( this, ResId( LB_ORIENT ) ),
//STRIP001 	mbPageDisabled   ( FALSE ),
//STRIP001 
//STRIP001 	maFlSize                         ( this, ResId( FL_SIZE ) ),
//STRIP001 	maFtWidth                        ( this, ResId( FT_WIDTH ) ),
//STRIP001 	maMtrWidth                       ( this, ResId( MTR_FLD_WIDTH ) ),
//STRIP001 	maFtHeight                       ( this, ResId( FT_HEIGHT ) ),
//STRIP001 	maMtrHeight                      ( this, ResId( MTR_FLD_HEIGHT ) ),
//STRIP001 	maCbxScale                       ( this, ResId( CBX_SCALE ) ),
//STRIP001 	maTsbSizeProtect				 ( this, ResId( TSB_SIZEPROTECT ) ),
//STRIP001 	maFtSizeReference				 ( this, ResId( FT_SIZEREFERENCE) ),	
//STRIP001 	maCtlSize                        ( this, ResId( CTL_SIZERECT ), RP_LT ),
//STRIP001 	maFlAdjust                       ( this, ResId( FL_ADJUST ) ),
//STRIP001 	maTsbAutoGrowWidth				( this, ResId( TSB_AUTOGROW_WIDTH ) ),
//STRIP001 	maTsbAutoGrowHeight				( this, ResId( TSB_AUTOGROW_HEIGHT ) ),
//STRIP001 
//STRIP001 	maFlDivider						(this, ResId( FL_DIVIDER ) ),
//STRIP001     mnProtectSizeState( STATE_NOCHECK ),
//STRIP001 	mbProtectDisabled( false ),
//STRIP001 	mbSizeDisabled( false ),
//STRIP001 
//STRIP001 	mrOutAttrs       ( rInAttrs )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// diese Page braucht ExchangeSupport
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// PoolUnit ermitteln
//STRIP001 	SfxItemPool* pPool = mrOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 	mePoolUnit = pPool->GetMetric( SID_ATTR_TRANSFORM_POS_X );
//STRIP001 
//STRIP001 	maDdLbAnchor.SetSelectHdl( LINK( this, SvxPositionSizeTabPage, SetAnchorHdl ) );
//STRIP001 	maDdLbOrient.SetSelectHdl( LINK( this, SvxPositionSizeTabPage, SetOrientHdl ) );
//STRIP001 
//STRIP001 	meRP = RP_LT; // s.o.
//STRIP001 
//STRIP001 	maMtrWidth.SetModifyHdl( LINK( this, SvxPositionSizeTabPage, ChangeWidthHdl ) );
//STRIP001 	maMtrHeight.SetModifyHdl( LINK( this, SvxPositionSizeTabPage, ChangeHeightHdl ) );
//STRIP001 
//STRIP001 	maCbxScale.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ClickAutoHdl ) );
//STRIP001 
//STRIP001 	maTsbAutoGrowWidth.Disable();
//STRIP001 	maTsbAutoGrowHeight.Disable();
//STRIP001 	maFlAdjust.Disable();
//STRIP001 
//STRIP001 	// #i2379# disable controls when protected
//STRIP001 	maTsbPosProtect.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ChangePosProtectHdl ) );
//STRIP001 	maTsbSizeProtect.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ChangeSizeProtectHdl ) );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::Construct()
//STRIP001 {
//STRIP001 	// Setzen des Rechtecks und der Workingarea
//STRIP001 	DBG_ASSERT( mpView, "Keine gueltige View Uebergeben!" );
//STRIP001 	meDlgUnit = GetModuleFieldUnit( &GetItemSet() );
//STRIP001 	SetFieldUnit( maMtrPosX, meDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( maMtrPosY, meDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( maMtrWidth, meDlgUnit, TRUE );
//STRIP001 	SetFieldUnit( maMtrHeight, meDlgUnit, TRUE );
//STRIP001 
//STRIP001 	if( meDlgUnit == FUNIT_MILE ||
//STRIP001 		meDlgUnit == FUNIT_KM )
//STRIP001 	{
//STRIP001 		maMtrPosX.SetDecimalDigits( 3 );
//STRIP001 		maMtrPosY.SetDecimalDigits( 3 );
//STRIP001 		maMtrWidth.SetDecimalDigits( 3 );
//STRIP001 		maMtrHeight.SetDecimalDigits( 3 );
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	maRect = mpView->GetAllMarkedRect();
//STRIP001 	mpView->GetPageViewPvNum( 0 )->LogicToPagePos( maRect );
//STRIP001 
//STRIP001 	// WorkArea holen und umrechnen:
//STRIP001 	maWorkArea = mpView->GetWorkArea();
//STRIP001 
//STRIP001 	// Beruecksichtigung Ankerposition (bei Writer)
//STRIP001 	const SdrMarkList& rMarkList = mpView->GetMarkList();
//STRIP001 	if( rMarkList.GetMarkCount() >= 1 )
//STRIP001 	{
//STRIP001 		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 		maAnchorPos = pObj->GetAnchorPos();
//STRIP001 
//STRIP001 		if( maAnchorPos != Point(0,0) ) // -> Writer
//STRIP001 		{
//STRIP001 			for( USHORT i = 1; i < rMarkList.GetMarkCount(); i++ )
//STRIP001 			{
//STRIP001 				pObj = rMarkList.GetMark( i )->GetObj();
//STRIP001 				if( maAnchorPos != pObj->GetAnchorPos() )
//STRIP001 				{
//STRIP001 					// Unterschiedliche Ankerpositionen
//STRIP001 					maFtPosX.Disable();
//STRIP001 					maMtrPosX.Disable();
//STRIP001 					maMtrPosX.SetText( String() );
//STRIP001 					maFtPosY.Disable();
//STRIP001 					maMtrPosY.Disable();
//STRIP001 					maMtrPosY.SetText( String() );
//STRIP001 					maFlPosition.Disable();
//STRIP001 					maFtPosReference.Disable();
//STRIP001 					maCtlPos.Disable();
//STRIP001 					maTsbPosProtect.Disable();
//STRIP001 					mbPageDisabled = TRUE;
//STRIP001 					return;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		Point aPt = maAnchorPos * -1;
//STRIP001 		Point aPt2 = aPt;
//STRIP001 
//STRIP001 		aPt += maWorkArea.TopLeft();
//STRIP001 		maWorkArea.SetPos( aPt );
//STRIP001 
//STRIP001 		aPt2 += maRect.TopLeft();
//STRIP001 		maRect.SetPos( aPt2 );
//STRIP001 	}
//STRIP001 
//STRIP001 	// this should happen via SID_ATTR_TRANSFORM_AUTOSIZE 
//STRIP001 	if( rMarkList.GetMarkCount() == 1 )
//STRIP001 	{
//STRIP001 		const SdrObject* pObj = rMarkList.GetMark( 0 )->GetObj();
//STRIP001 		SdrObjKind eKind = (SdrObjKind) pObj->GetObjIdentifier();
//STRIP001 		if( ( pObj->GetObjInventor() == SdrInventor ) &&
//STRIP001 			( eKind==OBJ_TEXT || eKind==OBJ_TITLETEXT || eKind==OBJ_OUTLINETEXT) &&
//STRIP001 			( (SdrTextObj*) pObj )->HasText() )
//STRIP001 		{
//STRIP001 			maFlAdjust.Enable();
//STRIP001 			maTsbAutoGrowWidth.Enable();
//STRIP001 			maTsbAutoGrowHeight.Enable();
//STRIP001 			maTsbAutoGrowWidth.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ClickSizeProtectHdl ) );
//STRIP001 			maTsbAutoGrowHeight.SetClickHdl( LINK( this, SvxPositionSizeTabPage, ClickSizeProtectHdl ) );
//STRIP001 
//STRIP001 			// Wird als Flag benutzt, um zu ermitteln, ob anwaehlbar ist
//STRIP001 			maTsbAutoGrowWidth.EnableTriState( FALSE );
//STRIP001 			maTsbAutoGrowHeight.EnableTriState( FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	// use page offset and recalculate
//STRIP001 	Point aPt( mpView->GetPageViewPvNum( 0 )->GetPageOrigin() );
//STRIP001 
//STRIP001 	// Massstab
//STRIP001 	Fraction aUIScale = mpView->GetModel()->GetUIScale();
//STRIP001 
//STRIP001 	lcl_ScaleRect( maWorkArea, aUIScale );
//STRIP001 	lcl_ScaleRect( maRect, aUIScale );
//STRIP001 	lcl_ScalePoint( aPt, aUIScale );
//STRIP001 
//STRIP001 	// Metrik konvertieren
//STRIP001 	int nDigits = maMtrPosX.GetDecimalDigits();
//STRIP001 
//STRIP001 	aPt = lcl_ConvertPoint( aPt, nDigits, (MapUnit) mePoolUnit, meDlgUnit );
//STRIP001 	maWorkArea = lcl_ConvertRect( maWorkArea, nDigits, (MapUnit) mePoolUnit, meDlgUnit );
//STRIP001 	maRect = lcl_ConvertRect( maRect, nDigits, (MapUnit) mePoolUnit, meDlgUnit );
//STRIP001 
//STRIP001 	// use page offset
//STRIP001 	aPt *= -1;
//STRIP001 	aPt += maWorkArea.TopLeft();
//STRIP001 	maWorkArea.SetPos( aPt );
//STRIP001 
//STRIP001 	SetMinMaxPosition();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SvxPositionSizeTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	if ( maMtrWidth.HasFocus() )
//STRIP001 		ChangeWidthHdl( this );
//STRIP001 	if ( maMtrHeight.HasFocus() )
//STRIP001 		ChangeHeightHdl( this );
//STRIP001 
//STRIP001 	BOOL bModified = FALSE;
//STRIP001 	if( !mbPageDisabled )
//STRIP001 	{
//STRIP001 		if ( maMtrPosX.IsValueModified() || maMtrPosY.IsValueModified() )
//STRIP001 		{
//STRIP001 			long lX = GetCoreValue( maMtrPosX, mePoolUnit );
//STRIP001 			long lY = GetCoreValue( maMtrPosY, mePoolUnit );
//STRIP001 
//STRIP001 			// Altes Rechteck mit CoreUnit
//STRIP001 			maRect = mpView->GetAllMarkedRect();
//STRIP001 			mpView->GetPageViewPvNum( 0 )->LogicToPagePos( maRect );
//STRIP001 
//STRIP001 			Fraction aUIScale = mpView->GetModel()->GetUIScale();
//STRIP001 			lX += maAnchorPos.X();
//STRIP001 			lX = Fraction( lX ) * aUIScale;
//STRIP001 			lY += maAnchorPos.Y();
//STRIP001 			lY = Fraction( lY ) * aUIScale;
//STRIP001 			
//STRIP001 			// #101581# GetTopLeftPosition(...) needs coordinates
//STRIP001 			// after UI scaling, in real PagePositions.
//STRIP001 			GetTopLeftPosition( lX, lY, maRect );
//STRIP001 
//STRIP001 			rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_POS_X ), (INT32) lX ) );
//STRIP001 			rOutAttrs.Put( SfxInt32Item( GetWhich( SID_ATTR_TRANSFORM_POS_Y ), (INT32) lY ) );
//STRIP001 
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( maTsbPosProtect.GetState() != maTsbPosProtect.GetSavedValue() )
//STRIP001 		{
//STRIP001 			if( maTsbPosProtect.GetState() == STATE_DONTKNOW )
//STRIP001 				rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_PROTECT_POS );
//STRIP001 			else
//STRIP001 				rOutAttrs.Put(
//STRIP001 					SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_PROTECT_POS ),
//STRIP001 					maTsbPosProtect.GetState() == STATE_CHECK ? TRUE : FALSE ) );
//STRIP001 			bModified |= TRUE;
//STRIP001 		}
//STRIP001 		if(maAnchorBox.IsVisible()) //nur fuer den Writer
//STRIP001 		{
//STRIP001 			if(maDdLbAnchor.GetSavedValue() != maDdLbAnchor.GetSelectEntryPos())
//STRIP001 			{
//STRIP001 				bModified |= TRUE;
//STRIP001 				rOutAttrs.Put(SfxUInt16Item(
//STRIP001 						SID_ATTR_TRANSFORM_ANCHOR, (USHORT)(ULONG)maDdLbAnchor.GetEntryData(maDdLbAnchor.GetSelectEntryPos())));
//STRIP001 			}
//STRIP001 			if(maDdLbOrient.GetSavedValue() != maDdLbOrient.GetSelectEntryPos())
//STRIP001 			{
//STRIP001 				bModified |= TRUE;
//STRIP001 				rOutAttrs.Put(SfxUInt16Item(
//STRIP001 						SID_ATTR_TRANSFORM_VERT_ORIENT, maDdLbOrient.GetSelectEntryPos()));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( maMtrWidth.IsValueModified() || maMtrHeight.IsValueModified() )
//STRIP001 	{
//STRIP001 		Fraction aUIScale = mpView->GetModel()->GetUIScale();
//STRIP001 
//STRIP001 		// get Width
//STRIP001 		double nWidth = maMtrWidth.GetValue( meDlgUnit );
//STRIP001 		nWidth = MetricField::ConvertDoubleValue( nWidth, maMtrWidth.GetBaseValue(), maMtrWidth.GetDecimalDigits(), meDlgUnit, FUNIT_100TH_MM );
//STRIP001 		long lWidth = nWidth * (double)aUIScale;
//STRIP001 		lWidth = OutputDevice::LogicToLogic( lWidth, MAP_100TH_MM, (MapUnit)mePoolUnit );
//STRIP001 		lWidth = maMtrWidth.Denormalize( lWidth );
//STRIP001 
//STRIP001 		// get Height
//STRIP001 		double nHeight = maMtrHeight.GetValue( meDlgUnit );
//STRIP001 		nHeight = MetricField::ConvertDoubleValue( nHeight, maMtrHeight.GetBaseValue(), maMtrHeight.GetDecimalDigits(), meDlgUnit, FUNIT_100TH_MM );
//STRIP001 		long lHeight = nHeight * (double)aUIScale;
//STRIP001 		lHeight = OutputDevice::LogicToLogic( lHeight, MAP_100TH_MM, (MapUnit)mePoolUnit );
//STRIP001 		lHeight = maMtrWidth.Denormalize( lHeight );
//STRIP001 
//STRIP001 		// put Width & Height to itemset
//STRIP001 		rOutAttrs.Put( SfxUInt32Item( GetWhich( SID_ATTR_TRANSFORM_WIDTH ),
//STRIP001 						(UINT32) lWidth ) );
//STRIP001 		rOutAttrs.Put( SfxUInt32Item( GetWhich( SID_ATTR_TRANSFORM_HEIGHT ),
//STRIP001 						(UINT32) lHeight ) );
//STRIP001 		rOutAttrs.Put( SfxAllEnumItem( GetWhich( SID_ATTR_TRANSFORM_SIZE_POINT ), meRP ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( maTsbSizeProtect.GetState() != maTsbSizeProtect.GetSavedValue() )
//STRIP001 	{
//STRIP001 		if ( maTsbSizeProtect.GetState() == STATE_DONTKNOW )
//STRIP001 			rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_PROTECT_SIZE );
//STRIP001 		else
//STRIP001 			rOutAttrs.Put(
//STRIP001 				SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_PROTECT_SIZE ),
//STRIP001 				maTsbSizeProtect.GetState() == STATE_CHECK ? TRUE : FALSE ) );
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( maTsbAutoGrowWidth.GetState() != maTsbAutoGrowWidth.GetSavedValue() )
//STRIP001 	{
//STRIP001 		if ( !maTsbAutoGrowWidth.IsTriStateEnabled() )
//STRIP001 		{
//STRIP001 			if( maTsbAutoGrowWidth.GetState() == STATE_DONTKNOW )
//STRIP001 				rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_AUTOWIDTH );
//STRIP001 			else
//STRIP001 				rOutAttrs.Put(
//STRIP001 					SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_AUTOWIDTH ),
//STRIP001 					maTsbAutoGrowWidth.GetState() == STATE_CHECK ? TRUE : FALSE ) );
//STRIP001 		}
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( maTsbAutoGrowHeight.GetState() != maTsbAutoGrowHeight.GetSavedValue() )
//STRIP001 	{
//STRIP001 		if ( !maTsbAutoGrowHeight.IsTriStateEnabled() )
//STRIP001 		{
//STRIP001 			if( maTsbAutoGrowHeight.GetState() == STATE_DONTKNOW )
//STRIP001 				rOutAttrs.InvalidateItem( SID_ATTR_TRANSFORM_AUTOHEIGHT );
//STRIP001 			else
//STRIP001 				rOutAttrs.Put(
//STRIP001 					SfxBoolItem( GetWhich( SID_ATTR_TRANSFORM_AUTOHEIGHT ),
//STRIP001 					maTsbAutoGrowHeight.GetState() == STATE_CHECK ? TRUE : FALSE ) );
//STRIP001 		}
//STRIP001 		bModified |= TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	return bModified;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 
//STRIP001 	if ( !mbPageDisabled )
//STRIP001 	{
//STRIP001 		pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_POS_X );
//STRIP001 
//STRIP001 		Fraction aUIScale = mpView->GetModel()->GetUIScale();
//STRIP001 		if ( pItem )
//STRIP001 		{
//STRIP001 			long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - maAnchorPos.X();
//STRIP001 			nTmp = Fraction( nTmp ) / aUIScale;
//STRIP001 
//STRIP001 			SetMetricValue( maMtrPosX, nTmp, mePoolUnit );
//STRIP001 		}
//STRIP001 
//STRIP001 		pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_POS_Y );
//STRIP001 		if ( pItem )
//STRIP001 		{
//STRIP001 			long nTmp = ( (const SfxInt32Item*)pItem )->GetValue() - maAnchorPos.Y();
//STRIP001 			nTmp = Fraction( nTmp ) / aUIScale;
//STRIP001 
//STRIP001 			SetMetricValue( maMtrPosY, nTmp, mePoolUnit );
//STRIP001 		}
//STRIP001 
//STRIP001 		pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_PROTECT_POS );
//STRIP001 		if ( pItem )
//STRIP001 		{
//STRIP001 			sal_Bool bProtected = ( ( const SfxBoolItem* )pItem )->GetValue();
//STRIP001 			maTsbPosProtect.SetState( bProtected ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 			maTsbPosProtect.EnableTriState( FALSE );
//STRIP001 			maTsbSizeProtect.Enable( !mbProtectDisabled & !bProtected );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			maTsbPosProtect.SetState( STATE_DONTKNOW );
//STRIP001 			maTsbSizeProtect.Enable( !mbProtectDisabled );
//STRIP001 		}
//STRIP001 
//STRIP001 		maTsbPosProtect.SaveValue();
//STRIP001 		maCtlPos.Reset();
//STRIP001 
//STRIP001         // #i2379# Disable controls for protected objects
//STRIP001         ChangePosProtectHdl( this );
//STRIP001 
//STRIP001 		if(maAnchorBox.IsVisible()) //nur fuer den Writer
//STRIP001 		{
//STRIP001 			pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_ANCHOR );
//STRIP001 			USHORT nAnchorPos = 0;
//STRIP001 			if(pItem)
//STRIP001 			{
//STRIP001 				nAnchorPos = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 				for (USHORT i = 0; i < maDdLbAnchor.GetEntryCount(); i++)
//STRIP001 				{
//STRIP001 					if ((ULONG)maDdLbAnchor.GetEntryData(i) == (ULONG)nAnchorPos)
//STRIP001 					{
//STRIP001 						maDdLbAnchor.SelectEntryPos(i);
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				maDdLbAnchor.SaveValue();
//STRIP001 				SetAnchorHdl(&maDdLbAnchor);
//STRIP001 			}
//STRIP001 			if(nAnchorPos == (USHORT)SVX_FLY_IN_CNTNT)
//STRIP001 			{
//STRIP001 				maCtlPos.Disable();
//STRIP001 				pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_VERT_ORIENT );
//STRIP001 				if(pItem)
//STRIP001 				{
//STRIP001 					maDdLbOrient.SelectEntryPos(((const SfxUInt16Item*)pItem)->GetValue());
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				maDdLbOrient.SelectEntryPos(     (USHORT)SVX_VERT_LINE_CENTER );
//STRIP001 			}
//STRIP001 			maDdLbOrient.SaveValue();
//STRIP001 			SetOrientHdl(&maDdLbOrient);
//STRIP001 			maCtlPos.Invalidate();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_WIDTH );
//STRIP001 	mlOldWidth = Max( pItem ? ( (const SfxUInt32Item*)pItem )->GetValue() : 0, (UINT32)1 );
//STRIP001 
//STRIP001 	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_HEIGHT );
//STRIP001 	mlOldHeight = Max( pItem ? ( (const SfxUInt32Item*)pItem )->GetValue() : 0, (UINT32)1 );
//STRIP001 
//STRIP001 	Fraction aUIScale = mpView->GetModel()->GetUIScale();
//STRIP001 
//STRIP001 	// set Width & Height
//STRIP001 	double nTmpWidth  = (double)OutputDevice::LogicToLogic( mlOldWidth, (MapUnit)mePoolUnit, MAP_100TH_MM );
//STRIP001 	double nTmpHeight = (double)OutputDevice::LogicToLogic( mlOldHeight, (MapUnit)mePoolUnit, MAP_100TH_MM );
//STRIP001 	nTmpWidth  = Fraction( nTmpWidth ) / aUIScale;
//STRIP001 	nTmpHeight = Fraction( nTmpHeight ) / aUIScale;
//STRIP001 
//STRIP001 	UINT32 nNorm = 10;
//STRIP001 	for( int i=0; i<maMtrWidth.GetDecimalDigits()-1; i++ )
//STRIP001 		nNorm*=10;
//STRIP001 	nTmpWidth*=(double)nNorm;
//STRIP001 
//STRIP001 	nNorm = 10;
//STRIP001 	for( i=0; i<maMtrHeight.GetDecimalDigits()-1; i++ )
//STRIP001 		nNorm*=10;
//STRIP001 	nTmpHeight*=(double)nNorm;
//STRIP001 
//STRIP001 	nTmpWidth =  MetricField::ConvertDoubleValue( (double)nTmpWidth, maMtrWidth.GetBaseValue(), maMtrWidth.GetDecimalDigits(), FUNIT_100TH_MM, meDlgUnit );
//STRIP001 	nTmpHeight = MetricField::ConvertDoubleValue( (double)nTmpHeight, maMtrHeight.GetBaseValue(), maMtrHeight.GetDecimalDigits(), FUNIT_100TH_MM, meDlgUnit );
//STRIP001 
//STRIP001 	maMtrWidth.SetValue( nTmpWidth, meDlgUnit );
//STRIP001 	maMtrHeight.SetValue( nTmpHeight, meDlgUnit );
//STRIP001 
//STRIP001 	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_PROTECT_SIZE );
//STRIP001 
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		maTsbSizeProtect.SetState( ( (const SfxBoolItem*)pItem )->GetValue()
//STRIP001 							  ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 		maTsbSizeProtect.EnableTriState( FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		maTsbSizeProtect.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_AUTOWIDTH );
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		maTsbAutoGrowWidth.SetState( ( ( const SfxBoolItem* )pItem )->GetValue()
//STRIP001 						   ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		maTsbAutoGrowWidth.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 	pItem = GetItem( mrOutAttrs, SID_ATTR_TRANSFORM_AUTOHEIGHT );
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		maTsbAutoGrowHeight.SetState( ( ( const SfxBoolItem* )pItem )->GetValue()
//STRIP001 						   ? STATE_CHECK : STATE_NOCHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		maTsbAutoGrowHeight.SetState( STATE_DONTKNOW );
//STRIP001 
//STRIP001 	// Ist Abgleich gesetzt?
//STRIP001 	String aStr = GetUserData();
//STRIP001 	maCbxScale.Check( (BOOL)aStr.ToInt32() );
//STRIP001 
//STRIP001 	maTsbSizeProtect.SaveValue();
//STRIP001 	maTsbAutoGrowWidth.SaveValue();
//STRIP001 	maTsbAutoGrowHeight.SaveValue();
//STRIP001 	ClickSizeProtectHdl( NULL );
//STRIP001 
//STRIP001     // #i2379# Disable controls for protected objects
//STRIP001     ChangeSizeProtectHdl( this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SfxTabPage* SvxPositionSizeTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxPositionSizeTabPage( pWindow, rOutAttrs ) );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT* SvxPositionSizeTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pPosSizeRanges );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxRectangleItem* pRectItem = NULL;
//STRIP001 
//STRIP001 	if( SFX_ITEM_SET == rSet.GetItemState( GetWhich( SID_ATTR_TRANSFORM_INTERN ) , FALSE,
//STRIP001 									(const SfxPoolItem**) &pRectItem ) )
//STRIP001 	{
//STRIP001 		// Setzen der MinMax-Position
//STRIP001 		maRect = pRectItem->GetValue();
//STRIP001 		SetMinMaxPosition();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 int SvxPositionSizeTabPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if( pSet )
//STRIP001 	{
//STRIP001 		INT32 lX = maMtrPosX.GetValue();
//STRIP001 		INT32 lY = maMtrPosY.GetValue();
//STRIP001 
//STRIP001 		// #106330#
//STRIP001 		// The below BugFix assumed that GetTopLeftPosition()
//STRIP001 		// needs special coordinate systems. This is not true,
//STRIP001 		// GetTopLeftPosition() just needs all parameters in one
//STRIP001 		// coor system. Thus, this part below is not necessary and
//STRIP001 		// leads to this new bug. Thus, i remove it again.
//STRIP001 		// I checked that #106330# works and #101581# is fixed, too.
//STRIP001 		//
//STRIP001 		// // #101581# GetTopLeftPosition(...) needs coordinates
//STRIP001 		// // after UI scaling, in real PagePositions. Thus I added
//STRIP001 		// // that calculation here
//STRIP001 		// Fraction aUIScale = mpView->GetModel()->GetUIScale();
//STRIP001 		// lX += maAnchorPos.X();
//STRIP001 		// lX = Fraction( lX ) * aUIScale;
//STRIP001 		// lY += maAnchorPos.Y();
//STRIP001 		// lY = Fraction( lY ) * aUIScale;
//STRIP001 		
//STRIP001 		GetTopLeftPosition( lX, lY, maRect );
//STRIP001 		
//STRIP001 		maRect.SetPos( Point( lX, lY ) );
//STRIP001 
//STRIP001 		pSet->Put( SfxRectangleItem( SID_ATTR_TRANSFORM_INTERN, maRect ) );
//STRIP001 
//STRIP001 		FillItemSet( *pSet );
//STRIP001 	}
//STRIP001 	return( LEAVE_PAGE );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, ChangePosProtectHdl, void *, p )
//STRIP001 {
//STRIP001 	maTsbSizeProtect.Enable( !mbProtectDisabled & (maTsbPosProtect.GetState() != STATE_CHECK) );
//STRIP001 
//STRIP001     // #106572# Remember user's last choice
//STRIP001 	maTsbSizeProtect.SetState( maTsbPosProtect.GetState() == STATE_CHECK ? 
//STRIP001                                STATE_CHECK : mnProtectSizeState );
//STRIP001 
//STRIP001     DisableSizeControls();
//STRIP001 
//STRIP001 	if( maTsbPosProtect.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		maFlPosition.Disable();
//STRIP001 		maFtPosX.Disable();
//STRIP001 		maMtrPosX.Disable();
//STRIP001 		maFtPosY.Disable();
//STRIP001 		maMtrPosY.Disable();
//STRIP001         maFtPosReference.Disable();
//STRIP001 		maCtlPos.Disable();
//STRIP001 		maCtlPos.Invalidate();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		maFlPosition.Enable();
//STRIP001 		maFtPosX.Enable();
//STRIP001 		maMtrPosX.Enable();
//STRIP001 		maFtPosY.Enable();
//STRIP001 		maMtrPosY.Enable();
//STRIP001         maFtPosReference.Enable();
//STRIP001 		maCtlPos.Enable();
//STRIP001 		maCtlPos.Invalidate();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::DisableSizeControls()
//STRIP001 {
//STRIP001 	if( maTsbSizeProtect.GetState() == STATE_CHECK )
//STRIP001 	{
//STRIP001 		maFlSize.Disable();
//STRIP001 		maFtWidth.Disable();
//STRIP001 		maMtrWidth.Disable();
//STRIP001 		maFtHeight.Disable();
//STRIP001 		maMtrHeight.Disable();
//STRIP001         maCbxScale.Disable();
//STRIP001         maFtSizeReference.Disable();
//STRIP001 		maCtlSize.Disable();
//STRIP001 		maCtlSize.Invalidate();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		maFlSize.Enable();
//STRIP001 		maFtWidth.Enable();
//STRIP001 		maMtrWidth.Enable();
//STRIP001 		maFtHeight.Enable();
//STRIP001 		maMtrHeight.Enable();
//STRIP001         maCbxScale.Enable();
//STRIP001         maFtSizeReference.Enable();
//STRIP001 		maCtlSize.Enable();
//STRIP001 		maCtlSize.Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, ChangeSizeProtectHdl, void *, p )
//STRIP001 {
//STRIP001 	if( maTsbSizeProtect.IsEnabled() )
//STRIP001 	{
//STRIP001         // #106572# Remember user's last choice
//STRIP001 
//STRIP001         // Note: this works only as long as the dialog is open.  When
//STRIP001         // the user closes the dialog, there is no way to remember
//STRIP001         // whether size was enabled or disabled befor pos protect was
//STRIP001         // clicked. Thus, if pos protect is selected, the dialog is
//STRIP001         // closed and reopened again, unchecking pos protect will
//STRIP001         // always uncheck size protect, too. That's life.
//STRIP001         mnProtectSizeState = maTsbSizeProtect.GetState();
//STRIP001     }
//STRIP001 
//STRIP001     DisableSizeControls();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SvxPositionSizeTabPage, ChangePosXHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxPositionSizeTabPage, ChangePosXHdl, void *, EMPTYARG )
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SvxPositionSizeTabPage, ChangePosYHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxPositionSizeTabPage, ChangePosYHdl, void *, EMPTYARG )
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::SetMinMaxPosition()
//STRIP001 {
//STRIP001 	// position
//STRIP001 	Rectangle aTmpRect = maWorkArea;
//STRIP001 
//STRIP001 	switch ( maCtlPos.GetActualRP() )
//STRIP001 	{
//STRIP001 		case RP_LT:
//STRIP001 			aTmpRect.Right()  -= maRect.Right() - maRect.Left();
//STRIP001 			aTmpRect.Bottom() -= maRect.Bottom() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_MT:
//STRIP001 			aTmpRect.Left()   += maRect.Center().X() - maRect.Left();
//STRIP001 			aTmpRect.Right()  -= maRect.Center().X() - maRect.Left();
//STRIP001 			aTmpRect.Bottom() -= maRect.Bottom() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_RT:
//STRIP001 			aTmpRect.Left()   += maRect.Right() - maRect.Left();
//STRIP001 			aTmpRect.Bottom() -= maRect.Bottom() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_LM:
//STRIP001 			aTmpRect.Right()  -= maRect.Right() - maRect.Left();
//STRIP001 			aTmpRect.Top()    += maRect.Center().Y() - maRect.Top();
//STRIP001 			aTmpRect.Bottom() -= maRect.Center().Y() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_MM:
//STRIP001 			aTmpRect.Left()   += maRect.Center().X() - maRect.Left();
//STRIP001 			aTmpRect.Right()  -= maRect.Center().X() - maRect.Left();
//STRIP001 			aTmpRect.Top()    += maRect.Center().Y() - maRect.Top();
//STRIP001 			aTmpRect.Bottom() -= maRect.Center().Y() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_RM:
//STRIP001 			aTmpRect.Left()   += maRect.Right() - maRect.Left();
//STRIP001 			aTmpRect.Top()    += maRect.Center().Y() - maRect.Top();
//STRIP001 			aTmpRect.Bottom() -= maRect.Center().Y() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_LB:
//STRIP001 			aTmpRect.Right()  -= maRect.Right() - maRect.Left();
//STRIP001 			aTmpRect.Top()    += maRect.Bottom() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_MB:
//STRIP001 			aTmpRect.Left()   += maRect.Center().X() - maRect.Left();
//STRIP001 			aTmpRect.Right()  -= maRect.Center().X() - maRect.Left();
//STRIP001 			aTmpRect.Top()    += maRect.Bottom() - maRect.Top();
//STRIP001 			break;
//STRIP001 		case RP_RB:
//STRIP001 			aTmpRect.Left()   += maRect.Right() - maRect.Left();
//STRIP001 			aTmpRect.Top()    += maRect.Bottom() - maRect.Top();
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	long nMaxLong = MetricField::ConvertValue( LONG_MAX, 0, MAP_100TH_MM, meDlgUnit ) - 1L;
//STRIP001 
//STRIP001 	if( Abs( aTmpRect.Left() ) > nMaxLong )
//STRIP001 	{
//STRIP001 		long nMult = aTmpRect.Left() < 0 ? -1 : 1;
//STRIP001 		aTmpRect.Left() = nMaxLong * nMult;
//STRIP001 	}
//STRIP001 	if( Abs( aTmpRect.Right() ) > nMaxLong )
//STRIP001 	{
//STRIP001 		long nMult = aTmpRect.Right() < 0 ? -1 : 1;
//STRIP001 		aTmpRect.Right() = nMaxLong * nMult;
//STRIP001 	}
//STRIP001 	if( Abs( aTmpRect.Top() ) > nMaxLong )
//STRIP001 	{
//STRIP001 		long nMult = aTmpRect.Top() < 0 ? -1 : 1;
//STRIP001 		aTmpRect.Top() = nMaxLong * nMult;
//STRIP001 	}
//STRIP001 	if( Abs( aTmpRect.Bottom() ) > nMaxLong )
//STRIP001 	{
//STRIP001 		long nMult = aTmpRect.Bottom() < 0 ? -1 : 1;
//STRIP001 		aTmpRect.Bottom() = nMaxLong * nMult;
//STRIP001 	}
//STRIP001 
//STRIP001 	maMtrPosX.SetMin( aTmpRect.Left() );
//STRIP001 	maMtrPosX.SetFirst( aTmpRect.Left() );
//STRIP001 	maMtrPosX.SetMax( aTmpRect.Right() );
//STRIP001 	maMtrPosX.SetLast( aTmpRect.Right() );
//STRIP001 
//STRIP001 	maMtrPosY.SetMin( aTmpRect.Top() );
//STRIP001 	maMtrPosY.SetFirst( aTmpRect.Top() );
//STRIP001 	maMtrPosY.SetMax( aTmpRect.Bottom() );
//STRIP001 	maMtrPosY.SetLast( aTmpRect.Bottom() );
//STRIP001 
//STRIP001 	// size
//STRIP001 	aTmpRect = maWorkArea;
//STRIP001 
//STRIP001 	switch ( maCtlSize.GetActualRP() )
//STRIP001 	{
//STRIP001 		case RP_LT:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 				aTmpRect.GetWidth() - ( maRect.Left() - aTmpRect.Left() ),
//STRIP001 				aTmpRect.GetHeight() - ( maRect.Top() - aTmpRect.Top() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_MT:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 					Min( maRect.Center().X() - aTmpRect.Left(),
//STRIP001 						 aTmpRect.Right() - maRect.Center().X() ) * 2,
//STRIP001 				aTmpRect.GetHeight() - ( maRect.Top() - aTmpRect.Top() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_RT:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 				aTmpRect.GetWidth() - ( aTmpRect.Right() - maRect.Right() ),
//STRIP001 				aTmpRect.GetHeight() - ( maRect.Top() - aTmpRect.Top() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_LM:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 				aTmpRect.GetWidth() - ( maRect.Left() - aTmpRect.Left() ),
//STRIP001 					Min( maRect.Center().Y() - aTmpRect.Top(),
//STRIP001 						  aTmpRect.Bottom() - maRect.Center().Y() ) * 2 ) );
//STRIP001 			break;
//STRIP001 		case RP_MM:
//STRIP001 		{
//STRIP001 			long n1, n2, n3, n4, n5, n6;
//STRIP001 			n1 = maRect.Center().X() - aTmpRect.Left();
//STRIP001 			n2 = aTmpRect.Right() - maRect.Center().X();
//STRIP001 			n3 = Min( n1, n2 );
//STRIP001 			n4 = maRect.Center().Y() - aTmpRect.Top();
//STRIP001 			n5 = aTmpRect.Bottom() - maRect.Center().Y();
//STRIP001 			n6 = Min( n4, n5 );
//STRIP001 			aTmpRect.SetSize( Size( n3 * 2, n6 * 3 ) );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case RP_RM:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 				aTmpRect.GetWidth() - ( aTmpRect.Right() - maRect.Right() ),
//STRIP001 					Min( maRect.Center().Y() - aTmpRect.Top(),
//STRIP001 						  aTmpRect.Bottom() - maRect.Center().Y() ) * 2 ) );
//STRIP001 			break;
//STRIP001 		case RP_LB:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 				aTmpRect.GetWidth() - ( maRect.Left() - aTmpRect.Left() ),
//STRIP001 				aTmpRect.GetHeight() - ( aTmpRect.Bottom() - maRect.Bottom() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_MB:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 					Min( maRect.Center().X() - aTmpRect.Left(),
//STRIP001 							 aTmpRect.Right() - maRect.Center().X() ) * 2,
//STRIP001 				aTmpRect.GetHeight() - ( maRect.Bottom() - aTmpRect.Bottom() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_RB:
//STRIP001 			aTmpRect.SetSize( Size(
//STRIP001 				aTmpRect.GetWidth() - ( aTmpRect.Right() - maRect.Right() ),
//STRIP001 				aTmpRect.GetHeight() - ( aTmpRect.Bottom() - maRect.Bottom() ) ) );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	maMtrWidth.SetMax( aTmpRect.GetWidth() );
//STRIP001 	maMtrWidth.SetLast( aTmpRect.GetWidth() );
//STRIP001 
//STRIP001 	maMtrHeight.SetMax( aTmpRect.GetHeight() );
//STRIP001 	maMtrHeight.SetLast( aTmpRect.GetHeight() );
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::GetTopLeftPosition( INT32& rX, INT32& rY,
//STRIP001 												const Rectangle& rRect )
//STRIP001 {
//STRIP001 	switch ( maCtlPos.GetActualRP() )
//STRIP001 	{
//STRIP001 		case RP_LT:
//STRIP001 			break;
//STRIP001 		case RP_MT:
//STRIP001 			rX = rX- ( rRect.Center().X() - rRect.Left() );
//STRIP001 			break;
//STRIP001 		case RP_RT:
//STRIP001 			rX = rX- ( rRect.Right() - rRect.Left() );
//STRIP001 			break;
//STRIP001 		case RP_LM:
//STRIP001 			rY = rY- ( rRect.Center().Y() - rRect.Top() );
//STRIP001 			break;
//STRIP001 		case RP_MM:
//STRIP001 			rX = rX- ( rRect.Center().X() - rRect.Left() );
//STRIP001 			rY = rY- ( rRect.Center().Y() - rRect.Top() );
//STRIP001 			break;
//STRIP001 		case RP_RM:
//STRIP001 			rX = rX- ( rRect.Right() - rRect.Left() );
//STRIP001 			rY = rY- ( rRect.Center().Y() - rRect.Top() );
//STRIP001 			break;
//STRIP001 		case RP_LB:
//STRIP001 			rY = rY- ( rRect.Bottom() - rRect.Top() );
//STRIP001 			break;
//STRIP001 		case RP_MB:
//STRIP001 			rX = rX- ( rRect.Center().X() - rRect.Left() );
//STRIP001 			rY = rY- ( rRect.Bottom() - rRect.Top() );
//STRIP001 			break;
//STRIP001 		case RP_RB:
//STRIP001 			rX = rX- ( rRect.Right() - rRect.Left() );
//STRIP001 			rY = rY- ( rRect.Bottom() - rRect.Top() );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::PointChanged( Window* pWindow, RECT_POINT eRP )
//STRIP001 {
//STRIP001 	if( pWindow == &maCtlPos )
//STRIP001 	{
//STRIP001 		SetMinMaxPosition();
//STRIP001 		switch( eRP )
//STRIP001 		{
//STRIP001 			case RP_LT:
//STRIP001 				maMtrPosX.SetValue( maRect.Left() );
//STRIP001 				maMtrPosY.SetValue( maRect.Top() );
//STRIP001 				break;
//STRIP001 			case RP_MT:
//STRIP001 				maMtrPosX.SetValue( maRect.Center().X() );
//STRIP001 				maMtrPosY.SetValue( maRect.Top() );
//STRIP001 				break;
//STRIP001 			case RP_RT:
//STRIP001 				maMtrPosX.SetValue( maRect.Right() );
//STRIP001 				maMtrPosY.SetValue( maRect.Top() );
//STRIP001 				break;
//STRIP001 			case RP_LM:
//STRIP001 				maMtrPosX.SetValue( maRect.Left() );
//STRIP001 				maMtrPosY.SetValue( maRect.Center().Y() );
//STRIP001 				break;
//STRIP001 			case RP_MM:
//STRIP001 				maMtrPosX.SetValue( maRect.Center().X() );
//STRIP001 				maMtrPosY.SetValue( maRect.Center().Y() );
//STRIP001 				break;
//STRIP001 			case RP_RM:
//STRIP001 				maMtrPosX.SetValue( maRect.Right() );
//STRIP001 				maMtrPosY.SetValue( maRect.Center().Y() );
//STRIP001 				break;
//STRIP001 			case RP_LB:
//STRIP001 				maMtrPosX.SetValue( maRect.Left() );
//STRIP001 				maMtrPosY.SetValue( maRect.Bottom() );
//STRIP001 				break;
//STRIP001 			case RP_MB:
//STRIP001 				maMtrPosX.SetValue( maRect.Center().X() );
//STRIP001 				maMtrPosY.SetValue( maRect.Bottom() );
//STRIP001 				break;
//STRIP001 			case RP_RB:
//STRIP001 				maMtrPosX.SetValue( maRect.Right() );
//STRIP001 				maMtrPosY.SetValue( maRect.Bottom() );
//STRIP001 				break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		meRP = eRP;
//STRIP001 
//STRIP001 		Rectangle aTmpRect( GetRect() );
//STRIP001 		SetMinMaxPosition();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::ShowAnchorCtrls(USHORT nAnchorCtrls)
//STRIP001 {
//STRIP001 	maTsbAutoGrowWidth.Hide();
//STRIP001 	maTsbAutoGrowHeight.Hide();
//STRIP001 	maFlAdjust.Hide();
//STRIP001 
//STRIP001 	maAnchorBox      .Show();
//STRIP001 	maFtAnchor       .Show();
//STRIP001 	maFtOrient       .Show();
//STRIP001 	maDdLbOrient     .Show();
//STRIP001 
//STRIP001 	for (USHORT i = 0; i < maDdLbAnchor.GetEntryCount(); i++)
//STRIP001 		maDdLbAnchor.SetEntryData(i, (void *)(long)i);
//STRIP001 
//STRIP001 	if (!(nAnchorCtrls & SVX_OBJ_AT_FLY))
//STRIP001 		maDdLbAnchor.RemoveEntry(3);
//STRIP001 	if (!(nAnchorCtrls & SVX_OBJ_PAGE))
//STRIP001 		maDdLbAnchor.RemoveEntry(2);
//STRIP001 	if (!(nAnchorCtrls & SVX_OBJ_IN_CNTNT))
//STRIP001 		maDdLbAnchor.RemoveEntry(1);
//STRIP001 	if (!(nAnchorCtrls & SVX_OBJ_AT_CNTNT))
//STRIP001 		maDdLbAnchor.RemoveEntry(0);
//STRIP001 
//STRIP001 	maDdLbAnchor     .Show();
//STRIP001 };
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::DisableResize()
//STRIP001 {
//STRIP001 	maFlSize.Disable();
//STRIP001 	maFtWidth.Disable();
//STRIP001 	maMtrWidth.Disable();
//STRIP001 	maFtHeight.Disable();
//STRIP001 	maMtrHeight.Disable();
//STRIP001 	maCbxScale.Disable();
//STRIP001 	maFtSizeReference.Disable();
//STRIP001 	maCtlSize.Disable();
//STRIP001 	mbSizeDisabled = true;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::DisableProtect()
//STRIP001 {
//STRIP001 	maFlProtect.Disable();
//STRIP001 	maTsbPosProtect.Disable();
//STRIP001 	maTsbSizeProtect.Disable();
//STRIP001 	mbProtectDisabled = true;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, SetAnchorHdl, ListBox *, pBox)
//STRIP001 {
//STRIP001 	BOOL bDisable = TRUE;
//STRIP001 	switch( (ULONG)pBox->GetEntryData(pBox->GetSelectEntryPos()) )
//STRIP001 	{
//STRIP001 		case SVX_FLY_AT_CNTNT:
//STRIP001 		case SVX_FLY_PAGE:
//STRIP001 		break;
//STRIP001 		case SVX_FLY_IN_CNTNT: bDisable = FALSE;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	maCtlPos.Enable(bDisable);
//STRIP001 	maCtlPos.Invalidate();
//STRIP001 	if(bDisable)
//STRIP001 	{
//STRIP001 		maDdLbOrient.Disable();
//STRIP001 		maFtOrient.Disable();
//STRIP001 		maMtrPosX.Enable();
//STRIP001 		maMtrPosY.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		maMtrPosX.Disable();
//STRIP001 		maDdLbOrient.Enable();
//STRIP001 		maFtOrient.Enable();
//STRIP001 		SetOrientHdl(&maDdLbOrient);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, SetOrientHdl, ListBox *, pBox )
//STRIP001 {
//STRIP001 	if(pBox->IsEnabled())
//STRIP001 	switch( pBox->GetSelectEntryPos() )
//STRIP001 	{
//STRIP001 		case SVX_VERT_TOP         :
//STRIP001 		case SVX_VERT_CENTER      :
//STRIP001 		case SVX_VERT_BOTTOM      :
//STRIP001 		case SVX_VERT_LINE_TOP    :
//STRIP001 		case SVX_VERT_LINE_CENTER :
//STRIP001 		case SVX_VERT_LINE_BOTTOM :
//STRIP001 					maMtrPosY.Disable();
//STRIP001 		break;
//STRIP001 		case SVX_VERT_NONE:
//STRIP001 					maMtrPosY.Enable();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SvxPositionSizeTabPage::GetRect()
//STRIP001 {
//STRIP001 	Rectangle aTmpRect( maRect );
//STRIP001 	aTmpRect.SetSize( Size( maMtrWidth.GetValue(), maMtrHeight.GetValue() ) );
//STRIP001 
//STRIP001 	switch ( maCtlSize.GetActualRP() )
//STRIP001 	{
//STRIP001 		case RP_LT:
//STRIP001 			// nichts!
//STRIP001 			break;
//STRIP001 		case RP_MT:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left() -
//STRIP001 						( aTmpRect.Right() - maRect.Right() ) / 2, maRect.Top() ) );
//STRIP001 			break;
//STRIP001 		case RP_RT:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left() -
//STRIP001 						( aTmpRect.Right() - maRect.Right() ), maRect.Top() ) );
//STRIP001 			break;
//STRIP001 		case RP_LM:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left(), maRect.Top() -
//STRIP001 						( aTmpRect.Bottom() - maRect.Bottom() ) / 2 ) );
//STRIP001 			break;
//STRIP001 		case RP_MM:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left() -
//STRIP001 						( aTmpRect.Right() - maRect.Right() ) / 2, maRect.Top() -
//STRIP001 						( aTmpRect.Bottom() - maRect.Bottom() ) / 2 ) );
//STRIP001 			break;
//STRIP001 		case RP_RM:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left() -
//STRIP001 						( aTmpRect.Right() - maRect.Right() ), maRect.Top() -
//STRIP001 						( aTmpRect.Bottom() - maRect.Bottom() ) / 2 ) );
//STRIP001 			break;
//STRIP001 		case RP_LB:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left(), maRect.Top() -
//STRIP001 						( aTmpRect.Bottom() - maRect.Bottom() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_MB:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left() -
//STRIP001 						( aTmpRect.Right() - maRect.Right() ) / 2, maRect.Top() -
//STRIP001 						( aTmpRect.Bottom() - maRect.Bottom() ) ) );
//STRIP001 			break;
//STRIP001 		case RP_RB:
//STRIP001 			aTmpRect.SetPos( Point( maRect.Left() -
//STRIP001 						( aTmpRect.Right() - maRect.Right() ), maRect.Top() -
//STRIP001 						( aTmpRect.Bottom() - maRect.Bottom() ) ) );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	return( aTmpRect );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, ChangeWidthHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( maCbxScale.IsChecked() &&
//STRIP001 		maCbxScale.IsEnabled() )
//STRIP001 	{
//STRIP001 		long nHeight = (long) ( ((double) mlOldHeight * (double) maMtrWidth.GetValue()) / (double) mlOldWidth );
//STRIP001 		if( nHeight <= maMtrHeight.GetMax( FUNIT_NONE ) )
//STRIP001 		{
//STRIP001 			maMtrHeight.SetUserValue( nHeight, FUNIT_NONE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nHeight = maMtrHeight.GetMax( FUNIT_NONE );
//STRIP001 			maMtrHeight.SetUserValue( nHeight );
//STRIP001 			const long nWidth = (long) ( ((double) mlOldWidth * (double) nHeight) / (double) mlOldHeight );
//STRIP001 			maMtrWidth.SetUserValue( nWidth, FUNIT_NONE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, ChangeHeightHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	if( maCbxScale.IsChecked() &&
//STRIP001 		maCbxScale.IsEnabled() )
//STRIP001 	{
//STRIP001 		long nWidth = (long) ( ((double) mlOldWidth * (double) maMtrHeight.GetValue()) / (double) mlOldHeight );
//STRIP001 		if( nWidth <= maMtrWidth.GetMax( FUNIT_NONE ) )
//STRIP001 		{
//STRIP001 			maMtrWidth.SetUserValue( nWidth, FUNIT_NONE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nWidth = maMtrWidth.GetMax( FUNIT_NONE );
//STRIP001 			maMtrWidth.SetUserValue( nWidth );
//STRIP001 			const long nHeight = (long) ( ((double) mlOldHeight * (double) nWidth) / (double) mlOldWidth );
//STRIP001 			maMtrHeight.SetUserValue( nHeight, FUNIT_NONE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, ClickSizeProtectHdl, void *, p )
//STRIP001 {
//STRIP001 	if( !mbSizeDisabled )
//STRIP001 	{
//STRIP001 		BOOL bHeightChecked = !maTsbAutoGrowHeight.IsTriStateEnabled() &&
//STRIP001 							  maTsbAutoGrowHeight.GetState() == STATE_CHECK;
//STRIP001 		BOOL bWidthChecked = !maTsbAutoGrowWidth.IsTriStateEnabled() &&
//STRIP001 							 maTsbAutoGrowWidth.GetState() == STATE_CHECK;
//STRIP001 		if( p == &maTsbAutoGrowHeight || p == NULL )
//STRIP001 		{
//STRIP001 			if( bHeightChecked )
//STRIP001 			{
//STRIP001 				maFtHeight.Disable();
//STRIP001 				maMtrHeight.Disable();
//STRIP001 				maCbxScale.Disable();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				maFtHeight.Enable();
//STRIP001 				maMtrHeight.Enable();
//STRIP001 				if( !bWidthChecked )
//STRIP001 					maCbxScale.Enable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( p == &maTsbAutoGrowWidth || p == NULL )
//STRIP001 		{
//STRIP001 			if( bWidthChecked )
//STRIP001 			{
//STRIP001 				maFtWidth.Disable();
//STRIP001 				maMtrWidth.Disable();
//STRIP001 				maCbxScale.Disable();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				maFtWidth.Enable();
//STRIP001 				maMtrWidth.Enable();
//STRIP001 				if( !bHeightChecked )
//STRIP001 					maCbxScale.Enable();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SvxPositionSizeTabPage, ClickAutoHdl, void *, p )
//STRIP001 {
//STRIP001 	if( maCbxScale.IsChecked() )
//STRIP001 	{
//STRIP001 		mlOldWidth  = Max( GetCoreValue( maMtrWidth,  mePoolUnit ), 1L );
//STRIP001 		mlOldHeight = Max( GetCoreValue( maMtrHeight, mePoolUnit ), 1L );
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxPositionSizeTabPage::FillUserData()
//STRIP001 {
//STRIP001 	// Abgleich wird in der Ini-Datei festgehalten
//STRIP001 	UniString aStr = UniString::CreateFromInt32( (sal_Int32) maCbxScale.IsChecked() );
//STRIP001 	SetUserData( aStr );
//STRIP001 }
}
