/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_srchdlg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:04:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _SV_WRKWIN_HXX
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MOREBTN_HXX //autogen wg. MoreButton
// auto strip #include <vcl/morebtn.hxx>
// auto strip #endif
//#ifndef _SV_SYSTEM_HXX //autogen wg. System
//#include <vcl/system.hxx>
//#endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen wg. RET_OK
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSLSTITM_HXX
// auto strip #include <svtools/slstitm.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMITER_HXX
// auto strip #include <svtools/itemiter.hxx>
// auto strip #endif
#ifndef _SFXSTYLE_HXX
#include <svtools/style.hxx>
#endif
// auto strip #ifndef _SVT_SEARCHOPT_HXX_
// auto strip #include <svtools/searchopt.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_OBJSH_HXX //autogen
// auto strip #include <bf_sfx2/objsh.hxx>
// auto strip #endif
// auto strip #ifndef _SFXMODULE_HXX
// auto strip #include <bf_sfx2/module.hxx>
// auto strip #endif
// auto strip #ifndef _SFXVIEWSH_HXX //autogen
// auto strip #include <bf_sfx2/viewsh.hxx>
// auto strip #endif
// auto strip #ifndef _BASEDLGS_HXX
// auto strip #include <bf_sfx2/basedlgs.hxx>
// auto strip #endif
// auto strip #ifndef _SVTOOLS_CJKOPTIONS_HXX
// auto strip #include <svtools/cjkoptions.hxx>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
// auto strip #include <com/sun/star/i18n/TransliterationModules.hpp>
// auto strip #endif

#pragma hdrstop

#define _SVX_SRCHDLG_CXX
#include "srchdlg.hxx"

#include "dialogs.hrc"
#include "svxitems.hrc"
#include "srchdlg.hrc"

#define ITEMID_SEARCH		SID_ATTR_SEARCH
#define	ITEMID_SETITEM		0

// auto strip #include "srchitem.hxx"
// auto strip #include "pageitem.hxx"
// auto strip #include "srchctrl.hxx"
// auto strip #include "srchxtra.hxx"
// auto strip #include "dialmgr.hxx"
// auto strip #include "dlgutil.hxx"

// auto strip #ifndef _SVX_OPTJSEARCH_HXX_
// auto strip #include <optjsearch.hxx>
// auto strip #endif
#define ITEMID_BRUSH SID_ATTR_BRUSH
// auto strip #ifndef _SVX_BRSHITEM_HXX //autogen
// auto strip #include <brshitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BACKGRND_HXX //autogen
// auto strip #include <backgrnd.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star::i18n;

// -----------------------------------------------------------------------

//STRIP001 #define REMEMBER_SIZE		10

//STRIP001 #define MODIFY_SEARCH		0x00000001
//STRIP001 #define MODIFY_REPLACE		0x00000002
//STRIP001 #define MODIFY_WORD			0x00000004
//STRIP001 #define MODIFY_EXACT		0x00000008
//STRIP001 #define MODIFY_BACKWARDS	0x00000010
//STRIP001 #define MODIFY_SELECTION	0x00000020
//STRIP001 #define MODIFY_REGEXP		0x00000040
//STRIP001 #define MODIFY_LAYOUT		0x00000080
//STRIP001 #define MODIFY_SIMILARITY	0x00000100
//STRIP001 #define MODIFY_FORMULAS		0x00000200
//STRIP001 #define MODIFY_VALUES		0x00000400
//STRIP001 #define MODIFY_NOTES		0x00000800
//STRIP001 #define MODIFY_ROWS			0x00001000
//STRIP001 #define MODIFY_COLUMNS		0x00002000
//STRIP001 #define MODIFY_ALLTABLES	0x00004000

//STRIP001 SV_IMPL_VARARR(SrchAttrItemList, SearchAttrItem);

//#define NotifyApp( nId )                                        \
//    rBindings.ExecuteSynchron( nId, (const SfxPoolItem**)&pSearchItem, 0L )

//STRIP001 #define GetCheckBoxValue( rBox )								\
//STRIP001 	rBox.IsEnabled() ? rBox.IsChecked() : FALSE

//STRIP001 struct SearchDlg_Impl
//STRIP001 {
//STRIP001 	FixedText	aSearchFormats;
//STRIP001 	FixedText	aReplaceFormats;
//STRIP001 
//STRIP001 	BOOL		bMultiLineEdit	: 1,
//STRIP001 				bSaveToModule	: 1,
//STRIP001 				bFocusOnSearch	: 1;
//STRIP001 	USHORT*		pRanges;
//STRIP001 	Timer		aSelectionTimer;
//STRIP001 
//STRIP001 	SearchDlg_Impl( Window* pParent ) :
//STRIP001 		aSearchFormats( pParent, ResId( FT_SEARCH_FORMATS ) ),
//STRIP001 		aReplaceFormats( pParent, ResId( FT_REPLACE_FORMATS ) ),
//STRIP001 		bMultiLineEdit( FALSE ),
//STRIP001 		bSaveToModule( TRUE ),
//STRIP001 		bFocusOnSearch( TRUE ),
//STRIP001 		pRanges( NULL )
//STRIP001 		{}
//STRIP001 	~SearchDlg_Impl() { delete[] pRanges; }
//STRIP001 };

// -----------------------------------------------------------------------

//STRIP001 void ListToStrArr_Impl( USHORT nId, SvStringsDtor& rStrLst, ComboBox& rCBox )
//STRIP001 {
//STRIP001 	SfxStringListItem* pSrchItem =
//STRIP001 		(SfxStringListItem*)SFX_APP()->GetItem( nId );
//STRIP001 	List* pLst = pSrchItem ? pSrchItem->GetList() : 0;
//STRIP001 
//STRIP001 	if ( pLst )
//STRIP001 		for ( USHORT i = 0; i < pLst->Count(); ++i )
//STRIP001 		{
//STRIP001 			String* pTmp = new String( *(String*)( pLst->GetObject(i) ) );
//STRIP001 			rStrLst.Insert( pTmp, rStrLst.Count() );
//STRIP001 			rCBox.InsertEntry( *pTmp );
//STRIP001 		}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void StrArrToList_Impl( USHORT nId, const SvStringsDtor& rStrLst )
//STRIP001 {
//STRIP001 	DBG_ASSERT( rStrLst.Count(), "vorher abpruefen!!" );
//STRIP001 	List aLst;
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < rStrLst.Count(); ++i )
//STRIP001 		aLst.Insert( rStrLst[ i ], LIST_APPEND );
//STRIP001 
//STRIP001 	SFX_APP()->PutItem( SfxStringListItem( nId, &aLst ) );
//STRIP001 }

// class SearchAttrItemList ----------------------------------------------

//STRIP001 SearchAttrItemList::SearchAttrItemList( const SearchAttrItemList& rList ) :
//STRIP001 
//STRIP001 	SrchAttrItemList( (BYTE)rList.Count() )
//STRIP001 
//STRIP001 {
//STRIP001 	SrchAttrItemList::Insert( &rList, 0 );
//STRIP001 	SearchAttrItem* pData = (SearchAttrItem*)GetData();
//STRIP001 
//STRIP001 	for ( USHORT i = Count(); i; --i, ++pData )
//STRIP001 		if ( !IsInvalidItem( pData->pItem ) )
//STRIP001 			pData->pItem = pData->pItem->Clone();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SearchAttrItemList::~SearchAttrItemList()
//STRIP001 {
//STRIP001 	Clear();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SearchAttrItemList::Put( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	if ( !rSet.Count() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	SfxItemIter aIter( rSet );
//STRIP001 	SearchAttrItem aItem;
//STRIP001 	const SfxPoolItem* pItem = aIter.GetCurItem();
//STRIP001 	USHORT nWhich;
//STRIP001 
//STRIP001 	while ( TRUE )
//STRIP001 	{
//STRIP001 		// nur testen, ob vorhanden ist ?
//STRIP001 		if( IsInvalidItem( pItem ) )
//STRIP001 		{
//STRIP001 			nWhich = rSet.GetWhichByPos( aIter.GetCurPos() );
//STRIP001 			aItem.pItem = (SfxPoolItem*)pItem;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nWhich = pItem->Which();
//STRIP001 			aItem.pItem = pItem->Clone();
//STRIP001 		}
//STRIP001 
//STRIP001 		aItem.nSlot = pPool->GetSlotId( nWhich );
//STRIP001 		Insert( aItem );
//STRIP001 
//STRIP001 		if ( aIter.IsAtEnd() )
//STRIP001 			break;
//STRIP001 		pItem = aIter.NextItem();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxItemSet& SearchAttrItemList::Get( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxItemPool* pPool = rSet.GetPool();
//STRIP001 	SearchAttrItem* pData = (SearchAttrItem*)GetData();
//STRIP001 
//STRIP001 	for ( USHORT i = Count(); i; --i, ++pData )
//STRIP001 		if ( IsInvalidItem( pData->pItem ) )
//STRIP001 			rSet.InvalidateItem( pPool->GetWhich( pData->nSlot ) );
//STRIP001 		else
//STRIP001 			rSet.Put( *pData->pItem );
//STRIP001 	return rSet;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SearchAttrItemList::Clear()
//STRIP001 {
//STRIP001 	SearchAttrItem* pData = (SearchAttrItem*)GetData();
//STRIP001 
//STRIP001 	for ( USHORT i = Count(); i; --i, ++pData )
//STRIP001 		if ( !IsInvalidItem( pData->pItem ) )
//STRIP001 			delete pData->pItem;
//STRIP001 	SrchAttrItemList::Remove( 0, Count() );
//STRIP001 }

// -----------------------------------------------------------------------

// l"oscht die Pointer auf die Items
//STRIP001 void SearchAttrItemList::Remove( USHORT nPos, USHORT nLen )
//STRIP001 {
//STRIP001 	if ( nPos + nLen > Count() )
//STRIP001 		nLen = Count() - nPos;
//STRIP001 	SearchAttrItem* pData = (SearchAttrItem*)GetData() + nPos;
//STRIP001 
//STRIP001 	for ( USHORT n = nLen; n; --n, ++pData )
//STRIP001 		if ( !IsInvalidItem( pData->pItem ) )
//STRIP001 			delete pData->pItem;
//STRIP001 
//STRIP001 	SrchAttrItemList::Remove( nPos, nLen );
//STRIP001 }


// class SvxJSearchOptionsDialog -----------------------------------------

//STRIP001 SvxJSearchOptionsDialog::SvxJSearchOptionsDialog(
//STRIP001 			Window *pParent,
//STRIP001 			const SfxItemSet& rOptionsSet, USHORT nUniqueId, INT32 nInitialFlags ) :
//STRIP001 	SfxSingleTabDialog	( pParent, rOptionsSet, RID_SVXPAGE_JSEARCH_OPTIONS ),
//STRIP001 	nInitialTlFlags( nInitialFlags )
//STRIP001 {
//STRIP001 	pPage = (SvxJSearchOptionsPage *)
//STRIP001 					SvxJSearchOptionsPage::Create( this, rOptionsSet );
//STRIP001 	SetTabPage( pPage );	//! implicitly calls pPage->Reset(...)!
//STRIP001 	pPage->EnableSaveOptions( FALSE );
//STRIP001 }


//STRIP001 SvxJSearchOptionsDialog::~SvxJSearchOptionsDialog()
//STRIP001 {
//STRIP001 	// pPage will be implicitly destroyed by the
//STRIP001 	// SfxSingleTabDialog destructor
//STRIP001 }


//STRIP001 void SvxJSearchOptionsDialog::Activate()
//STRIP001 {
//STRIP001 	pPage->SetTransliterationFlags( nInitialTlFlags );
//STRIP001 }


//STRIP001 INT32 SvxJSearchOptionsDialog::GetTransliterationFlags() const
//STRIP001 {
//STRIP001 	return pPage->GetTransliterationFlags();
//STRIP001 }


//STRIP001 void SvxJSearchOptionsDialog::SetTransliterationFlags( INT32 nSettings )
//STRIP001 {
//STRIP001 	pPage->SetTransliterationFlags( nSettings );
//STRIP001 }

//STRIP001 #ifdef INI_LIST
//STRIP001 #undef INI_LIST
//STRIP001 #endif
//STRIP001 #define INI_LIST() \
//STRIP001 	aSearchText 	( this, ResId( FT_SEARCH ) ),							\
//STRIP001 	aSearchLB		( this, ResId( ED_SEARCH ) ),							\
//STRIP001 	aSearchTmplLB	( this, ResId( LB_SEARCH ) ),							\
//STRIP001 	aSearchAttrText ( this, ResId( FT_SEARCH_ATTR ) ),						\
//STRIP001 	aReplaceText	( this, ResId( FT_REPLACE ) ),							\
//STRIP001 	aReplaceLB		( this, ResId( ED_REPLACE ) ),							\
//STRIP001 	aReplaceTmplLB	( this, ResId( LB_REPLACE ) ),							\
//STRIP001 	aReplaceAttrText( this, ResId( FT_REPLACE_ATTR ) ),						\
//STRIP001 	aSearchAllBtn	( this, ResId( BTN_SEARCH_ALL ) ),						\
//STRIP001 	aSearchBtn		( this, ResId( BTN_SEARCH ) ),							\
//STRIP001 	aReplaceAllBtn	( this, ResId( BTN_REPLACE_ALL ) ),						\
//STRIP001 	aReplaceBtn 	( this, ResId( BTN_REPLACE ) ),							\
//STRIP001 	aAttributeBtn	( this, ResId( BTN_ATTRIBUTE ) ),						\
//STRIP001 	aCloseBtn		( this, ResId( BTN_CLOSE ) ),							\
//STRIP001 	aFormatBtn		( this, ResId( BTN_FORMAT ) ),							\
//STRIP001 	aHelpBtn		( this, ResId( BTN_HELP ) ),							\
//STRIP001 	aNoFormatBtn	( this, ResId( BTN_NOFORMAT ) ),						\
//STRIP001 	pMoreBtn		( new MoreButton( this, ResId( BTN_MORE ) ) ),			\
//STRIP001 	aWordBtn		( this, ResId( BTN_CELLS ) ),							\
//STRIP001 	aMatchCaseCB	( this, ResId( CB_MATCH_CASE ) ),						\
//STRIP001 	aBackwardsBtn	( this, ResId( BTN_BACKWARDS ) ),						\
//STRIP001 	aSelectionBtn	( this, ResId( BTN_SELECTIONS ) ),						\
//STRIP001 	aRegExpBtn		( this, ResId( BTN_REGEXP ) ),							\
//STRIP001 	aLayoutBtn		( this, ResId( BTN_LAYOUTS ) ),							\
//STRIP001 	aSimilarityBox 	( this, ResId( CB_SIMILARITY) ),						\
//STRIP001 	aSimilarityBtn  ( this, ResId( PB_SIMILARITY) ),						\
//STRIP001 	aJapMatchFullHalfWidthCB( this, ResId( CB_JAP_MATCH_FULL_HALF_WIDTH ) ),\
//STRIP001 	aJapOptionsCB	( this, ResId( CB_JAP_SOUNDS_LIKE ) ),					\
//STRIP001 	aJapOptionsBtn	( this, ResId( PB_JAP_OPTIONS ) ),						\
//STRIP001     aOptionsFL      ( this, ResId( FL_OPTIONS ) ),							\
//STRIP001 	aFormulasBtn	( this, ResId( BTN_FORMULAS ) ),						\
//STRIP001 	aValuesBtn		( this, ResId( BTN_VALUES ) ),							\
//STRIP001 	aNotesBtn		( this, ResId( BTN_NOTES ) ),							\
//STRIP001     aSearchFL       ( this, ResId( FL_SEARCH ) ),							\
//STRIP001     aSearchVertFL   ( this, ResId( FL_SEARCH_VERT ) ),						\
//STRIP001 	aRowsBtn		( this, ResId( BTN_ROWS ) ),							\
//STRIP001 	aColumnsBtn 	( this, ResId( BTN_COLUMNS ) ),							\
//STRIP001     aSearchDirFL    ( this, ResId( FL_SEARCHDIR ) ),						\
//STRIP001     aSearchDirVertFL( this, ResId( FL_SEARCHDIR_VERT ) ),					\
//STRIP001 	aAllTablesCB	( this, ResId( CB_ALLTABLES ) ),						\
//STRIP001     aCalcExtrasFL   ( this, ResId( FL_CALCEXTRAS ) ),						\
//STRIP001 	aCalcStr		(		ResId( STR_WORDCALC ) ),						\
//STRIP001 	rBindings		( rBind ),												\
//STRIP001 	bWriter 		( FALSE ),												\
//STRIP001 	bSearch 		( TRUE ),												\
//STRIP001 	bFormat 		( FALSE ),												\
//STRIP001 	nOptions		( USHRT_MAX ),											\
//STRIP001 	bSet			( FALSE ),												\
//STRIP001 	bReadOnly		( FALSE ),												\
//STRIP001 	bConstruct		( TRUE ),												\
//STRIP001 	nModifyFlag		( 0 ),													\
//STRIP001 	pImpl	 		( NULL ),												\
//STRIP001 	pSearchList 	( NULL ),												\
//STRIP001 	pReplaceList	( NULL ),												\
//STRIP001 	pSearchItem 	( NULL ),												\
//STRIP001 	pSearchController		( NULL ),										\
//STRIP001 	pOptionsController		( NULL ),										\
//STRIP001 	pFamilyController		( NULL ),										\
//STRIP001 	pSearchSetController	( NULL ),										\
//STRIP001 	pReplaceSetController	( NULL ),										\
//STRIP001 	nTransliterationFlags	( 0x00000000 )

// class SvxSearchDialog -------------------------------------------------

//STRIP001 SvxSearchDialog::SvxSearchDialog( Window* pParent, SfxBindings& rBind ) :
//STRIP001 
//STRIP001 	SfxModelessDialog( &rBind, NULL, pParent, SVX_RES( RID_SVXDLG_SEARCH ) ),
//STRIP001 
//STRIP001 	INI_LIST()
//STRIP001 
//STRIP001 {
//STRIP001 	Construct_Impl();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxSearchDialog::SvxSearchDialog( Window* pParent, SfxChildWindow* pChildWin, SfxBindings& rBind ) :
//STRIP001 
//STRIP001 	SfxModelessDialog( &rBind, pChildWin, pParent, SVX_RES( RID_SVXDLG_SEARCH ) ),
//STRIP001 
//STRIP001 	INI_LIST()
//STRIP001 
//STRIP001 {
//STRIP001 	Construct_Impl();
//STRIP001 }

//STRIP001 #undef INI_LIST

// -----------------------------------------------------------------------

//STRIP001 SvxSearchDialog::~SvxSearchDialog()
//STRIP001 {
//STRIP001 	Hide();
//STRIP001 
//STRIP001 	rBindings.EnterRegistrations();
//STRIP001 	delete pSearchController;
//STRIP001 	delete pOptionsController;
//STRIP001 	delete pFamilyController;
//STRIP001 	delete pSearchSetController;
//STRIP001 	delete pReplaceSetController;
//STRIP001 	rBindings.LeaveRegistrations();
//STRIP001 
//STRIP001 	delete pSearchItem;
//STRIP001 	delete pImpl;
//STRIP001 	delete pSearchList;
//STRIP001 	delete pReplaceList;
//STRIP001 	delete pMoreBtn;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::Construct_Impl()
//STRIP001 {
//STRIP001 	// temporary to avoid incompatibility
//STRIP001 	pImpl = new SearchDlg_Impl( this );
//STRIP001 	pImpl->aSelectionTimer.SetTimeout( 500 );
//STRIP001 	pImpl->aSelectionTimer.SetTimeoutHdl(
//STRIP001 		LINK( this, SvxSearchDialog, TimeoutHdl_Impl ) );
//STRIP001 
//STRIP001 	EnableControls_Impl( 0 );
//STRIP001 
//STRIP001 	// alten Text des aWordBtn's merken
//STRIP001 	( aCalcStr += sal_Unicode('#') ) += aWordBtn.GetText();
//STRIP001 
//STRIP001 /*! (pb) there is no AppWindow anymore
//STRIP001 	// Position anpassen
//STRIP001 	Point aPos;
//STRIP001 	const Size aScreen( Application::GetAppWindow()->GetDesktopRectPixel().GetSize() );
//STRIP001 	const Size MySize( GetSizePixel() );
//STRIP001 	aPos.X() =	( aScreen.Width() - MySize.Width() ) / 2;
//STRIP001 	aPos.Y() =	aScreen.Height() - MySize.Height() - 60;
//STRIP001 	SetPosPixel( aPos );
//STRIP001 */
//STRIP001 
//STRIP001 	aLayoutStr = SVX_RESSTR( RID_SVXSTR_SEARCH_STYLES );
//STRIP001 	aStylesStr = aLayoutBtn.GetText();
//STRIP001 
//STRIP001 	// gemerkte Such-Strings von der Applikation holen
//STRIP001 	ListToStrArr_Impl( SID_SEARCHDLG_SEARCHSTRINGS,
//STRIP001 					   aSearchStrings, aSearchLB 	);
//STRIP001 	ListToStrArr_Impl( SID_SEARCHDLG_REPLACESTRINGS,
//STRIP001 					   aReplaceStrings, aReplaceLB 	);
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 	InitControls_Impl();
//STRIP001 
//STRIP001 	// Attribut-Sets nur einmal im Ctor() besorgen
//STRIP001     const SfxPoolItem* ppArgs[] = { pSearchItem, 0 };
//STRIP001 	const SvxSetItem* pSrchSetItem =
//STRIP001         (const SvxSetItem*) rBindings.GetDispatcher()->Execute( FID_SEARCH_SEARCHSET, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001 
//STRIP001 	if ( pSrchSetItem )
//STRIP001 		InitAttrList_Impl( &pSrchSetItem->GetItemSet(), 0 );
//STRIP001 
//STRIP001 	const SvxSetItem* pReplSetItem =
//STRIP001         (const SvxSetItem*)rBindings.GetDispatcher()->Execute( FID_SEARCH_REPLACESET, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001 
//STRIP001 	if ( pReplSetItem )
//STRIP001 		InitAttrList_Impl( 0, &pReplSetItem->GetItemSet() );
//STRIP001 
//STRIP001 	// Controller erzeugen und gleich aktualisieren
//STRIP001 	rBindings.EnterRegistrations();
//STRIP001 	pSearchController =
//STRIP001 		new SvxSearchController( SID_SEARCH_ITEM, rBindings, *this );
//STRIP001 	pOptionsController =
//STRIP001 		new SvxSearchController( SID_SEARCH_OPTIONS, rBindings, *this );
//STRIP001 	rBindings.LeaveRegistrations();
//STRIP001     rBindings.GetDispatcher()->Execute( FID_SEARCH_ON, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001 	pImpl->aSelectionTimer.Start();
//STRIP001 
//STRIP001 
//STRIP001     SvtCJKOptions aCJKOptions;
//STRIP001     if(!aCJKOptions.IsJapaneseFindEnabled())
//STRIP001     {
//STRIP001         aJapOptionsCB.Check( FALSE );
//STRIP001         aJapOptionsCB.Hide();
//STRIP001         aJapOptionsBtn.Hide();
//STRIP001     }
//STRIP001     if(!aCJKOptions.IsCJKFontEnabled())
//STRIP001     {
//STRIP001         aJapMatchFullHalfWidthCB.Hide();
//STRIP001     }
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxSearchDialog::Close()
//STRIP001 {
//STRIP001 	// remember strings speichern
//STRIP001 	if ( aSearchStrings.Count() )
//STRIP001 		StrArrToList_Impl( SID_SEARCHDLG_SEARCHSTRINGS, aSearchStrings );
//STRIP001 
//STRIP001 	if ( aReplaceStrings.Count() )
//STRIP001 		StrArrToList_Impl( SID_SEARCHDLG_REPLACESTRINGS, aReplaceStrings );
//STRIP001 
//STRIP001 	// save settings to configuration
//STRIP001 	SvtSearchOptions aOpt;
//STRIP001 	aOpt.SetWholeWordsOnly			( aWordBtn				  .IsChecked() );
//STRIP001 	aOpt.SetBackwards				( aBackwardsBtn			  .IsChecked() );
//STRIP001 	aOpt.SetUseRegularExpression	( aRegExpBtn			  .IsChecked() );
//STRIP001 	//aOpt.SetMatchCase				( aMatchCaseCB			  .IsChecked() );
//STRIP001 	aOpt.SetSearchForStyles			( aLayoutBtn			  .IsChecked() );
//STRIP001 	aOpt.SetSimilaritySearch		( aSimilarityBox		  .IsChecked() );
//STRIP001     //aOpt.SetMatchFullHalfWidthForms   ( !aJapMatchFullHalfWidthCB.IsChecked() );
//STRIP001 	aOpt.SetUseAsianOptions			( aJapOptionsCB		  	  .IsChecked() );
//STRIP001 
//STRIP001     const SfxPoolItem* ppArgs[] = { pSearchItem, 0 };
//STRIP001     rBindings.GetDispatcher()->Execute( FID_SEARCH_OFF, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001     rBindings.Execute( SID_SEARCH_DLG );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 INT32 SvxSearchDialog::GetTransliterationFlags() const
//STRIP001 {
//STRIP001 	INT32 &rFlags = (INT32) nTransliterationFlags;
//STRIP001     if (!aMatchCaseCB.IsChecked())
//STRIP001 		rFlags |=  TransliterationModules_IGNORE_CASE;
//STRIP001 	else
//STRIP001 		rFlags &= ~TransliterationModules_IGNORE_CASE;
//STRIP001     if ( !aJapMatchFullHalfWidthCB.IsChecked())
//STRIP001 		rFlags |=  TransliterationModules_IGNORE_WIDTH;
//STRIP001 	else
//STRIP001 		rFlags &= ~TransliterationModules_IGNORE_WIDTH;
//STRIP001 	return nTransliterationFlags;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::ApplyTransliterationFlags_Impl( INT32 nSettings )
//STRIP001 {
//STRIP001 	nTransliterationFlags = nSettings;
//STRIP001 	BOOL bVal = 0 != (nSettings & TransliterationModules_IGNORE_CASE);
//STRIP001     aMatchCaseCB            .Check(!bVal );
//STRIP001 	bVal = 0 != (nSettings & TransliterationModules_IGNORE_WIDTH);
//STRIP001     aJapMatchFullHalfWidthCB.Check( !bVal );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::Activate()
//STRIP001 {
//STRIP001 	// apply possible transliteration changes of the SvxSearchItem member
//STRIP001 	DBG_ASSERT( pSearchItem, "SearchItem missing" );
//STRIP001 	if (pSearchItem)
//STRIP001 	{
//STRIP001 		aMatchCaseCB            .Check( pSearchItem->GetExact() );
//STRIP001         aJapMatchFullHalfWidthCB.Check( !pSearchItem->IsMatchFullHalfWidthForms() );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::InitControls_Impl()
//STRIP001 {
//STRIP001 	// CaseSensitives AutoComplete
//STRIP001 	aSearchLB.EnableAutocomplete( TRUE, TRUE );
//STRIP001 	aSearchLB.Show();
//STRIP001 	aReplaceLB.EnableAutocomplete( TRUE, TRUE );
//STRIP001 	aReplaceLB.Show();
//STRIP001 
//STRIP001 	aFormatBtn.Disable();
//STRIP001 	aAttributeBtn.Disable();
//STRIP001 
//STRIP001 	aSearchLB.SetModifyHdl( LINK( this, SvxSearchDialog, ModifyHdl_Impl ) );
//STRIP001 	aReplaceLB.SetModifyHdl( LINK( this, SvxSearchDialog, ModifyHdl_Impl ) );
//STRIP001 
//STRIP001 	Link aLink = LINK( this, SvxSearchDialog, FocusHdl_Impl );
//STRIP001 	aSearchLB.SetGetFocusHdl( aLink );
//STRIP001 	pImpl->aSearchFormats.SetGetFocusHdl( aLink );
//STRIP001 
//STRIP001 	aReplaceLB.SetGetFocusHdl( aLink );
//STRIP001 	pImpl->aReplaceFormats.SetGetFocusHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxSearchDialog, LoseFocusHdl_Impl );
//STRIP001 	aSearchLB.SetLoseFocusHdl( aLink );
//STRIP001 	aReplaceLB.SetLoseFocusHdl( aLink );
//STRIP001 	aSearchTmplLB.SetLoseFocusHdl( aLink );
//STRIP001 	aReplaceTmplLB.SetLoseFocusHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxSearchDialog, CommandHdl_Impl );
//STRIP001 	aSearchBtn.SetClickHdl( aLink );
//STRIP001 	aSearchAllBtn.SetClickHdl( aLink );
//STRIP001 	aReplaceBtn.SetClickHdl( aLink );
//STRIP001 	aReplaceAllBtn.SetClickHdl( aLink );
//STRIP001 	aCloseBtn.SetClickHdl( aLink );
//STRIP001 	aSimilarityBtn.SetClickHdl( aLink );
//STRIP001 	aJapOptionsBtn.SetClickHdl( aLink );
//STRIP001 
//STRIP001 	aLink = LINK( this, SvxSearchDialog, FlagHdl_Impl );
//STRIP001 	aWordBtn.SetClickHdl( aLink );
//STRIP001 	aSelectionBtn.SetClickHdl( aLink );
//STRIP001 	aMatchCaseCB.SetClickHdl( aLink );
//STRIP001 	aRegExpBtn.SetClickHdl( aLink );
//STRIP001 	aBackwardsBtn.SetClickHdl( aLink );
//STRIP001 	aSimilarityBox.SetClickHdl( aLink );
//STRIP001 	aJapOptionsCB.SetClickHdl( aLink );
//STRIP001 	aJapMatchFullHalfWidthCB.SetClickHdl( aLink );
//STRIP001 
//STRIP001 	aLayoutBtn.SetClickHdl( LINK( this, SvxSearchDialog, TemplateHdl_Impl ) );
//STRIP001 	aFormatBtn.SetClickHdl( LINK( this, SvxSearchDialog, FormatHdl_Impl ) );
//STRIP001 	aNoFormatBtn.SetClickHdl(
//STRIP001 		LINK( this, SvxSearchDialog, NoFormatHdl_Impl ) );
//STRIP001 	aAttributeBtn.SetClickHdl(
//STRIP001 		LINK( this, SvxSearchDialog, AttributeHdl_Impl ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::Init_Impl( int bSearchPattern )
//STRIP001 {
//STRIP001 	DBG_ASSERT( pSearchItem, "SearchItem == 0" );
//STRIP001 	bWriter = ( pSearchItem->GetAppFlag() == SVX_SEARCHAPP_WRITER );
//STRIP001 
//STRIP001 	pImpl->bMultiLineEdit = FALSE;
//STRIP001 
//STRIP001 	if ( !pImpl->bMultiLineEdit )
//STRIP001 	{
//STRIP001 		pImpl->aSearchFormats.Hide();
//STRIP001 		aSearchAttrText.Show();
//STRIP001 		pImpl->aReplaceFormats.Hide();
//STRIP001 		aReplaceAttrText.Show();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String aText = aSearchAttrText.GetText();
//STRIP001 		aSearchAttrText.Hide();
//STRIP001 
//STRIP001 		if ( aText.Len() )
//STRIP001 			pImpl->aSearchFormats.SetText( aText );
//STRIP001 		pImpl->aSearchFormats.Show();
//STRIP001 		aText = aReplaceAttrText.GetText();
//STRIP001 		aReplaceAttrText.Hide();
//STRIP001 
//STRIP001 		if ( aText.Len() )
//STRIP001 			pImpl->aReplaceFormats.SetText( aText );
//STRIP001 		pImpl->aReplaceFormats.Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( nModifyFlag & MODIFY_WORD ) == 0 )
//STRIP001  		aWordBtn.Check( pSearchItem->GetWordOnly() );
//STRIP001 	if ( ( nModifyFlag & MODIFY_EXACT ) == 0 )
//STRIP001 		aMatchCaseCB.Check( pSearchItem->GetExact() );
//STRIP001 	if ( ( nModifyFlag & MODIFY_BACKWARDS ) == 0 )
//STRIP001 		aBackwardsBtn.Check( pSearchItem->GetBackward() );
//STRIP001 	if ( ( nModifyFlag & MODIFY_SELECTION ) == 0 )
//STRIP001 		aSelectionBtn.Check( pSearchItem->GetSelection() );
//STRIP001 	if ( ( nModifyFlag & MODIFY_REGEXP ) == 0 )
//STRIP001 		aRegExpBtn.Check( pSearchItem->GetRegExp() );
//STRIP001 	if ( ( nModifyFlag & MODIFY_LAYOUT ) == 0 )
//STRIP001 		aLayoutBtn.Check( pSearchItem->GetPattern() );
//STRIP001 	aSimilarityBox.Check( pSearchItem->IsLevenshtein() );
//STRIP001 	if( aJapOptionsCB.IsVisible() )
//STRIP001 		aJapOptionsCB.Check( pSearchItem->IsUseAsianOptions() );
//STRIP001 	ApplyTransliterationFlags_Impl( pSearchItem->GetTransliterationFlags() );
//STRIP001 
//STRIP001 	FASTBOOL bDraw = FALSE;
//STRIP001 
//STRIP001 	if ( pSearchItem->GetAppFlag() == SVX_SEARCHAPP_CALC )
//STRIP001 	{
//STRIP001 		Link aLink = LINK( this, SvxSearchDialog, FlagHdl_Impl );
//STRIP001 		aFormulasBtn.SetClickHdl( aLink );
//STRIP001 		aNotesBtn.SetClickHdl( aLink );
//STRIP001 		aValuesBtn.SetClickHdl( aLink );
//STRIP001 		aRowsBtn.SetClickHdl( aLink );
//STRIP001 		aColumnsBtn.SetClickHdl( aLink );
//STRIP001 		aAllTablesCB.SetClickHdl( aLink );
//STRIP001 
//STRIP001 		switch ( pSearchItem->GetCellType() )
//STRIP001 		{
//STRIP001 			case SVX_SEARCHIN_FORMULA:
//STRIP001 				if ( ( nModifyFlag & MODIFY_FORMULAS ) == 0 )
//STRIP001 					aFormulasBtn.Check();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SVX_SEARCHIN_VALUE:
//STRIP001 				if ( ( nModifyFlag & MODIFY_VALUES ) == 0 )
//STRIP001 					aValuesBtn.Check();
//STRIP001 				break;
//STRIP001 
//STRIP001 			case SVX_SEARCHIN_NOTE:
//STRIP001 				if ( ( nModifyFlag & MODIFY_NOTES ) == 0 )
//STRIP001 					aNotesBtn.Check();
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		aWordBtn.SetText( aCalcStr.GetToken( 0, '#' ) );
//STRIP001 
//STRIP001 		if ( pSearchItem->GetRowDirection() &&
//STRIP001 			 ( nModifyFlag & MODIFY_ROWS ) == 0 )
//STRIP001 			aRowsBtn.Check();
//STRIP001 		else if ( !pSearchItem->GetRowDirection() &&
//STRIP001 				  ( nModifyFlag & MODIFY_COLUMNS ) == 0 )
//STRIP001 			aColumnsBtn.Check();
//STRIP001 
//STRIP001 		if ( ( nModifyFlag & MODIFY_ALLTABLES ) == 0 )
//STRIP001 			aAllTablesCB.Check( pSearchItem->IsAllTables() );
//STRIP001 
//STRIP001 		// nur im Writer Suche nach Formatierung
//STRIP001 		aFormatBtn.Hide();
//STRIP001 		aNoFormatBtn.Hide();
//STRIP001 		aAttributeBtn.Hide();
//STRIP001 
//STRIP001 		// Extras beim StarCalc
//STRIP001 		pMoreBtn->AddWindow( &aFormulasBtn );
//STRIP001 		pMoreBtn->AddWindow( &aNotesBtn );
//STRIP001 		pMoreBtn->AddWindow( &aValuesBtn );
//STRIP001         pMoreBtn->AddWindow( &aSearchFL );
//STRIP001         pMoreBtn->AddWindow( &aSearchVertFL );
//STRIP001 		pMoreBtn->AddWindow( &aRowsBtn );
//STRIP001 		pMoreBtn->AddWindow( &aColumnsBtn );
//STRIP001         pMoreBtn->AddWindow( &aSearchDirFL );
//STRIP001         pMoreBtn->AddWindow( &aSearchDirVertFL );
//STRIP001 		pMoreBtn->AddWindow( &aAllTablesCB );
//STRIP001         pMoreBtn->AddWindow( &aCalcExtrasFL );
//STRIP001 		pMoreBtn->Show();
//STRIP001 		pMoreBtn->Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aWordBtn.SetText( aCalcStr.GetToken( 1, '#' ) );
//STRIP001 
//STRIP001 		if ( pSearchItem->GetAppFlag() == SVX_SEARCHAPP_DRAW )
//STRIP001 		{
//STRIP001 			aRegExpBtn.Hide();
//STRIP001 			aLayoutBtn.Hide();
//STRIP001 
//STRIP001 			// nur im Writer Suche nach Formatierung
//STRIP001 			aFormatBtn.Hide();
//STRIP001 			aNoFormatBtn.Hide();
//STRIP001 			aAttributeBtn.Hide();
//STRIP001 			bDraw = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( !pSearchList )
//STRIP001 			{
//STRIP001 				// Attribut-Sets besorgen, wenn noch nicht geschehen
//STRIP001                 const SfxPoolItem* ppArgs[] = { pSearchItem, 0 };
//STRIP001 				const SvxSetItem* pSrchSetItem =
//STRIP001                 (const SvxSetItem*)rBindings.GetDispatcher()->Execute( FID_SEARCH_SEARCHSET, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001 
//STRIP001 				if ( pSrchSetItem )
//STRIP001 					InitAttrList_Impl( &pSrchSetItem->GetItemSet(), 0 );
//STRIP001 
//STRIP001 				const SvxSetItem* pReplSetItem =
//STRIP001                 (const SvxSetItem*)rBindings.GetDispatcher()->Execute( FID_SEARCH_REPLACESET, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001 
//STRIP001 				if ( pReplSetItem )
//STRIP001 					InitAttrList_Impl( 0, &pReplSetItem->GetItemSet() );
//STRIP001 			}
//STRIP001 			aFormatBtn.Show();
//STRIP001 			aNoFormatBtn.Show();
//STRIP001 			aAttributeBtn.Show();
//STRIP001 		}
//STRIP001 		pMoreBtn->SetState( FALSE );
//STRIP001 		pMoreBtn->Hide();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !bDraw )
//STRIP001 	{
//STRIP001 		aRegExpBtn.Show();
//STRIP001 		aLayoutBtn.Show();
//STRIP001 	}
//STRIP001 
//STRIP001 	// "Ahnlichkeitssuche?
//STRIP001 	if ( ( nModifyFlag & MODIFY_SIMILARITY ) == 0 )
//STRIP001 		aSimilarityBox.Check( pSearchItem->IsLevenshtein() );
//STRIP001 	bSet = TRUE;
//STRIP001 
//STRIP001 	pImpl->bSaveToModule = FALSE;
//STRIP001 	FlagHdl_Impl( &aSimilarityBox );
//STRIP001 	FlagHdl_Impl( &aJapOptionsCB );
//STRIP001 	pImpl->bSaveToModule = TRUE;
//STRIP001 
//STRIP001 	FASTBOOL bDisableSearch = FALSE;
//STRIP001 	SfxViewShell* pViewShell = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		BOOL bText = !bSearchPattern;
//STRIP001 
//STRIP001 		if ( pViewShell->HasSelection( bText ) )
//STRIP001 			EnableControl_Impl( &aSelectionBtn );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aSelectionBtn.Check( FALSE );
//STRIP001 			aSelectionBtn.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Patternsuche und es wurden keine AttrSets "ubergeben
//STRIP001 	if ( bSearchPattern )
//STRIP001 	{
//STRIP001 		SfxObjectShell* pShell = SfxObjectShell::Current();
//STRIP001 
//STRIP001 		if ( pShell && pShell->GetStyleSheetPool() )
//STRIP001 		{
//STRIP001 			// Vorlagen beschaffen
//STRIP001 			aSearchTmplLB .Clear();
//STRIP001 			aReplaceTmplLB.Clear();
//STRIP001 			SfxStyleSheetBasePool* pStylePool = pShell->GetStyleSheetPool();
//STRIP001 			pStylePool->SetSearchMask( pSearchItem->GetFamily(),
//STRIP001 									   SFXSTYLEBIT_ALL );
//STRIP001 			SfxStyleSheetBase* pBase = pStylePool->First();
//STRIP001 
//STRIP001 			while ( pBase )
//STRIP001 			{
//STRIP001 				if ( pBase->IsUsed() )
//STRIP001 					aSearchTmplLB.InsertEntry( pBase->GetName() );
//STRIP001 				aReplaceTmplLB.InsertEntry( pBase->GetName() );
//STRIP001 				pBase = pStylePool->Next();
//STRIP001 			}
//STRIP001 			aSearchTmplLB.SelectEntry( pSearchItem->GetSearchString() );
//STRIP001 			aReplaceTmplLB.SelectEntry( pSearchItem->GetReplaceString() );
//STRIP001 
//STRIP001 		}
//STRIP001 		aSearchTmplLB.Show();
//STRIP001 
//STRIP001 		if ( bConstruct )
//STRIP001 			// nur nach dem Erzeugen den Fokus grappen
//STRIP001 			aSearchTmplLB.GrabFocus();
//STRIP001 		aReplaceTmplLB.Show();
//STRIP001 		aSearchLB.Hide();
//STRIP001 		aReplaceLB.Hide();
//STRIP001 
//STRIP001 		aWordBtn.Disable();
//STRIP001 		aRegExpBtn.Disable();
//STRIP001 		aMatchCaseCB.Disable();
//STRIP001 
//STRIP001 		bDisableSearch = !aSearchTmplLB.GetEntryCount();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		FASTBOOL bSetSearch = ( ( nModifyFlag & MODIFY_SEARCH ) == 0 );
//STRIP001 		FASTBOOL bSetReplace = ( ( nModifyFlag & MODIFY_REPLACE ) == 0 );
//STRIP001 
//STRIP001 		if ( pSearchItem->GetSearchString().Len() && bSetSearch )
//STRIP001 			aSearchLB.SetText( pSearchItem->GetSearchString() );
//STRIP001 		else if ( aSearchStrings.Count() )
//STRIP001 		{
//STRIP001 			FASTBOOL bAttributes =
//STRIP001 				( ( pSearchList && pSearchList->Count() ) ||
//STRIP001 				  ( pReplaceList && pReplaceList->Count() ) );
//STRIP001 
//STRIP001 			if ( bSetSearch && !bAttributes )
//STRIP001 				aSearchLB.SetText( *aSearchStrings[ 0 ] );
//STRIP001 
//STRIP001 			String aReplaceTxt = pSearchItem->GetReplaceString();
//STRIP001 
//STRIP001 			if ( aReplaceStrings.Count() )
//STRIP001 				aReplaceTxt = *aReplaceStrings[ 0 ];
//STRIP001 
//STRIP001 			if ( bSetReplace && !bAttributes )
//STRIP001 				aReplaceLB.SetText( aReplaceTxt );
//STRIP001 		}
//STRIP001 		aSearchLB.Show();
//STRIP001 
//STRIP001 		if ( bConstruct )
//STRIP001 			// nur nach dem Erzeugen den Fokus grappen
//STRIP001 			aSearchLB.GrabFocus();
//STRIP001 		aReplaceLB.Show();
//STRIP001 		aSearchTmplLB.Hide();
//STRIP001 		aReplaceTmplLB.Hide();
//STRIP001 
//STRIP001 		EnableControl_Impl( &aRegExpBtn );
//STRIP001 		EnableControl_Impl( &aMatchCaseCB );
//STRIP001 
//STRIP001 		if ( aRegExpBtn.IsChecked() )
//STRIP001 			aWordBtn.Disable();
//STRIP001 		else
//STRIP001 			EnableControl_Impl( &aWordBtn );
//STRIP001 
//STRIP001 		String aSrchAttrTxt;
//STRIP001 
//STRIP001 		if ( pImpl->bMultiLineEdit )
//STRIP001 			aSrchAttrTxt = pImpl->aSearchFormats.GetText();
//STRIP001 		else
//STRIP001 			aSrchAttrTxt = aSearchAttrText.GetText();
//STRIP001 
//STRIP001 		bDisableSearch = !aSearchLB.GetText().Len() && !aSrchAttrTxt.Len();
//STRIP001 	}
//STRIP001 	FocusHdl_Impl( &aSearchLB );
//STRIP001 
//STRIP001 	if ( bDisableSearch )
//STRIP001 	{
//STRIP001 		aSearchBtn.Disable();
//STRIP001 		aSearchAllBtn.Disable();
//STRIP001 		aReplaceBtn.Disable();
//STRIP001 		aReplaceAllBtn.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		EnableControl_Impl( &aSearchBtn );
//STRIP001 		EnableControl_Impl( &aSearchAllBtn );
//STRIP001 		EnableControl_Impl( &aReplaceBtn );
//STRIP001 		EnableControl_Impl( &aReplaceAllBtn );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( ( !pImpl->bMultiLineEdit && aSearchAttrText.GetText().Len() ) ||
//STRIP001 			( pImpl->bMultiLineEdit && pImpl->aSearchFormats.GetText().Len() ) )
//STRIP001 		EnableControl_Impl( &aNoFormatBtn );
//STRIP001 	else
//STRIP001 		aNoFormatBtn.Disable();
//STRIP001 
//STRIP001 	if ( !pSearchList )
//STRIP001 	{
//STRIP001 		aAttributeBtn.Disable();
//STRIP001 		aFormatBtn.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( aLayoutBtn.IsChecked() )
//STRIP001 	{
//STRIP001 		pImpl->bSaveToModule = FALSE;
//STRIP001 		TemplateHdl_Impl( &aLayoutBtn );
//STRIP001 		pImpl->bSaveToModule = TRUE;
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::InitAttrList_Impl( const SfxItemSet* pSSet,
//STRIP001 										 const SfxItemSet* pRSet )
//STRIP001 {
//STRIP001 	if ( !pSSet && !pRSet )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( !pImpl->pRanges && pSSet )
//STRIP001 	{
//STRIP001 		USHORT nCnt = 0;
//STRIP001 		const USHORT* pPtr = pSSet->GetRanges();
//STRIP001 		const USHORT* pTmp = pPtr;
//STRIP001 
//STRIP001 		while( *pPtr )
//STRIP001 		{
//STRIP001 			nCnt += ( *(pPtr+1) - *pPtr ) + 1;
//STRIP001 			pPtr += 2;
//STRIP001 		}
//STRIP001 		nCnt = pPtr - pTmp + 1;
//STRIP001 		pImpl->pRanges = new USHORT[nCnt];
//STRIP001 		memcpy( pImpl->pRanges, pTmp, sizeof(USHORT) * nCnt );
//STRIP001 	}
//STRIP001 
//STRIP001 	// sorge daf"ur, das die Texte der Attribute richtig stehen
//STRIP001 	String aDesc;
//STRIP001 
//STRIP001 	if ( pSSet )
//STRIP001 	{
//STRIP001 		delete pSearchList;
//STRIP001 		pSearchList = new SearchAttrItemList;
//STRIP001 
//STRIP001 		if ( pSSet->Count() )
//STRIP001 		{
//STRIP001 			pSearchList->Put( *pSSet );
//STRIP001 
//STRIP001 			if ( !pImpl->bMultiLineEdit )
//STRIP001 				aSearchAttrText.SetText( BuildAttrText_Impl( aDesc, TRUE ) );
//STRIP001 			else
//STRIP001 				pImpl->aSearchFormats.SetText( BuildAttrText_Impl( aDesc, TRUE ) );
//STRIP001 
//STRIP001 			if ( aDesc.Len() )
//STRIP001 				bFormat |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pRSet )
//STRIP001 	{
//STRIP001 		delete pReplaceList;
//STRIP001 		pReplaceList = new SearchAttrItemList;
//STRIP001 
//STRIP001 		if ( pRSet->Count() )
//STRIP001 		{
//STRIP001 			pReplaceList->Put( *pRSet );
//STRIP001 
//STRIP001 			if ( !pImpl->bMultiLineEdit )
//STRIP001 				aReplaceAttrText.SetText( BuildAttrText_Impl( aDesc, FALSE ) );
//STRIP001 			else
//STRIP001 				pImpl->aReplaceFormats.SetText( BuildAttrText_Impl( aDesc, FALSE ) );
//STRIP001 
//STRIP001 			if ( aDesc.Len() )
//STRIP001 				bFormat |= TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, FlagHdl_Impl, Button *, pButton )
//STRIP001 {
//STRIP001  	if ( pButton && !bSet )
//STRIP001 		SetModifyFlag_Impl( pButton );
//STRIP001 	else
//STRIP001 		bSet = FALSE;
//STRIP001 
//STRIP001 	if ( pButton == &aSimilarityBox )
//STRIP001 	{
//STRIP001 		BOOL bIsChecked = aSimilarityBox.IsChecked();
//STRIP001 
//STRIP001 		if ( bIsChecked )
//STRIP001 		{
//STRIP001 			aSimilarityBtn.Enable();
//STRIP001 			aRegExpBtn.Check( FALSE );
//STRIP001 			aRegExpBtn.Disable();
//STRIP001 			EnableControl_Impl( &aWordBtn );
//STRIP001 
//STRIP001 			if ( aLayoutBtn.IsChecked() )
//STRIP001 			{
//STRIP001 				EnableControl_Impl( &aMatchCaseCB );
//STRIP001 				aLayoutBtn.Check( FALSE );
//STRIP001 			}
//STRIP001 			aRegExpBtn.Disable();
//STRIP001 			aLayoutBtn.Disable();
//STRIP001 			aFormatBtn.Disable();
//STRIP001 			aNoFormatBtn.Disable();
//STRIP001 			aAttributeBtn.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			EnableControl_Impl( &aRegExpBtn );
//STRIP001 			EnableControl_Impl( &aLayoutBtn );
//STRIP001 			EnableControl_Impl( &aFormatBtn );
//STRIP001 			EnableControl_Impl( &aAttributeBtn );
//STRIP001 			aSimilarityBtn.Disable();
//STRIP001 		}
//STRIP001 		pSearchItem->SetLevenshtein( bIsChecked );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( aLayoutBtn.IsChecked() && !bFormat )
//STRIP001 		{
//STRIP001 			aWordBtn.Check( FALSE );
//STRIP001 			aWordBtn.Disable();
//STRIP001 			aRegExpBtn.Check( FALSE );
//STRIP001 			aRegExpBtn.Disable();
//STRIP001 			aMatchCaseCB.Check( FALSE );
//STRIP001 			aMatchCaseCB.Disable();
//STRIP001 
//STRIP001 			if ( aSearchTmplLB.GetEntryCount() )
//STRIP001 			{
//STRIP001 				EnableControl_Impl( &aSearchBtn );
//STRIP001 				EnableControl_Impl( &aSearchAllBtn );
//STRIP001 				EnableControl_Impl( &aReplaceBtn );
//STRIP001 				EnableControl_Impl( &aReplaceAllBtn );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			EnableControl_Impl( &aRegExpBtn );
//STRIP001 			EnableControl_Impl( &aMatchCaseCB );
//STRIP001 
//STRIP001 			if ( aRegExpBtn.IsChecked() )
//STRIP001 			{
//STRIP001 				aWordBtn.Check( FALSE );
//STRIP001 				aWordBtn.Disable();
//STRIP001 				aSimilarityBox.Disable();
//STRIP001 				aSimilarityBtn.Disable();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				EnableControl_Impl( &aWordBtn );
//STRIP001 				EnableControl_Impl( &aSimilarityBox );
//STRIP001 			}
//STRIP001 
//STRIP001 			// Such-String vorhanden? dann Buttons enablen
//STRIP001 			bSet = TRUE;
//STRIP001 			ModifyHdl_Impl( &aSearchLB );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( &aAllTablesCB == pButton )
//STRIP001 	{
//STRIP001 		if ( aAllTablesCB.IsChecked() )
//STRIP001 			aSearchAllBtn.Disable();
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bSet = TRUE;
//STRIP001 			ModifyHdl_Impl( &aSearchLB );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( &aJapOptionsCB == pButton )
//STRIP001 	{
//STRIP001 		BOOL bEnableJapOpt = aJapOptionsCB.IsChecked();
//STRIP001 		aMatchCaseCB			.Enable(!bEnableJapOpt );
//STRIP001 		aJapMatchFullHalfWidthCB.Enable(!bEnableJapOpt );
//STRIP001 		aJapOptionsBtn			.Enable( bEnableJapOpt );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pImpl->bSaveToModule )
//STRIP001 		SaveToModule_Impl();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, CommandHdl_Impl, Button *, pBtn )
//STRIP001 {
//STRIP001 	FASTBOOL bInclusive = ( aLayoutBtn.GetText() == aLayoutStr );
//STRIP001 
//STRIP001 	if ( ( pBtn == &aSearchBtn )	||
//STRIP001 		 ( pBtn == &aSearchAllBtn ) ||
//STRIP001 		 ( pBtn == &aReplaceBtn )	||
//STRIP001 		 ( pBtn == &aReplaceAllBtn ) )
//STRIP001 	{
//STRIP001 		if ( aLayoutBtn.IsChecked() && !bInclusive )
//STRIP001 		{
//STRIP001 			pSearchItem->SetSearchString ( aSearchTmplLB.GetSelectEntry() );
//STRIP001 			pSearchItem->SetReplaceString( aReplaceTmplLB.GetSelectEntry() );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pSearchItem->SetSearchString ( aSearchLB.GetText() );
//STRIP001 			pSearchItem->SetReplaceString( aReplaceLB.GetText() );
//STRIP001 
//STRIP001 			if ( pBtn == &aReplaceBtn )
//STRIP001 				Remember_Impl( aReplaceLB.GetText(), FALSE );
//STRIP001 			else
//STRIP001 			{
//STRIP001 				Remember_Impl( aSearchLB.GetText(), TRUE );
//STRIP001 
//STRIP001 				if ( pBtn == &aReplaceAllBtn )
//STRIP001 					Remember_Impl( aReplaceLB.GetText(), FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		pSearchItem->SetRegExp( FALSE );
//STRIP001 		pSearchItem->SetLevenshtein( FALSE );
//STRIP001 		if (GetCheckBoxValue( aRegExpBtn ))
//STRIP001 			pSearchItem->SetRegExp( TRUE );
//STRIP001 		else if (GetCheckBoxValue( aSimilarityBox ))
//STRIP001 			pSearchItem->SetLevenshtein( TRUE );
//STRIP001 
//STRIP001 		pSearchItem->SetWordOnly( GetCheckBoxValue( aWordBtn ) );
//STRIP001 		pSearchItem->SetBackward( GetCheckBoxValue( aBackwardsBtn ) );
//STRIP001 		pSearchItem->SetPattern( GetCheckBoxValue( aLayoutBtn ) );
//STRIP001 		pSearchItem->SetSelection( GetCheckBoxValue( aSelectionBtn ) );
//STRIP001 
//STRIP001 		pSearchItem->SetUseAsianOptions( GetCheckBoxValue( aJapOptionsCB ) );
//STRIP001 		INT32 nFlags = GetTransliterationFlags();
//STRIP001 		if( !pSearchItem->IsUseAsianOptions())
//STRIP001             nFlags &= (TransliterationModules_IGNORE_CASE |
//STRIP001 					   TransliterationModules_IGNORE_WIDTH );
//STRIP001 		pSearchItem->SetTransliterationFlags( nFlags );
//STRIP001 
//STRIP001 		if ( !bWriter )
//STRIP001 		{
//STRIP001 			if ( aFormulasBtn.IsChecked() )
//STRIP001 				pSearchItem->SetCellType( SVX_SEARCHIN_FORMULA );
//STRIP001 			else if ( aValuesBtn.IsChecked() )
//STRIP001 				pSearchItem->SetCellType( SVX_SEARCHIN_VALUE );
//STRIP001 			else if ( aNotesBtn.IsChecked() )
//STRIP001 				pSearchItem->SetCellType( SVX_SEARCHIN_NOTE );
//STRIP001 
//STRIP001 			pSearchItem->SetRowDirection( aRowsBtn.IsChecked() );
//STRIP001 			pSearchItem->SetAllTables( aAllTablesCB.IsChecked() );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( pBtn == &aSearchBtn )
//STRIP001 			pSearchItem->SetCommand( SVX_SEARCHCMD_FIND );
//STRIP001 		else if ( pBtn == &aSearchAllBtn )
//STRIP001 			pSearchItem->SetCommand( SVX_SEARCHCMD_FIND_ALL );
//STRIP001 		else if ( pBtn == &aReplaceBtn )
//STRIP001 			pSearchItem->SetCommand( SVX_SEARCHCMD_REPLACE );
//STRIP001 		else if ( pBtn == &aReplaceAllBtn )
//STRIP001 			pSearchItem->SetCommand( SVX_SEARCHCMD_REPLACE_ALL );
//STRIP001 
//STRIP001 		// wenn nach Vorlagen gesucht wird, dann Format-Listen l"oschen
//STRIP001 		if ( !bFormat && pSearchItem->GetPattern() )
//STRIP001 		{
//STRIP001 			if ( pSearchList )
//STRIP001 				pSearchList->Clear();
//STRIP001 
//STRIP001 			if ( pReplaceList )
//STRIP001 				pReplaceList->Clear();
//STRIP001 		}
//STRIP001 		nModifyFlag = 0;
//STRIP001         const SfxPoolItem* ppArgs[] = { pSearchItem, 0 };
//STRIP001         rBindings.ExecuteSynchron( FID_SEARCH_NOW, ppArgs, 0L );
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aCloseBtn )
//STRIP001 	{
//STRIP001 		if ( !aLayoutBtn.IsChecked() || bInclusive )
//STRIP001 		{
//STRIP001 			String aStr( aSearchLB.GetText() );
//STRIP001 
//STRIP001 			if ( aStr.Len() )
//STRIP001 				Remember_Impl( aStr, TRUE );
//STRIP001 			aStr = aReplaceLB.GetText();
//STRIP001 
//STRIP001 			if ( aStr.Len() )
//STRIP001 				Remember_Impl( aStr, FALSE );
//STRIP001 		}
//STRIP001 		SaveToModule_Impl();
//STRIP001 		Close();
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aSimilarityBtn )
//STRIP001 	{
//STRIP001 		SvxSearchSimilarityDialog* pDlg =
//STRIP001 			new SvxSearchSimilarityDialog( this,
//STRIP001 										   pSearchItem->IsLEVRelaxed(),
//STRIP001 										   pSearchItem->GetLEVOther(),
//STRIP001 										   pSearchItem->GetLEVShorter(),
//STRIP001 										   pSearchItem->GetLEVLonger() );
//STRIP001 
//STRIP001 		if ( pDlg->Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			pSearchItem->SetLEVRelaxed( pDlg->IsRelaxed() );
//STRIP001 			pSearchItem->SetLEVOther( pDlg->GetOther() );
//STRIP001 			pSearchItem->SetLEVShorter( pDlg->GetShorter() );
//STRIP001 			pSearchItem->SetLEVLonger( pDlg->GetLonger() );
//STRIP001 			SaveToModule_Impl();
//STRIP001 		}
//STRIP001 		delete pDlg;
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aJapOptionsBtn )
//STRIP001 	{
//STRIP001 		SfxItemSet aSet( SFX_APP()->GetPool() );
//STRIP001 		pSearchItem->SetTransliterationFlags( GetTransliterationFlags() );
//STRIP001 		SvxJSearchOptionsDialog aDlg( this, aSet, RID_SVXPAGE_JSEARCH_OPTIONS,
//STRIP001 									pSearchItem->GetTransliterationFlags() );
//STRIP001         int nRet = aDlg.Execute();
//STRIP001         if (RET_OK == nRet) //! true only if FillItemSet of SvxJSearchOptionsPage returns true
//STRIP001         {
//STRIP001             INT32 nFlags = aDlg.GetTransliterationFlags();
//STRIP001             pSearchItem->SetTransliterationFlags( nFlags );
//STRIP001             ApplyTransliterationFlags_Impl( nFlags );
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, ModifyHdl_Impl, ComboBox *, pEd )
//STRIP001 {
//STRIP001 	if ( !bSet )
//STRIP001 		SetModifyFlag_Impl( pEd );
//STRIP001 	else
//STRIP001 		bSet = FALSE;
//STRIP001 
//STRIP001 	if ( pEd == &aSearchLB || pEd == &aReplaceLB )
//STRIP001 	{
//STRIP001 		xub_StrLen nLBTxtLen = aSearchLB.GetText().Len(), nTxtLen;
//STRIP001 
//STRIP001 		if ( !pImpl->bMultiLineEdit )
//STRIP001 		   nTxtLen = aSearchAttrText.GetText().Len();
//STRIP001 		else
//STRIP001 			nTxtLen = pImpl->aSearchFormats.GetText().Len();
//STRIP001 
//STRIP001 		if ( nLBTxtLen || nTxtLen )
//STRIP001 		{
//STRIP001 			EnableControl_Impl( &aSearchBtn );
//STRIP001 			EnableControl_Impl( &aSearchAllBtn );
//STRIP001 			EnableControl_Impl( &aReplaceBtn );
//STRIP001 			EnableControl_Impl( &aReplaceAllBtn );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aSearchBtn.Disable();
//STRIP001 			aSearchAllBtn.Disable();
//STRIP001 			aReplaceBtn.Disable();
//STRIP001 			aReplaceAllBtn.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, TemplateHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( pImpl->bSaveToModule )
//STRIP001 		SaveToModule_Impl();
//STRIP001 
//STRIP001 	if ( bFormat )
//STRIP001 		return 0;
//STRIP001 	String sDesc;
//STRIP001 
//STRIP001 	if ( aLayoutBtn.IsChecked() )
//STRIP001 	{
//STRIP001 		if ( !pFamilyController )
//STRIP001 		{
//STRIP001 			USHORT nId = 0;
//STRIP001 
//STRIP001 			// Vorlagen-Controller enablen
//STRIP001 			switch ( pSearchItem->GetFamily() )
//STRIP001 			{
//STRIP001 				case SFX_STYLE_FAMILY_CHAR:
//STRIP001 					nId = SID_STYLE_FAMILY1; break;
//STRIP001 
//STRIP001 				case SFX_STYLE_FAMILY_PARA:
//STRIP001 					nId = SID_STYLE_FAMILY2; break;
//STRIP001 
//STRIP001 				case SFX_STYLE_FAMILY_FRAME:
//STRIP001 					nId = SID_STYLE_FAMILY3; break;
//STRIP001 
//STRIP001 				case SFX_STYLE_FAMILY_PAGE:
//STRIP001 					nId = SID_STYLE_FAMILY4; break;
//STRIP001 
//STRIP001 				case SFX_STYLE_FAMILY_ALL:
//STRIP001 					break;
//STRIP001 
//STRIP001 				default:
//STRIP001 					DBG_ERROR( "StyleSheetFamily wurde geaendert?" );
//STRIP001 			}
//STRIP001 
//STRIP001 			rBindings.EnterRegistrations();
//STRIP001 			pFamilyController =
//STRIP001 				new SvxSearchController( nId, rBindings, *this );
//STRIP001 			rBindings.LeaveRegistrations();
//STRIP001 			aSearchTmplLB.Clear();
//STRIP001 			aReplaceTmplLB.Clear();
//STRIP001 
//STRIP001 			aSearchTmplLB.Show();
//STRIP001 			aReplaceTmplLB.Show();
//STRIP001 			aSearchLB.Hide();
//STRIP001 			aReplaceLB.Hide();
//STRIP001 
//STRIP001 			if ( !pImpl->bMultiLineEdit )
//STRIP001 			{
//STRIP001 				aSearchAttrText.SetText( sDesc );
//STRIP001 				aReplaceAttrText.SetText( sDesc );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pImpl->aSearchFormats.SetText( sDesc );
//STRIP001 				pImpl->aReplaceFormats.SetText( sDesc );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aFormatBtn.Disable();
//STRIP001 		aNoFormatBtn.Disable();
//STRIP001 		aAttributeBtn.Disable();
//STRIP001 		aSimilarityBox.Disable();
//STRIP001 		aSimilarityBtn.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Vorlagen-Controller disablen
//STRIP001 		rBindings.EnterRegistrations();
//STRIP001 		DELETEZ( pFamilyController );
//STRIP001 		rBindings.LeaveRegistrations();
//STRIP001 
//STRIP001 		aSearchLB.Show();
//STRIP001 		aReplaceLB.Show();
//STRIP001 		aSearchTmplLB.Hide();
//STRIP001 		aReplaceTmplLB.Hide();
//STRIP001 
//STRIP001 		if ( !pImpl->bMultiLineEdit )
//STRIP001 		{
//STRIP001 			aSearchAttrText.SetText( BuildAttrText_Impl( sDesc, TRUE ) );
//STRIP001 			aReplaceAttrText.SetText( BuildAttrText_Impl( sDesc, FALSE ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pImpl->aSearchFormats.SetText( BuildAttrText_Impl( sDesc, TRUE ) );
//STRIP001 			pImpl->aReplaceFormats.SetText( BuildAttrText_Impl( sDesc, FALSE ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		EnableControl_Impl( &aFormatBtn );
//STRIP001 		EnableControl_Impl( &aAttributeBtn );
//STRIP001 		EnableControl_Impl( &aSimilarityBox );
//STRIP001 
//STRIP001 		FocusHdl_Impl( bSearch ? &aSearchLB : &aReplaceLB );
//STRIP001 	}
//STRIP001 	bSet = TRUE;
//STRIP001 	pImpl->bSaveToModule = FALSE;
//STRIP001 	FlagHdl_Impl( &aLayoutBtn );
//STRIP001 	pImpl->bSaveToModule = TRUE;
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::Remember_Impl( const String &rStr,BOOL bSearch )
//STRIP001 {
//STRIP001 	if ( !rStr.Len() )
//STRIP001 		return;
//STRIP001 
//STRIP001 	SvStringsDtor* pArr = bSearch ? &aSearchStrings : &aReplaceStrings;
//STRIP001 	::com::boBox* pListBox = bSearch ? &aSearchLB : &aReplaceLB;
//STRIP001 
//STRIP001 	// identische Strings ignorieren
//STRIP001 	for ( USHORT i = 0; i < pArr->Count(); ++i )
//STRIP001 	{
//STRIP001 		if ( COMPARE_EQUAL == (*pArr)[i]->CompareTo( rStr ) )
//STRIP001 			return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// bei maximaler Belegung "altesten Eintrag l"oschen (ListBox und Array)
//STRIP001 	String* pInsStr;
//STRIP001 
//STRIP001 	if ( pArr->Count() >= REMEMBER_SIZE )
//STRIP001 	{
//STRIP001 		pInsStr = (*pArr)[REMEMBER_SIZE - 1];
//STRIP001 		pListBox->RemoveEntry( USHORT(REMEMBER_SIZE - 1) );
//STRIP001 		pArr->Remove( REMEMBER_SIZE - 1 );
//STRIP001 		*pInsStr = rStr;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pInsStr = new String( rStr );
//STRIP001 
//STRIP001 	pArr->Insert( pInsStr, 0 );
//STRIP001 	pListBox->InsertEntry( *pInsStr, 0 );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::TemplatesChanged_Impl( SfxStyleSheetBasePool& rPool )
//STRIP001 {
//STRIP001 //	SetUpdateMode( FALSE );
//STRIP001 	String aOldSrch( aSearchTmplLB .GetSelectEntry() );
//STRIP001 	String aOldRepl( aReplaceTmplLB.GetSelectEntry() );
//STRIP001 	aSearchTmplLB .Clear();
//STRIP001 	aReplaceTmplLB.Clear();
//STRIP001 	rPool.SetSearchMask( pSearchItem->GetFamily(), SFXSTYLEBIT_ALL );
//STRIP001 	aSearchTmplLB.SetUpdateMode( FALSE );
//STRIP001 	aReplaceTmplLB.SetUpdateMode( FALSE );
//STRIP001 	SfxStyleSheetBase* pBase = rPool.First();
//STRIP001 
//STRIP001 	while ( pBase )
//STRIP001 	{
//STRIP001 		if ( pBase->IsUsed() )
//STRIP001 			aSearchTmplLB.InsertEntry( pBase->GetName() );
//STRIP001 		aReplaceTmplLB.InsertEntry( pBase->GetName() );
//STRIP001 		pBase = rPool.Next();
//STRIP001 	}
//STRIP001 	aSearchTmplLB.SetUpdateMode( TRUE );
//STRIP001 	aReplaceTmplLB.SetUpdateMode( TRUE );
//STRIP001 	aSearchTmplLB.SelectEntryPos(0);
//STRIP001 
//STRIP001 	if ( aOldSrch.Len() )
//STRIP001 		aSearchTmplLB .SelectEntry( aOldSrch );
//STRIP001 	aReplaceTmplLB.SelectEntryPos(0);
//STRIP001 
//STRIP001 	if ( aOldRepl.Len() )
//STRIP001 		aReplaceTmplLB.SelectEntry( aOldRepl );
//STRIP001 
//STRIP001 	if ( aSearchTmplLB.GetEntryCount() )
//STRIP001 	{
//STRIP001 		EnableControl_Impl( &aSearchBtn );
//STRIP001 		EnableControl_Impl( &aSearchAllBtn );
//STRIP001 		EnableControl_Impl( &aReplaceBtn );
//STRIP001 		EnableControl_Impl( &aReplaceAllBtn );
//STRIP001 	}
//STRIP001 //	FlagHdl_Impl(0);
//STRIP001 //	SetUpdateMode( TRUE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::EnableControls_Impl( const USHORT nFlags )
//STRIP001 {
//STRIP001 	if ( nFlags == nOptions )
//STRIP001 		return;
//STRIP001 	else
//STRIP001 		nOptions = nFlags;
//STRIP001 
//STRIP001 	if ( !nOptions )
//STRIP001 	{
//STRIP001 		if ( IsVisible() )
//STRIP001 		{
//STRIP001 			Hide();
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( !IsVisible() )
//STRIP001 		Show();
//STRIP001 	FASTBOOL bNoSearch = TRUE;
//STRIP001 
//STRIP001 	if ( ( SEARCH_OPTIONS_SEARCH & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSearchBtn.Enable();
//STRIP001 		bNoSearch = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aSearchBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_SEARCH_ALL & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSearchAllBtn.Enable();
//STRIP001 		bNoSearch = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aSearchAllBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_REPLACE & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aReplaceBtn.Enable();
//STRIP001 		aReplaceText.Enable();
//STRIP001 		aReplaceLB.Enable();
//STRIP001 		aReplaceTmplLB.Enable();
//STRIP001 		bNoSearch = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aReplaceBtn.Disable();
//STRIP001 		aReplaceText.Disable();
//STRIP001 		aReplaceLB.Disable();
//STRIP001 		aReplaceTmplLB.Disable();
//STRIP001 	}
//STRIP001 	if ( ( SEARCH_OPTIONS_REPLACE_ALL & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aReplaceAllBtn.Enable();
//STRIP001 		bNoSearch = FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aReplaceAllBtn.Disable();
//STRIP001 	aSearchBtn.Enable( !bNoSearch );
//STRIP001 	aSearchText.Enable( !bNoSearch );
//STRIP001 	aSearchLB.Enable( !bNoSearch );
//STRIP001 
//STRIP001 	if ( ( SEARCH_OPTIONS_WHOLE_WORDS & nOptions ) != 0 )
//STRIP001 		aWordBtn.Enable();
//STRIP001 	else
//STRIP001 		aWordBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_BACKWARDS & nOptions ) != 0 )
//STRIP001 		aBackwardsBtn.Enable();
//STRIP001 	else
//STRIP001 		aBackwardsBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_REG_EXP & nOptions ) != 0 )
//STRIP001 		aRegExpBtn.Enable();
//STRIP001 	else
//STRIP001 		aRegExpBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_EXACT & nOptions ) != 0 )
//STRIP001 		aMatchCaseCB.Enable();
//STRIP001 	else
//STRIP001 		aMatchCaseCB.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_SELECTION & nOptions ) != 0 )
//STRIP001 		aSelectionBtn.Enable();
//STRIP001 	else
//STRIP001 		aSelectionBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_FAMILIES & nOptions ) != 0 )
//STRIP001 		aLayoutBtn.Enable();
//STRIP001 	else
//STRIP001 		aLayoutBtn.Disable();
//STRIP001 	if ( ( SEARCH_OPTIONS_FORMAT & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aAttributeBtn.Enable();
//STRIP001 		aFormatBtn.Enable();
//STRIP001 		aNoFormatBtn.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aAttributeBtn.Disable();
//STRIP001 		aFormatBtn.Disable();
//STRIP001 		aNoFormatBtn.Disable();
//STRIP001 	}
//STRIP001 	if ( ( SEARCH_OPTIONS_MORE & nOptions ) != 0 &&
//STRIP001 		 pSearchItem && pSearchItem->GetAppFlag() == SVX_SEARCHAPP_CALC )
//STRIP001 		pMoreBtn->Enable();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pMoreBtn->SetState( FALSE );
//STRIP001 		pMoreBtn->Disable();
//STRIP001 	}
//STRIP001 	if ( ( SEARCH_OPTIONS_SIMILARITY & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSimilarityBox.Enable();
//STRIP001 		aSimilarityBtn.Enable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aSimilarityBox.Disable();
//STRIP001 		aSimilarityBtn.Disable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSearchItem )
//STRIP001 		Init_Impl( pSearchItem->GetPattern() &&
//STRIP001 				   ( !pSearchList || !pSearchList->Count() ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::EnableControl_Impl( Control* pCtrl )
//STRIP001 {
//STRIP001 	if ( &aSearchBtn == pCtrl && ( SEARCH_OPTIONS_SEARCH & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSearchBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aSearchAllBtn == pCtrl &&
//STRIP001 		 ( SEARCH_OPTIONS_SEARCH_ALL & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSearchAllBtn.Enable( ( bWriter || !aAllTablesCB.IsChecked() ) );
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aReplaceBtn == pCtrl && ( SEARCH_OPTIONS_REPLACE & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aReplaceBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aReplaceAllBtn == pCtrl &&
//STRIP001 		 ( SEARCH_OPTIONS_REPLACE_ALL & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aReplaceAllBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aWordBtn == pCtrl && ( SEARCH_OPTIONS_WHOLE_WORDS & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aWordBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aBackwardsBtn == pCtrl && ( SEARCH_OPTIONS_BACKWARDS & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aBackwardsBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aRegExpBtn == pCtrl && ( SEARCH_OPTIONS_REG_EXP & nOptions ) != 0
//STRIP001 		&& !aSimilarityBox.IsChecked())
//STRIP001 	{
//STRIP001 		aRegExpBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aMatchCaseCB == pCtrl && ( SEARCH_OPTIONS_EXACT & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		if (!aJapOptionsCB.IsChecked())
//STRIP001 			aMatchCaseCB.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aSelectionBtn == pCtrl && ( SEARCH_OPTIONS_SELECTION & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSelectionBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aLayoutBtn == pCtrl && ( SEARCH_OPTIONS_FAMILIES & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aLayoutBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( 	&aAttributeBtn == pCtrl
//STRIP001 		 && ( SEARCH_OPTIONS_FORMAT & nOptions ) != 0
//STRIP001 		 && pSearchList )
//STRIP001 	{
//STRIP001 		aAttributeBtn.Enable( pImpl->bFocusOnSearch );
//STRIP001 	}
//STRIP001 	if ( &aFormatBtn == pCtrl && ( SEARCH_OPTIONS_FORMAT & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aFormatBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aNoFormatBtn == pCtrl && ( SEARCH_OPTIONS_FORMAT & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aNoFormatBtn.Enable();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 	if ( &aSimilarityBox == pCtrl &&
//STRIP001 		 ( SEARCH_OPTIONS_SIMILARITY & nOptions ) != 0 )
//STRIP001 	{
//STRIP001 		aSimilarityBox.Enable();
//STRIP001 
//STRIP001 		if ( aSimilarityBox.IsChecked() )
//STRIP001 			aSimilarityBtn.Enable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::SetItem_Impl( const SvxSearchItem* pItem )
//STRIP001 {
//STRIP001 	if ( pItem )
//STRIP001 	{
//STRIP001 		delete pSearchItem;
//STRIP001 		pSearchItem = (SvxSearchItem*)pItem->Clone();
//STRIP001 		Init_Impl( pSearchItem->GetPattern() &&
//STRIP001 				   ( !pSearchList || !pSearchList->Count() ) );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, FocusHdl_Impl, Control *, pCtrl )
//STRIP001 {
//STRIP001 	xub_StrLen nTxtLen;
//STRIP001 
//STRIP001 	if ( !pImpl->bMultiLineEdit )
//STRIP001 		nTxtLen = aSearchAttrText.GetText().Len();
//STRIP001 	else
//STRIP001 		nTxtLen = pImpl->aSearchFormats.GetText().Len();
//STRIP001 
//STRIP001 	if ( pCtrl == &aSearchLB || pCtrl == &pImpl->aSearchFormats )
//STRIP001 	{
//STRIP001 		if ( pCtrl->HasChildPathFocus() )
//STRIP001 			pImpl->bFocusOnSearch = TRUE;
//STRIP001 		pCtrl = &aSearchLB;
//STRIP001 		bSearch = TRUE;
//STRIP001 
//STRIP001 		if( nTxtLen )
//STRIP001 			EnableControl_Impl( &aNoFormatBtn );
//STRIP001 		else
//STRIP001 			aNoFormatBtn.Disable();
//STRIP001 		EnableControl_Impl( &aAttributeBtn );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pImpl->bFocusOnSearch = FALSE;
//STRIP001 		pCtrl = &aReplaceLB;
//STRIP001 		bSearch = FALSE;
//STRIP001 
//STRIP001 		if ( ( !pImpl->bMultiLineEdit && aReplaceAttrText.GetText().Len() ) ||
//STRIP001 				( pImpl->bMultiLineEdit && pImpl->aReplaceFormats.GetText().Len() ) )
//STRIP001 			EnableControl_Impl( &aNoFormatBtn );
//STRIP001 		else
//STRIP001 			aNoFormatBtn.Disable();
//STRIP001 		aAttributeBtn.Disable();
//STRIP001 	}
//STRIP001 	bSet = TRUE;
//STRIP001 
//STRIP001 	aSearchLB.SetSelection( Selection( SELECTION_MIN, SELECTION_MAX ) );
//STRIP001 
//STRIP001 	ModifyHdl_Impl( (ComboBox*)pCtrl );
//STRIP001 	aLayoutBtn.SetText( bFormat && nTxtLen ? aLayoutStr : aStylesStr );
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, LoseFocusHdl_Impl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001 	SaveToModule_Impl();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, FormatHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 
//STRIP001 	DBG_ASSERT( pSh, "no DocShell" );
//STRIP001 
//STRIP001 	if ( !pSh || !pImpl->pRanges )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	USHORT nCnt = 0;
//STRIP001 	const USHORT* pPtr = pImpl->pRanges;
//STRIP001 	const USHORT* pTmp = pPtr;
//STRIP001 
//STRIP001 	while( *pTmp )
//STRIP001 		pTmp++;
//STRIP001 	nCnt = pTmp - pPtr + 7;
//STRIP001 	USHORT* pWhRanges = new USHORT[nCnt];
//STRIP001 	USHORT nPos = 0;
//STRIP001 
//STRIP001 	while( *pPtr )
//STRIP001 	{
//STRIP001 		pWhRanges[nPos++] = *pPtr++;
//STRIP001 	}
//STRIP001 
//STRIP001 	pWhRanges[nPos++] = SID_ATTR_PARA_MODEL;
//STRIP001 	pWhRanges[nPos++] = SID_ATTR_PARA_MODEL;
//STRIP001 
//STRIP001 	USHORT nBrushWhich = pSh->GetPool().GetWhich(SID_ATTR_BRUSH);
//STRIP001 	pWhRanges[nPos++] = nBrushWhich;
//STRIP001 	pWhRanges[nPos++] = nBrushWhich;
//STRIP001 	pWhRanges[nPos++] = SID_PARA_BACKGRND_DESTINATION;
//STRIP001 	pWhRanges[nPos++] = SID_PARA_BACKGRND_DESTINATION;
//STRIP001 	pWhRanges[nPos] = 0;
//STRIP001 	SfxItemPool& rPool = pSh->GetPool();
//STRIP001 	SfxItemSet aSet( rPool, pWhRanges );
//STRIP001 	String aTxt;
//STRIP001 
//STRIP001 	aSet.InvalidateAllItems();
//STRIP001 	aSet.Put(SvxBrushItem(nBrushWhich));
//STRIP001 	aSet.Put(SfxUInt16Item(SID_PARA_BACKGRND_DESTINATION, PARA_DEST_CHAR));
//STRIP001 
//STRIP001 	if ( bSearch )
//STRIP001 	{
//STRIP001 		aTxt = SVX_RESSTR( RID_SVXSTR_SEARCH );
//STRIP001 		pSearchList->Get( aSet );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aTxt = SVX_RESSTR( RID_SVXSTR_REPLACE );
//STRIP001 		pReplaceList->Get( aSet );
//STRIP001 	}
//STRIP001 	aSet.DisableItem(SID_ATTR_PARA_MODEL);
//STRIP001 	aSet.DisableItem(rPool.GetWhich(SID_ATTR_PARA_PAGEBREAK));
//STRIP001 	aSet.DisableItem(rPool.GetWhich(SID_ATTR_PARA_KEEP));
//STRIP001 
//STRIP001 	SvxSearchFormatDialog* pDlg = new SvxSearchFormatDialog( this, aSet );
//STRIP001 
//STRIP001 	aTxt.Insert( pDlg->GetText(), 0 );
//STRIP001 	pDlg->SetText( aTxt );
//STRIP001 
//STRIP001 	if ( pDlg->Execute() == RET_OK )
//STRIP001 	{
//STRIP001 		DBG_ASSERT( pDlg->GetOutputItemSet(), "invalid Output-Set" );
//STRIP001 		SfxItemSet aOutSet( *pDlg->GetOutputItemSet() );
//STRIP001 
//STRIP001 		SearchAttrItemList* pList = bSearch ? pSearchList : pReplaceList;
//STRIP001 
//STRIP001 		SearchAttrItem* pAItem;
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		for( USHORT n = 0; n < pList->Count(); ++n )
//STRIP001 			if( !IsInvalidItem( (pAItem = &pList->GetObject(n))->pItem ) &&
//STRIP001 				SFX_ITEM_SET == aOutSet.GetItemState(
//STRIP001 					pAItem->pItem->Which(), FALSE, &pItem ) )
//STRIP001 			{
//STRIP001 				delete pAItem->pItem;
//STRIP001 				pAItem->pItem = pItem->Clone();
//STRIP001 				aOutSet.ClearItem( pAItem->pItem->Which() );
//STRIP001 			}
//STRIP001 
//STRIP001 		if( aOutSet.Count() )
//STRIP001 			pList->Put( aOutSet );
//STRIP001 
//STRIP001 		PaintAttrText_Impl(); // AttributText in GroupBox setzen
//STRIP001 	}
//STRIP001 	delete pDlg;
//STRIP001 	delete[] pWhRanges;
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, NoFormatHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	aLayoutBtn.SetText( aStylesStr );
//STRIP001 	bFormat = FALSE;
//STRIP001 	aLayoutBtn.Check( FALSE );
//STRIP001 
//STRIP001 	if ( bSearch )
//STRIP001 	{
//STRIP001 		if ( !pImpl->bMultiLineEdit )
//STRIP001 			aSearchAttrText.SetText( String() );
//STRIP001 		else
//STRIP001 			pImpl->aSearchFormats.SetText( String() );
//STRIP001 		pSearchList->Clear();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( !pImpl->bMultiLineEdit )
//STRIP001 			aReplaceAttrText.SetText( String() );
//STRIP001 		else
//STRIP001 			pImpl->aReplaceFormats.SetText( String() );
//STRIP001 		pReplaceList->Clear();
//STRIP001 	}
//STRIP001 	pImpl->bSaveToModule = FALSE;
//STRIP001 	TemplateHdl_Impl( &aLayoutBtn );
//STRIP001 	pImpl->bSaveToModule = TRUE;
//STRIP001 	aNoFormatBtn.Disable();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, AttributeHdl_Impl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	if ( !pSearchList || !pImpl->pRanges )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	SvxSearchAttributeDialog* pDlg = new SvxSearchAttributeDialog( this, *pSearchList, pImpl->pRanges );
//STRIP001 	pDlg->Execute();
//STRIP001 	delete pDlg;
//STRIP001 	PaintAttrText_Impl();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxSearchDialog, TimeoutHdl_Impl, Timer *, pTimer )
//STRIP001 {
//STRIP001 	SfxViewShell* pViewShell = SfxViewShell::Current();
//STRIP001 
//STRIP001 	if ( pViewShell )
//STRIP001 	{
//STRIP001 		if ( pViewShell->HasSelection( aSearchLB.IsVisible() ) )
//STRIP001 			EnableControl_Impl( &aSelectionBtn );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aSelectionBtn.Check( FALSE );
//STRIP001 			aSelectionBtn.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	pTimer->Start();
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::GetSearchItems( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	xub_StrLen nLen;
//STRIP001 
//STRIP001 	if ( !pImpl->bMultiLineEdit )
//STRIP001 		nLen = aSearchAttrText.GetText().Len();
//STRIP001 	else
//STRIP001 		nLen = pImpl->aSearchFormats.GetText().Len();
//STRIP001 
//STRIP001 	if ( nLen && pSearchList )
//STRIP001 		pSearchList->Get( rSet );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::GetReplaceItems( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	xub_StrLen nLen;
//STRIP001 
//STRIP001 	if ( !pImpl->bMultiLineEdit )
//STRIP001 		nLen = aReplaceAttrText.GetText().Len();
//STRIP001 	else
//STRIP001 		nLen = pImpl->aReplaceFormats.GetText().Len();
//STRIP001 
//STRIP001 	if ( nLen && pReplaceList )
//STRIP001 		pReplaceList->Get( rSet );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 String& SvxSearchDialog::BuildAttrText_Impl( String& rStr,
//STRIP001 											 BOOL bSrchFlag ) const
//STRIP001 {
//STRIP001 	if ( rStr.Len() )
//STRIP001 		rStr.Erase();
//STRIP001 
//STRIP001 	SfxObjectShell* pSh = SfxObjectShell::Current();
//STRIP001 	DBG_ASSERT( pSh, "no DocShell" );
//STRIP001 
//STRIP001 	if ( !pSh )
//STRIP001 		return rStr;
//STRIP001 
//STRIP001 	SfxItemPool& rPool = pSh->GetPool();
//STRIP001 	SearchAttrItemList* pList = bSrchFlag ? pSearchList : pReplaceList;
//STRIP001 
//STRIP001 	if ( !pList )
//STRIP001 		return rStr;
//STRIP001 
//STRIP001 	// Metrik abfragen
//STRIP001 	SfxMapUnit eMapUnit = SFX_MAPUNIT_CM;
//STRIP001 	FieldUnit eFieldUnit = GetModuleFieldUnit();
//STRIP001 
//STRIP001 	switch ( eFieldUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_MM:			eMapUnit = SFX_MAPUNIT_MM; break;
//STRIP001 		case FUNIT_CM:
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:			eMapUnit = SFX_MAPUNIT_CM; break;
//STRIP001 		case FUNIT_TWIP:		eMapUnit = SFX_MAPUNIT_TWIP; break;
//STRIP001 		case FUNIT_POINT:
//STRIP001 		case FUNIT_PICA:		eMapUnit = SFX_MAPUNIT_POINT; break;
//STRIP001 		case FUNIT_INCH:
//STRIP001 		case FUNIT_FOOT:
//STRIP001 		case FUNIT_MILE:		eMapUnit = SFX_MAPUNIT_INCH; break;
//STRIP001 		case FUNIT_100TH_MM:	eMapUnit = SFX_MAPUNIT_100TH_MM; break;
//STRIP001 	}
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < pList->Count(); ++i )
//STRIP001 	{
//STRIP001 		const SearchAttrItem& rItem = pList->GetObject(i);
//STRIP001 
//STRIP001 		if ( rStr.Len() )
//STRIP001 			rStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( ", " ) );
//STRIP001 
//STRIP001 		if ( !IsInvalidItem( rItem.pItem ) )
//STRIP001 		{
//STRIP001 			String aStr;
//STRIP001 			rPool.GetPresentation( *rItem.pItem,
//STRIP001 									SFX_ITEM_PRESENTATION_COMPLETE,
//STRIP001 									eMapUnit, aStr );
//STRIP001 			rStr += aStr;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			//Sonderbehandlung fuer Zeichenhintergrund
//STRIP001 			USHORT nId = rItem.nSlot == SID_ATTR_BRUSH_CHAR ?
//STRIP001 								RID_SVXITEMS_BRUSH_CHAR :
//STRIP001 									rItem.nSlot - SID_SVX_START + RID_ATTR_BEGIN;
//STRIP001 			rStr += SVX_RESSTR( nId );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return rStr;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::PaintAttrText_Impl()
//STRIP001 {
//STRIP001 	String aDesc;
//STRIP001 	BuildAttrText_Impl( aDesc, bSearch );
//STRIP001 
//STRIP001 	if ( !bFormat && aDesc.Len() )
//STRIP001 		bFormat = TRUE;
//STRIP001 
//STRIP001 	if ( bSearch )
//STRIP001 	{
//STRIP001 		if ( !pImpl->bMultiLineEdit )
//STRIP001 			aSearchAttrText.SetText( aDesc );
//STRIP001 		else
//STRIP001 			pImpl->aSearchFormats.SetText( aDesc );
//STRIP001 		FocusHdl_Impl( &aSearchLB );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if ( !pImpl->bMultiLineEdit )
//STRIP001 			aReplaceAttrText.SetText( aDesc );
//STRIP001 		else
//STRIP001 			pImpl->aReplaceFormats.SetText( aDesc );
//STRIP001 		FocusHdl_Impl( &aReplaceLB );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::SetModifyFlag_Impl( const Control* pCtrl )
//STRIP001 {
//STRIP001 	if ( &aSearchLB == (ComboBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_SEARCH;
//STRIP001 	else if ( &aReplaceLB == (ComboBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_REPLACE;
//STRIP001 	else if ( &aWordBtn == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_WORD;
//STRIP001 	else if ( &aMatchCaseCB == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_EXACT;
//STRIP001 	else if ( &aBackwardsBtn == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_BACKWARDS;
//STRIP001 	else if ( &aSelectionBtn == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_SELECTION;
//STRIP001 	else if ( &aRegExpBtn == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_REGEXP;
//STRIP001 	else if ( &aLayoutBtn == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_LAYOUT;
//STRIP001 	else if ( &aSimilarityBox == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_SIMILARITY;
//STRIP001 	else if ( &aFormulasBtn == (RadioButton*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_FORMULAS;
//STRIP001 	else if ( &aValuesBtn == (RadioButton*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_VALUES;
//STRIP001 	else if ( &aNotesBtn == (RadioButton*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_NOTES;
//STRIP001 	else if ( &aRowsBtn == (RadioButton*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_ROWS;
//STRIP001 	else if ( &aColumnsBtn == (RadioButton*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_COLUMNS;
//STRIP001 	else if ( &aAllTablesCB == (CheckBox*)pCtrl )
//STRIP001 		nModifyFlag |= MODIFY_ALLTABLES;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxSearchDialog::SaveToModule_Impl()
//STRIP001 {
//STRIP001 	if ( !pSearchItem )
//STRIP001 		return;
//STRIP001 
//STRIP001 	if ( aLayoutBtn.IsChecked() )
//STRIP001 	{
//STRIP001 		pSearchItem->SetSearchString ( aSearchTmplLB.GetSelectEntry() );
//STRIP001 		pSearchItem->SetReplaceString( aReplaceTmplLB.GetSelectEntry() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pSearchItem->SetSearchString ( aSearchLB.GetText() );
//STRIP001 		pSearchItem->SetReplaceString( aReplaceLB.GetText() );
//STRIP001 		Remember_Impl( aSearchLB.GetText(), TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 	pSearchItem->SetRegExp( FALSE );
//STRIP001 	pSearchItem->SetLevenshtein( FALSE );
//STRIP001 	if (GetCheckBoxValue( aRegExpBtn ))
//STRIP001 		pSearchItem->SetRegExp( TRUE );
//STRIP001 	else if (GetCheckBoxValue( aSimilarityBox ))
//STRIP001 		pSearchItem->SetLevenshtein( TRUE );
//STRIP001 
//STRIP001 	pSearchItem->SetWordOnly( GetCheckBoxValue( aWordBtn ) );
//STRIP001 	pSearchItem->SetBackward( GetCheckBoxValue( aBackwardsBtn ) );
//STRIP001 	pSearchItem->SetPattern( GetCheckBoxValue( aLayoutBtn ) );
//STRIP001 	pSearchItem->SetSelection( GetCheckBoxValue( aSelectionBtn ) );
//STRIP001 
//STRIP001 	pSearchItem->SetUseAsianOptions( GetCheckBoxValue( aJapOptionsCB ) );
//STRIP001 	INT32 nFlags = GetTransliterationFlags();
//STRIP001 	if( !pSearchItem->IsUseAsianOptions())
//STRIP001 		nFlags &= (TransliterationModules_IGNORE_CASE |
//STRIP001 				   TransliterationModules_IGNORE_WIDTH );
//STRIP001 	pSearchItem->SetTransliterationFlags( nFlags );
//STRIP001 
//STRIP001 	if ( !bWriter )
//STRIP001 	{
//STRIP001 		if ( aFormulasBtn.IsChecked() )
//STRIP001 			pSearchItem->SetCellType( SVX_SEARCHIN_FORMULA );
//STRIP001 		else if ( aValuesBtn.IsChecked() )
//STRIP001 			pSearchItem->SetCellType( SVX_SEARCHIN_VALUE );
//STRIP001 		else if ( aNotesBtn.IsChecked() )
//STRIP001 			pSearchItem->SetCellType( SVX_SEARCHIN_NOTE );
//STRIP001 
//STRIP001 		pSearchItem->SetRowDirection( aRowsBtn.IsChecked() );
//STRIP001 		pSearchItem->SetAllTables( aAllTablesCB.IsChecked() );
//STRIP001 	}
//STRIP001 
//STRIP001 	pSearchItem->SetCommand( SVX_SEARCHCMD_FIND );
//STRIP001 	nModifyFlag = 0;
//STRIP001     const SfxPoolItem* ppArgs[] = { pSearchItem, 0 };
//STRIP001     rBindings.GetDispatcher()->Execute( SID_SEARCH_ITEM, SFX_CALLMODE_SLOT, ppArgs );
//STRIP001 }

// class SvxSearchDialogWrapper ------------------------------------------

/*N*/ SFX_IMPL_CHILDWINDOW(SvxSearchDialogWrapper, SID_SEARCH_DLG)

// -----------------------------------------------------------------------

/*N*/ SvxSearchDialogWrapper::SvxSearchDialogWrapper( Window* pParent, USHORT nId,
/*N*/ 												SfxBindings* pBindings,
/*N*/ 												SfxChildWinInfo* pInfo ) :
/*N*/ 	SfxChildWindow( pParent, nId )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pWindow = new SvxSearchDialog( pParent, this, *pBindings );
//STRIP001 	( (SvxSearchDialog*)pWindow )->Initialize( pInfo );
//STRIP001 
//STRIP001 	pBindings->Update( SID_SEARCH_ITEM );
//STRIP001 	pBindings->Update( SID_SEARCH_OPTIONS );
//STRIP001 	pBindings->Update( SID_SEARCH_SEARCHSET );
//STRIP001 	pBindings->Update( SID_SEARCH_REPLACESET );
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 	( (SvxSearchDialog*)pWindow )->bConstruct = FALSE;
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ SfxChildWinInfo SvxSearchDialogWrapper::GetInfo() const
/*N*/ {
/*?*/ 	SfxChildWinInfo aInfo = SfxChildWindow::GetInfo();
/*?*/ 	aInfo.bVisible = sal_False;
/*?*/ 	return aInfo;
/*N*/ }

}
