/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_rubydialog.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:01:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#ifndef _SVX_RUBYDLG_HXX_
#include <rubydialog.hxx>
#endif
// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif
// auto strip #include <dialmgr.hxx>
#include <dialogs.hrc>
#include <rubydialog.hrc>
// auto strip #ifndef _SFXAPP_HXX
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
// auto strip #include <com/sun/star/frame/XController.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_STYLE_XSTYLE_HPP_
// auto strip #include <com/sun/star/style/XStyle.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_TEXT_XRUBYSELECTION_HPP_
// auto strip #include <com/sun/star/text/XRubySelection.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUES_HPP_
// auto strip #include <com/sun/star/beans/PropertyValues.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
// auto strip #include <com/sun/star/beans/XPropertySet.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
// auto strip #include <com/sun/star/beans/XPropertySetInfo.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
// auto strip #include <com/sun/star/container/XNameContainer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_STYLE_XSTYLEFAMILIESSUPPLIER_HPP_
// auto strip #include <com/sun/star/style/XStyleFamiliesSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_TEXT_RUBYADJUST_HPP_
// auto strip #include <com/sun/star/text/RubyAdjust.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_VIEW_XSELECTIONCHANGELISTENER_HPP_
// auto strip #include <com/sun/star/view/XSelectionChangeListener.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_VIEW_XSELECTIONSUPPLIER_HPP_
// auto strip #include <com/sun/star/view/XSelectionSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _CPPUHELPER_IMPLBASE3_HXX_
// auto strip #include <cppuhelper/implbase1.hxx>
// auto strip #endif

// auto strip #ifndef INCLUDED_SVTOOLS_COLORCFG_HXX
// auto strip #include <svtools/colorcfg.hxx>
// auto strip #endif
namespace binfilter {

//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::frame;
//STRIP001 using namespace ::com::sun::star::text;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 using namespace ::com::sun::star::style;
//STRIP001 using namespace ::com::sun::star::text;
//STRIP001 using namespace ::com::sun::star::view;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::container;
//STRIP001 using namespace rtl;
//STRIP001 
//STRIP001 #define C2U(cChar) ::rtl::OUString::createFromAscii(cChar)

/*N*/ SFX_IMPL_CHILDWINDOW( SvxRubyChildWindow, SID_RUBY_DIALOG );

//STRIP001 static const sal_Char cRubyBaseText[] = "RubyBaseText";
//STRIP001 static const sal_Char cRubyText[] = "RubyText";
//STRIP001 static const sal_Char cCharacterStyles[] = "CharacterStyles";
//STRIP001 static const sal_Char cRubyAdjust[] = "RubyAdjust";
//STRIP001 static const sal_Char cRubyIsAbove[] = "RubyIsAbove";
//STRIP001 static const sal_Char cDisplayName[] = "DisplayName";
//STRIP001 static const sal_Char cRubyCharStyleName[] = "RubyCharStyleName";
//STRIP001 static const sal_Char cRubies[] = "Rubies";
//STRIP001 /* -----------------------------09.01.01 17:24--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
/*?*/ SvxRubyChildWindow::SvxRubyChildWindow( Window* pParent, USHORT nId,
/*?*/ 	SfxBindings* pBindings, SfxChildWinInfo* pInfo) :
/*?*/ 	SfxChildWindow(pParent, nId)
/*?*/ {DBG_BF_ASSERT(0, "STRIP");//STRIP001 
//STRIP001 	pWindow = new SvxRubyDialog( pBindings, this, pParent, SVX_RES( RID_SVXDLG_RUBY ) );
//STRIP001 	SvxRubyDialog* pDlg = (SvxRubyDialog*) pWindow;
//STRIP001 
//STRIP001 	if ( pInfo->nFlags & SFX_CHILDWIN_ZOOMIN )
//STRIP001 		pDlg->RollUp();
//STRIP001 
//STRIP001 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 
//STRIP001     pDlg->Initialize( pInfo );
/*?*/ }
//STRIP001 /* -----------------------------10.01.01 13:53--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
/*?*/ SfxChildWinInfo SvxRubyChildWindow::GetInfo() const
/*?*/ {
/*?*/ 	return SfxChildWindow::GetInfo();
/*?*/ }
//STRIP001 /* -----------------------------09.01.01 17:17--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 class SvxRubyData_Impl : public cppu::WeakImplHelper1
//STRIP001                                 <  ::com::sun::star::view::XSelectionChangeListener >
//STRIP001 {
//STRIP001     Reference<XModel>               xModel;
//STRIP001 	Reference<XRubySelection> 		xSelection;
//STRIP001 	Sequence<PropertyValues>		aRubyValues;
//STRIP001     Reference<XController>          xController;
//STRIP001     sal_Bool                        bHasSelectionChanged;
//STRIP001     public:
//STRIP001         SvxRubyData_Impl();
//STRIP001         ~SvxRubyData_Impl();
//STRIP001 
//STRIP001     void    SetController(Reference<XController> xCtrl);
//STRIP001     Reference<XModel>               GetModel()
//STRIP001                                     {
//STRIP001                                         if(!xController.is())
//STRIP001                                             xModel = 0;
//STRIP001                                         else
//STRIP001                                             xModel = xController->getModel();
//STRIP001                                         return xModel;
//STRIP001                                     }
//STRIP001     sal_Bool                        HasSelectionChanged() const{return bHasSelectionChanged;}
//STRIP001     Reference<XRubySelection>       GetRubySelection()
//STRIP001                                     {
//STRIP001                                         xSelection = Reference<XRubySelection>(xController, UNO_QUERY);
//STRIP001                                         return xSelection;
//STRIP001                                     }
//STRIP001     void                            UpdateRubyValues(sal_Bool bAutoUpdate)
//STRIP001                                     {
//STRIP001                                         if(!xSelection.is())
//STRIP001                                             aRubyValues.realloc(0);
//STRIP001                                         else
//STRIP001                                             aRubyValues = xSelection->getRubyList(bAutoUpdate);
//STRIP001 										bHasSelectionChanged = sal_False;
//STRIP001                                     }
//STRIP001     Sequence<PropertyValues>&       GetRubyValues() {return aRubyValues;}
//STRIP001     void                            AssertOneEntry();
//STRIP001 
//STRIP001     virtual void SAL_CALL selectionChanged( const ::com::sun::star::lang::EventObject& aEvent ) throw (RuntimeException);
//STRIP001     virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& Source ) throw (RuntimeException);
//STRIP001 
//STRIP001 };
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 SvxRubyData_Impl::SvxRubyData_Impl() :
//STRIP001     bHasSelectionChanged(sal_False)
//STRIP001 {
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 SvxRubyData_Impl::~SvxRubyData_Impl()
//STRIP001 {
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void    SvxRubyData_Impl::SetController(Reference<XController> xCtrl)
//STRIP001 {
//STRIP001     if(xCtrl.get() != xController.get())
//STRIP001     {
//STRIP001         try
//STRIP001         {
//STRIP001             Reference<XSelectionSupplier> xSelSupp(xController, UNO_QUERY);
//STRIP001             if(xSelSupp.is())
//STRIP001                 xSelSupp->removeSelectionChangeListener(this);
//STRIP001 
//STRIP001             bHasSelectionChanged = sal_True;
//STRIP001             xController = xCtrl;
//STRIP001             xSelSupp = Reference<XSelectionSupplier>(xController, UNO_QUERY);
//STRIP001             if(xSelSupp.is())
//STRIP001                 xSelSupp->addSelectionChangeListener(this);
//STRIP001         }
//STRIP001         catch(Exception&)
//STRIP001         {}
//STRIP001     }
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxRubyData_Impl::selectionChanged( const EventObject& aEvent ) throw (RuntimeException)
//STRIP001 {
//STRIP001     bHasSelectionChanged = sal_True;
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxRubyData_Impl::disposing( const EventObject&) throw (RuntimeException)
//STRIP001 {
//STRIP001     try
//STRIP001     {
//STRIP001         Reference<XSelectionSupplier> xSelSupp(xController, UNO_QUERY);
//STRIP001         if(xSelSupp.is())
//STRIP001             xSelSupp->removeSelectionChangeListener(this);
//STRIP001     }
//STRIP001     catch(Exception&)
//STRIP001     {}
//STRIP001     xController = 0;
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void  SvxRubyData_Impl::AssertOneEntry()
//STRIP001 {
//STRIP001     //create one entry
//STRIP001     if(!aRubyValues.getLength())
//STRIP001     {
//STRIP001         aRubyValues.realloc(1);
//STRIP001         Sequence<PropertyValue>& rValues = aRubyValues.getArray()[0];
//STRIP001         rValues.realloc(5);
//STRIP001         PropertyValue* pValues = rValues.getArray();
//STRIP001         pValues[0].Name = C2U(cRubyBaseText);
//STRIP001         pValues[1].Name = C2U(cRubyText);
//STRIP001         pValues[2].Name = C2U(cRubyAdjust);
//STRIP001         pValues[3].Name = C2U(cRubyIsAbove);
//STRIP001         pValues[4].Name = C2U(cRubyCharStyleName);
//STRIP001     }
//STRIP001 }
//STRIP001 /* ---------------------------------------------------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxRubyDialog::SvxRubyDialog( SfxBindings *pBind, SfxChildWindow *pCW,
//STRIP001 									Window* pParent, const ResId& rResId ) :
//STRIP001 	SfxModelessDialog( pBind, pCW, pParent, rResId ),
//STRIP001     aLeftFT(this,               ResId(FT_LEFT )),
//STRIP001     aRightFT(this,              ResId(FT_RIGHT  )),
//STRIP001     aLeft1ED(this,              ResId(ED_LEFT_1  )),
//STRIP001 	aRight1ED(this, 			ResId(ED_RIGHT_1 )),
//STRIP001 	aLeft2ED(this, 				ResId(ED_LEFT_2  )),
//STRIP001 	aRight2ED(this, 			ResId(ED_RIGHT_2 )),
//STRIP001 	aLeft3ED(this, 				ResId(ED_LEFT_3  )),
//STRIP001 	aRight3ED(this, 			ResId(ED_RIGHT_3 )),
//STRIP001 	aLeft4ED(this, 				ResId(ED_LEFT_4  )),
//STRIP001 	aRight4ED(this, 			ResId(ED_RIGHT_4 )),
//STRIP001 	aScrollSB(this, 			ResId(SB_SCROLL  )),
//STRIP001 	aAutoDetectionCB(this, 		ResId(CB_AUTO_DETECT	)),
//STRIP001 	aAdjustFT(this, 			ResId(FT_ADJUST		)),
//STRIP001 	aAdjustLB(this, 			ResId(LB_ADJUST		)),
//STRIP001     aPositionFT(this,           ResId(FT_POSITION     )),
//STRIP001     aPositionLB(this,           ResId(LB_POSITION     )),
//STRIP001     aCharStyleFT(this,          ResId(FT_CHAR_STYLE     )),
//STRIP001 	aCharStyleLB(this, 			ResId(LB_CHAR_STYLE		)),
//STRIP001 	aStylistPB(this, 			ResId(PB_STYLIST		)),
//STRIP001 	aPreviewFT(this, 			ResId(FT_PREVIEW		)),
//STRIP001 	aPreviewWin(*this, 			ResId(WIN_PREVIEW		)),
//STRIP001 	aApplyPB(this, 				ResId(PB_APPLY			)),
//STRIP001 	aClosePB(this, 				ResId(PB_CLOSE			)),
//STRIP001 	aHelpPB(this, 				ResId(PB_HELP			)),
//STRIP001 	pBindings(pBind),
//STRIP001 	nLastPos(0),
//STRIP001     nCurrentEdit(0)
//STRIP001 {
//STRIP001     xImpl = pImpl = new SvxRubyData_Impl;
//STRIP001     FreeResource();
//STRIP001     //#85638# automatic detection not yet available
//STRIP001     aAutoDetectionCB.Hide();
//STRIP001 	aEditArr[0] = &aLeft1ED; aEditArr[1] = &aRight1ED;
//STRIP001 	aEditArr[2] = &aLeft2ED; aEditArr[3] = &aRight2ED;
//STRIP001 	aEditArr[4] = &aLeft3ED; aEditArr[5] = &aRight3ED;
//STRIP001 	aEditArr[6] = &aLeft4ED; aEditArr[7] = &aRight4ED;
//STRIP001 
//STRIP001 	aApplyPB.SetClickHdl(LINK(this, SvxRubyDialog, ApplyHdl_Impl));
//STRIP001 	aClosePB.SetClickHdl(LINK(this, SvxRubyDialog, CloseHdl_Impl));
//STRIP001 	aStylistPB.SetClickHdl(LINK(this, SvxRubyDialog, StylistHdl_Impl));
//STRIP001 	aAutoDetectionCB.SetClickHdl(LINK(this, SvxRubyDialog, AutomaticHdl_Impl));
//STRIP001 	aAdjustLB.SetSelectHdl(LINK(this, SvxRubyDialog, AdjustHdl_Impl));
//STRIP001     aPositionLB.SetSelectHdl(LINK(this, SvxRubyDialog, PositionHdl_Impl));
//STRIP001     aCharStyleLB.SetSelectHdl(LINK(this, SvxRubyDialog, CharStyleHdl_Impl));
//STRIP001 
//STRIP001 	Link aScrLk(LINK(this, SvxRubyDialog, ScrollHdl_Impl));
//STRIP001 	aScrollSB.SetScrollHdl( aScrLk );
//STRIP001 	aScrollSB.SetEndScrollHdl( aScrLk );
//STRIP001 
//STRIP001 	Link aEditLk(LINK(this, SvxRubyDialog, EditModifyHdl_Impl));
//STRIP001     Link aScrollLk(LINK(this, SvxRubyDialog, EditScrollHdl_Impl));
//STRIP001     Link aJumpLk(LINK(this, SvxRubyDialog, EditJumpHdl_Impl));
//STRIP001 	for(USHORT i = 0; i < 8; i++)
//STRIP001     {
//STRIP001 		aEditArr[i]->SetModifyHdl(aEditLk);
//STRIP001         aEditArr[i]->SetJumpHdl(aJumpLk);
//STRIP001         if(!i || 7 == i)
//STRIP001             aEditArr[i]->SetScrollHdl(aScrollLk);
//STRIP001     }
//STRIP001 
//STRIP001 	UpdateColors();
//STRIP001 }
//STRIP001 /* -----------------------------09.01.01 17:17--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SvxRubyDialog::~SvxRubyDialog()
//STRIP001 {
//STRIP001 	ClearCharStyleList();
//STRIP001     EventObject aEvent;
//STRIP001     xImpl->disposing(aEvent);
//STRIP001 }
//STRIP001 /* -----------------------------01.02.01 10:29--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxRubyDialog::ClearCharStyleList()
//STRIP001 {
//STRIP001     for(USHORT i = 0; i < aCharStyleLB.GetEntryCount(); i++)
//STRIP001 	{
//STRIP001 		void* pData = aCharStyleLB.GetEntryData(i);
//STRIP001 		delete (OUString*)pData;
//STRIP001     }
//STRIP001     aCharStyleLB.Clear();
//STRIP001 }
//STRIP001 /* -----------------------------09.01.01 17:17--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 BOOL 	SvxRubyDialog::Close()
//STRIP001 {
//STRIP001 	pBindings->GetDispatcher()->Execute( SID_RUBY_DIALOG,
//STRIP001 		                      SFX_CALLMODE_ASYNCHRON |
//STRIP001 							  SFX_CALLMODE_RECORD);
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 /* -----------------------------29.01.01 15:26--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxRubyDialog::Activate()
//STRIP001 {
//STRIP001 	SfxModelessDialog::Activate();
//STRIP001 	SfxPoolItem* pState = 0;
//STRIP001 	SfxItemState	eState = pBindings->QueryState( SID_STYLE_DESIGNER, pState );
//STRIP001     sal_Bool bEnable = (eState < SFX_ITEM_AVAILABLE) || !pState || !((SfxBoolItem*)pState)->GetValue();
//STRIP001     aStylistPB.Enable(bEnable);
//STRIP001 	//get selection from current view frame
//STRIP001 	SfxViewFrame* pCurFrm = SfxViewFrame::Current();
//STRIP001     Reference< XController > xCtrl = pCurFrm->GetFrame()->GetController();
//STRIP001     pImpl->SetController(xCtrl);
//STRIP001     if(pImpl->HasSelectionChanged())
//STRIP001     {
//STRIP001 
//STRIP001         Reference< XRubySelection > xRubySel = pImpl->GetRubySelection();
//STRIP001         pImpl->UpdateRubyValues(aAutoDetectionCB.IsChecked());
//STRIP001         EnableControls(xRubySel.is());
//STRIP001         if(xRubySel.is())
//STRIP001         {
//STRIP001             Reference< XModel > xModel = pImpl->GetModel();
//STRIP001             const String sCharStyleSelect = aCharStyleLB.GetSelectEntry();
//STRIP001             ClearCharStyleList();
//STRIP001             Reference<XStyleFamiliesSupplier> xSupplier(xModel, UNO_QUERY);
//STRIP001             if(xSupplier.is())
//STRIP001             {
//STRIP001                 try
//STRIP001                 {
//STRIP001                     Reference<XNameAccess> xFam = xSupplier->getStyleFamilies();
//STRIP001                     Any aChar = xFam->getByName(C2U(cCharacterStyles));
//STRIP001                     Reference<XNameContainer> xChar;
//STRIP001                     aChar >>= xChar;
//STRIP001                     Reference<XIndexAccess> xCharIdx(xChar, UNO_QUERY);
//STRIP001                     if(xCharIdx.is())
//STRIP001                     {
//STRIP001                         OUString sUIName(C2U(cDisplayName));
//STRIP001                         for(sal_Int32 nStyle = 0; nStyle < xCharIdx->getCount(); nStyle++)
//STRIP001                         {
//STRIP001                             Any aStyle = xCharIdx->getByIndex(nStyle);
//STRIP001                             Reference<XStyle> xStyle;
//STRIP001                             aStyle >>= xStyle;
//STRIP001                             Reference<XPropertySet> xPrSet(xStyle, UNO_QUERY);
//STRIP001                             OUString sName, sCoreName;
//STRIP001                             if(xPrSet.is())
//STRIP001                             {
//STRIP001                                 Reference<XPropertySetInfo> xInfo = xPrSet->getPropertySetInfo();
//STRIP001                                 if(xInfo->hasPropertyByName(sUIName))
//STRIP001                                 {
//STRIP001                                     Any aName = xPrSet->getPropertyValue(sUIName);
//STRIP001                                     aName >>= sName;
//STRIP001                                 }
//STRIP001                             }
//STRIP001                             Reference<XNamed> xNamed(xStyle, UNO_QUERY);
//STRIP001                             if(xNamed.is())
//STRIP001                             {
//STRIP001                                 sCoreName = xNamed->getName();
//STRIP001                                 if(!sName.getLength())
//STRIP001                                     sName = sCoreName;
//STRIP001                             }
//STRIP001                             if(sName.getLength())
//STRIP001                             {
//STRIP001                                 USHORT nPos = aCharStyleLB.InsertEntry(sName);
//STRIP001                                 aCharStyleLB.SetEntryData( nPos, new OUString(sCoreName) );
//STRIP001 
//STRIP001                             }
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001                 catch(Exception&)
//STRIP001                 {
//STRIP001                     DBG_ERROR("exception in style access")
//STRIP001                 }
//STRIP001                 if(sCharStyleSelect.Len())
//STRIP001                     aCharStyleLB.SelectEntry(sCharStyleSelect);
//STRIP001             }
//STRIP001             aCharStyleLB.Enable(xSupplier.is());
//STRIP001             aCharStyleFT.Enable(xSupplier.is());
//STRIP001         }
//STRIP001 		Update();
//STRIP001 		aPreviewWin.Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------29.01.01 15:26--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void	SvxRubyDialog::Deactivate()
//STRIP001 {
//STRIP001 	SfxModelessDialog::Deactivate();
//STRIP001 }
//STRIP001 /* -----------------------------30.01.01 15:35--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxRubyDialog::SetText(sal_Int32 nPos, Edit& rLeft, Edit& rRight)
//STRIP001 {
//STRIP001 	OUString sLeft, sRight;
//STRIP001     const Sequence<PropertyValues>&  aRubyValues = pImpl->GetRubyValues();
//STRIP001     BOOL bEnable = aRubyValues.getLength() > nPos;
//STRIP001 	if(bEnable)
//STRIP001 	{
//STRIP001         const Sequence<PropertyValue> aProps = aRubyValues.getConstArray()[nPos];
//STRIP001 		const PropertyValue* pProps = aProps.getConstArray();
//STRIP001 		for(sal_Int32 nProp = 0; nProp < aProps.getLength(); nProp++)
//STRIP001 		{
//STRIP001 			if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyBaseText)))
//STRIP001 				pProps[nProp].Value >>= sLeft;
//STRIP001 			else if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyText)))
//STRIP001 				pProps[nProp].Value >>= sRight;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if(!nPos)
//STRIP001         bEnable = TRUE;
//STRIP001 	rLeft.Enable(bEnable);
//STRIP001 	rRight.Enable(bEnable);
//STRIP001 	rLeft.SetText(sLeft);
//STRIP001 	rRight.SetText(sRight);
//STRIP001 	rLeft.SaveValue();
//STRIP001 	rRight.SaveValue();
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxRubyDialog::GetText()
//STRIP001 {
//STRIP001 	long nLastPos = GetLastPos();
//STRIP001 	for(int i = 0; i < 8; i+=2)
//STRIP001 	{
//STRIP001         if(aEditArr[i]->IsEnabled() &&
//STRIP001 			(aEditArr[i]->GetText() != aEditArr[i]->GetSavedValue() ||
//STRIP001 			aEditArr[i + 1]->GetText() != aEditArr[i + 1]->GetSavedValue()))
//STRIP001 		{
//STRIP001             Sequence<PropertyValues>& aRubyValues = pImpl->GetRubyValues();
//STRIP001             DBG_ASSERT(aRubyValues.getLength() > (i / 2 + nLastPos), "wrong index" )
//STRIP001 			SetModified(TRUE);
//STRIP001             Sequence<PropertyValue> &rProps = aRubyValues.getArray()[i / 2 + nLastPos];
//STRIP001 			PropertyValue* pProps = rProps.getArray();
//STRIP001 			for(sal_Int32 nProp = 0; nProp < rProps.getLength(); nProp++)
//STRIP001 			{
//STRIP001 				if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyBaseText)))
//STRIP001 					pProps[nProp].Value <<= OUString(aEditArr[i]->GetText());
//STRIP001 				else if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyText)))
//STRIP001 					pProps[nProp].Value <<= OUString(aEditArr[i + 1]->GetText());
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SvxRubyDialog::Update()
//STRIP001 {
//STRIP001     const Sequence<PropertyValues>& aRubyValues = pImpl->GetRubyValues();
//STRIP001     sal_Int32 nLen = aRubyValues.getLength();
//STRIP001 	aScrollSB.Enable(nLen > 4);
//STRIP001 	aScrollSB.SetRange( Range(0, nLen > 4 ? nLen - 4 : 0));
//STRIP001 	aScrollSB.SetThumbPos(0);
//STRIP001 	SetLastPos(0);
//STRIP001 	SetModified(FALSE);
//STRIP001 
//STRIP001 	sal_Int16 nAdjust = -1;
//STRIP001     sal_Int16 nPosition = -1;
//STRIP001 	OUString sCharStyleName, sTmp;
//STRIP001 	sal_Bool bCharStyleEqual = sal_True;
//STRIP001 	for(sal_Int32 nRuby = 0; nRuby < nLen; nRuby++)
//STRIP001 	{
//STRIP001         const Sequence<PropertyValue> &rProps = aRubyValues.getConstArray()[nRuby];
//STRIP001         const PropertyValue* pProps = rProps.getConstArray();
//STRIP001 		for(sal_Int32 nProp = 0; nProp < rProps.getLength(); nProp++)
//STRIP001 		{
//STRIP001 			sal_Int16 nTmp;
//STRIP001 			if(nAdjust > -2 &&
//STRIP001 				pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyAdjust)))
//STRIP001 			{
//STRIP001 				pProps[nProp].Value >>= nTmp;
//STRIP001 				if(!nRuby)
//STRIP001 					nAdjust = nTmp;
//STRIP001 				else if(nAdjust != nTmp)
//STRIP001 					nAdjust = -2;
//STRIP001 			}
//STRIP001             if(nPosition > -2 &&
//STRIP001                 pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyIsAbove)))
//STRIP001             {
//STRIP001                 sal_Bool bTmp = *(sal_Bool*)pProps[nProp].Value.getValue();
//STRIP001                 if(!nRuby)
//STRIP001                     nPosition = bTmp ? 0 : 1;
//STRIP001                 else  if(!nPosition && !bTmp || nPosition == 1 && bTmp  )
//STRIP001                     nPosition = -2;
//STRIP001             }
//STRIP001 			if(bCharStyleEqual &&
//STRIP001 				pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyCharStyleName)))
//STRIP001 			{
//STRIP001 				pProps[nProp].Value >>= sTmp;
//STRIP001 				if(!nRuby)
//STRIP001 					sCharStyleName = sTmp;
//STRIP001 				else if(sCharStyleName != sTmp)
//STRIP001 					bCharStyleEqual = sal_False;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001     if(!nLen)
//STRIP001     {
//STRIP001         //enable selection if the ruby list is empty
//STRIP001         nAdjust = 0;
//STRIP001         nPosition = 0;
//STRIP001     }
//STRIP001     if(nAdjust > -1)
//STRIP001 		aAdjustLB.SelectEntryPos(nAdjust);
//STRIP001 	else
//STRIP001 		aAdjustLB.SetNoSelection();
//STRIP001     if(nPosition > -1)
//STRIP001         aPositionLB.SelectEntryPos(nPosition ? 1 : 0);
//STRIP001     if(!nLen || bCharStyleEqual && !sCharStyleName.getLength())
//STRIP001         sCharStyleName = C2U(cRubies);
//STRIP001     if(sCharStyleName.getLength())
//STRIP001     {
//STRIP001         for(USHORT i = 0; i < aCharStyleLB.GetEntryCount(); i++)
//STRIP001         {
//STRIP001             const OUString* pCoreName = (const OUString*)aCharStyleLB.GetEntryData(i);
//STRIP001             if(pCoreName && sCharStyleName == *pCoreName)
//STRIP001             {
//STRIP001                 aCharStyleLB.SelectEntryPos(i);
//STRIP001                 break;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001 		aCharStyleLB.SetNoSelection();
//STRIP001 
//STRIP001 	ScrollHdl_Impl(&aScrollSB);
//STRIP001 }
//STRIP001 /* -----------------------------16.02.01 14:01--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void	SvxRubyDialog::GetCurrentText(String& rBase, String& rRuby)
//STRIP001 {
//STRIP001 	rBase = aEditArr[nCurrentEdit * 2]->GetText();
//STRIP001 	rRuby = aEditArr[nCurrentEdit * 2 + 1]->GetText();
//STRIP001 }
//STRIP001 /* -----------------------------31.01.01 14:09--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, ScrollHdl_Impl, ScrollBar*, pScroll)
//STRIP001 {
//STRIP001 	long nPos = pScroll->GetThumbPos();
//STRIP001 	long nLastPos = GetLastPos();
//STRIP001 	if(nLastPos != nPos)
//STRIP001 	{
//STRIP001 		GetText();
//STRIP001 	}
//STRIP001 	SetText(nPos++, aLeft1ED, aRight1ED);
//STRIP001 	SetText(nPos++, aLeft2ED, aRight2ED);
//STRIP001 	SetText(nPos++, aLeft3ED, aRight3ED);
//STRIP001 	SetText(nPos, aLeft4ED, aRight4ED);
//STRIP001 	SetLastPos(nPos - 3);
//STRIP001 	aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------30.01.01 14:48--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, ApplyHdl_Impl, PushButton*, EMPTYARG)
//STRIP001 {
//STRIP001     const Sequence<PropertyValues>&  aRubyValues = pImpl->GetRubyValues();
//STRIP001     if(!aRubyValues.getLength())
//STRIP001     {
//STRIP001         AssertOneEntry();
//STRIP001         PositionHdl_Impl(&aPositionLB);
//STRIP001         AdjustHdl_Impl(&aAdjustLB);
//STRIP001         CharStyleHdl_Impl(&aCharStyleLB);
//STRIP001     }
//STRIP001     GetText();
//STRIP001 	//reset all edit fields - SaveValue is called
//STRIP001 	ScrollHdl_Impl(&aScrollSB); 
//STRIP001 
//STRIP001     Reference<XRubySelection>  xSelection = pImpl->GetRubySelection();
//STRIP001     if(IsModified() && xSelection.is())
//STRIP001     {
//STRIP001         try
//STRIP001         {
//STRIP001             xSelection->setRubyList(aRubyValues, aAutoDetectionCB.IsChecked());
//STRIP001         }
//STRIP001         catch(Exception& )
//STRIP001         {
//STRIP001             DBG_ERROR("Exception caught")
//STRIP001         }
//STRIP001     }
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------29.01.01 09:38--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, CloseHdl_Impl, PushButton*, EMPTYARG)
//STRIP001 {
//STRIP001 	Close();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------29.01.01 15:10--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, StylistHdl_Impl, PushButton*, EMPTYARG)
//STRIP001 {
//STRIP001 	SfxPoolItem* pState = 0;
//STRIP001 	SfxItemState	eState = pBindings->QueryState( SID_STYLE_DESIGNER, pState );
//STRIP001 	if(eState <= SFX_ITEM_SET || !pState || !((SfxBoolItem*)pState)->GetValue())
//STRIP001 	{
//STRIP001 		pBindings->GetDispatcher()->Execute( SID_STYLE_DESIGNER,
//STRIP001 		                      SFX_CALLMODE_ASYNCHRON |
//STRIP001 							  SFX_CALLMODE_RECORD);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------30.01.01 15:32--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, AutomaticHdl_Impl, CheckBox*, pBox)
//STRIP001 {
//STRIP001     pImpl->UpdateRubyValues(pBox->IsChecked());
//STRIP001     Update();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------31.01.01 16:37--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, AdjustHdl_Impl, ListBox*, pBox)
//STRIP001 {
//STRIP001     AssertOneEntry();
//STRIP001     sal_Int16 nAdjust = pBox->GetSelectEntryPos();
//STRIP001     Sequence<PropertyValues>&  aRubyValues = pImpl->GetRubyValues();
//STRIP001     for(sal_Int32 nRuby = 0; nRuby < aRubyValues.getLength(); nRuby++)
//STRIP001 	{
//STRIP001         Sequence<PropertyValue> &rProps = aRubyValues.getArray()[nRuby];
//STRIP001 		PropertyValue* pProps = rProps.getArray();
//STRIP001 		for(sal_Int32 nProp = 0; nProp < rProps.getLength(); nProp++)
//STRIP001 		{
//STRIP001 			if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyAdjust)))
//STRIP001 				pProps[nProp].Value <<= nAdjust;
//STRIP001 		}
//STRIP001 		SetModified(TRUE);
//STRIP001 	}
//STRIP001 	aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------01.06.01 10:24--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, PositionHdl_Impl, ListBox*, pBox)
//STRIP001 {
//STRIP001     AssertOneEntry();
//STRIP001     sal_Bool bAbove = !pBox->GetSelectEntryPos();
//STRIP001     const Type& rType = ::getBooleanCppuType();
//STRIP001     Sequence<PropertyValues>&  aRubyValues = pImpl->GetRubyValues();
//STRIP001     for(sal_Int32 nRuby = 0; nRuby < aRubyValues.getLength(); nRuby++)
//STRIP001 	{
//STRIP001         Sequence<PropertyValue> &rProps = aRubyValues.getArray()[nRuby];
//STRIP001 		PropertyValue* pProps = rProps.getArray();
//STRIP001 		for(sal_Int32 nProp = 0; nProp < rProps.getLength(); nProp++)
//STRIP001 		{
//STRIP001             if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyIsAbove)))
//STRIP001                 pProps[nProp].Value.setValue(&bAbove, rType);
//STRIP001 		}
//STRIP001 		SetModified(TRUE);
//STRIP001 	}
//STRIP001 	aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------01.02.01 10:06--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, CharStyleHdl_Impl, ListBox*, pBox)
//STRIP001 {
//STRIP001     AssertOneEntry();
//STRIP001     OUString sStyleName;
//STRIP001 	if(LISTBOX_ENTRY_NOTFOUND != aCharStyleLB.GetSelectEntryPos())
//STRIP001 		sStyleName = *(OUString*) aCharStyleLB.GetEntryData(aCharStyleLB.GetSelectEntryPos());
//STRIP001     Sequence<PropertyValues>&  aRubyValues = pImpl->GetRubyValues();
//STRIP001     for(sal_Int32 nRuby = 0; nRuby < aRubyValues.getLength(); nRuby++)
//STRIP001 	{
//STRIP001         Sequence<PropertyValue> &rProps = aRubyValues.getArray()[nRuby];
//STRIP001 		PropertyValue* pProps = rProps.getArray();
//STRIP001 		for(sal_Int32 nProp = 0; nProp < rProps.getLength(); nProp++)
//STRIP001 		{
//STRIP001 			if(pProps[nProp].Name.equalsAsciiL(RTL_CONSTASCII_STRINGPARAM(cRubyCharStyleName)))
//STRIP001 			{
//STRIP001 				pProps[nProp].Value <<= sStyleName;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		SetModified(TRUE);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------16.02.01 08:35--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, EditModifyHdl_Impl, Edit*, pEdit)
//STRIP001 {
//STRIP001 	for(USHORT i = 0; i < 8; i++)
//STRIP001 	{
//STRIP001 		if(pEdit == aEditArr[i])
//STRIP001 		{
//STRIP001 			nCurrentEdit = i / 2;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aPreviewWin.Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------------------17.07.01 09:11--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, EditScrollHdl_Impl, sal_Int32*, pParam)
//STRIP001 {
//STRIP001     long nRet = 0;
//STRIP001     if(aScrollSB.IsEnabled())
//STRIP001     {
//STRIP001         //scroll forward
//STRIP001         if(*pParam > 0 && (aEditArr[7]->HasFocus() || aEditArr[6]->HasFocus() ))
//STRIP001         {
//STRIP001             if(aScrollSB.GetRangeMax() > aScrollSB.GetThumbPos())
//STRIP001             {
//STRIP001                 aScrollSB.SetThumbPos(aScrollSB.GetThumbPos() + 1);
//STRIP001                 aEditArr[6]->GrabFocus();
//STRIP001                 nRet = 1;
//STRIP001             }
//STRIP001         }
//STRIP001         //scroll backward
//STRIP001         else if(aScrollSB.GetThumbPos() && (aEditArr[0]->HasFocus()||aEditArr[1]->HasFocus()) )
//STRIP001         {
//STRIP001             aScrollSB.SetThumbPos(aScrollSB.GetThumbPos() - 1);
//STRIP001             aEditArr[1]->GrabFocus();
//STRIP001             nRet = 1;
//STRIP001         }
//STRIP001         if(nRet)
//STRIP001             ScrollHdl_Impl(&aScrollSB);
//STRIP001     }
//STRIP001     return nRet;
//STRIP001 }
//STRIP001 /* -----------------------------20.07.2001 15:18------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SvxRubyDialog, EditJumpHdl_Impl, sal_Int32*, pParam)
//STRIP001 {
//STRIP001     USHORT nIndex = USHRT_MAX;
//STRIP001     for(USHORT i = 0; i < 8; i++)
//STRIP001     {
//STRIP001         if(aEditArr[i]->HasFocus())
//STRIP001             nIndex = i;
//STRIP001     }
//STRIP001     if(nIndex < 8)
//STRIP001     {
//STRIP001         if(*pParam > 0)
//STRIP001         {
//STRIP001             if(nIndex < 6)
//STRIP001                 aEditArr[nIndex + 2]->GrabFocus();
//STRIP001             else if( EditScrollHdl_Impl(pParam))
//STRIP001                 aEditArr[nIndex]->GrabFocus();
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             if(nIndex > 1)
//STRIP001                 aEditArr[nIndex - 2]->GrabFocus();
//STRIP001             else if( EditScrollHdl_Impl(pParam))
//STRIP001                 aEditArr[nIndex]->GrabFocus();
//STRIP001         }
//STRIP001     }
//STRIP001     return 0;
//STRIP001 };
//STRIP001 /* -----------------------------19.06.01 11:33--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SvxRubyDialog::AssertOneEntry()
//STRIP001 {
//STRIP001     pImpl->AssertOneEntry();
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRubyDialog::UpdateColors( void )
//STRIP001 {
//STRIP001 	const StyleSettings&	rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001 	svtools::ColorConfig		aColorConfig;
//STRIP001 
//STRIP001 	Font					aFnt( aPreviewWin.GetFont() );
//STRIP001 
//STRIP001 	Color					aNewTextCol( aColorConfig.GetColorValue( svtools::FONTCOLOR ).nColor );
//STRIP001 	Color					aNewFillCol( rStyleSettings.GetWindowColor() );
//STRIP001 
//STRIP001 	if( aNewFillCol != aFnt.GetFillColor() || aNewTextCol != aFnt.GetColor() )
//STRIP001 	{
//STRIP001 		aFnt.SetFillColor( aNewFillCol );
//STRIP001 		aFnt.SetColor( aNewTextCol );
//STRIP001 		aPreviewWin.SetFont( aFnt );
//STRIP001 
//STRIP001 		aPreviewWin.Invalidate();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxRubyDialog::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	SfxModelessDialog::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001 		UpdateColors();
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------------------29.01.01 15:44--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void lcl_MoveBox(long nOffset, Edit& rLeft, Edit& rRight)
//STRIP001 {
//STRIP001 	Size aLeftSz(rLeft.GetSizePixel());
//STRIP001 	Point aRightPos(rRight.GetPosPixel());
//STRIP001 	Size aRightSz(rRight.GetSizePixel());
//STRIP001 	aLeftSz.Width() += nOffset;
//STRIP001 	aRightSz.Width() -= nOffset;
//STRIP001 	aRightPos.X() += nOffset;
//STRIP001 	rLeft.SetSizePixel(aLeftSz);
//STRIP001 	rRight.SetPosSizePixel(aRightPos, aRightSz);
//STRIP001 
//STRIP001 }
//STRIP001 /* -----------------------------16.02.01 08:09--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 RubyPreview::RubyPreview(SvxRubyDialog& rParent, const ResId& rResId) :
//STRIP001 		Window(&rParent, rResId),
//STRIP001 		rParentDlg(rParent)
//STRIP001 {
//STRIP001 	SetMapMode(MAP_TWIP);
//STRIP001 	Size aWinSize = GetOutputSize();
//STRIP001 
//STRIP001 	Font aFont = GetFont();
//STRIP001 	aFont.SetHeight(aWinSize.Height() / 4);
//STRIP001 	SetFont(aFont);
//STRIP001 
//STRIP001 	SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001 }
//STRIP001 /* -----------------------------29.01.01 14:05--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void RubyPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001     Font aRubyFont = GetFont();
//STRIP001     Font aSaveFont(aRubyFont);
//STRIP001     aRubyFont.SetHeight(aRubyFont.GetHeight() * 70 / 100);
//STRIP001 
//STRIP001     Size aWinSize = GetOutputSize();
//STRIP001 	Rectangle aRect(Point(0, 0), aWinSize);
//STRIP001 	SetLineColor();
//STRIP001 	SetFillColor( aSaveFont.GetFillColor() );
//STRIP001 	DrawRect(aRect);
//STRIP001 
//STRIP001 	String sBaseText, sRubyText;
//STRIP001 	rParentDlg.GetCurrentText(sBaseText, sRubyText);
//STRIP001 
//STRIP001 	long nTextHeight = GetTextHeight();
//STRIP001 	long nBaseWidth = GetTextWidth(sBaseText);
//STRIP001     SetFont(aRubyFont);
//STRIP001     long nRubyWidth = GetTextWidth(sRubyText);
//STRIP001     SetFont(aSaveFont);
//STRIP001 
//STRIP001 	USHORT nAdjust = rParentDlg.aAdjustLB.GetSelectEntryPos();
//STRIP001 	//use center if no adjustment is available
//STRIP001 	if(nAdjust > 4)
//STRIP001 		nAdjust = 1;
//STRIP001 
//STRIP001     //which part is stretched ?
//STRIP001 	sal_Bool bRubyStretch = nBaseWidth >= nRubyWidth;
//STRIP001 
//STRIP001 	long nCenter = aWinSize.Width() / 2;
//STRIP001 	long nLeftStart = nCenter - (bRubyStretch ? (nBaseWidth / 2) : (nRubyWidth / 2));
//STRIP001 	long nRightEnd = nCenter + (bRubyStretch ? (nBaseWidth / 2) : (nRubyWidth / 2));
//STRIP001 
//STRIP001 	long nYRuby = aWinSize.Height() / 4 - nTextHeight / 2;
//STRIP001 	long nYBase = aWinSize.Height() * 3 / 4 - nTextHeight / 2;
//STRIP001 
//STRIP001     //use above also if no selection is set
//STRIP001     BOOL bAbove = rParentDlg.aPositionLB.GetSelectEntryPos() != 1;
//STRIP001     if(!bAbove)
//STRIP001     {
//STRIP001         long nTmp = nYRuby;
//STRIP001         nYRuby = nYBase;
//STRIP001         nYBase = nTmp;
//STRIP001     }
//STRIP001 	long nYOutput, nOutTextWidth;
//STRIP001 	String sOutputText;
//STRIP001 
//STRIP001 
//STRIP001     if(bRubyStretch)
//STRIP001 	{
//STRIP001 		DrawText( Point( nLeftStart , nYBase),  sBaseText );
//STRIP001 		nYOutput = nYRuby;
//STRIP001 		sOutputText = sRubyText;
//STRIP001 		nOutTextWidth = nRubyWidth;
//STRIP001         SetFont(aRubyFont);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         SetFont(aRubyFont);
//STRIP001         DrawText( Point( nLeftStart , nYRuby),  sRubyText );
//STRIP001 		nYOutput = nYBase;
//STRIP001 		sOutputText = sBaseText;
//STRIP001 		nOutTextWidth = nBaseWidth;
//STRIP001         SetFont(aSaveFont);
//STRIP001     }
//STRIP001 
//STRIP001 	switch(nAdjust)
//STRIP001 	{
//STRIP001 		case RubyAdjust_LEFT:
//STRIP001 			DrawText( Point( nLeftStart , nYOutput),  sOutputText );
//STRIP001 		break;
//STRIP001 		case RubyAdjust_RIGHT:
//STRIP001 			DrawText( Point( nRightEnd - nOutTextWidth, nYOutput),  sOutputText );
//STRIP001 		break;
//STRIP001 		case RubyAdjust_INDENT_BLOCK:
//STRIP001 		{
//STRIP001 			long nCharWidth = GetTextWidth(String::CreateFromAscii("X"));
//STRIP001 			if(nOutTextWidth < (nRightEnd - nLeftStart - nCharWidth))
//STRIP001 			{
//STRIP001 				nCharWidth /= 2;
//STRIP001 				nLeftStart += nCharWidth;
//STRIP001 				nRightEnd -= nCharWidth;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		// no break!
//STRIP001 		case RubyAdjust_BLOCK:
//STRIP001 		if(sOutputText.Len() > 1)
//STRIP001 		{
//STRIP001 			xub_StrLen nCount = sOutputText.Len();
//STRIP001 			long nSpace = ((nRightEnd - nLeftStart) - GetTextWidth(sOutputText)) / (nCount - 1);
//STRIP001 			for(xub_StrLen i = 0; i < nCount; i++)
//STRIP001 			{
//STRIP001 				sal_Unicode cChar = sOutputText.GetChar(i);
//STRIP001 				DrawText( Point( nLeftStart , nYOutput),  cChar);
//STRIP001 				long nCharWidth = GetTextWidth(cChar);
//STRIP001 				nLeftStart += nCharWidth + nSpace;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		//no break;
//STRIP001 		case RubyAdjust_CENTER:
//STRIP001 			DrawText( Point( nCenter - nOutTextWidth / 2 , nYOutput),  sOutputText );
//STRIP001 		break;
//STRIP001 	}
//STRIP001     SetFont(aSaveFont);
//STRIP001 }
//STRIP001 /* -----------------------------16.02.01 15:12--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void RubyEdit::GetFocus()
//STRIP001 {
//STRIP001 	GetModifyHdl().Call(this);
//STRIP001 	Edit::GetFocus();
//STRIP001 }
//STRIP001 /* -----------------------------17.07.01 09:00--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 long  RubyEdit::PreNotify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001     long nHandled = 0;
//STRIP001 	if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001         const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001         const KeyCode&  rKeyCode = pKEvt->GetKeyCode();
//STRIP001         USHORT nMod = rKeyCode.GetModifier();
//STRIP001         USHORT nCode = rKeyCode.GetCode();
//STRIP001         if( nCode == KEY_TAB && (!nMod || KEY_SHIFT == nMod))
//STRIP001         {
//STRIP001             sal_Int32 nParam = KEY_SHIFT == nMod ? -1 : 1;
//STRIP001             if(aScrollHdl.IsSet() && aScrollHdl.Call(&nParam))
//STRIP001                 nHandled = 1;
//STRIP001         }
//STRIP001         else if(KEY_UP == nCode || KEY_DOWN == nCode)
//STRIP001         {
//STRIP001             sal_Int32 nParam = KEY_UP == nCode ? -1 : 1;
//STRIP001             aJumpHdl.Call(&nParam);
//STRIP001         }
//STRIP001 	}
//STRIP001 	if(!nHandled)
//STRIP001         nHandled = Edit::PreNotify(rNEvt);
//STRIP001 	return nHandled;
//STRIP001 }

}
