/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_hlinettp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:47:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _ADRPARSE_HXX
#include <svtools/adrparse.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
#include <svtools/pathoptions.hxx>
#endif
#ifndef INCLUDED_SVTOOLS_USEROPTIONS_HXX
#include <svtools/useroptions.hxx>
#endif

#include "hlinettp.hxx"
#include "hyperdlg.hrc"
namespace binfilter {

#define STD_DOC_SUBPATH		"internal"
#define STD_DOC_NAME		"url_transfer.htm"

//STRIP001 sal_Char __READONLY_DATA sAnonymous[]    = "anonymous";
//STRIP001 sal_Char __READONLY_DATA sHTTPScheme[]   = INET_HTTP_SCHEME;
//STRIP001 sal_Char __READONLY_DATA sHTTPSScheme[]  = INET_HTTPS_SCHEME;
//STRIP001 sal_Char __READONLY_DATA sFTPScheme[]    = INET_FTP_SCHEME;
//STRIP001 sal_Char __READONLY_DATA sTelnetScheme[] = INET_TELNET_SCHEME;
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Contructor / Destructor
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 SvxHyperlinkInternetTp::SvxHyperlinkInternetTp ( Window *pParent,
//STRIP001 												 const SfxItemSet& rItemSet)
//STRIP001 :	maGrpLinkTyp			( this, ResId (GRP_LINKTYPE) ),
//STRIP001 	maRbtLinktypInternet	( this, ResId (RB_LINKTYP_INTERNET) ),
//STRIP001 	maRbtLinktypFTP			( this, ResId (RB_LINKTYP_FTP) ),
//STRIP001 	maRbtLinktypTelnet		( this, ResId (RB_LINKTYP_TELNET) ),
//STRIP001 	maFtTarget				( this, ResId (FT_TARGET_HTML) ),
//STRIP001 	maCbbTarget				( this, INET_PROT_HTTP ),
//STRIP001 	maFtLogin				( this, ResId (FT_LOGIN) ),
//STRIP001 	maEdLogin				( this, ResId (ED_LOGIN) ),
//STRIP001 	maFtPassword			( this, ResId (FT_PASSWD) ),
//STRIP001 	maEdPassword			( this, ResId (ED_PASSWD) ),
//STRIP001 	maCbAnonymous			( this, ResId (CBX_ANONYMOUS) ),
//STRIP001 	maBtBrowse				( this, ResId (BTN_BROWSE) ),
//STRIP001 	maBtTarget				( this, ResId (BTN_TARGET) ),
//STRIP001 	SvxHyperlinkTabPageBase ( pParent, SVX_RES( RID_SVXPAGE_HYPERLINK_INTERNET ),
//STRIP001 	                          rItemSet ) ,
//STRIP001 	mbMarkWndOpen			( FALSE ),
//STRIP001 	maStrStdDocURL			()
//STRIP001 {
//STRIP001 	// Set HC bitmaps and display display of bitmap names.
//STRIP001 	maBtBrowse.SetModeImage( Image( ResId( IMG_BROWSE_HC ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001     maBtBrowse.EnableTextDisplay (FALSE);
//STRIP001 	maBtTarget.SetModeImage( Image( ResId( IMG_TARGET_HC ) ), BMP_COLOR_HIGHCONTRAST );
//STRIP001     maBtTarget.EnableTextDisplay (FALSE);
//STRIP001 
//STRIP001 	InitStdControls();
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	// Init URL-Box (pos&size, Open-Handler)
//STRIP001 	maCbbTarget.SetPosSizePixel ( LogicToPixel( Point( COL_2, 25 ), MAP_APPFONT ),
//STRIP001 		                          LogicToPixel( Size ( 176 - COL_DIFF, 60), MAP_APPFONT ) );
//STRIP001 	maCbbTarget.Show();
//STRIP001 	maCbbTarget.SetHelpId( HID_HYPERDLG_INET_PATH );
//STRIP001 
//STRIP001 	// Find Path to Std-Doc
//STRIP001 	String aStrBasePaths( SvtPathOptions().GetTemplatePath() );
//STRIP001 	for( xub_StrLen n = 0; n < aStrBasePaths.GetTokenCount(); n++ )
//STRIP001 	{
//STRIP001 	    INetURLObject aURL( aStrBasePaths.GetToken( n ) );
//STRIP001 		aURL.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( STD_DOC_SUBPATH ) ) );
//STRIP001 		aURL.Append( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM( STD_DOC_NAME ) ) );
//STRIP001 		if ( FileExists( aURL ) )
//STRIP001         {
//STRIP001 			maStrStdDocURL = aURL.GetMainURL( INetURLObject::NO_DECODE );
//STRIP001             break;
//STRIP001         }
//STRIP001 	}
//STRIP001 	SetExchangeSupport ();
//STRIP001 
//STRIP001 	///////////////////////////////////////
//STRIP001 	// set defaults
//STRIP001 	maRbtLinktypInternet.Check ();
//STRIP001 	maFtLogin.Show( FALSE );
//STRIP001 	maFtPassword.Show( FALSE );
//STRIP001 	maEdLogin.Show( FALSE );
//STRIP001 	maEdPassword.Show( FALSE );
//STRIP001 	maCbAnonymous.Show( FALSE );
//STRIP001 	maBtTarget.Enable( FALSE );
//STRIP001 	maBtBrowse.Enable( maStrStdDocURL != aEmptyStr );
//STRIP001 
//STRIP001 	///////////////////////////////////////
//STRIP001 	// overload handlers
//STRIP001 	maRbtLinktypInternet.SetClickHdl( LINK ( this, SvxHyperlinkInternetTp, Click_SmartProtocol_Impl ) );
//STRIP001 	maRbtLinktypFTP.SetClickHdl     ( LINK ( this, SvxHyperlinkInternetTp, Click_SmartProtocol_Impl ) );
//STRIP001 	maRbtLinktypTelnet.SetClickHdl  ( LINK ( this, SvxHyperlinkInternetTp, Click_SmartProtocol_Impl ) );
//STRIP001 	maCbAnonymous.SetClickHdl       ( LINK ( this, SvxHyperlinkInternetTp, ClickAnonymousHdl_Impl ) );
//STRIP001 	maBtBrowse.SetClickHdl          ( LINK ( this, SvxHyperlinkInternetTp, ClickBrowseHdl_Impl ) );
//STRIP001 	maBtTarget.SetClickHdl          ( LINK ( this, SvxHyperlinkInternetTp, ClickTargetHdl_Impl ) );
//STRIP001 	maEdLogin.SetModifyHdl			( LINK ( this, SvxHyperlinkInternetTp, ModifiedLoginHdl_Impl ) );
//STRIP001 
//STRIP001 	maCbbTarget.SetLoseFocusHdl		( LINK ( this, SvxHyperlinkInternetTp, LostFocusTargetHdl_Impl ) );
//STRIP001 	maCbbTarget.SetModifyHdl		( LINK ( this, SvxHyperlinkInternetTp, ModifiedTargetHdl_Impl ) );
//STRIP001 
//STRIP001 	maTimer.SetTimeoutHdl			( LINK ( this, SvxHyperlinkInternetTp, TimeoutHdl_Impl ) );
//STRIP001 }
//STRIP001 
//STRIP001 SvxHyperlinkInternetTp::~SvxHyperlinkInternetTp ()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Fill the all dialog-controls except controls in groupbox "more..."
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::FillDlgFields ( String& aStrURL )
//STRIP001 {
//STRIP001 	INetURLObject aURL( aStrURL );
//STRIP001 	String aStrScheme = GetSchemeFromURL( aStrURL );
//STRIP001 
//STRIP001     // set additional controls for FTP: Username / Password
//STRIP001 	if ( aStrScheme.SearchAscii( sFTPScheme ) == 0 )
//STRIP001 	{
//STRIP001 		if ( aURL.GetUser().ToLowerAscii().SearchAscii ( sAnonymous ) == 0 )
//STRIP001 			setAnonymousFTPUser();
//STRIP001 		else
//STRIP001 			setFTPUser(aURL.GetUser(), aURL.GetPass());
//STRIP001 
//STRIP001         //do not show password and user in url
//STRIP001         aURL.SetUserAndPass(aEmptyStr,aEmptyStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// set URL-field
//STRIP001     // Show the scheme, #72740
//STRIP001     if ( aURL.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001 		maCbbTarget.SetText( aURL.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001     else
//STRIP001         maCbbTarget.SetText( aStrURL ); // #77696#
//STRIP001 
//STRIP001     SetScheme( aStrScheme );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::setAnonymousFTPUser()
//STRIP001 {
//STRIP001 	maEdLogin.SetText( UniString::CreateFromAscii( RTL_CONSTASCII_STRINGPARAM ( sAnonymous ) ) );
//STRIP001 	SvAddressParser aAddress( SvtUserOptions().GetEmail() );
//STRIP001 	maEdPassword.SetText( aAddress.Count() ? aAddress.GetEmailAddress(0) : String() );
//STRIP001 
//STRIP001 	maFtLogin.Disable ();
//STRIP001 	maFtPassword.Disable ();
//STRIP001 	maEdLogin.Disable ();
//STRIP001 	maEdPassword.Disable ();
//STRIP001 	maCbAnonymous.Check();
//STRIP001 }
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::setFTPUser(const String& rUser, const String& rPassword)
//STRIP001 {
//STRIP001 	maEdLogin.SetText ( rUser );
//STRIP001 	maEdPassword.SetText ( rPassword );
//STRIP001 
//STRIP001 	maFtLogin.Enable ();
//STRIP001 	maFtPassword.Enable ();
//STRIP001 	maEdLogin.Enable ();
//STRIP001 	maEdPassword.Enable ();
//STRIP001 	maCbAnonymous.Check(FALSE);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* retrieve and prepare data from dialog-fields
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::GetCurentItemData ( String& aStrURL, String& aStrName,
//STRIP001 												 String& aStrIntName, String& aStrFrame,
//STRIP001 												 SvxLinkInsertMode& eMode )
//STRIP001 {
//STRIP001     aStrURL = CreateAbsoluteURL();
//STRIP001 	GetDataFromCommonFields( aStrName, aStrIntName, aStrFrame, eMode );
//STRIP001 }
//STRIP001 
//STRIP001 String SvxHyperlinkInternetTp::CreateAbsoluteURL() const
//STRIP001 {
//STRIP001     String aStrURL = maCbbTarget.GetText();
//STRIP001     String aScheme = GetSchemeFromURL(aStrURL);
//STRIP001 
//STRIP001     INetURLObject aURL(aStrURL);
//STRIP001 
//STRIP001 	if( aURL.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001     {
//STRIP001         aURL.SetSmartProtocol( GetSmartProtocolFromButtons() );
//STRIP001         aURL.SetSmartURL(aStrURL);
//STRIP001     }
//STRIP001 
//STRIP001 	// username and password for ftp-url
//STRIP001 	if( aURL.GetProtocol() == INET_PROT_FTP )
//STRIP001 		aURL.SetUserAndPass ( maEdLogin.GetText(), maEdPassword.GetText() );
//STRIP001 
//STRIP001 	if ( aURL.GetProtocol() != INET_PROT_NOT_VALID )
//STRIP001         return aURL.GetMainURL( INetURLObject::DECODE_WITH_CHARSET );
//STRIP001     else //#105788# always create a URL even if it is not valid
//STRIP001         return aStrURL;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* static method to create Tabpage
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IconChoicePage* SvxHyperlinkInternetTp::Create( Window* pWindow, const SfxItemSet& rItemSet )
//STRIP001 {
//STRIP001 	return( new SvxHyperlinkInternetTp( pWindow, rItemSet ) );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Set initial focus
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::SetInitFocus()
//STRIP001 {
//STRIP001 	maCbbTarget.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Contens of editfield "Taregt" modified
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, ModifiedTargetHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001     String aScheme = GetSchemeFromURL( maCbbTarget.GetText() );
//STRIP001     if(aScheme.Len()!=0)
//STRIP001         SetScheme( aScheme );
//STRIP001 
//STRIP001 	// start timer
//STRIP001 	maTimer.SetTimeout( 2500 );
//STRIP001 	maTimer.Start();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* If target-field was modify, to browse the new doc afeter timeout
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, TimeoutHdl_Impl, Timer *, EMPTYARG )
//STRIP001 {
//STRIP001     RefreshMarkWindow();
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Contens of editfield "Login" modified
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, ModifiedLoginHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	String aStrLogin ( maEdLogin.GetText() );
//STRIP001 	if ( aStrLogin.EqualsIgnoreCaseAscii( sAnonymous ) )
//STRIP001 	{
//STRIP001 		maCbAnonymous.Check();
//STRIP001 		ClickAnonymousHdl_Impl(NULL);
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::SetScheme( const String& aScheme )
//STRIP001 {
//STRIP001     //if  aScheme is empty or unknown the default beaviour is like it where HTTP
//STRIP001 
//STRIP001     BOOL bFTP = aScheme.SearchAscii( sFTPScheme ) == 0;
//STRIP001     BOOL bTelnet = FALSE;
//STRIP001     if( !bFTP )
//STRIP001         bTelnet = aScheme.SearchAscii( sTelnetScheme ) == 0;
//STRIP001     BOOL bInternet = !(bFTP || bTelnet);
//STRIP001 
//STRIP001     //update protocol button selection:
//STRIP001     maRbtLinktypFTP.Check(bFTP);
//STRIP001     maRbtLinktypTelnet.Check(bTelnet);
//STRIP001     maRbtLinktypInternet.Check(bInternet);
//STRIP001 
//STRIP001     //update target:
//STRIP001     RemoveImproperProtocol(aScheme);
//STRIP001     maCbbTarget.SetSmartProtocol( GetSmartProtocolFromButtons() );
//STRIP001 
//STRIP001     //show/hide  special fields for FTP:
//STRIP001     maFtLogin.Show( bFTP );
//STRIP001 	maFtPassword.Show( bFTP );
//STRIP001 	maEdLogin.Show( bFTP );
//STRIP001 	maEdPassword.Show( bFTP );
//STRIP001 	maCbAnonymous.Show( bFTP );
//STRIP001 
//STRIP001     //update 'link target in document'-window and opening-button
//STRIP001     if( aScheme.SearchAscii( sHTTPScheme ) == 0 )
//STRIP001     {
//STRIP001         maBtTarget.Enable();
//STRIP001 	    if ( mbMarkWndOpen )
//STRIP001 		    ShowMarkWnd ();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         //disable for https, ftp and telnet
//STRIP001         maBtTarget.Disable();
//STRIP001 		if ( mbMarkWndOpen )
//STRIP001 			HideMarkWnd ();
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Remove protocol if it does not fit to the current button selection
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::RemoveImproperProtocol(const String& aProperScheme)
//STRIP001 {
//STRIP001     String aStrURL ( maCbbTarget.GetText() );
//STRIP001 	if ( aStrURL != aEmptyStr )
//STRIP001 	{
//STRIP001 		String aStrScheme = GetSchemeFromURL( aStrURL );
//STRIP001 		if ( aStrScheme != aEmptyStr && aStrScheme != aProperScheme )
//STRIP001 		{
//STRIP001 			aStrURL.Erase ( 0, aStrScheme.Len() );
//STRIP001             maCbbTarget.SetText ( aStrURL );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 String SvxHyperlinkInternetTp::GetSchemeFromButtons() const
//STRIP001 {
//STRIP001     if( maRbtLinktypFTP.IsChecked() )
//STRIP001 	{
//STRIP001 		return String::CreateFromAscii( INET_FTP_SCHEME );
//STRIP001 	} 
//STRIP001 	else if( maRbtLinktypTelnet.IsChecked() )
//STRIP001 	{
//STRIP001         return String::CreateFromAscii( INET_TELNET_SCHEME );
//STRIP001 	}
//STRIP001 	return String::CreateFromAscii( INET_HTTP_SCHEME );
//STRIP001 }
//STRIP001 
//STRIP001 INetProtocol SvxHyperlinkInternetTp::GetSmartProtocolFromButtons() const
//STRIP001 {
//STRIP001 	if( maRbtLinktypFTP.IsChecked() )
//STRIP001 	{
//STRIP001 		return INET_PROT_FTP;
//STRIP001 	} 
//STRIP001 	else if( maRbtLinktypTelnet.IsChecked() )
//STRIP001 	{
//STRIP001         return INET_PROT_TELNET;
//STRIP001 	}
//STRIP001 	return INET_PROT_HTTP;
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Click on Radiobutton : Internet, FTP or Telnet
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, Click_SmartProtocol_Impl, void*, EMPTYARG )
//STRIP001 {
//STRIP001     String aScheme = GetSchemeFromButtons();
//STRIP001     SetScheme( aScheme );
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Click on Checkbox : Anonymous user
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, ClickAnonymousHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	// disable login-editfields if checked
//STRIP001 	if ( maCbAnonymous.IsChecked() )
//STRIP001 	{
//STRIP001         if ( maEdLogin.GetText().ToLowerAscii().SearchAscii ( sAnonymous ) == 0 )
//STRIP001         {
//STRIP001             maStrOldUser = aEmptyStr;
//STRIP001 	        maStrOldPassword = aEmptyStr;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             maStrOldUser = maEdLogin.GetText();
//STRIP001 	        maStrOldPassword = maEdPassword.GetText();
//STRIP001         }
//STRIP001 
//STRIP001 		setAnonymousFTPUser();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		setFTPUser(maStrOldUser, maStrOldPassword);
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Combobox Target lost the focus
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, LostFocusTargetHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	RefreshMarkWindow();
//STRIP001 	return (0L);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Click on imagebutton : Browse
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, ClickBrowseHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	/////////////////////////////////////////////////
//STRIP001 	// Open URL if available
//STRIP001 
//STRIP001     SfxStringItem aName( SID_FILE_NAME, maStrStdDocURL );
//STRIP001 	SfxStringItem aRefererItem( SID_REFERER, UniString::CreateFromAscii(
//STRIP001 		                        RTL_CONSTASCII_STRINGPARAM( "private:user" ) ) );
//STRIP001 	SfxBoolItem aNewView( SID_OPEN_NEW_VIEW, TRUE );
//STRIP001 	SfxBoolItem aSilent( SID_SILENT, TRUE );
//STRIP001 	SfxBoolItem aReadOnly( SID_DOC_READONLY, TRUE );
//STRIP001 
//STRIP001     SfxBoolItem aBrowse( SID_BROWSE, TRUE );
//STRIP001     
//STRIP001     const SfxPoolItem *ppItems[] = { &aName, &aNewView, &aSilent, &aReadOnly, &aRefererItem, &aBrowse, NULL };
//STRIP001     (((SvxHpLinkDlg*)mpDialog)->GetBindings())->Execute( SID_OPENDOC, ppItems, 0, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD );
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Click on imagebutton : Target
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK ( SvxHyperlinkInternetTp, ClickTargetHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	RefreshMarkWindow();
//STRIP001 	ShowMarkWnd ();
//STRIP001 	mbMarkWndOpen = IsMarkWndVisible ();
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::RefreshMarkWindow()
//STRIP001 {
//STRIP001     if ( maRbtLinktypInternet.IsChecked() && IsMarkWndVisible() )
//STRIP001     {
//STRIP001         EnterWait();
//STRIP001 		String aStrURL( CreateAbsoluteURL() );
//STRIP001 		if ( aStrURL != aEmptyStr )
//STRIP001 			mpMarkWnd->RefreshTree ( aStrURL );
//STRIP001         else
//STRIP001             mpMarkWnd->SetError( LERR_DOCNOTOPEN );
//STRIP001         LeaveWait();
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Get String from Bookmark-Wnd
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::SetMarkStr ( String& aStrMark )
//STRIP001 {
//STRIP001 	String aStrURL ( maCbbTarget.GetText() );
//STRIP001 
//STRIP001 	const sal_Unicode sUHash = '#';
//STRIP001 	xub_StrLen nPos = aStrURL.SearchBackward( sUHash );
//STRIP001 
//STRIP001 	if( nPos != STRING_NOTFOUND )
//STRIP001 		aStrURL.Erase ( nPos );
//STRIP001 
//STRIP001 	aStrURL += sUHash;
//STRIP001 	aStrURL += aStrMark;
//STRIP001 
//STRIP001 	maCbbTarget.SetText ( aStrURL );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Enable Browse-Button in subject to the office is in onlinemode
//STRIP001 |*
//STRIP001 |************************************************************************/
//STRIP001 
//STRIP001 void SvxHyperlinkInternetTp::SetOnlineMode( BOOL bEnable )
//STRIP001 {
//STRIP001 	// State of target-button in subject to the current url-string
//STRIP001 	// ( Can't display any targets in an document, if there is no
//STRIP001 	//   valid url to a document )
//STRIP001 	String aStrCurrentTarget( maCbbTarget.GetText() );
//STRIP001 	aStrCurrentTarget.EraseTrailingChars();
//STRIP001 
//STRIP001 	if( aStrCurrentTarget == aEmptyStr                ||
//STRIP001 		aStrCurrentTarget.EqualsIgnoreCaseAscii( sHTTPScheme )  ||
//STRIP001 		aStrCurrentTarget.EqualsIgnoreCaseAscii( sHTTPSScheme ) )
//STRIP001 		maBtTarget.Enable( FALSE );
//STRIP001 	else
//STRIP001 		maBtTarget.Enable( TRUE );
//STRIP001 }
}
