/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_accessibility.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:00:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
//STRIP001 #include <com/sun/star/accessibility/AccessibleRole.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
//STRIP001 #include <com/sun/star/accessibility/AccessibleStateType.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLETEXTTYPE_HPP_
//STRIP001 #include <com/sun/star/accessibility/AccessibleTextType.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_XACCESSIBLEEVENTLISTENER_HPP_
//STRIP001 #include <com/sun/star/accessibility/XAccessibleEventListener.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTOBJECT_HPP_
//STRIP001 #include <com/sun/star/accessibility/AccessibleEventObject.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_AWT_FOCUSEVENT_HPP_
//STRIP001 #include <com/sun/star/awt/FocusEvent.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_AWT_XFOCUSLISTENER_HPP_
//STRIP001 #include <com/sun/star/awt/XFocusListener.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _UTL_ACCESSIBLERELATIONSETHELPER_HXX_
//STRIP001 #include <unotools/accessiblerelationsethelper.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARD_HPP_
//STRIP001 #include <com/sun/star/datatransfer/clipboard/XClipboard.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XFLUSHABLECLIPBOARD_HPP_
//STRIP001 #include <com/sun/star/datatransfer/clipboard/XFlushableClipboard.hpp>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _COM_SUN_STAR_I18N_WORDTYPE_HPP_
//STRIP001 #include <com/sun/star/i18n/WordType.hpp>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
//STRIP001 #include <unotools/accessiblestatesethelper.hxx>
//STRIP001 #endif
//STRIP001 #ifndef COMPHELPER_ACCESSIBLE_EVENT_NOTIFIER
//STRIP001 #include <comphelper/accessibleeventnotifier.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _TOOLS_DEBUG_HXX
//STRIP001 #include <tools/debug.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_SVAPP_HXX
//STRIP001 #include <vcl/svapp.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_WINDOW_HXX
//STRIP001 #include <vcl/window.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VCL_UNOHELP2_HXX
//STRIP001 #include <vcl/unohelp2.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_GEN_HXX
//STRIP001 #include <tools/gen.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VOS_MUTEX_HXX_
//STRIP001 #include <vos/mutex.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXITEMSET_HXX
//STRIP001 #include <svtools/itemset.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #include <bf_svx/editdata.hxx>
//STRIP001 #ifndef _MyEDITVIEW_HXX
//STRIP001 #include <bf_svx/editview.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _EEITEM_HXX
//STRIP001 #include <bf_svx/eeitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OUTLINER_HXX
//STRIP001 #include <bf_svx/outliner.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_UNOEDHLP_HXX
//STRIP001 #include <bf_svx/unoedhlp.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 
//STRIP001 #ifndef _ACCESSIBILITY_HXX_
//STRIP001 #include "accessibility.hxx"
//STRIP001 #endif
//STRIP001 #ifndef APPLICAT_HXX
//STRIP001 #include <applicat.hxx>
//STRIP001 #endif
//STRIP001 #ifndef DOCUMENT_HXX
//STRIP001 #include <document.hxx>
//STRIP001 #endif
//STRIP001 #ifndef VIEW_HXX
//STRIP001 #include <view.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 using namespace rtl;
//STRIP001 using namespace ::com::sun::star;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::accessibility;
//STRIP001 
//STRIP001 #define C2U(cChar)  ::rtl::OUString::createFromAscii(cChar)
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 static awt::Rectangle lcl_GetBounds( Window *pWin )
//STRIP001 {
//STRIP001     // !! see VCLXAccessibleComponent::implGetBounds()
//STRIP001 
//STRIP001     //! the coordinates returned are relativ to the parent window !
//STRIP001     //! Thus the top-left point may be different from (0, 0) !
//STRIP001 
//STRIP001     awt::Rectangle aBounds;
//STRIP001     if (pWin)
//STRIP001     {
//STRIP001         Rectangle aRect = pWin->GetWindowExtentsRelative( NULL );
//STRIP001         aBounds.X       = aRect.Left();
//STRIP001         aBounds.Y       = aRect.Top();
//STRIP001         aBounds.Width   = aRect.GetWidth();
//STRIP001         aBounds.Height  = aRect.GetHeight();
//STRIP001         Window* pParent = pWin->GetAccessibleParentWindow();
//STRIP001         if (pParent)
//STRIP001         {
//STRIP001             Rectangle aParentRect = pParent->GetWindowExtentsRelative( NULL );
//STRIP001             awt::Point aParentScreenLoc( aParentRect.Left(), aParentRect.Top() );
//STRIP001             aBounds.X -= aParentScreenLoc.X;
//STRIP001             aBounds.Y -= aParentScreenLoc.Y;
//STRIP001         }
//STRIP001     }
//STRIP001     return aBounds;
//STRIP001 }
//STRIP001 
//STRIP001 static awt::Point lcl_GetLocationOnScreen( Window *pWin )
//STRIP001 {
//STRIP001     // !! see VCLXAccessibleComponent::getLocationOnScreen()
//STRIP001 
//STRIP001     awt::Point aPos;
//STRIP001     if (pWin)
//STRIP001     {
//STRIP001         Rectangle aRect = pWin->GetWindowExtentsRelative( NULL );
//STRIP001         aPos.X = aRect.Left();
//STRIP001         aPos.Y = aRect.Top();
//STRIP001     }
//STRIP001     return aPos;
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 SmGraphicAccessible::SmGraphicAccessible( SmGraphicWindow *pGraphicWin ) :
//STRIP001     aAccName            ( String(SmResId(RID_DOCUMENTSTR)) ),
//STRIP001     pWin                (pGraphicWin),
//STRIP001     nClientId           (0)
//STRIP001 {
//STRIP001     DBG_ASSERT( pWin, "SmGraphicAccessible: window missing" );
//STRIP001     //++aRefCount;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SmGraphicAccessible::SmGraphicAccessible( const SmGraphicAccessible &rSmAcc ) :
//STRIP001     aAccName            ( String(SmResId(RID_DOCUMENTSTR)) ),
//STRIP001     nClientId           (0)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     pWin = rSmAcc.pWin;
//STRIP001     DBG_ASSERT( pWin, "SmGraphicAccessible: window missing" );
//STRIP001     //++aRefCount;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SmGraphicAccessible::~SmGraphicAccessible()
//STRIP001 {
//STRIP001 /*
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (--aRefCount == 0)
//STRIP001     {
//STRIP001     }
//STRIP001 */
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SmDocShell * SmGraphicAccessible::GetDoc_Impl()
//STRIP001 {
//STRIP001     SmViewShell *pView = pWin ? pWin->GetView() : 0;
//STRIP001     return pView ? pView->GetDoc() : 0;
//STRIP001 }
//STRIP001 
//STRIP001 String SmGraphicAccessible::GetAccessibleText_Impl()
//STRIP001 {
//STRIP001     String aTxt;
//STRIP001     SmDocShell *pDoc = GetDoc_Impl();
//STRIP001     if (pDoc)
//STRIP001         aTxt = pDoc->GetAccessibleText();
//STRIP001     return aTxt;
//STRIP001 }
//STRIP001 
//STRIP001 void SmGraphicAccessible::ClearWin()
//STRIP001 {
//STRIP001     pWin = 0;   // implicitly results in AccessibleStateType::DEFUNC set
//STRIP001 
//STRIP001 	if ( nClientId )
//STRIP001 	{
//STRIP001         comphelper::AccessibleEventNotifier::revokeClientNotifyDisposing( nClientId, *this );
//STRIP001 		nClientId =  0;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SmGraphicAccessible::LaunchEvent(
//STRIP001         const sal_Int16 nAccesibleEventId,
//STRIP001         const uno::Any &rOldVal,
//STRIP001         const uno::Any &rNewVal)
//STRIP001 {
//STRIP001     AccessibleEventObject aEvt;
//STRIP001     aEvt.Source     = (XAccessible *) this;
//STRIP001     aEvt.EventId    = nAccesibleEventId;
//STRIP001     aEvt.OldValue   = rOldVal;
//STRIP001     aEvt.NewValue   = rNewVal ;
//STRIP001 
//STRIP001     // pass event on to event-listener's
//STRIP001 	if (nClientId)
//STRIP001 		::comphelper::AccessibleEventNotifier::addEvent( nClientId, aEvt );
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessibleContext > SAL_CALL SmGraphicAccessible::getAccessibleContext()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return this;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SAL_CALL SmGraphicAccessible::containsPoint( const awt::Point& aPoint )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //! the arguments coordinates are relativ to the current window !
//STRIP001     //! Thus the top-left point is (0, 0)
//STRIP001 
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001 
//STRIP001     Size aSz( pWin->GetSizePixel() );
//STRIP001     return  aPoint.X >= 0  &&  aPoint.Y >= 0  &&
//STRIP001             aPoint.X < aSz.Width()  &&  aPoint.Y < aSz.Height();
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessible > SAL_CALL SmGraphicAccessible::getAccessibleAtPoint(
//STRIP001         const awt::Point& aPoint )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     XAccessible *pRes = 0;
//STRIP001     if (containsPoint( aPoint ))
//STRIP001         pRes = this;
//STRIP001     return pRes;
//STRIP001 }
//STRIP001 
//STRIP001 awt::Rectangle SAL_CALL SmGraphicAccessible::getBounds()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001     return lcl_GetBounds( pWin );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Point SAL_CALL SmGraphicAccessible::getLocation()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001     awt::Rectangle aRect( lcl_GetBounds( pWin ) );
//STRIP001     return awt::Point( aRect.X, aRect.Y );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Point SAL_CALL SmGraphicAccessible::getLocationOnScreen()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001     return lcl_GetLocationOnScreen( pWin );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Size SAL_CALL SmGraphicAccessible::getSize()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001 
//STRIP001     Size aSz( pWin->GetSizePixel() );
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     awt::Rectangle aRect( lcl_GetBounds( pWin ) );
//STRIP001     Size aSz2( aRect.Width, aRect.Height );
//STRIP001     DBG_ASSERT( aSz == aSz2, "mismatch in width" );
//STRIP001 #endif
//STRIP001     return awt::Size( aSz.Width(), aSz.Height() );
//STRIP001 }
//STRIP001 
//STRIP001 void SAL_CALL SmGraphicAccessible::grabFocus()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001 
//STRIP001     pWin->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getForeground()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     return (sal_Int32) pWin->GetTextColor().GetColor();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getBackground()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     Wallpaper aWall( pWin->GetDisplayBackground() );
//STRIP001     ColorData nCol;
//STRIP001     if (aWall.IsBitmap() || aWall.IsGradient())
//STRIP001         nCol = pWin->GetSettings().GetStyleSettings().GetWindowColor().GetColor();
//STRIP001     else
//STRIP001         nCol = aWall.GetColor().GetColor();
//STRIP001     return (sal_Int32) nCol;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getAccessibleChildCount()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 Reference< XAccessible > SAL_CALL SmGraphicAccessible::getAccessibleChild(
//STRIP001         sal_Int32 i )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     throw IndexOutOfBoundsException();  // there is no child...
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 Reference< XAccessible > SAL_CALL SmGraphicAccessible::getAccessibleParent()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001 
//STRIP001     Window *pAccParent = pWin->GetAccessibleParentWindow();
//STRIP001     DBG_ASSERT( pAccParent, "accessible parent missing" );
//STRIP001     return pAccParent ? pAccParent->GetAccessible() : Reference< XAccessible >();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getAccessibleIndexInParent()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     sal_Int32 nIdx = -1;
//STRIP001     Window *pAccParent = pWin ? pWin->GetAccessibleParentWindow() : 0;
//STRIP001     if (pAccParent)
//STRIP001     {
//STRIP001         USHORT nCnt = pAccParent->GetAccessibleChildWindowCount();
//STRIP001         for (USHORT i = 0;  i < nCnt  &&  nIdx == -1;  ++i)
//STRIP001             if (pAccParent->GetAccessibleChildWindow( i ) == pWin)
//STRIP001                 nIdx = i;
//STRIP001     }
//STRIP001     return nIdx;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int16 SAL_CALL SmGraphicAccessible::getAccessibleRole()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return AccessibleRole::DOCUMENT;
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmGraphicAccessible::getAccessibleDescription()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     SmDocShell *pDoc = GetDoc_Impl();
//STRIP001     return pDoc ? OUString(pDoc->GetText()) : OUString();
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmGraphicAccessible::getAccessibleName()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return aAccName;
//STRIP001 }
//STRIP001 
//STRIP001 Reference< XAccessibleRelationSet > SAL_CALL SmGraphicAccessible::getAccessibleRelationSet()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     Reference< XAccessibleRelationSet > xRelSet = new utl::AccessibleRelationSetHelper();
//STRIP001     return xRelSet;   // empty relation set
//STRIP001 }
//STRIP001 
//STRIP001 Reference< XAccessibleStateSet > SAL_CALL SmGraphicAccessible::getAccessibleStateSet()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 	::utl::AccessibleStateSetHelper *pStateSet =
//STRIP001             new ::utl::AccessibleStateSetHelper;
//STRIP001 
//STRIP001 	Reference<XAccessibleStateSet> xStateSet( pStateSet );
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         pStateSet->AddState( AccessibleStateType::DEFUNC );
//STRIP001     else
//STRIP001     {
//STRIP001         //pStateSet->AddState( AccessibleStateType::EDITABLE );
//STRIP001         //pStateSet->AddState( AccessibleStateType::HORIZONTAL );
//STRIP001         //pStateSet->AddState( AccessibleStateType::TRANSIENT );
//STRIP001         pStateSet->AddState( AccessibleStateType::ENABLED );
//STRIP001         pStateSet->AddState( AccessibleStateType::FOCUSABLE );
//STRIP001         if (pWin->HasFocus())
//STRIP001             pStateSet->AddState( AccessibleStateType::FOCUSED );
//STRIP001         if (pWin->IsActive())
//STRIP001             pStateSet->AddState( AccessibleStateType::ACTIVE );
//STRIP001         if (pWin->IsVisible())
//STRIP001             pStateSet->AddState( AccessibleStateType::SHOWING );
//STRIP001         if (pWin->IsReallyVisible())
//STRIP001             pStateSet->AddState( AccessibleStateType::VISIBLE );
//STRIP001         if (COL_TRANSPARENT != pWin->GetBackground().GetColor().GetColor())
//STRIP001             pStateSet->AddState( AccessibleStateType::OPAQUE );
//STRIP001     }
//STRIP001 
//STRIP001 	return xStateSet;
//STRIP001 }
//STRIP001 
//STRIP001 Locale SAL_CALL SmGraphicAccessible::getLocale()
//STRIP001     throw (IllegalAccessibleComponentStateException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     // should be the document language...
//STRIP001     // We use the language of the localized symbol names here.
//STRIP001     return Application::GetSettings().GetUILocale();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 void SAL_CALL SmGraphicAccessible::addEventListener(
//STRIP001         const Reference< XAccessibleEventListener >& xListener )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	if (xListener.is())
//STRIP001     {
//STRIP001 		vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 		if (pWin)
//STRIP001 		{
//STRIP001 			if (!nClientId)
//STRIP001                 nClientId = comphelper::AccessibleEventNotifier::registerClient( );
//STRIP001 			::comphelper::AccessibleEventNotifier::addEventListener( nClientId, xListener );
//STRIP001 		}
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 void SAL_CALL SmGraphicAccessible::removeEventListener(
//STRIP001         const Reference< XAccessibleEventListener >& xListener )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	if (xListener.is())
//STRIP001 	{
//STRIP001 		vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 		sal_Int32 nListenerCount = comphelper::AccessibleEventNotifier::removeEventListener( nClientId, xListener );
//STRIP001 		if ( !nListenerCount )
//STRIP001 		{
//STRIP001 			// no listeners anymore
//STRIP001 			// -> revoke ourself. This may lead to the notifier thread dying (if we were the last client),
//STRIP001 			// and at least to us not firing any events anymore, in case somebody calls
//STRIP001 			// NotifyAccessibleEvent, again
//STRIP001 			::comphelper::AccessibleEventNotifier::revokeClient( nClientId );
//STRIP001 			nClientId = 0;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getCaretPosition()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SAL_CALL SmGraphicAccessible::setCaretPosition( sal_Int32 nIndex )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001     // nothing to be done
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Unicode SAL_CALL SmGraphicAccessible::getCharacter( sal_Int32 nIndex )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     xub_StrLen nIdx = (xub_StrLen) nIndex;
//STRIP001     String aTxt( GetAccessibleText_Impl() );
//STRIP001     if (!(0 <= nIdx  &&  nIdx < aTxt.Len()))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001     return aTxt.GetChar( nIdx );
//STRIP001 }
//STRIP001 
//STRIP001 Sequence< beans::PropertyValue > SAL_CALL SmGraphicAccessible::getCharacterAttributes(
//STRIP001         sal_Int32 nIndex, const ::com::sun::star::uno::Sequence< ::rtl::OUString >& aRequestedAttributes )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     INT32 nLen = GetAccessibleText_Impl().Len();
//STRIP001     if (!(0 <= nIndex  &&  nIndex < nLen))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001     return Sequence< beans::PropertyValue >();
//STRIP001 }
//STRIP001 
//STRIP001 awt::Rectangle SAL_CALL SmGraphicAccessible::getCharacterBounds( sal_Int32 nIndex )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     awt::Rectangle aRes;
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     else
//STRIP001     {
//STRIP001         // get accessible text
//STRIP001         SmViewShell *pView = pWin->GetView();
//STRIP001         SmDocShell  *pDoc  = pView ? pView->GetDoc() : 0;
//STRIP001         if (!pDoc)
//STRIP001             throw RuntimeException();
//STRIP001         String aTxt( GetAccessibleText_Impl() );
//STRIP001         if (!(0 <= nIndex  &&  nIndex <= aTxt.Len()))   // #108812# aTxt.Len() is valid
//STRIP001             throw IndexOutOfBoundsException();
//STRIP001 
//STRIP001         // #108812# find a reasonable rectangle for position aTxt.Len().
//STRIP001         bool bWasBehindText = (nIndex == aTxt.Len());
//STRIP001         if (bWasBehindText && nIndex)
//STRIP001             --nIndex;
//STRIP001 
//STRIP001         const SmNode *pTree = pDoc->GetFormulaTree();
//STRIP001         const SmNode *pNode = pTree->FindNodeWithAccessibleIndex( (xub_StrLen) nIndex );
//STRIP001         //! pNode may be 0 if the index belongs to a char that was inserted
//STRIP001         //! only for the accessible text!
//STRIP001         if (pNode)
//STRIP001         {
//STRIP001             sal_Int32 nAccIndex = pNode->GetAccessibleIndex();
//STRIP001             DBG_ASSERT( nAccIndex >= 0, "invalid accessible index" );
//STRIP001             DBG_ASSERT( nIndex >= nAccIndex, "index out of range" );
//STRIP001 
//STRIP001             String    aNodeText;
//STRIP001             pNode->GetAccessibleText( aNodeText );
//STRIP001             sal_Int32 nNodeIndex = nIndex - nAccIndex;
//STRIP001             if (0 <= nNodeIndex  &&  nNodeIndex < aNodeText.Len())
//STRIP001             {
//STRIP001                 // get appropriate rectangle
//STRIP001                 Point aOffset(pNode->GetTopLeft() - pTree->GetTopLeft());
//STRIP001                 Point aTLPos (pWin->GetFormulaDrawPos() + aOffset);
//STRIP001 //                aTLPos.X() -= pNode->GetItalicLeftSpace();
//STRIP001 //                Size  aSize (pNode->GetItalicSize());
//STRIP001                 aTLPos.X() -= 0;
//STRIP001                 Size  aSize (pNode->GetSize());
//STRIP001 
//STRIP001                 long *pXAry = new long[ aNodeText.Len() ];
//STRIP001                 pWin->SetFont( pNode->GetFont() );
//STRIP001                 pWin->GetTextArray( aNodeText, pXAry, 0, aNodeText.Len() );
//STRIP001                 aTLPos.X()    += nNodeIndex > 0 ? pXAry[nNodeIndex - 1] : 0;
//STRIP001                 aSize.Width()  = nNodeIndex > 0 ? pXAry[nNodeIndex] - pXAry[nNodeIndex - 1] : pXAry[nNodeIndex];
//STRIP001                 delete[] pXAry;
//STRIP001 
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     Point aLP00( pWin->LogicToPixel( Point(0,0)) );
//STRIP001     Point aPL00( pWin->PixelToLogic( Point(0,0)) );
//STRIP001 #endif
//STRIP001                 aTLPos = pWin->LogicToPixel( aTLPos );
//STRIP001                 aSize  = pWin->LogicToPixel( aSize );
//STRIP001                 aRes.X = aTLPos.X();
//STRIP001                 aRes.Y = aTLPos.Y();
//STRIP001                 aRes.Width  = aSize.Width();
//STRIP001                 aRes.Height = aSize.Height();
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         // #108812# take rectangle from last character and move it to the right
//STRIP001         if (bWasBehindText)
//STRIP001             aRes.X += aRes.Width;
//STRIP001     }
//STRIP001 
//STRIP001     return aRes;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getCharacterCount()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return GetAccessibleText_Impl().Len();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getIndexAtPoint( const awt::Point& aPoint )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     sal_Int32 nRes = -1;
//STRIP001     if (pWin)
//STRIP001     {
//STRIP001         const SmNode *pTree = pWin->GetView()->GetDoc()->GetFormulaTree();
//STRIP001 		//! kann NULL sein! ZB wenn bereits beim laden des Dokuments (bevor der
//STRIP001 		//! Parser angeworfen wurde) ins Fenster geklickt wird.
//STRIP001 		if (!pTree)
//STRIP001             return nRes;
//STRIP001 
//STRIP001         // get position relativ to formula draw position
//STRIP001         Point  aPos( aPoint.X, aPoint.Y );
//STRIP001         aPos = pWin->PixelToLogic( aPos );
//STRIP001         aPos -= pWin->GetFormulaDrawPos();
//STRIP001 
//STRIP001         // if it was inside the formula then get the appropriate node
//STRIP001 		const SmNode *pNode = 0;
//STRIP001 		if (pTree->OrientedDist(aPos) <= 0)
//STRIP001 			pNode = pTree->FindRectClosestTo(aPos);
//STRIP001 
//STRIP001         if (pNode)
//STRIP001         {
//STRIP001             // get appropriate rectangle
//STRIP001             Point   aOffset( pNode->GetTopLeft() - pTree->GetTopLeft() );
//STRIP001             Point   aTLPos ( /*pWin->GetFormulaDrawPos() +*/ aOffset );
//STRIP001 //            aTLPos.X() -= pNode->GetItalicLeftSpace();
//STRIP001 //            Size  aSize( pNode->GetItalicSize() );
//STRIP001             aTLPos.X() -= 0;
//STRIP001             Size  aSize( pNode->GetSize() );
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     Point aLP00( pWin->LogicToPixel( Point(0,0)) );
//STRIP001     Point aPL00( pWin->PixelToLogic( Point(0,0)) );
//STRIP001 #endif
//STRIP001 
//STRIP001             Rectangle aRect( aTLPos, aSize );
//STRIP001             if (aRect.IsInside( aPos ))
//STRIP001             {
//STRIP001                 DBG_ASSERT( pNode->IsVisible(), "node is not a leaf" );
//STRIP001                 String aTxt;
//STRIP001                 pNode->GetAccessibleText( aTxt );
//STRIP001                 DBG_ASSERT( aTxt.Len(), "no accessible text available" );
//STRIP001 
//STRIP001                 long nNodeX = pNode->GetLeft();
//STRIP001 
//STRIP001                 long *pXAry = new long[ aTxt.Len() ];
//STRIP001                 pWin->SetFont( pNode->GetFont() );
//STRIP001                 pWin->GetTextArray( aTxt, pXAry, 0, aTxt.Len() );
//STRIP001                 for (sal_Int32 i = 0;  i < aTxt.Len()  &&  nRes == -1;  ++i)
//STRIP001                 {
//STRIP001                     if (pXAry[i] + nNodeX > aPos.X())
//STRIP001                         nRes = i;
//STRIP001                 }
//STRIP001                 delete[] pXAry;
//STRIP001                 DBG_ASSERT( nRes >= 0  &&  nRes < aTxt.Len(), "index out of range" );
//STRIP001                 DBG_ASSERT( pNode->GetAccessibleIndex() >= 0,
//STRIP001                         "invalid accessible index" );
//STRIP001 
//STRIP001                 nRes = pNode->GetAccessibleIndex() + nRes;
//STRIP001             }
//STRIP001 		}
//STRIP001     }
//STRIP001     return nRes;
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmGraphicAccessible::getSelectedText()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return OUString();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getSelectionStart()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return -1;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmGraphicAccessible::getSelectionEnd()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return -1;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SAL_CALL SmGraphicAccessible::setSelection(
//STRIP001         sal_Int32 nStartIndex,
//STRIP001         sal_Int32 nEndIndex )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     INT32 nLen = GetAccessibleText_Impl().Len();
//STRIP001     if (!(0 <= nStartIndex  &&  nStartIndex < nLen) ||
//STRIP001         !(0 <= nEndIndex    &&  nEndIndex   < nLen))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001     return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmGraphicAccessible::getText()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return GetAccessibleText_Impl();
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmGraphicAccessible::getTextRange(
//STRIP001         sal_Int32 nStartIndex,
//STRIP001         sal_Int32 nEndIndex )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001     //!! nEndIndex may be the string lenght per definition of the interface !!
//STRIP001     //!! text should be copied exclusive that end index though. And arguments
//STRIP001     //!! may be switched.
//STRIP001 
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     String aTxt( GetAccessibleText_Impl() );
//STRIP001     xub_StrLen nStart = (xub_StrLen) Min(nStartIndex, nEndIndex);
//STRIP001     xub_StrLen nEnd   = (xub_StrLen) Max(nStartIndex, nEndIndex);
//STRIP001     if (!(0 <= nStart  &&  nStart <= aTxt.Len()) ||
//STRIP001         !(0 <= nEnd    &&  nEnd   <= aTxt.Len()))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001     return aTxt.Copy( nStart, nEnd - nStart );
//STRIP001 }
//STRIP001 
//STRIP001 ::com::sun::star::accessibility::TextSegment SAL_CALL SmGraphicAccessible::getTextAtIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     String aTxt( GetAccessibleText_Impl() );
//STRIP001     xub_StrLen nIdx = (xub_StrLen) nIndex;
//STRIP001     //!! nIndex is allowed to be the string length
//STRIP001     if (!(0 <= nIdx  &&  nIdx <= aTxt.Len()))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001 
//STRIP001     ::com::sun::star::accessibility::TextSegment aResult;
//STRIP001     aResult.SegmentStart = -1;
//STRIP001     aResult.SegmentEnd = -1;
//STRIP001     if ( (AccessibleTextType::CHARACTER == aTextType)  &&  (nIdx < aTxt.Len()) )
//STRIP001     {
//STRIP001         aResult.SegmentText = aTxt.Copy(nIdx, 1);
//STRIP001         aResult.SegmentStart = nIdx;
//STRIP001         aResult.SegmentEnd = nIdx+1;
//STRIP001     }
//STRIP001     return aResult;
//STRIP001 }
//STRIP001 
//STRIP001 ::com::sun::star::accessibility::TextSegment SAL_CALL SmGraphicAccessible::getTextBeforeIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     String aTxt( GetAccessibleText_Impl() );
//STRIP001     xub_StrLen nIdx = (xub_StrLen) nIndex;
//STRIP001     //!! nIndex is allowed to be the string length
//STRIP001     if (!(0 <= nIdx  &&  nIdx <= aTxt.Len()))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001 
//STRIP001     ::com::sun::star::accessibility::TextSegment aResult;
//STRIP001     aResult.SegmentStart = -1;
//STRIP001     aResult.SegmentEnd = -1;
//STRIP001 
//STRIP001     if ( (AccessibleTextType::CHARACTER == aTextType)  && nIdx )
//STRIP001     {
//STRIP001         aResult.SegmentText = aTxt.Copy(nIdx-1, 1);
//STRIP001         aResult.SegmentStart = nIdx-1;
//STRIP001         aResult.SegmentEnd = nIdx;
//STRIP001     }
//STRIP001     return aResult;
//STRIP001 }
//STRIP001 
//STRIP001 ::com::sun::star::accessibility::TextSegment SAL_CALL SmGraphicAccessible::getTextBehindIndex( sal_Int32 nIndex, sal_Int16 aTextType ) throw (::com::sun::star::lang::IndexOutOfBoundsException, ::com::sun::star::lang::IllegalArgumentException, ::com::sun::star::uno::RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     String aTxt( GetAccessibleText_Impl() );
//STRIP001     xub_StrLen nIdx = (xub_StrLen) nIndex;
//STRIP001     //!! nIndex is allowed to be the string length
//STRIP001     if (!(0 <= nIdx  &&  nIdx <= aTxt.Len()))
//STRIP001         throw IndexOutOfBoundsException();
//STRIP001 
//STRIP001     ::com::sun::star::accessibility::TextSegment aResult;
//STRIP001     aResult.SegmentStart = -1;
//STRIP001     aResult.SegmentEnd = -1;
//STRIP001 
//STRIP001     nIdx++; // text *behind*
//STRIP001     if ( (AccessibleTextType::CHARACTER == aTextType)  &&  (nIdx < aTxt.Len()) )
//STRIP001     {
//STRIP001         aResult.SegmentText = aTxt.Copy(nIdx, 1);
//STRIP001         aResult.SegmentStart = nIdx;
//STRIP001         aResult.SegmentEnd = nIdx+1;
//STRIP001     }
//STRIP001     return aResult;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SAL_CALL SmGraphicAccessible::copyText(
//STRIP001         sal_Int32 nStartIndex,
//STRIP001         sal_Int32 nEndIndex )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 	sal_Bool bReturn = sal_False;
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     else
//STRIP001 	{
//STRIP001         Reference< datatransfer::clipboard::XClipboard > xClipboard = pWin->GetClipboard();
//STRIP001 		if ( xClipboard.is() )
//STRIP001 		{
//STRIP001             ::rtl::OUString sText( getTextRange(nStartIndex, nEndIndex) );
//STRIP001 
//STRIP001 			::vcl::unohelper::TextDataObject* pDataObj = new ::vcl::unohelper::TextDataObject( sText );
//STRIP001 			const sal_uInt32 nRef = Application::ReleaseSolarMutex();
//STRIP001 			xClipboard->setContents( pDataObj, NULL );
//STRIP001 
//STRIP001 			Reference< datatransfer::clipboard::XFlushableClipboard > xFlushableClipboard( xClipboard, uno::UNO_QUERY );
//STRIP001 			if( xFlushableClipboard.is() )
//STRIP001 				xFlushableClipboard->flushClipboard();
//STRIP001 
//STRIP001 			Application::AcquireSolarMutex( nRef );
//STRIP001 
//STRIP001 			bReturn = sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     return bReturn;
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmGraphicAccessible::getImplementationName()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return C2U("SmGraphicAccessible");
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SAL_CALL SmGraphicAccessible::supportsService(
//STRIP001         const OUString& rServiceName )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return  rServiceName == C2U( "com::sun::star::accessibility::Accessible" ) ||
//STRIP001             rServiceName == C2U( "com::sun::star::accessibility::AccessibleComponent" ) ||
//STRIP001             rServiceName == C2U( "com::sun::star::accessibility::AccessibleContext" ) ||
//STRIP001             rServiceName == C2U( "com::sun::star::accessibility::AccessibleText" );
//STRIP001 }
//STRIP001 
//STRIP001 Sequence< OUString > SAL_CALL SmGraphicAccessible::getSupportedServiceNames()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     Sequence< OUString > aNames(4);
//STRIP001     OUString *pNames = aNames.getArray();
//STRIP001     pNames[0] = C2U( "com::sun::star::accessibility::Accessible" );
//STRIP001     pNames[1] = C2U( "com::sun::star::accessibility::AccessibleComponent" );
//STRIP001     pNames[2] = C2U( "com::sun::star::accessibility::AccessibleContext" );
//STRIP001     pNames[3] = C2U( "com::sun::star::accessibility::AccessibleText" );
//STRIP001     return aNames;
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SmEditSource::SmEditSource( SmEditWindow *pWin, EditEngine &rEEngine, EditView &rEView ) :
//STRIP001     aViewFwd    (rEView),
//STRIP001     aTextFwd    (rEEngine, *this),
//STRIP001     aEditViewFwd(rEView),
//STRIP001     rEditEngine (rEEngine),
//STRIP001     rEditView   (rEView)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SmEditSource::SmEditSource( const SmEditSource &rSrc ) :
//STRIP001     aViewFwd    (rSrc.rEditView),
//STRIP001     aTextFwd    (rSrc.rEditEngine, *this),
//STRIP001     aEditViewFwd(rSrc.rEditView),
//STRIP001     rEditEngine (rSrc.rEditEngine),
//STRIP001     rEditView   (rSrc.rEditView)
//STRIP001 {
//STRIP001     //aBroadCaster;     can be completely new
//STRIP001 }
//STRIP001 
//STRIP001 SmEditSource::~SmEditSource()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SvxEditSource* SmEditSource::Clone() const
//STRIP001 {
//STRIP001     return new SmEditSource( *this );
//STRIP001 }
//STRIP001 
//STRIP001 SvxTextForwarder* SmEditSource::GetTextForwarder()
//STRIP001 {
//STRIP001     return &aTextFwd;
//STRIP001 }
//STRIP001 
//STRIP001 SvxViewForwarder* SmEditSource::GetViewForwarder()
//STRIP001 {
//STRIP001     return &aViewFwd;
//STRIP001 }
//STRIP001 
//STRIP001 SvxEditViewForwarder* SmEditSource::GetEditViewForwarder( sal_Bool bCreate )
//STRIP001 {
//STRIP001     return &aEditViewFwd;
//STRIP001 }
//STRIP001 
//STRIP001 void SmEditSource::UpdateData()
//STRIP001 {
//STRIP001     // would possibly only by needed if the XText inteface is implemented
//STRIP001     // and its text needs to be updated.
//STRIP001 }
//STRIP001 
//STRIP001 SfxBroadcaster & SmEditSource::GetBroadcaster() const
//STRIP001 {
//STRIP001     return ((SmEditSource *) this)->aBroadCaster;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SmViewForwarder::SmViewForwarder( EditView &rView ) :
//STRIP001     rEditView(rView)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SmViewForwarder::~SmViewForwarder()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SmViewForwarder::IsValid() const
//STRIP001 {
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SmViewForwarder::GetVisArea() const
//STRIP001 {
//STRIP001     OutputDevice* pOutDev = rEditView.GetWindow();
//STRIP001 
//STRIP001     if( pOutDev )
//STRIP001     {
//STRIP001         Rectangle aVisArea = rEditView.GetVisArea();
//STRIP001 
//STRIP001         // figure out map mode from edit engine
//STRIP001         EditEngine* pEditEngine = rEditView.GetEditEngine();
//STRIP001 
//STRIP001         if( pEditEngine )
//STRIP001         {
//STRIP001             MapMode aMapMode(pOutDev->GetMapMode());
//STRIP001             aVisArea = OutputDevice::LogicToLogic( aVisArea,
//STRIP001                                                    pEditEngine->GetRefMapMode(),
//STRIP001                                                    aMapMode.GetMapUnit() );
//STRIP001             aMapMode.SetOrigin(Point());
//STRIP001             return pOutDev->LogicToPixel( aVisArea, aMapMode );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return Rectangle();
//STRIP001 }
//STRIP001 
//STRIP001 Point SmViewForwarder::LogicToPixel( const Point& rPoint, const MapMode& rMapMode ) const
//STRIP001 {
//STRIP001     OutputDevice* pOutDev = rEditView.GetWindow();
//STRIP001 
//STRIP001     if( pOutDev )
//STRIP001     {
//STRIP001         MapMode aMapMode(pOutDev->GetMapMode());
//STRIP001         Point aPoint( OutputDevice::LogicToLogic( rPoint, rMapMode,
//STRIP001                                                   aMapMode.GetMapUnit() ) );
//STRIP001         aMapMode.SetOrigin(Point());
//STRIP001         return pOutDev->LogicToPixel( aPoint, aMapMode );
//STRIP001     }
//STRIP001 
//STRIP001     return Point();
//STRIP001 }
//STRIP001 
//STRIP001 Point SmViewForwarder::PixelToLogic( const Point& rPoint, const MapMode& rMapMode ) const
//STRIP001 {
//STRIP001     OutputDevice* pOutDev = rEditView.GetWindow();
//STRIP001 
//STRIP001     if( pOutDev )
//STRIP001     {
//STRIP001         MapMode aMapMode(pOutDev->GetMapMode());
//STRIP001         aMapMode.SetOrigin(Point());
//STRIP001         Point aPoint( pOutDev->PixelToLogic( rPoint, aMapMode ) );
//STRIP001         return OutputDevice::LogicToLogic( aPoint,
//STRIP001                                            aMapMode.GetMapUnit(),
//STRIP001                                            rMapMode );
//STRIP001     }
//STRIP001 
//STRIP001     return Point();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SmTextForwarder::SmTextForwarder( EditEngine& rEngine, SmEditSource & rSource) :
//STRIP001     rEditEngine ( rEngine ),
//STRIP001     rEditSource (rSource)
//STRIP001 {
//STRIP001     rEditEngine.SetNotifyHdl( LINK(this, SmTextForwarder, NotifyHdl) );
//STRIP001 }
//STRIP001 
//STRIP001 SmTextForwarder::~SmTextForwarder()
//STRIP001 {
//STRIP001 	//	die EditEngine muss ggf. von aussen geloescht werden
//STRIP001     rEditEngine.SetNotifyHdl( Link() );
//STRIP001 }
//STRIP001 
//STRIP001 IMPL_LINK(SmTextForwarder, NotifyHdl, EENotify*, aNotify)
//STRIP001 {
//STRIP001     if (aNotify)
//STRIP001     {
//STRIP001         ::std::auto_ptr< SfxHint > aHint = SvxEditSourceHelper::EENotification2Hint( aNotify );
//STRIP001         if (aHint.get())
//STRIP001             rEditSource.GetBroadcaster().Broadcast( *aHint.get() );
//STRIP001     }
//STRIP001 
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetParagraphCount() const
//STRIP001 {
//STRIP001 	return rEditEngine.GetParagraphCount();
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetTextLen( USHORT nParagraph ) const
//STRIP001 {
//STRIP001 	return rEditEngine.GetTextLen( nParagraph );
//STRIP001 }
//STRIP001 
//STRIP001 String SmTextForwarder::GetText( const ESelection& rSel ) const
//STRIP001 {
//STRIP001 	String aRet = rEditEngine.GetText( rSel, LINEEND_LF );
//STRIP001 	aRet.ConvertLineEnd();
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 SfxItemSet SmTextForwarder::GetAttribs( const ESelection& rSel, BOOL bOnlyHardAttrib ) const
//STRIP001 {
//STRIP001 	if( rSel.nStartPara == rSel.nEndPara )
//STRIP001 	{
//STRIP001 		sal_uInt8 nFlags = 0;
//STRIP001 		switch( bOnlyHardAttrib )
//STRIP001 		{
//STRIP001 		case EditEngineAttribs_All:
//STRIP001 			nFlags = GETATTRIBS_ALL;
//STRIP001 			break;
//STRIP001 		case EditEngineAttribs_HardAndPara:
//STRIP001 			nFlags = GETATTRIBS_PARAATTRIBS|GETATTRIBS_CHARATTRIBS;
//STRIP001 			break;
//STRIP001 		case EditEngineAttribs_OnlyHard:
//STRIP001 			nFlags = GETATTRIBS_CHARATTRIBS;
//STRIP001 			break;
//STRIP001 		default:
//STRIP001             DBG_ERROR("unknown flags for SmTextForwarder::GetAttribs");
//STRIP001 		}
//STRIP001 
//STRIP001 		return rEditEngine.GetAttribs( rSel.nStartPara, rSel.nStartPos, rSel.nEndPos, nFlags );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		return rEditEngine.GetAttribs( rSel, bOnlyHardAttrib );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 SfxItemSet SmTextForwarder::GetParaAttribs( USHORT nPara ) const
//STRIP001 {
//STRIP001 	SfxItemSet aSet( rEditEngine.GetParaAttribs( nPara ) );
//STRIP001 
//STRIP001 	USHORT nWhich = EE_PARA_START;
//STRIP001 	while( nWhich <= EE_PARA_END )
//STRIP001 	{
//STRIP001 		if( aSet.GetItemState( nWhich, TRUE ) != SFX_ITEM_ON )
//STRIP001 		{
//STRIP001 			if( rEditEngine.HasParaAttrib( nPara, nWhich ) )
//STRIP001 				aSet.Put( rEditEngine.GetParaAttrib( nPara, nWhich ) );
//STRIP001 		}
//STRIP001 		nWhich++;
//STRIP001 	}
//STRIP001 
//STRIP001 	return aSet;
//STRIP001 }
//STRIP001 
//STRIP001 void SmTextForwarder::SetParaAttribs( USHORT nPara, const SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	rEditEngine.SetParaAttribs( nPara, rSet );
//STRIP001 }
//STRIP001 
//STRIP001 SfxItemPool* SmTextForwarder::GetPool() const
//STRIP001 {
//STRIP001 	return rEditEngine.GetEmptyItemSet().GetPool();
//STRIP001 }
//STRIP001 
//STRIP001 void SmTextForwarder::GetPortions( USHORT nPara, SvUShorts& rList ) const
//STRIP001 {
//STRIP001 	rEditEngine.GetPortions( nPara, rList );
//STRIP001 }
//STRIP001 
//STRIP001 void SmTextForwarder::QuickInsertText( const String& rText, const ESelection& rSel )
//STRIP001 {
//STRIP001 	rEditEngine.QuickInsertText( rText, rSel );
//STRIP001 }
//STRIP001 
//STRIP001 void SmTextForwarder::QuickInsertLineBreak( const ESelection& rSel )
//STRIP001 {
//STRIP001 	rEditEngine.QuickInsertLineBreak( rSel );
//STRIP001 }
//STRIP001 
//STRIP001 void SmTextForwarder::QuickInsertField( const SvxFieldItem& rFld, const ESelection& rSel )
//STRIP001 {
//STRIP001 	rEditEngine.QuickInsertField( rFld, rSel );
//STRIP001 }
//STRIP001 
//STRIP001 void SmTextForwarder::QuickSetAttribs( const SfxItemSet& rSet, const ESelection& rSel )
//STRIP001 {
//STRIP001 	rEditEngine.QuickSetAttribs( rSet, rSel );
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SmTextForwarder::IsValid() const
//STRIP001 {
//STRIP001     // cannot reliably query EditEngine state
//STRIP001     // while in the middle of an update
//STRIP001     return rEditEngine.GetUpdateMode();
//STRIP001 }
//STRIP001 
//STRIP001 XubString SmTextForwarder::CalcFieldValue( const SvxFieldItem& rField, USHORT nPara, USHORT nPos, Color*& rpTxtColor, Color*& rpFldColor )
//STRIP001 {
//STRIP001 	return rEditEngine.CalcFieldValue( rField, nPara, nPos, rpTxtColor, rpFldColor );
//STRIP001 }
//STRIP001 
//STRIP001 USHORT GetSvxEditEngineItemState( EditEngine& rEditEngine, const ESelection& rSel, USHORT nWhich )
//STRIP001 {
//STRIP001 	EECharAttribArray aAttribs;
//STRIP001 
//STRIP001 	const SfxPoolItem*	pLastItem = NULL;
//STRIP001 
//STRIP001 	SfxItemState eState = SFX_ITEM_DEFAULT;
//STRIP001 
//STRIP001 	// check all paragraphs inside the selection
//STRIP001 	for( USHORT nPara = rSel.nStartPara; nPara <= rSel.nEndPara; nPara++ )
//STRIP001 	{
//STRIP001 		SfxItemState eParaState = SFX_ITEM_DEFAULT;
//STRIP001 
//STRIP001 		// calculate start and endpos for this paragraph
//STRIP001 		USHORT nPos = 0;
//STRIP001 		if( rSel.nStartPara == nPara )
//STRIP001 			nPos = rSel.nStartPos;
//STRIP001 
//STRIP001 		USHORT nEndPos = rSel.nEndPos;
//STRIP001 		if( rSel.nEndPara != nPara )
//STRIP001 			nEndPos = rEditEngine.GetTextLen( nPara );
//STRIP001 
//STRIP001 
//STRIP001 		// get list of char attribs
//STRIP001 		rEditEngine.GetCharAttribs( nPara, aAttribs );
//STRIP001 
//STRIP001 		BOOL bEmpty = TRUE;		// we found no item inside the selektion of this paragraph
//STRIP001 		BOOL bGaps  = FALSE;	// we found items but theire gaps between them
//STRIP001 		USHORT nLastEnd = nPos;
//STRIP001 
//STRIP001 		const SfxPoolItem* pParaItem = NULL;
//STRIP001 
//STRIP001 		for( USHORT nAttrib = 0; nAttrib < aAttribs.Count(); nAttrib++ )
//STRIP001 		{
//STRIP001 			struct EECharAttrib aAttrib = aAttribs.GetObject( nAttrib );
//STRIP001 			DBG_ASSERT( aAttrib.pAttr, "GetCharAttribs gives corrupt data" );
//STRIP001 
//STRIP001 			const sal_Bool bEmptyPortion = aAttrib.nStart == aAttrib.nEnd;
//STRIP001 			if( (!bEmptyPortion && (aAttrib.nStart >= nEndPos)) || (bEmptyPortion && (aAttrib.nStart > nEndPos)) )
//STRIP001 				break;	// break if we are already behind our selektion
//STRIP001 
//STRIP001 			if( (!bEmptyPortion && (aAttrib.nEnd <= nPos)) || (bEmptyPortion && (aAttrib.nEnd < nPos)) )
//STRIP001 				continue;	// or if the attribute ends before our selektion
//STRIP001 
//STRIP001 			if( aAttrib.pAttr->Which() != nWhich )
//STRIP001 				continue; // skip if is not the searched item
//STRIP001 
//STRIP001 			// if we already found an item
//STRIP001 			if( pParaItem )
//STRIP001 			{
//STRIP001 				// ... and its different to this one than the state is dont care
//STRIP001 				if( *pParaItem != *aAttrib.pAttr )
//STRIP001 					return SFX_ITEM_DONTCARE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pParaItem = aAttrib.pAttr;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bEmpty )
//STRIP001 				bEmpty = FALSE;
//STRIP001 
//STRIP001 			if( !bGaps && aAttrib.nStart > nLastEnd )
//STRIP001 				bGaps = TRUE;
//STRIP001 
//STRIP001 			nLastEnd = aAttrib.nEnd;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bEmpty && !bGaps && nLastEnd < ( nEndPos - 1 ) )
//STRIP001 			bGaps = TRUE;
//STRIP001 /*
//STRIP001 		// since we have no portion with our item or if there were gaps
//STRIP001 		if( bEmpty || bGaps )
//STRIP001 		{
//STRIP001 			// we need to check the paragraph item
//STRIP001 			const SfxItemSet& rParaSet = rEditEngine.GetParaAttribs( nPara );
//STRIP001 			if( rParaSet.GetItemState( nWhich ) == SFX_ITEM_SET )
//STRIP001 			{
//STRIP001 				eState = SFX_ITEM_SET;
//STRIP001 				// get item from the paragraph
//STRIP001 				const SfxPoolItem* pTempItem = rParaSet.GetItem( nWhich );
//STRIP001 				if( pParaItem )
//STRIP001 				{
//STRIP001 					if( *pParaItem != *pTempItem )
//STRIP001 						return SFX_ITEM_DONTCARE;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pParaItem = pTempItem;
//STRIP001 				}
//STRIP001 
//STRIP001 				// set if theres no last item or if its the same
//STRIP001 				eParaState = SFX_ITEM_SET;
//STRIP001 			}
//STRIP001 			else if( bEmpty )
//STRIP001 			{
//STRIP001 				eParaState = SFX_ITEM_DEFAULT;
//STRIP001 			}
//STRIP001 			else if( bGaps )
//STRIP001 			{
//STRIP001 				// gaps and item not set in paragraph, thats a dont care
//STRIP001 				return SFX_ITEM_DONTCARE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			eParaState = SFX_ITEM_SET;
//STRIP001 		}
//STRIP001 */
//STRIP001 		if( bEmpty )
//STRIP001 			eParaState = SFX_ITEM_DEFAULT;
//STRIP001 		else if( bGaps )
//STRIP001 			eParaState = SFX_ITEM_DONTCARE;
//STRIP001 		else
//STRIP001 			eParaState = SFX_ITEM_SET;
//STRIP001 
//STRIP001 		// if we already found an item check if we found the same
//STRIP001 		if( pLastItem )
//STRIP001 		{
//STRIP001 			if( (pParaItem == NULL) || (*pLastItem != *pParaItem) )
//STRIP001 				return SFX_ITEM_DONTCARE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pLastItem = pParaItem;
//STRIP001 			eState = eParaState;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return eState;
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetItemState( const ESelection& rSel, USHORT nWhich ) const
//STRIP001 {
//STRIP001 	return GetSvxEditEngineItemState( rEditEngine, rSel, nWhich );
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetItemState( USHORT nPara, USHORT nWhich ) const
//STRIP001 {
//STRIP001 	const SfxItemSet& rSet = rEditEngine.GetParaAttribs( nPara );
//STRIP001 	return rSet.GetItemState( nWhich );
//STRIP001 }
//STRIP001 
//STRIP001 LanguageType SmTextForwarder::GetLanguage( USHORT nPara, USHORT nIndex ) const
//STRIP001 {
//STRIP001     return rEditEngine.GetLanguage(nPara, nIndex);
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetFieldCount( USHORT nPara ) const
//STRIP001 {
//STRIP001     return rEditEngine.GetFieldCount(nPara);
//STRIP001 }
//STRIP001 
//STRIP001 EFieldInfo SmTextForwarder::GetFieldInfo( USHORT nPara, USHORT nField ) const
//STRIP001 {
//STRIP001     return rEditEngine.GetFieldInfo( nPara, nField );
//STRIP001 }
//STRIP001 
//STRIP001 EBulletInfo SmTextForwarder::GetBulletInfo( USHORT nPara ) const
//STRIP001 {
//STRIP001     return EBulletInfo();
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SmTextForwarder::GetCharBounds( USHORT nPara, USHORT nIndex ) const
//STRIP001 {
//STRIP001     // #108900# Handle virtual position one-past-the end of the string
//STRIP001     if( nIndex >= rEditEngine.GetTextLen(nPara) )
//STRIP001     {
//STRIP001         Rectangle aLast(0,0,0,0);
//STRIP001 
//STRIP001         if( nIndex )
//STRIP001             aLast = rEditEngine.GetCharacterBounds( EPosition(nPara, nIndex-1) );
//STRIP001 
//STRIP001         aLast.Move( aLast.Right() - aLast.Left(), 0 );
//STRIP001         aLast.SetSize( Size(1, rEditEngine.GetTextHeight()) );
//STRIP001         return aLast;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         return rEditEngine.GetCharacterBounds( EPosition(nPara, nIndex) );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SmTextForwarder::GetParaBounds( USHORT nPara ) const
//STRIP001 {
//STRIP001     const Point aPnt = rEditEngine.GetDocPosTopLeft( nPara );
//STRIP001     const ULONG nWidth = rEditEngine.CalcTextWidth();
//STRIP001     const ULONG nHeight = rEditEngine.GetTextHeight( nPara );
//STRIP001 
//STRIP001     return Rectangle( aPnt.X(), aPnt.Y(), aPnt.X() + nWidth, aPnt.Y() + nHeight );
//STRIP001 }
//STRIP001 
//STRIP001 MapMode SmTextForwarder::GetMapMode() const
//STRIP001 {
//STRIP001     return rEditEngine.GetRefMapMode();
//STRIP001 }
//STRIP001 
//STRIP001 OutputDevice* SmTextForwarder::GetRefDevice() const
//STRIP001 {
//STRIP001     return rEditEngine.GetRefDevice();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::GetIndexAtPoint( const Point& rPos, USHORT& nPara, USHORT& nIndex ) const
//STRIP001 {
//STRIP001     EPosition aDocPos = rEditEngine.FindDocPosition( rPos );
//STRIP001 
//STRIP001     nPara = aDocPos.nPara;
//STRIP001     nIndex = aDocPos.nIndex;
//STRIP001 
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::GetWordIndices( USHORT nPara, USHORT nIndex, USHORT& nStart, USHORT& nEnd ) const
//STRIP001 {
//STRIP001     ESelection aRes = rEditEngine.GetWord( ESelection(nPara, nIndex, nPara, nIndex), ::com::sun::star::i18n::WordType::DICTIONARY_WORD );
//STRIP001 
//STRIP001     if( aRes.nStartPara == nPara &&
//STRIP001         aRes.nStartPara == aRes.nEndPara )
//STRIP001     {
//STRIP001         nStart = aRes.nStartPos;
//STRIP001         nEnd = aRes.nEndPos;
//STRIP001 
//STRIP001         return sal_True;
//STRIP001     }
//STRIP001 
//STRIP001     return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::GetAttributeRun( USHORT& nStartIndex, USHORT& nEndIndex, USHORT nPara, USHORT nIndex ) const
//STRIP001 {
//STRIP001     return SvxEditSourceHelper::GetAttributeRun( nStartIndex, nEndIndex, rEditEngine, nPara, nIndex );
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetLineCount( USHORT nPara ) const
//STRIP001 {
//STRIP001     return rEditEngine.GetLineCount(nPara);
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetLineLen( USHORT nPara, USHORT nLine ) const
//STRIP001 {
//STRIP001     return rEditEngine.GetLineLen(nPara, nLine);
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::QuickFormatDoc( BOOL bFull )
//STRIP001 {
//STRIP001     rEditEngine.QuickFormatDoc();
//STRIP001 
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 USHORT SmTextForwarder::GetDepth( USHORT nPara ) const
//STRIP001 {
//STRIP001     // math has no outliner...
//STRIP001     return 0;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::SetDepth( USHORT nPara, USHORT nNewDepth )
//STRIP001 {
//STRIP001     // math has no outliner...
//STRIP001     return 0 == nNewDepth;  // is it the value from 'GetDepth' ?
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::Delete( const ESelection& rSelection )
//STRIP001 {
//STRIP001     rEditEngine.QuickDelete( rSelection );
//STRIP001     rEditEngine.QuickFormatDoc();
//STRIP001 
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmTextForwarder::InsertText( const String& rStr, const ESelection& rSelection )
//STRIP001 {
//STRIP001     rEditEngine.QuickInsertText( rStr, rSelection );
//STRIP001     rEditEngine.QuickFormatDoc();
//STRIP001 
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SmEditViewForwarder::SmEditViewForwarder( EditView& rView ) :
//STRIP001     rEditView( rView )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 SmEditViewForwarder::~SmEditViewForwarder()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SmEditViewForwarder::IsValid() const
//STRIP001 {
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SmEditViewForwarder::GetVisArea() const
//STRIP001 {
//STRIP001     OutputDevice* pOutDev = rEditView.GetWindow();
//STRIP001 
//STRIP001     if( pOutDev )
//STRIP001     {
//STRIP001         Rectangle aVisArea = rEditView.GetVisArea();
//STRIP001 
//STRIP001         // figure out map mode from edit engine
//STRIP001         EditEngine* pEditEngine = rEditView.GetEditEngine();
//STRIP001 
//STRIP001         if( pEditEngine )
//STRIP001         {
//STRIP001             MapMode aMapMode(pOutDev->GetMapMode());
//STRIP001             aVisArea = OutputDevice::LogicToLogic( aVisArea,
//STRIP001                                                    pEditEngine->GetRefMapMode(),
//STRIP001                                                    aMapMode.GetMapUnit() );
//STRIP001             aMapMode.SetOrigin(Point());
//STRIP001             return pOutDev->LogicToPixel( aVisArea, aMapMode );
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return Rectangle();
//STRIP001 }
//STRIP001 
//STRIP001 Point SmEditViewForwarder::LogicToPixel( const Point& rPoint, const MapMode& rMapMode ) const
//STRIP001 {
//STRIP001     OutputDevice* pOutDev = rEditView.GetWindow();
//STRIP001 
//STRIP001     if( pOutDev )
//STRIP001     {
//STRIP001         MapMode aMapMode(pOutDev->GetMapMode());
//STRIP001         Point aPoint( OutputDevice::LogicToLogic( rPoint, rMapMode,
//STRIP001                                                   aMapMode.GetMapUnit() ) );
//STRIP001         aMapMode.SetOrigin(Point());
//STRIP001         return pOutDev->LogicToPixel( aPoint, aMapMode );
//STRIP001     }
//STRIP001 
//STRIP001     return Point();
//STRIP001 }
//STRIP001 
//STRIP001 Point SmEditViewForwarder::PixelToLogic( const Point& rPoint, const MapMode& rMapMode ) const
//STRIP001 {
//STRIP001     OutputDevice* pOutDev = rEditView.GetWindow();
//STRIP001 
//STRIP001     if( pOutDev )
//STRIP001     {
//STRIP001         MapMode aMapMode(pOutDev->GetMapMode());
//STRIP001         aMapMode.SetOrigin(Point());
//STRIP001         Point aPoint( pOutDev->PixelToLogic( rPoint, aMapMode ) );
//STRIP001         return OutputDevice::LogicToLogic( aPoint,
//STRIP001                                            aMapMode.GetMapUnit(),
//STRIP001                                            rMapMode );
//STRIP001     }
//STRIP001 
//STRIP001     return Point();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmEditViewForwarder::GetSelection( ESelection& rSelection ) const
//STRIP001 {
//STRIP001     rSelection = rEditView.GetSelection();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmEditViewForwarder::SetSelection( const ESelection& rSelection )
//STRIP001 {
//STRIP001     rEditView.SetSelection( rSelection );
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmEditViewForwarder::Copy()
//STRIP001 {
//STRIP001     rEditView.Copy();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmEditViewForwarder::Cut()
//STRIP001 {
//STRIP001     rEditView.Cut();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SmEditViewForwarder::Paste()
//STRIP001 {
//STRIP001     rEditView.Paste();
//STRIP001     return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 SmEditAccessible::SmEditAccessible( SmEditWindow *pEditWin ) :
//STRIP001     aAccName            ( String(SmResId(STR_CMDBOXWINDOW)) ),
//STRIP001     pWin                (pEditWin),
//STRIP001     pTextHelper         (0)
//STRIP001 {
//STRIP001     DBG_ASSERT( pWin, "SmEditAccessible: window missing" );
//STRIP001     //++aRefCount;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SmEditAccessible::SmEditAccessible( const SmEditAccessible &rSmAcc ) :
//STRIP001     aAccName            ( String(SmResId(STR_CMDBOXWINDOW)) )
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     pWin = rSmAcc.pWin;
//STRIP001     DBG_ASSERT( pWin, "SmEditAccessible: window missing" );
//STRIP001     //++aRefCount;
//STRIP001 }
//STRIP001 
//STRIP001 SmEditAccessible::~SmEditAccessible()
//STRIP001 {
//STRIP001     delete pTextHelper;
//STRIP001 /*
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (--aRefCount == 0)
//STRIP001     {
//STRIP001     }
//STRIP001 */
//STRIP001 }
//STRIP001 
//STRIP001 void SmEditAccessible::Init()
//STRIP001 {
//STRIP001     DBG_ASSERT( pWin, "SmEditAccessible: window missing" );
//STRIP001     if (pWin)
//STRIP001     {
//STRIP001         EditEngine *pEditEngine = pWin->GetEditEngine();
//STRIP001         EditView   *pEditView   = pWin->GetEditView();
//STRIP001         if (pEditEngine && pEditView)
//STRIP001         {
//STRIP001             ::std::auto_ptr< SvxEditSource > pEditSource(
//STRIP001                     new SmEditSource( pWin, *pEditEngine, *pEditView ) );
//STRIP001             pTextHelper = new ::accessibility::AccessibleTextHelper( pEditSource );
//STRIP001             pTextHelper->SetEventSource( this );
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 SmDocShell * SmEditAccessible::GetDoc_Impl()
//STRIP001 {
//STRIP001     SmViewShell *pView = pWin ? pWin->GetView() : 0;
//STRIP001     return pView ? pView->GetDoc() : 0;
//STRIP001 }
//STRIP001 
//STRIP001 void SmEditAccessible::ClearWin()
//STRIP001 {
//STRIP001     pWin = 0;   // implicitly results in AccessibleStateType::DEFUNC set
//STRIP001 
//STRIP001     //! make TextHelper implicitly release C++ references to some core objects
//STRIP001     pTextHelper->SetEditSource( ::std::auto_ptr<SvxEditSource>(NULL) );
//STRIP001     //! make TextHelper release references
//STRIP001     //! (e.g. the one set by the 'SetEventSource' call)
//STRIP001     pTextHelper->Dispose();
//STRIP001     delete pTextHelper;     pTextHelper = 0;
//STRIP001 }
//STRIP001 
//STRIP001 // XAccessible
//STRIP001 uno::Reference< XAccessibleContext > SAL_CALL SmEditAccessible::getAccessibleContext(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return this;
//STRIP001 }
//STRIP001 
//STRIP001 // XAccessibleComponent
//STRIP001 sal_Bool SAL_CALL SmEditAccessible::containsPoint( const awt::Point& aPoint )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //! the arguments coordinates are relativ to the current window !
//STRIP001     //! Thus the top left-point is (0, 0)
//STRIP001 
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001 
//STRIP001     Size aSz( pWin->GetSizePixel() );
//STRIP001     return  aPoint.X >= 0  &&  aPoint.Y >= 0  &&
//STRIP001             aPoint.X < aSz.Width()  &&  aPoint.Y < aSz.Height();
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessible > SAL_CALL SmEditAccessible::getAccessibleAtPoint( const awt::Point& aPoint )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pTextHelper)
//STRIP001         throw RuntimeException();
//STRIP001     return pTextHelper->GetAt( aPoint );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Rectangle SAL_CALL SmEditAccessible::getBounds(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001     return lcl_GetBounds( pWin );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Point SAL_CALL SmEditAccessible::getLocation(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001     awt::Rectangle aRect( lcl_GetBounds( pWin ) );
//STRIP001     return awt::Point( aRect.X, aRect.Y );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Point SAL_CALL SmEditAccessible::getLocationOnScreen(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001     return lcl_GetLocationOnScreen( pWin );
//STRIP001 }
//STRIP001 
//STRIP001 awt::Size SAL_CALL SmEditAccessible::getSize(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     DBG_ASSERT(pWin->GetParent()->GetAccessible() == getAccessibleParent(),
//STRIP001             "mismatch of window parent and accessible parent" );
//STRIP001 
//STRIP001     Size aSz( pWin->GetSizePixel() );
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     awt::Rectangle aRect( lcl_GetBounds( pWin ) );
//STRIP001     Size aSz2( aRect.Width, aRect.Height );
//STRIP001     DBG_ASSERT( aSz == aSz2, "mismatch in width" );
//STRIP001 #endif
//STRIP001     return awt::Size( aSz.Width(), aSz.Height() );
//STRIP001 }
//STRIP001 
//STRIP001 void SAL_CALL SmEditAccessible::grabFocus(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001 
//STRIP001     pWin->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmEditAccessible::getForeground()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     return (sal_Int32) pWin->GetTextColor().GetColor();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmEditAccessible::getBackground()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001     Wallpaper aWall( pWin->GetDisplayBackground() );
//STRIP001     ColorData nCol;
//STRIP001     if (aWall.IsBitmap() || aWall.IsGradient())
//STRIP001         nCol = pWin->GetSettings().GetStyleSettings().GetWindowColor().GetColor();
//STRIP001     else
//STRIP001         nCol = aWall.GetColor().GetColor();
//STRIP001     return (sal_Int32) nCol;
//STRIP001 }
//STRIP001 
//STRIP001 // XAccessibleContext
//STRIP001 sal_Int32 SAL_CALL SmEditAccessible::getAccessibleChildCount(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pTextHelper)
//STRIP001         throw RuntimeException();
//STRIP001     return pTextHelper->GetChildCount();
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessible > SAL_CALL SmEditAccessible::getAccessibleChild( sal_Int32 i )
//STRIP001     throw (IndexOutOfBoundsException, RuntimeException)
//STRIP001 {
//STRIP001     vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pTextHelper)
//STRIP001         throw RuntimeException();
//STRIP001     return pTextHelper->GetChild( i );
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessible > SAL_CALL SmEditAccessible::getAccessibleParent(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (!pWin)
//STRIP001         throw RuntimeException();
//STRIP001 
//STRIP001     Window *pAccParent = pWin->GetAccessibleParentWindow();
//STRIP001     DBG_ASSERT( pAccParent, "accessible parent missing" );
//STRIP001     return pAccParent ? pAccParent->GetAccessible() : Reference< XAccessible >();
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int32 SAL_CALL SmEditAccessible::getAccessibleIndexInParent(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     sal_Int32 nIdx = -1;
//STRIP001     Window *pAccParent = pWin ? pWin->GetAccessibleParentWindow() : 0;
//STRIP001     if (pAccParent)
//STRIP001     {
//STRIP001         USHORT nCnt = pAccParent->GetAccessibleChildWindowCount();
//STRIP001         for (USHORT i = 0;  i < nCnt  &&  nIdx == -1;  ++i)
//STRIP001             if (pAccParent->GetAccessibleChildWindow( i ) == pWin)
//STRIP001                 nIdx = i;
//STRIP001     }
//STRIP001     return nIdx;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Int16 SAL_CALL SmEditAccessible::getAccessibleRole(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return AccessibleRole::PANEL /*TEXT ?*/;
//STRIP001 }
//STRIP001 
//STRIP001 ::rtl::OUString SAL_CALL SmEditAccessible::getAccessibleDescription(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return OUString();  // empty as agreed with product-management
//STRIP001 }
//STRIP001 
//STRIP001 ::rtl::OUString SAL_CALL SmEditAccessible::getAccessibleName(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     // same name as displayed by the window when not docked
//STRIP001     return aAccName;
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessibleRelationSet > SAL_CALL SmEditAccessible::getAccessibleRelationSet(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     Reference< XAccessibleRelationSet > xRelSet = new utl::AccessibleRelationSetHelper();
//STRIP001     return xRelSet;   // empty relation set
//STRIP001 }
//STRIP001 
//STRIP001 uno::Reference< XAccessibleStateSet > SAL_CALL SmEditAccessible::getAccessibleStateSet(  )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001 	::utl::AccessibleStateSetHelper *pStateSet =
//STRIP001             new ::utl::AccessibleStateSetHelper;
//STRIP001 
//STRIP001 	Reference<XAccessibleStateSet> xStateSet( pStateSet );
//STRIP001 
//STRIP001     if (!pWin || !pTextHelper)
//STRIP001         pStateSet->AddState( AccessibleStateType::DEFUNC );
//STRIP001     else
//STRIP001     {
//STRIP001         //pStateSet->AddState( AccessibleStateType::EDITABLE );
//STRIP001         pStateSet->AddState( AccessibleStateType::MULTI_LINE );
//STRIP001         //pStateSet->AddState( AccessibleStateType::HORIZONTAL );
//STRIP001         //pStateSet->AddState( AccessibleStateType::TRANSIENT );
//STRIP001         pStateSet->AddState( AccessibleStateType::ENABLED );
//STRIP001         pStateSet->AddState( AccessibleStateType::FOCUSABLE );
//STRIP001         if (pWin->HasFocus())
//STRIP001             pStateSet->AddState( AccessibleStateType::FOCUSED );
//STRIP001         if (pWin->IsActive())
//STRIP001             pStateSet->AddState( AccessibleStateType::ACTIVE );
//STRIP001         if (pWin->IsVisible())
//STRIP001             pStateSet->AddState( AccessibleStateType::SHOWING );
//STRIP001         if (pWin->IsReallyVisible())
//STRIP001             pStateSet->AddState( AccessibleStateType::VISIBLE );
//STRIP001         if (COL_TRANSPARENT != pWin->GetBackground().GetColor().GetColor())
//STRIP001             pStateSet->AddState( AccessibleStateType::OPAQUE );
//STRIP001     }
//STRIP001 
//STRIP001 	return xStateSet;
//STRIP001 }
//STRIP001 
//STRIP001 Locale SAL_CALL SmEditAccessible::getLocale(  )
//STRIP001     throw (IllegalAccessibleComponentStateException, RuntimeException)
//STRIP001 {
//STRIP001 	vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     // should be the document language...
//STRIP001     // We use the language of the localized symbol names here.
//STRIP001     return Application::GetSettings().GetUILocale();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // XAccessibleEventBroadcaster
//STRIP001 void SAL_CALL SmEditAccessible::addEventListener( const uno::Reference< XAccessibleEventListener >& xListener )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (pTextHelper)   // not disposing (about to destroy view shell)
//STRIP001         pTextHelper->AddEventListener( xListener );
//STRIP001 }
//STRIP001 
//STRIP001 void SAL_CALL SmEditAccessible::removeEventListener( const uno::Reference< XAccessibleEventListener >& xListener )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     if (pTextHelper)   // not disposing (about to destroy view shell)
//STRIP001         pTextHelper->RemoveEventListener( xListener );
//STRIP001 }
//STRIP001 
//STRIP001 OUString SAL_CALL SmEditAccessible::getImplementationName()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return C2U("SmEditAccessible");
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SAL_CALL SmEditAccessible::supportsService(
//STRIP001         const OUString& rServiceName )
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     return  rServiceName == C2U( "com::sun::star::accessibility::Accessible" ) ||
//STRIP001             rServiceName == C2U( "com::sun::star::accessibility::AccessibleComponent" ) ||
//STRIP001             rServiceName == C2U( "com::sun::star::accessibility::AccessibleContext" );
//STRIP001 }
//STRIP001 
//STRIP001 Sequence< OUString > SAL_CALL SmEditAccessible::getSupportedServiceNames()
//STRIP001     throw (RuntimeException)
//STRIP001 {
//STRIP001     //vos::OGuard aGuard(Application::GetSolarMutex());
//STRIP001     Sequence< OUString > aNames(3);
//STRIP001     OUString *pNames = aNames.getArray();
//STRIP001     pNames[0] = C2U( "com::sun::star::accessibility::Accessible" );
//STRIP001     pNames[1] = C2U( "com::sun::star::accessibility::AccessibleComponent" );
//STRIP001     pNames[2] = C2U( "com::sun::star::accessibility::AccessibleContext" );
//STRIP001     return aNames;
//STRIP001 }
//STRIP001 
//STRIP001 //////////////////////////////////////////////////////////////////////

}
