/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_templdlg.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:04:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// auto strip #ifndef _MENU_HXX //autogen
// auto strip #include <vcl/menu.hxx>
// auto strip #endif
#ifndef _SFXINTITEM_HXX //autogen
#include <svtools/intitem.hxx>
#endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _EMBOBJ_HXX //autogen
// auto strip #include <so3/embobj.hxx>
// auto strip #endif
#ifndef _SFXSTYLE_HXX //autogen
#include <svtools/style.hxx>
#endif
// auto strip #ifndef _IFACE_HXX //autogen
// auto strip #include <so3/iface.hxx>
// auto strip #endif
#pragma hdrstop

#define _SVSTDARR_STRINGSDTOR
// auto strip #include <svtools/svstdarr.hxx>

// auto strip #ifndef _UNOTOOLS_PROCESSFACTORY_HXX
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_INTLWRAPPER_HXX
// auto strip #include <unotools/intlwrapper.hxx>
// auto strip #endif

// auto strip #include "sfxhelp.hxx"
// auto strip #include "app.hxx"
#include "dispatch.hxx"
// auto strip #include "bindings.hxx"
// auto strip #include "templdlg.hxx"
#include "templdgi.hxx"
#include "tplcitem.hxx"
#include "sfxtypes.hxx"
#include "styfitem.hxx"
// auto strip #include "objsh.hxx"
#include "viewsh.hxx"
// auto strip #include "newstyle.hxx"
#include "tplpitem.hxx"
#include "sfxresid.hxx"

#include "templdlg.hrc"
#include "sfx.hrc"
#include "dialog.hrc"
// auto strip #include "arrdecl.hxx"
// auto strip #include "fltfnc.hxx"
// auto strip #include "docfilt.hxx"
// auto strip #include "docfac.hxx"
// auto strip #include "docvor.hxx"
// auto strip #include "doctempl.hxx"
// auto strip #include "module.hxx"
#include "imgmgr.hxx"
#include "helpid.hrc"
// auto strip #include "appdata.hxx"
#include "objshimp.hxx"
#include "viewfrm.hxx"

// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

namespace binfilter {

//=========================================================================

// Fenster wird ab jetzt dynamisch erstellt. Daher hier R"ander usw.

#define SFX_TEMPLDLG_HFRAME			3
#define SFX_TEMPLDLG_VTOPFRAME		3

#ifdef MAC
#define SFX_TEMPLDLG_VBOTFRAME		8
#else
#define SFX_TEMPLDLG_VBOTFRAME		3
#endif

#define SFX_TEMPLDLG_MIDHSPACE		3
#define SFX_TEMPLDLG_MIDVSPACE		3
#define SFX_TEMPLDLG_FILTERHEIGHT	100

static USHORT nLastItemId = USHRT_MAX;

//=========================================================================

/*N*/ TYPEINIT0(SfxCommonTemplateDialog_Impl);
/*N*/ TYPEINIT1(SfxTemplateDialog_Impl,SfxCommonTemplateDialog_Impl);
//STRIP001 TYPEINIT1(SfxTemplateCatalog_Impl,SfxCommonTemplateDialog_Impl);

/*N*/ SFX_IMPL_DOCKINGWINDOW(SfxTemplateDialogWrapper, SID_STYLE_DESIGNER)

//-------------------------------------------------------------------------

// Redirektionsfunktionen

/*N*/ SfxTemplateDialog::SfxTemplateDialog
/*N*/ (
/*N*/ 	SfxBindings *pBindings,
/*N*/ 	SfxChildWindow *pCW,
/*N*/ 	Window *pParent
/*N*/ )

/*  [Beschreibung]
	Gestalterklasse.
*/
/*N*/ 	: SfxDockingWindow( pBindings, pCW, pParent, SfxResId(DLG_STYLE_DESIGNER) ),
/*N*/ 
/*N*/ 	pImpl( new SfxTemplateDialog_Impl( pParent, pBindings, this ) )
/*N*/ 
/*N*/ {
/*N*/ 	pImpl->updateNonFamilyImages();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxTemplateDialog::~SfxTemplateDialog()
/*N*/ {
/*N*/ 	delete pImpl;
/*N*/ }

/*N*/ ISfxTemplateCommon* SfxTemplateDialog::GetISfxTemplateCommon()
/*N*/ {
/*N*/ 	return pImpl->GetISfxTemplateCommon();
/*N*/ }

// ------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog::DataChanged( const DataChangedEvent& _rDCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( ( DATACHANGED_SETTINGS == _rDCEvt.GetType() ) &&
//STRIP001 		 ( 0 != ( SETTINGS_STYLE & _rDCEvt.GetFlags() ) ) )
//STRIP001 	{
//STRIP001 		pImpl->updateFamilyImages();
//STRIP001 		pImpl->updateNonFamilyImages();
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxDockingWindow::DataChanged( _rDCEvt );
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog::Update()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	pImpl->Update();
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog::Resize()
/*N*/ {
/*N*/ 	if(pImpl)
/*N*/ 		pImpl->Resize();
/*N*/ 	SfxDockingWindow::Resize();
/*N*/ }


//-------------------------------------------------------------------------

/*N*/ SfxChildAlignment SfxTemplateDialog::CheckAlignment(SfxChildAlignment eActAlign,SfxChildAlignment eAlign)
/*N*/ {
/*N*/ 	switch (eAlign)
/*N*/ 	{
/*N*/ 		case SFX_ALIGN_TOP:
/*N*/ 		case SFX_ALIGN_HIGHESTTOP:
/*N*/ 		case SFX_ALIGN_LOWESTTOP:
/*N*/ 		case SFX_ALIGN_BOTTOM:
/*N*/ 		case SFX_ALIGN_LOWESTBOTTOM:
/*N*/ 		case SFX_ALIGN_HIGHESTBOTTOM:
/*N*/ 			return eActAlign;
/*N*/ 			break;
/*N*/ 
/*N*/ 		case SFX_ALIGN_LEFT:
/*N*/ 		case SFX_ALIGN_RIGHT:
/*N*/ 		case SFX_ALIGN_FIRSTLEFT:
/*N*/ 		case SFX_ALIGN_LASTLEFT:
/*N*/ 		case SFX_ALIGN_FIRSTRIGHT:
/*N*/ 		case SFX_ALIGN_LASTRIGHT:
/*N*/ 			return eAlign;
/*N*/ 			break;
/*N*/ 
/*N*/ 		default:
/*N*/ 			return eAlign;
/*N*/ 			break;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 SfxTemplateCatalog::SfxTemplateCatalog(Window *pParent, SfxBindings *pBindings)
//STRIP001  : SfxModalDialog(pParent,SfxResId(RID_STYLECATALOG))
//STRIP001 {
//STRIP001 	pImpl = new SfxTemplateCatalog_Impl(pParent, pBindings, this);
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SfxTemplateCatalog::~SfxTemplateCatalog()
//STRIP001 {
//STRIP001 	delete pImpl;
//STRIP001 }

//-------------------------------------------------------------------------

/*?*/ void DropListBox_Impl::MouseButtonDown( const MouseEvent& rMEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	nModifier = rMEvt.GetModifier();
//STRIP001 
//STRIP001 	BOOL bHitEmptySpace = ( NULL == GetEntry( rMEvt.GetPosPixel(), TRUE ) );
//STRIP001 	if( bHitEmptySpace && ( rMEvt.GetClicks() == 2 ) && rMEvt.IsMod1() )
//STRIP001 		Control::MouseButtonDown( rMEvt );
//STRIP001 	else
//STRIP001 		SvTreeListBox::MouseButtonDown( rMEvt );
/*?*/ }

/*?*/ sal_Int8 DropListBox_Impl::AcceptDrop( const AcceptDropEvent& rEvt )

/*  [Beschreibung ]

	Droppen eigentlich immer dann erlaubt, wenn von den selektieren
	Objekten ine Stylesheet erstellt werden kann und der Dragvorgang
	von der Selektion aus gestartet wurde.
	Hier vereinfachend: Es liegen Daten im Clipboardformat der
	Applikation vor. Cave mehrere Writer gleichzeitig!
*/

/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	if ( IsDropFormatSupported( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR ) )
//STRIP001 	{
//STRIP001 		SvLBoxEntry* pEntry = GetEntry( rEvt.maPosPixel, TRUE );
//STRIP001 		if ( pPreDropEntry && ( pEntry != pPreDropEntry || rEvt.mbLeaving ) )
//STRIP001 		{
//STRIP001 			ShowTargetEmphasis( pPreDropEntry, FALSE );
//STRIP001 			pPreDropEntry = 0;
//STRIP001 		}
//STRIP001 		if ( pEntry && pEntry != pPreDropEntry && !rEvt.mbLeaving )
//STRIP001 		{
//STRIP001 			ShowTargetEmphasis( pEntry, TRUE );
//STRIP001 			pPreDropEntry = pEntry;
//STRIP001 		}
//STRIP001 		if ( !pEntry && pDialog->bNewByExampleDisabled || pEntry && pDialog->bUpdateByExampleDisabled )
//STRIP001 			return DND_ACTION_NONE;
//STRIP001 		else
//STRIP001 			return DND_ACTION_COPY;
//STRIP001 	}
//STRIP001 
//STRIP001 	return SvTreeListBox::AcceptDrop( rEvt );
/*?*/ }

//-------------------------------------------------------------------------

/*?*/ sal_Int8 DropListBox_Impl::ExecuteDrop( const ExecuteDropEvent& rEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 //	rEvt.maDropEvent.Context->acceptDrop( DND_ACTION_NONE );
//STRIP001 //	rEvt.maDropEvent.Context->dropComplete( TRUE );
//STRIP001 
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 	SfxObjectShell* pDocShell = pDialog->GetObjectShell();
//STRIP001 	TransferableDataHelper aHelper( rEvt.maDropEvent.Transferable );
//STRIP001 	sal_uInt32 nFormatCount = aHelper.GetFormatCount();
//STRIP001 	if ( pDocShell )
//STRIP001 	{
//STRIP001 		sal_Bool bFormatFound = sal_False;
//STRIP001 
//STRIP001 		for ( sal_uInt32 i = 0; i < nFormatCount; ++i )
//STRIP001 		{
//STRIP001 			SotFormatStringId nId = aHelper.GetFormat(i);
//STRIP001 			TransferableObjectDescriptor aDesc;
//STRIP001 
//STRIP001 			if ( aHelper.GetTransferableObjectDescriptor( nId, aDesc ) )
//STRIP001 			{
//STRIP001 		    	if ( pDocShell->GetFactory() == aDesc.maClassName )
//STRIP001 				{
//STRIP001 					SvLBoxEntry* pEntry = GetEntry( rEvt.maPosPixel, TRUE );
//STRIP001 
//STRIP001 					if ( pEntry && pEntry != pPreDropEntry )
//STRIP001 						ShowTargetEmphasis( pEntry, FALSE );
//STRIP001 
//STRIP001 					PostUserEvent( LINK( this, DropListBox_Impl, OnAsyncExecuteDrop ), pEntry );
//STRIP001 
//STRIP001 					bFormatFound = sal_True;
//STRIP001 					nRet =  rEvt.mnAction;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( !bFormatFound )
//STRIP001 			return SvTreeListBox::ExecuteDrop( rEvt );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
/*?*/ }


//STRIP001 IMPL_LINK( DropListBox_Impl, OnAsyncExecuteDrop, SvLBoxEntry*, pEntry )
//STRIP001 {
//STRIP001 	if ( pEntry )
//STRIP001 	{
//STRIP001 		pDialog->SelectStyle( GetEntryText( pEntry )  );
//STRIP001 		pDialog->ActionSelect( SID_STYLE_UPDATE_BY_EXAMPLE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pDialog->ActionSelect( SID_STYLE_NEW_BY_EXAMPLE );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


//STRIP001 IMPL_LINK( DropListBox_Impl, OnAsyncExecuteError, void*, NOTINTERESTEDIN )
//STRIP001 {
//STRIP001 	ErrorHandler::HandleError( ERRCODE_IO_WRONGFORMAT );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }


/*?*/ long DropListBox_Impl::Notify( NotifyEvent& rNEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001     long nRet = 0;
//STRIP001     if( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyCode&	rKeyCode = rNEvt.GetKeyEvent()->GetKeyCode();
//STRIP001         if(!rKeyCode.GetModifier())
//STRIP001         {
//STRIP001             if( pDialog->bCanDel && KEY_DELETE == rKeyCode.GetCode())
//STRIP001             {
//STRIP001                 pDialog->DeleteHdl( NULL );
//STRIP001                 nRet =  1;
//STRIP001             }
//STRIP001             else if( KEY_RETURN == rKeyCode.GetCode())
//STRIP001             {
//STRIP001                 GetDoubleClickHdl().Call(this);
//STRIP001                 nRet = 1;
//STRIP001             }
//STRIP001         }
//STRIP001 	}
//STRIP001     if(!nRet)
//STRIP001         nRet = SvTreeListBox::Notify( rNEvt );
//STRIP001     return nRet;
/*?*/ }


//-------------------------------------------------------------------------


/*N*/ SfxActionListBox::SfxActionListBox
/*N*/ (
/*N*/ 	SfxCommonTemplateDialog_Impl* pParent,
/*N*/ 	WinBits nWinBits
/*N*/ )

/*  [Beschreibung]

	ListBox- Klasse, die im Command-Handler ein PopupMenu (Gestalter
	spezifisch) startet.

*/

/*N*/ :       DropListBox_Impl(pParent->GetWindow(), nWinBits, pParent)
/*N*/ 
/*N*/ {
/*N*/ 	EnableContextMenuHandling();
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 SfxActionListBox::SfxActionListBox( SfxCommonTemplateDialog_Impl* pParent,
//STRIP001 									const ResId &rResId) :
//STRIP001 	DropListBox_Impl(pParent->GetWindow(), rResId, pParent)
//STRIP001 {
//STRIP001 	EnableContextMenuHandling();
//STRIP001 }

//-------------------------------------------------------------------------

/*?*/ PopupMenu* SfxActionListBox::CreateContextMenu( void )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001 	//added by BerryJia for fixing Bug102739 2002-9-9 17:00(Beijing Time)
//STRIP001 	if( !( GetSelectionCount() > 0 ) )
//STRIP001 	{
//STRIP001 		pDialog->EnableEdit( FALSE );
//STRIP001 		pDialog->EnableDel( FALSE );
//STRIP001 	}
//STRIP001 	return pDialog->CreateContextMenu();
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ SfxTemplateDialogWrapper::SfxTemplateDialogWrapper(Window *pParent,
/*N*/ 		USHORT nId,  SfxBindings *p, SfxChildWinInfo *pInfo) :
/*N*/ 	SfxChildWindow(pParent, nId)
/*N*/ {
/*N*/ 	SfxTemplateDialog *pWin = new SfxTemplateDialog(p, this, pParent);
/*N*/ 	pWindow = pWin;
/*N*/ 	eChildAlignment = SFX_ALIGN_NOALIGNMENT;
/*N*/ 
/*N*/ 	pWin->Initialize( pInfo );
/*N*/ 	pWin->SetMinOutputSizePixel(pWin->pImpl->GetMinOutputSizePixel());
/*N*/ }

//=========================================================================
//STRIP001 SV_DECL_PTRARR_DEL(ExpandedEntries, StringPtr,16,8)
//STRIP001 SV_IMPL_PTRARR(ExpandedEntries, StringPtr)

/*  [Beschreibung]

	TreeListBox- Klasse f"ur die Anzeige der hierarchischen View
	der Vorlagen

*/

//STRIP001 class StyleTreeListBox_Impl : public DropListBox_Impl
//STRIP001 {
//STRIP001 private:
//STRIP001 	SvLBoxEntry*					pCurEntry;
//STRIP001 	SfxCommonTemplateDialog_Impl*	pCommon;
//STRIP001 	Link            				aDoubleClickLink;
//STRIP001 	Link            				aDropLink;
//STRIP001 	String          				aParent;
//STRIP001 	String          				aStyle;
//STRIP001 
//STRIP001 protected:
//STRIP001 	virtual void    Command( const CommandEvent& rMEvt );
//STRIP001 	virtual long 	Notify( NotifyEvent& rNEvt );
//STRIP001 	virtual BOOL    DoubleClickHdl();
//STRIP001 	virtual long    ExpandingHdl();
//STRIP001 	virtual void    ExpandedHdl();
//STRIP001 	virtual BOOL    NotifyMoving(SvLBoxEntry*  pTarget,
//STRIP001 								 SvLBoxEntry*  pEntry,
//STRIP001 								 SvLBoxEntry*& rpNewParent,
//STRIP001 								 ULONG&        rNewChildPos);
//STRIP001 public:
//STRIP001 	StyleTreeListBox_Impl( SfxCommonTemplateDialog_Impl* pParent, WinBits nWinStyle = 0);
//STRIP001 
//STRIP001 	void 				SetDoubleClickHdl(const Link &rLink) { aDoubleClickLink = rLink; }
//STRIP001 	void 				SetDropHdl(const Link &rLink) { aDropLink = rLink; }
//STRIP001 	const String&		GetParent() const { return aParent; }
//STRIP001 	const String&		GetStyle() const { return aStyle; }
//STRIP001 	void 				MakeExpanded_Impl(ExpandedEntries& rEntries) const;
//STRIP001 
//STRIP001 	virtual PopupMenu*	CreateContextMenu( void );
//STRIP001 };

//-------------------------------------------------------------------------


//STRIP001 void StyleTreeListBox_Impl::MakeExpanded_Impl(ExpandedEntries& rEntries) const
//STRIP001 {
//STRIP001 	SvLBoxEntry *pEntry;
//STRIP001 	USHORT nCount=0;
//STRIP001 	for(pEntry=(SvLBoxEntry*)FirstVisible();pEntry;pEntry=(SvLBoxEntry*)NextVisible(pEntry))
//STRIP001 	{
//STRIP001 		if(IsExpanded(pEntry))
//STRIP001 		{
//STRIP001 			StringPtr pString=new String(GetEntryText(pEntry));
//STRIP001 			rEntries.Insert(pString,nCount++);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 PopupMenu* StyleTreeListBox_Impl::CreateContextMenu()
//STRIP001 {
//STRIP001 	return pDialog->CreateContextMenu();
//STRIP001 }

//STRIP001 BOOL StyleTreeListBox_Impl::DoubleClickHdl()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 
//STRIP001 	DoubleClick-Handler; ruft entsprechenden Link.
//STRIP001 	Virtuelle Methode aus SV.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	aDoubleClickLink.Call(this);
//STRIP001 	return FALSE;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void StyleTreeListBox_Impl::Command( const CommandEvent& rCEvt )
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	::com::mand Handler; dieser executed ein PopupMenu (Gestalter
//STRIP001 	spezifisch).
//STRIP001 	Virtuelle Methode aus SV.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	SvTreeListBox::Command(rCEvt);
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 long StyleTreeListBox_Impl::Notify( NotifyEvent& rNEvt )
//STRIP001 {
//STRIP001 	// handle <RETURN> as double click
//STRIP001 
//STRIP001 	long nRet = 0;
//STRIP001     if ( rNEvt.GetType() == EVENT_KEYINPUT )
//STRIP001 	{
//STRIP001 		const KeyCode&	rKeyCode = rNEvt.GetKeyEvent()->GetKeyCode();
//STRIP001         if ( !rKeyCode.GetModifier() && KEY_RETURN == rKeyCode.GetCode() )
//STRIP001         {
//STRIP001 			aDoubleClickLink.Call( this );
//STRIP001             nRet = 1;
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( !nRet )
//STRIP001         nRet = DropListBox_Impl::Notify( rNEvt );
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL StyleTreeListBox_Impl::NotifyMoving(SvLBoxEntry*  pTarget,
//STRIP001 										 SvLBoxEntry*  pEntry,
//STRIP001 										 SvLBoxEntry*& rpNewParent,
//STRIP001 										 ULONG& lPos)
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	NotifyMoving Handler; dieser leitet per Link das Event an den Dialog
//STRIP001 	weiter.
//STRIP001 	Virtuelle Methode aus SV.
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	if(!pTarget || !pEntry)
//STRIP001 		return FALSE;
//STRIP001 	aParent = GetEntryText(pTarget);
//STRIP001 	aStyle  = GetEntryText(pEntry);
//STRIP001 	const BOOL bRet = (BOOL)aDropLink.Call(this);
//STRIP001 	rpNewParent = pTarget;
//STRIP001 	lPos=0;
//STRIP001 	IntlWrapper aIntlWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 	const CollatorWrapper* pCollator = aIntlWrapper.getCaseCollator();
//STRIP001 	for(SvLBoxEntry *pTmpEntry=FirstChild(pTarget);
//STRIP001 		pTmpEntry && COMPARE_LESS==pCollator->compareString(
//STRIP001 			GetEntryText(pTmpEntry),GetEntryText(pEntry));
//STRIP001 		pTmpEntry=NextSibling(pTmpEntry),lPos++);
//STRIP001 
//STRIP001 	return bRet? (BOOL)2: FALSE;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 long  StyleTreeListBox_Impl::ExpandingHdl()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	ExpandingHdl Handler; der aktuelle Eintrag wird gemerkt.
//STRIP001 	Virtuelle Methode aus SV.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 	<StyleTreeListBox_Impl::ExpandedHdl()>
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	pCurEntry = GetCurEntry();
//STRIP001 	return TRUE;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void  StyleTreeListBox_Impl::ExpandedHdl()
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	ExpandedHdl Handler;
//STRIP001 	Virtuelle Methode aus SV.
//STRIP001 
//STRIP001 	[Querverweise]
//STRIP001 	<StyleTreeListBox_Impl::ExpandingHdl()>
//STRIP001 
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	SvLBoxEntry *pEntry = GetHdlEntry();
//STRIP001 	if(!IsExpanded(pEntry) && pCurEntry != GetCurEntry())
//STRIP001 		SelectAll( FALSE );
//STRIP001 	pCurEntry = 0;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 StyleTreeListBox_Impl::StyleTreeListBox_Impl(
//STRIP001 	SfxCommonTemplateDialog_Impl* pParent, WinBits nWinStyle) :
//STRIP001 	DropListBox_Impl(pParent->GetWindow(), nWinStyle, pParent),
//STRIP001 	pCurEntry(0),
//STRIP001 	pCommon(pParent)
//STRIP001 
//STRIP001 /*  [Beschreibung]
//STRIP001 
//STRIP001 	Konstruktor StyleTreeListBox_Impl
//STRIP001 
//STRIP001 */
//STRIP001 {
//STRIP001 	EnableContextMenuHandling();
//STRIP001 }

//-------------------------------------------------------------------------
//-------------------------------------------------------------------------

class StyleTreeArr_Impl;


/*  [Beschreibung]

	Interne Struktur f"ur den Aufbau der hierarchischen View

*/

//STRIP001 struct StyleTree_Impl
//STRIP001 {
//STRIP001 	String aName;
//STRIP001 	String aParent;
//STRIP001 	StyleTreeArr_Impl *pChilds;
//STRIP001 	BOOL bIsExpanded;
//STRIP001 	BOOL HasParent() const { return aParent.Len() != 0; }
//STRIP001 
//STRIP001 	StyleTree_Impl(const String &rName, const String &rParent):
//STRIP001 		aName(rName), aParent(rParent), pChilds(0), bIsExpanded(0) {}
//STRIP001 	~StyleTree_Impl();
//STRIP001 	void Put(StyleTree_Impl* pIns, ULONG lPos=ULONG_MAX);
//STRIP001 	ULONG Count();
//STRIP001 };

//STRIP001 typedef StyleTree_Impl* StyleTree_ImplPtr;
//STRIP001 SV_DECL_PTRARR_DEL(StyleTreeArr_Impl, StyleTree_ImplPtr, 16, 8)
//STRIP001 SV_IMPL_PTRARR(StyleTreeArr_Impl, StyleTree_ImplPtr)


//STRIP001 ULONG StyleTree_Impl::Count()
//STRIP001 {
//STRIP001 	return pChilds ? pChilds->Count() : 0L;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 StyleTree_Impl::~StyleTree_Impl()
//STRIP001 {
//STRIP001 	delete pChilds;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void StyleTree_Impl::Put(StyleTree_Impl* pIns, ULONG lPos)
//STRIP001 {
//STRIP001 	if ( !pChilds )
//STRIP001 		pChilds = new StyleTreeArr_Impl;
//STRIP001 
//STRIP001 	if ( ULONG_MAX == lPos )
//STRIP001 		lPos = pChilds->Count();
//STRIP001 	pChilds->Insert( pIns, (USHORT)lPos );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 StyleTreeArr_Impl &MakeTree_Impl(StyleTreeArr_Impl &rArr)
//STRIP001 {
//STRIP001 	const USHORT nCount = rArr.Count();
//STRIP001 	// Alle unter ihren Parents einordnen
//STRIP001 	USHORT i;
//STRIP001 	for(i = 0; i < nCount; ++i)
//STRIP001 	{
//STRIP001 		StyleTree_ImplPtr pEntry = rArr[i];
//STRIP001 		if(pEntry->HasParent())
//STRIP001 		{
//STRIP001 			for(USHORT j = 0; j < nCount; ++j)
//STRIP001 			{
//STRIP001 				StyleTree_ImplPtr pCmp = rArr[j];
//STRIP001 				if(pCmp->aName == pEntry->aParent)
//STRIP001 				{
//STRIP001 					// initial sortiert einfuegen
//STRIP001 					USHORT ii;
//STRIP001 					IntlWrapper aIntlWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory(), Application::GetSettings().GetLocale() );
//STRIP001 					const CollatorWrapper* pCollator = aIntlWrapper.getCaseCollator();
//STRIP001 					for ( ii = 0;
//STRIP001 						 ii < pCmp->Count() && COMPARE_LESS ==
//STRIP001 						 pCollator->compareString( (*pCmp->pChilds)[ii]->aName,
//STRIP001 										pEntry->aName);++ii);
//STRIP001 					pCmp->Put(pEntry,ii);
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// alle, die schon unter ihrem Parent eingeordnet wurden
//STRIP001 	// entfernen
//STRIP001 	for(i = 0; i < rArr.Count(); )
//STRIP001 	{
//STRIP001 		if(rArr[i]->HasParent())
//STRIP001 			rArr.Remove(i);
//STRIP001 		else
//STRIP001 			++i;
//STRIP001 	}
//STRIP001 	return rArr;
//STRIP001 }

//-------------------------------------------------------------------------


//STRIP001 /*?*/ inline BOOL IsExpanded_Impl( const ExpandedEntries& rEntries,
//STRIP001 /*?*/ 							 const String &rStr)
//STRIP001 /*?*/ {
//STRIP001 /*?*/ 	USHORT nCount=rEntries.Count();
//STRIP001 /*?*/ 	for(USHORT n=0;n<nCount;n++)
//STRIP001 /*?*/ 		if(*rEntries[n]==rStr)
//STRIP001 /*?*/ 			return TRUE;
//STRIP001 /*?*/ 	return FALSE;
//STRIP001 /*?*/ }



//STRIP001 SvLBoxEntry* FillBox_Impl(SvTreeListBox *pBox,
//STRIP001 								 StyleTree_ImplPtr pEntry,
//STRIP001 								 const ExpandedEntries& rEntries,
//STRIP001 								 SvLBoxEntry* pParent = 0)
//STRIP001 {
//STRIP001 	SvLBoxEntry* pNewEntry = pBox->InsertEntry(pEntry->aName, pParent);
//STRIP001 	const USHORT nCount = pEntry->pChilds? pEntry->pChilds->Count(): 0;
//STRIP001 	for(USHORT i = 0; i < nCount; ++i)
//STRIP001 		FillBox_Impl(pBox, (*pEntry->pChilds)[i], rEntries, pNewEntry);
//STRIP001 	return pNewEntry;
//STRIP001 }

//-------------------------------------------------------------------------

// Konstruktor

/*N*/ SfxCommonTemplateDialog_Impl::SfxCommonTemplateDialog_Impl( SfxBindings* pB, SfxDockingWindow* pW ) :
/*N*/ 
/*N*/ 	aISfxTemplateCommon		( this ),
/*N*/ 	pBindings				( pB ),
/*N*/ 	pWindow					( pW ),
/*N*/ 	pModule					( NULL ),
/*N*/ 	pTimer					( NULL ),
/*N*/ 	pStyleSheetPool			( NULL ),
/*N*/ 	pTreeBox				( NULL ),
/*N*/ 	pCurObjShell			( NULL ),
/*N*/ 
/*N*/ 	aFmtLb					( this, WB_BORDER | WB_TABSTOP | WB_SORT ),
/*N*/ 	aFilterLb				( pW, WB_BORDER | WB_DROPDOWN | WB_TABSTOP ),
/*N*/ 
/*N*/ 	nActFamily				( 0xffff ),
/*N*/ 	nActFilter				( 0 ),
/*N*/ 	nAppFilter				( 0 ),
/*N*/ 
/*N*/ 	bDontUpdate				( FALSE ),
/*N*/ 	bIsWater				( FALSE ),
/*N*/ 	bEnabled				( TRUE ),
/*N*/ 	bUpdate					( FALSE ),
/*N*/ 	bUpdateFamily			( FALSE ),
/*N*/ 	bCanEdit				( FALSE ),
/*N*/ 	bCanDel					( FALSE ),
/*N*/ 	bCanNew					( TRUE ),
/*N*/ 	bWaterDisabled			( FALSE ),
/*N*/ 	bNewByExampleDisabled	( FALSE ),
/*N*/ 	bUpdateByExampleDisabled( FALSE ),
/*N*/ 	bTreeDrag				( TRUE ),
/*N*/ 	bHierarchical			( FALSE ),
/*N*/ 	bBindingUpdate			( TRUE ),
/*N*/ 	m_pStyleFamiliesId		( NULL )
/*N*/ {
/*N*/ 	aFmtLb.SetHelpId( HID_TEMPLATE_FMT );
/*N*/ 	aFilterLb.SetHelpId( HID_TEMPLATE_FILTER );
/*N*/ 	aFmtLb.SetWindowBits( WB_SORT | WB_HIDESELECTION );
/*N*/ 	Font aFont = aFmtLb.GetFont();
/*N*/ 	aFont.SetWeight( WEIGHT_NORMAL );
/*N*/ #ifdef MAC
/*N*/ 	aFont.SetName( String::CreateFromAscii( "Geneva" ) );
/*N*/ 	aFont.SetSize( Size( 0, 10 ) );
/*N*/ #endif
/*N*/ 	aFmtLb.SetFont( aFont );
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 SfxCommonTemplateDialog_Impl::SfxCommonTemplateDialog_Impl( SfxBindings* pB, ModalDialog* pW ) :
//STRIP001 
//STRIP001 	aISfxTemplateCommon		( this ),
//STRIP001 	pBindings				( pB ),
//STRIP001 	pWindow					( pW ),
//STRIP001 	pModule					( NULL ),
//STRIP001 	pTimer					( NULL ),
//STRIP001 	pStyleSheetPool			( NULL ),
//STRIP001 	pTreeBox				( NULL ),
//STRIP001 	pCurObjShell			( NULL ),
//STRIP001 
//STRIP001 	aFmtLb					( this, SfxResId( BT_VLIST ) ),
//STRIP001 	aFilterLb				( pW, SfxResId( BT_FLIST ) ),
//STRIP001 
//STRIP001 	nActFamily				( 0xffff ),
//STRIP001 	nActFilter				( 0 ),
//STRIP001 	nAppFilter				( 0 ),
//STRIP001 
//STRIP001 	bDontUpdate				( FALSE ),
//STRIP001 	bIsWater				( FALSE ),
//STRIP001 	bEnabled				( TRUE ),
//STRIP001 	bUpdate					( FALSE ),
//STRIP001 	bUpdateFamily			( FALSE ),
//STRIP001 	bCanEdit				( FALSE ),
//STRIP001 	bCanDel					( FALSE ),
//STRIP001 	bCanNew					( TRUE ),
//STRIP001 	bWaterDisabled			( FALSE ),
//STRIP001 	bNewByExampleDisabled	( FALSE ),
//STRIP001 	bUpdateByExampleDisabled( FALSE ),
//STRIP001 	bTreeDrag				( TRUE ),
//STRIP001 	bHierarchical			( FALSE ),
//STRIP001 	bBindingUpdate			( TRUE )
//STRIP001 
//STRIP001 {
//STRIP001 	aFmtLb.SetWindowBits( WB_SORT );
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ USHORT SfxCommonTemplateDialog_Impl::StyleNrToInfoOffset(USHORT nId)
/*N*/ {
/*N*/ 	const SfxStyleFamilyItem *pItem=pStyleFamilies->GetObject(nId);
/*N*/ 	return SfxFamilyIdToNId(pItem->GetFamily())-1;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::EnableEdit(BOOL bEnable)
/*N*/ {
/*N*/ 	SfxCommonTemplateDialog_Impl::EnableEdit( bEnable );
/*N*/ 	if( !bEnable || !bUpdateByExampleDisabled )
/*N*/ 		EnableItem( SID_STYLE_UPDATE_BY_EXAMPLE, bEnable);
/*N*/ }

//-------------------------------------------------------------------------


//STRIP001 USHORT SfxCommonTemplateDialog_Impl::InfoOffsetToStyleNr(USHORT nId)
//STRIP001 {
//STRIP001 	for ( USHORT i=0;i<pStyleFamilies->Count();i++ )
//STRIP001 		if ( SfxFamilyIdToNId(pStyleFamilies->GetObject(i)->GetFamily()) == nId+1 )
//STRIP001 			return i;
//STRIP001 	DBG_ERROR("Style Nummer nicht gefunden");
//STRIP001 	return 0;
//STRIP001 }


//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::ReadResource()
/*N*/ {
/*N*/ 	// globale Benutzer-Resource auslesen
/*N*/ 	USHORT i;
/*N*/ 	for(i = 0; i < MAX_FAMILIES; ++i)
/*N*/ 		pFamilyState[i] = 0;
/*N*/ 
/*N*/ 	SfxViewFrame* pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*N*/ 	pCurObjShell = pViewFrame->GetObjectShell();
/*N*/ 	ResMgr* pMgr = pCurObjShell ? pCurObjShell->GetResMgr() : NULL;
/*N*/ 	ResId aFamId( DLG_STYLE_DESIGNER, pMgr );
/*N*/ 	aFamId.SetRT(RSC_SFX_STYLE_FAMILIES);
/*N*/ 	m_pStyleFamiliesId = new ResId( aFamId );
/*N*/ 	if( !pMgr || !pMgr->IsAvailable( aFamId ) )
/*?*/ 		pStyleFamilies = new SfxStyleFamilies;
/*N*/ 	else
/*N*/ 		pStyleFamilies = new SfxStyleFamilies( aFamId );
/*N*/ 
/*N*/ 	nActFilter = pCurObjShell ? pCurObjShell->Get_Impl()->nStyleFilter : 0xFFFF;
/*N*/ 
/*N*/ 		// Einfuegen in die Toolbox
/*N*/ 		// umgekehrte Reihenfolge, da immer vorne eingefuegt wird.
/*N*/ 	USHORT nCount = pStyleFamilies->Count();
/*N*/ 
/*N*/ 	pBindings->ENTERREGISTRATIONS();
/*N*/ 
/*N*/ 	for(i = 0; i < nCount; ++i)
/*N*/ 	{
/*N*/ 		USHORT nSlot = 0;
/*N*/ 		switch((USHORT)pStyleFamilies->GetObject(i)->GetFamily())
/*N*/ 		{
/*N*/ 			case SFX_STYLE_FAMILY_CHAR: nSlot = SID_STYLE_FAMILY1; break;
/*N*/ 			case SFX_STYLE_FAMILY_PARA: nSlot = SID_STYLE_FAMILY2; break;
/*N*/ 			case SFX_STYLE_FAMILY_FRAME:nSlot = SID_STYLE_FAMILY3; break;
/*N*/ 			case SFX_STYLE_FAMILY_PAGE: nSlot = SID_STYLE_FAMILY4; break;
/*N*/ 			case SFX_STYLE_FAMILY_PSEUDO: nSlot = SID_STYLE_FAMILY5; break;
/*N*/ 			default: DBG_ERROR("unbekannte StyleFamily"); break;
/*N*/ 		}
/*N*/ 		pBoundItems[i] =
/*N*/ 			new SfxTemplateControllerItem(nSlot, *this, *pBindings);
/*N*/ 	}
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_WATERCAN, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_NEW_BY_EXAMPLE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_UPDATE_BY_EXAMPLE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_NEW, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_DRAGHIERARCHIE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_EDIT, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_DELETE, *this, *pBindings);
/*N*/ 	pBoundItems[i++] = new SfxTemplateControllerItem(
/*N*/ 		SID_STYLE_FAMILY, *this, *pBindings);
/*N*/ 	pBindings->LEAVEREGISTRATIONS();
/*N*/ 
/*N*/ 	for(; i < COUNT_BOUND_FUNC; ++i)
/*N*/ 		pBoundItems[i] = 0;
/*N*/ 
/*N*/ 	StartListening(*pBindings);
/*N*/ 
/*N*/ //In umgekehrter Reihenfolge des Auftretens in den Stylefamilies einfuegen.
/*N*/ //Das ist fuer den Toolbar des Gestalters. Die Listbox des Kataloges achtet
/*N*/ //selbst auf korrekte Reihenfolge.
/*N*/ 
/*N*/ //Reihenfolgen: Reihenfolge in der Resource = Reihenfolge in Toolbar bzw.
/*N*/ //Listbox.
/*N*/ //Reihenfolge aufsteigender SIDs: Niedrige SIDs werden als erstes angezeigt,
/*N*/ //wenn Vorlagen mehrerer Familien aktiv sind.
/*N*/ 
/*N*/ 	for( ; nCount--; )
/*N*/ 	{
/*N*/ 		const SfxStyleFamilyItem *pItem = pStyleFamilies->GetObject( nCount );
/*N*/ 		USHORT nId = SfxFamilyIdToNId( (USHORT) pItem->GetFamily() );
/*N*/ 		InsertFamilyItem( nId, pItem );
/*N*/ 	}
/*N*/ 
/*N*/ 	LoadedFamilies();
/*N*/ 
/*N*/ 	USHORT nStart = SID_STYLE_FAMILY1;
/*N*/ 	USHORT nEnd = SID_STYLE_FAMILY4;
/*N*/ 
/*N*/ 	for ( i = nStart; i <= nEnd; i++ )
/*N*/ 		pBindings->Update(i);
/*N*/ 
/*N*/ 	pModule = pCurObjShell ? pCurObjShell->GetModule() : NULL;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxCommonTemplateDialog_Impl::ClearResource()
//STRIP001 {
//STRIP001 	ClearFamilyList();
//STRIP001 	DELETEX(pStyleFamilies);
//STRIP001 	USHORT i;
//STRIP001 	for ( i = 0; i < MAX_FAMILIES; ++i )
//STRIP001 		DELETEX(pFamilyState[i]);
//STRIP001 	for ( i = 0; i < COUNT_BOUND_FUNC; ++i )
//STRIP001 		delete pBoundItems[i];
//STRIP001 	pCurObjShell = NULL;
//STRIP001 
//STRIP001 	DELETEZ( m_pStyleFamiliesId );
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::Initialize()
/*N*/ {
/*N*/ 	// globale Benutzer-Resource auslesen
/*N*/ 	ReadResource();
/*N*/ 	pBindings->Invalidate( SID_STYLE_FAMILY );
/*N*/ 	pBindings->Update( SID_STYLE_FAMILY );
/*N*/ 	Update_Impl();
/*N*/ 
/*N*/ 	aFilterLb.SetSelectHdl( LINK( this, SfxCommonTemplateDialog_Impl, FilterSelectHdl ) );
/*N*/ 	aFmtLb.SetDoubleClickHdl( LINK( this, SfxCommonTemplateDialog_Impl, ApplyHdl ) );
/*N*/ 	aFmtLb.SetSelectHdl( LINK( this, SfxCommonTemplateDialog_Impl, FmtSelectHdl ) );
/*N*/ 
/*N*/ 	aFilterLb.Show();
/*N*/ 	aFmtLb.Show();
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxCommonTemplateDialog_Impl::~SfxCommonTemplateDialog_Impl()
/*N*/ {
/*N*/ 	String aEmpty;
/*N*/ 	if ( bIsWater )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Execute_Impl(SID_STYLE_WATERCAN, aEmpty, aEmpty, 0);
/*N*/ 	GetWindow()->Hide();
/*N*/ 	DELETEX(pStyleFamilies);
/*N*/ 	DELETEZ( m_pStyleFamiliesId );
/*N*/ 	USHORT i;
/*N*/ 	for ( i = 0; i < MAX_FAMILIES; ++i )
/*N*/ 		DELETEX(pFamilyState[i]);
/*N*/ 	for ( i = 0; i < COUNT_BOUND_FUNC; ++i )
/*N*/ 		delete pBoundItems[i];
/*N*/ 	if ( pStyleSheetPool )
/*N*/ 		EndListening(*pStyleSheetPool);
/*N*/ 	pStyleSheetPool = NULL;
/*N*/ 	delete pTreeBox;
/*N*/ 	delete pTimer;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ USHORT SfxCommonTemplateDialog_Impl::SfxFamilyIdToNId( USHORT nFamily )
/*N*/ {
/*N*/ 	switch ( nFamily )
/*N*/ 	{
/*N*/ 		case SFX_STYLE_FAMILY_CHAR:		return 1; break;
/*N*/ 		case SFX_STYLE_FAMILY_PARA:		return 2; break;
/*N*/ 		case SFX_STYLE_FAMILY_FRAME:	return 3; break;
/*N*/ 		case SFX_STYLE_FAMILY_PAGE:		return 4; break;
/*N*/ 		case SFX_STYLE_FAMILY_PSEUDO:	return 5; break;
/*N*/ 		default: 						return 0;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

// Hilfsfunktion: Zugriff auf aktuelles Family-Item
/*N*/ const SfxStyleFamilyItem *SfxCommonTemplateDialog_Impl::GetFamilyItem_Impl() const
/*N*/ {
/*N*/ 	const USHORT nCount = pStyleFamilies->Count();
/*N*/ 	for(USHORT i = 0; i < nCount; ++i)
/*N*/ 	{
/*N*/ 		const SfxStyleFamilyItem *pItem = pStyleFamilies->GetObject(i);
/*N*/ //        if(!pItem)continue;
/*N*/ 		USHORT nId = SfxFamilyIdToNId((USHORT)pItem->GetFamily());
/*N*/ 		if(nId == nActFamily)
/*N*/ 			return pItem;
/*N*/ 	}
/*N*/ 	return 0;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::SelectStyle(const String &rStr)
/*N*/ {
/*N*/ 	const SfxStyleFamilyItem* pItem = GetFamilyItem_Impl();
/*N*/ 	if ( !pItem )
/*N*/ 		return;
/*N*/ 	const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 	SfxStyleSheetBase* pStyle = pStyleSheetPool->Find( rStr, eFam, SFXSTYLEBIT_ALL );
/*N*/ 	if( pStyle )
/*N*/ 		EnableEdit( !(pStyle->GetMask() & SFXSTYLEBIT_READONLY) );
/*N*/ 	else
/*N*/ 		EnableEdit(FALSE);
/*N*/ 
/*N*/ 	if ( pTreeBox )
/*N*/ 	{
/*?*/ 		if ( rStr.Len() )
/*?*/ 		{
/*?*/ 			SvLBoxEntry* pEntry = pTreeBox->First();
/*?*/ 			while ( pEntry )
/*?*/ 			{
/*?*/ 				if ( pTreeBox->GetEntryText( pEntry ) == rStr )
/*?*/ 				{
/*?*/ 					pTreeBox->MakeVisible( pEntry );
/*?*/ 					pTreeBox->Select( pEntry );
/*?*/ 					return;
/*?*/ 				}
/*?*/ 				pEntry = pTreeBox->Next( pEntry );
/*?*/ 			}
/*N*/ 		}
/*N*/ 		else
/*N*/ 			pTreeBox->SelectAll( FALSE );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		BOOL bSelect = ( rStr.Len() > 0 );
/*N*/ 		if ( bSelect )
/*N*/ 		{
/*N*/ 			SvLBoxEntry* pEntry = (SvLBoxEntry*)aFmtLb.FirstVisible();
/*N*/ 			while ( pEntry && aFmtLb.GetEntryText( pEntry ) != rStr )
/*N*/ 				pEntry = (SvLBoxEntry*)aFmtLb.NextVisible( pEntry );
/*N*/ 			if ( !pEntry )
/*N*/ 				bSelect = FALSE;
/*N*/ 			else
/*N*/ 			{
/*N*/ 				aFmtLb.MakeVisible( pEntry );
/*N*/ 				aFmtLb.Select( pEntry );
/*N*/ 				bWaterDisabled = !HasSelectedStyle(); //added by BerryJia for fixing Bug76391 2003-1-22
/*N*/ 				FmtSelectHdl( NULL );
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( !bSelect )
/*N*/ 		{
/*N*/ 			aFmtLb.SelectAll( FALSE );
/*N*/ 			EnableEdit(FALSE);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ String SfxCommonTemplateDialog_Impl::GetSelectedEntry() const
/*N*/ {
/*N*/ 	String aRet;
/*N*/ 	if ( pTreeBox )
/*N*/ 	{
/*?*/ 		SvLBoxEntry* pEntry = pTreeBox->FirstSelected();
/*?*/ 		if( !pEntry )
/*?*/ 			pEntry = aFmtLb.GetPreDropEntry();
/*?*/ 		if ( pEntry )
/*?*/ 			aRet = pTreeBox->GetEntryText( pEntry );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		SvLBoxEntry* pEntry = aFmtLb.FirstSelected();
/*N*/ 		if ( pEntry )
/*N*/ 			aRet = aFmtLb.GetEntryText( pEntry );
/*N*/ 	}
/*N*/ 	return aRet;
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::EnableTreeDrag( BOOL bEnable )
/*N*/ {
/*N*/ 	if ( pStyleSheetPool )
/*N*/ 	{
/*N*/ 		SfxStyleSheetBase* pStyle = pStyleSheetPool->First();
/*N*/ 		if ( pTreeBox )
/*N*/ 		{
/*N*/ 			if ( pStyle && pStyle->HasParentSupport() && bEnable )
/*N*/ 				pTreeBox->SetDragDropMode(SV_DRAGDROP_CTRL_MOVE);
/*N*/ 			else
/*N*/ 				pTreeBox->SetDragDropMode(SV_DRAGDROP_NONE);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	bTreeDrag = bEnable;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxCommonTemplateDialog_Impl::FillTreeBox()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pTreeBox, "FillTreeBox() without treebox");
//STRIP001 	if(pStyleSheetPool && nActFamily != 0xffff)
//STRIP001 	{
//STRIP001 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
//STRIP001 		pStyleSheetPool->SetSearchMask(pItem->GetFamily(), SFXSTYLEBIT_ALL);
//STRIP001 		StyleTreeArr_Impl aArr;
//STRIP001 		SfxStyleSheetBase *pStyle = pStyleSheetPool->First();
//STRIP001 		if(pStyle && pStyle->HasParentSupport() && bTreeDrag )
//STRIP001 			pTreeBox->SetDragDropMode(SV_DRAGDROP_CTRL_MOVE);
//STRIP001 		else
//STRIP001 			pTreeBox->SetDragDropMode(SV_DRAGDROP_NONE);
//STRIP001 		while(pStyle)
//STRIP001 		{
//STRIP001 			StyleTree_ImplPtr pNew =
//STRIP001 				new StyleTree_Impl(pStyle->GetName(), pStyle->GetParent());
//STRIP001 			aArr.Insert(pNew, aArr.Count());
//STRIP001 			pStyle = pStyleSheetPool->Next();
//STRIP001 		}
//STRIP001 		MakeTree_Impl(aArr);
//STRIP001 		ExpandedEntries aEntries;
//STRIP001 		if(pTreeBox)
//STRIP001 			((const StyleTreeListBox_Impl *)pTreeBox)->
//STRIP001 				MakeExpanded_Impl( aEntries);
//STRIP001 		pTreeBox->SetUpdateMode( FALSE );
//STRIP001 		pTreeBox->Clear();
//STRIP001 		const USHORT nCount = aArr.Count();
//STRIP001 		for(USHORT i = 0; i < nCount; ++i)
//STRIP001 			FillBox_Impl(pTreeBox, aArr[i], aEntries);
//STRIP001 
//STRIP001 //		EnableEdit(FALSE);
//STRIP001 		EnableItem(SID_STYLE_WATERCAN,FALSE);
//STRIP001 
//STRIP001 		SfxTemplateItem* pState = pFamilyState[nActFamily-1];
//STRIP001 
//STRIP001 		if ( nCount )
//STRIP001 			pTreeBox->Expand( pTreeBox->First() );
//STRIP001 
//STRIP001 		for ( SvLBoxEntry* pEntry = pTreeBox->First(); pEntry; pEntry = pTreeBox->Next( pEntry ) )
//STRIP001 		{
//STRIP001 			if ( IsExpanded_Impl( aEntries, pTreeBox->GetEntryText( pEntry ) ) )
//STRIP001 				pTreeBox->Expand( pEntry );
//STRIP001 		}
//STRIP001 
//STRIP001 		pTreeBox->SetUpdateMode( TRUE );
//STRIP001 
//STRIP001 		String aStyle;
//STRIP001 		if(pState)  //Aktuellen Eintrag selektieren
//STRIP001 			aStyle = pState->GetStyleName();
//STRIP001 		SelectStyle(aStyle);
//STRIP001 		EnableDelete();
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------
/*?*/ BOOL SfxCommonTemplateDialog_Impl::HasSelectedStyle() const
/*?*/ {
/*?*/ 	return pTreeBox? pTreeBox->FirstSelected() != 0:
/*?*/ 			aFmtLb.GetSelectionCount() != 0;
/*?*/ }


//-------------------------------------------------------------------------

// intern: Aktualisierung der Anzeige
/*N*/ void SfxCommonTemplateDialog_Impl::UpdateStyles_Impl(USHORT nFlags)     // Flags, was aktualisiert werden soll (s.o.)
/*N*/ {
/*N*/ 	DBG_ASSERT(nFlags, "nichts zu tun");
/*N*/ 	const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 	if (!pItem)
/*N*/ 	{
/*N*/ 		// Ist beim Vorlagenkatalog der Fall
/*N*/ 		SfxTemplateItem **ppItem = pFamilyState;
/*N*/ 		const USHORT nFamilyCount = pStyleFamilies->Count();
/*N*/ 		USHORT n;
/*N*/ 		for(n=0;n<nFamilyCount;n++)
/*N*/ 			if(ppItem[StyleNrToInfoOffset(n)])break;
/*N*/ 		if ( n == nFamilyCount )
/*N*/ 			// passiert gelegentlich bei Beichten, Formularen etc.; wei?der Teufel warum
/*N*/ 			return;
/*N*/ 		ppItem+=StyleNrToInfoOffset(n);
/*N*/ 		nAppFilter = (*ppItem)->GetValue();
/*N*/ 		FamilySelect(  StyleNrToInfoOffset(n)+1 );
/*N*/ 		pItem = GetFamilyItem_Impl();
/*N*/ 	}
/*N*/ 
/*N*/ 	const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 
/*N*/ 	SfxFilterTupel *pT = pItem->GetFilterList().GetObject(nActFilter);
/*N*/ 	USHORT nFilter = pT ? pItem->GetFilterList().GetObject(nActFilter)->nFlags : 0;
/*N*/ 	if(!nFilter)    // automatisch
/*N*/ 		nFilter = nAppFilter;
/*N*/ 
/*N*/ 	DBG_ASSERT(pStyleSheetPool, "kein StyleSheetPool");
/*N*/ 	if(pStyleSheetPool)
/*N*/ 	{
/*N*/ 		pStyleSheetPool->SetSearchMask(eFam, nFilter);
/*N*/ 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 		if((nFlags & UPDATE_FAMILY) == UPDATE_FAMILY)
/*N*/ 		{
/*N*/ 			if(ISA(SfxTemplateDialog_Impl))
/*N*/ 				((DockingWindow* )GetWindow())->SetText(
/*N*/ 					pItem->GetText()); // Titel setzen
/*N*/ 			CheckItem(nActFamily, TRUE);    // Button in Toolbox checken
/*N*/ 			aFilterLb.SetUpdateMode(FALSE);
/*N*/ 			aFilterLb.Clear();
/*N*/             //insert hierarchical at the beginning
/*N*/             aFilterLb.InsertEntry(String(SfxResId(STR_STYLE_FILTER_HIERARCHICAL)), 0);
/*N*/ 			const SfxStyleFilter& rFilter = pItem->GetFilterList();
/*N*/ 			for(USHORT i = 0; i < rFilter.Count(); ++i)
/*N*/ 				aFilterLb.InsertEntry(rFilter.GetObject(i)->aName);
/*N*/ 			if(nActFilter < aFilterLb.GetEntryCount() - 1)
/*N*/ 				aFilterLb.SelectEntryPos(nActFilter + 1);
/*N*/ 			else
/*N*/ 			{
/*?*/ 				nActFilter = 0;
/*?*/ 				aFilterLb.SelectEntryPos(1);
/*?*/ 				SfxFilterTupel *pT = rFilter.GetObject(nActFilter);
/*?*/ 				USHORT nFilter = pT ? rFilter.GetObject(nActFilter)->nFlags : 0;
/*?*/ 				pStyleSheetPool->SetSearchMask(eFam, nFilter);
/*N*/ 			}
/*N*/ 
/*N*/ 			if(pTreeBox)
/*?*/ 				aFilterLb.SelectEntry(String(SfxResId(STR_STYLE_FILTER_HIERARCHICAL)));
/*N*/ 			//Falls in Treedarstellung wieder Family Hierarchie selektieren
/*N*/ 
/*N*/ 			aFilterLb.SetUpdateMode(TRUE);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			if( nActFilter < aFilterLb.GetEntryCount() - 1)
/*N*/ 				aFilterLb.SelectEntryPos(nActFilter + 1);
/*N*/ 			else
/*N*/ 			{
/*?*/ 				nActFilter = 0;
/*?*/ 				aFilterLb.SelectEntryPos(1);
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if(nFlags & UPDATE_FAMILY_LIST)
/*N*/ 		{
/*N*/ //			EnableEdit(FALSE);
/*N*/ 			EnableItem(SID_STYLE_WATERCAN,FALSE);
/*N*/ 
/*N*/ 			SfxStyleSheetBase *pStyle = pStyleSheetPool->First();
/*N*/ 			SvLBoxEntry* pEntry = aFmtLb.First();
/*N*/ 			SvStringsDtor aStrings;
/*N*/ 
/*N*/ 			while( pStyle )
/*N*/ 			{
/*N*/ 				//Bubblesort
/*N*/ 				for( USHORT nPos = aStrings.Count() + 1 ; nPos-- ;)
/*N*/ 				{
/*N*/ 					if( !nPos || *aStrings[nPos-1] < pStyle->GetName() )
/*N*/ 					{
/*N*/ 						// Die Namen stehen in den Styles, also nicht kopieren
/*N*/ 						// Reingefallen!: Writer hat insgesamt nur 1 Style
/*N*/ 						aStrings.Insert(
/*N*/ 							new String( pStyle->GetName() ), nPos );
/*N*/ 						break;
/*N*/ 					}
/*N*/ 				}
/*N*/ 				pStyle = pStyleSheetPool->Next();
/*N*/ 			}
/*N*/ 
/*N*/ 
/*N*/ 			USHORT nCount = aStrings.Count();
/*N*/ 			USHORT nPos = 0;
/*N*/ 			while( nPos < nCount && pEntry &&
/*N*/ 				   *aStrings[ nPos ] == aFmtLb.GetEntryText( pEntry ) )
/*N*/ 			{
/*N*/ 				nPos++;
/*N*/ 				pEntry = aFmtLb.Next( pEntry );
/*N*/ 			}
/*N*/ 
/*N*/ 			if( nPos < nCount || pEntry )
/*N*/ 			{
/*N*/ 				// Box mit den Vorlagen fuellen
/*N*/ 				aFmtLb.SetUpdateMode(FALSE);
/*N*/ 				aFmtLb.Clear();
/*N*/ 
/*N*/ 				nPos = 0;
/*N*/ 				while( nPos < nCount )
/*N*/ 					aFmtLb.InsertEntry( *aStrings.GetObject( nPos++ ));
/*N*/ 				aFmtLb.SetUpdateMode(TRUE);
/*N*/ 			}
/*N*/ 				// aktuelle Vorlage anzeigen
/*N*/ 			SfxTemplateItem *pState = pFamilyState[nActFamily-1];
/*N*/ 			String aStyle;
/*N*/ 			if(pState)  //Aktuellen Eintrag selektieren
/*N*/ 				aStyle = pState->GetStyleName();
/*N*/ 			SelectStyle(aStyle);
/*N*/ 			EnableDelete();
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

// Aktualisierung Anzeige: Gie\skanne an/aus
/*N*/ void SfxCommonTemplateDialog_Impl::SetWaterCanState(const SfxBoolItem *pItem)
/*N*/ {
/*N*/ //	EnableItem(SID_STYLE_WATERCAN, pItem != 0);
/*N*/ 	bWaterDisabled =  pItem == 0;
//added by BerryJia for fixing Bug76391 2003-1-7
/*N*/ 	if(!bWaterDisabled)
/*N*/ 		bWaterDisabled = !HasSelectedStyle();
/*N*/ 
/*N*/ 	if(pItem && !bWaterDisabled)
/*N*/ 	{
/*N*/ 		CheckItem(SID_STYLE_WATERCAN, pItem->GetValue());
/*N*/ 		EnableItem( SID_STYLE_WATERCAN, TRUE );
/*N*/ 	}
/*N*/ 	else
/*N*/ 		if(!bWaterDisabled)
/*N*/ 			EnableItem(SID_STYLE_WATERCAN, TRUE);
/*N*/ 		else
/*N*/ 			EnableItem(SID_STYLE_WATERCAN, FALSE);
/*N*/ 
//Waehrend Giesskannenmodus Statusupdates ignorieren.
/*N*/ 
/*N*/ 	USHORT nCount=pStyleFamilies->Count();
/*N*/ 	pBindings->EnterRegistrations();
/*N*/ 	for(USHORT n=0; n<nCount; n++)
/*N*/ 	{
/*N*/ 		SfxControllerItem *pCItem=pBoundItems[n];
/*N*/ 		BOOL bChecked = pItem && pItem->GetValue();
/*N*/ 		if( pCItem->IsBound() == bChecked )
/*?*/ 			if( !bChecked )
/*?*/ 				pCItem->ReBind();
/*?*/ 			else
/*?*/ 				pCItem->UnBind();
/*N*/ 	}
/*N*/ 	pBindings->LeaveRegistrations();
/*N*/ }

//-------------------------------------------------------------------------

// Item mit dem Status einer Family wird kopiert und gemerkt
// (Aktualisierung erfolgt, wenn alle Stati aktualisiert worden sind.
// Siehe auch: <SfxBindings::AddDoneHdl(const Link &)>

/*N*/ void SfxCommonTemplateDialog_Impl::SetFamilyState( USHORT nSlotId, const SfxTemplateItem* pItem )
/*N*/ {
/*N*/ 	USHORT nIdx = nSlotId - SID_STYLE_FAMILY_START;
/*N*/ 	DELETEZ(pFamilyState[nIdx]);
/*N*/ 	if ( pItem )
/*N*/ 		pFamilyState[nIdx] = new SfxTemplateItem(*pItem);
/*N*/ 	bUpdate = TRUE;
/*N*/ 
/*N*/ 	// Wenn verwendete Vorlagen ( wie zum Teufel findet man das heraus ?? )
/*N*/ 	bUpdateFamily = TRUE;
/*N*/ }

//-------------------------------------------------------------------------

// Benachrichtigung durch SfxBindings, da"s die Aktualisierung
// beendet ist. St"o\st die Aktualisierung der Anzeige an.

/*N*/ void SfxCommonTemplateDialog_Impl::Update_Impl()
/*N*/ {
/*N*/ 	BOOL bDocChanged=FALSE;
/*N*/ 	SfxStyleSheetBasePool *pNewPool = 0;
/*N*/ 	SfxViewFrame *pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*N*/ 	SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
/*N*/ 	if( pDocShell )
/*N*/ 		pNewPool = pDocShell->GetStyleSheetPool();
/*N*/ 
/*N*/ 	if ( pNewPool != pStyleSheetPool && pDocShell )
/*N*/ 	{
/*N*/ 		SfxModule* pNewModule = pDocShell->GetModule();
/*N*/ 		if( pNewModule && pNewModule != pModule )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			ClearResource();
//STRIP001 /*?*/ 			ReadResource();
/*N*/ 		}
/*N*/ 		if ( pStyleSheetPool )
/*N*/ 		{
/*?*/ 			EndListening(*pStyleSheetPool);
/*?*/ 			pStyleSheetPool = 0;
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pNewPool )
/*N*/ 		{
/*N*/ 			StartListening(*pNewPool);
/*N*/ 			pStyleSheetPool = pNewPool;
/*N*/ 			bDocChanged=TRUE;
/*N*/ 		}
/*N*/ //		InvalidateBindings();
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bUpdateFamily)
/*N*/ 		UpdateFamily_Impl();
/*N*/ 
/*N*/ 	USHORT i;
/*N*/ 	for(i = 0; i < MAX_FAMILIES; ++i)
/*N*/ 		if(pFamilyState[i])
/*N*/ 			break;
/*N*/ 	if(i == MAX_FAMILIES || !pNewPool)
/*N*/ 		// nichts erlaubt
/*N*/ 		return;
/*N*/ 
/*N*/ 	 SfxTemplateItem *pItem = 0;
/*N*/ 	 // aktueller Bereich nicht innerhalb der erlaubten Bereiche
/*N*/ 	 // oder Default
/*N*/ 	 if(nActFamily == 0xffff || 0 == (pItem = pFamilyState[nActFamily-1] ) )
/*N*/ 	 {
/*?*/ 		 CheckItem(nActFamily, FALSE);
/*?*/ 		 SfxTemplateItem **ppItem = pFamilyState;
/*?*/ 		 const USHORT nFamilyCount = pStyleFamilies->Count();
/*?*/ 		 USHORT n;
/*?*/ 		 for(n=0;n<nFamilyCount;n++)
/*?*/ 			 if(ppItem[StyleNrToInfoOffset(n)])break;
/*?*/ 		 ppItem+=StyleNrToInfoOffset(n);
/*?*/ 
/*?*/ 		 nAppFilter = (*ppItem)->GetValue();
/*?*/ 		 FamilySelect(  StyleNrToInfoOffset(n)+1 );
/*?*/ 
/*?*/ 		 pItem = *ppItem;
/*N*/ 	 }
/*N*/ 	 else if( bDocChanged )
/*N*/ 	 {
/*N*/ 		 // andere DocShell -> alles neu
/*N*/ 		 CheckItem( nActFamily, TRUE );
/*N*/ 		 nActFilter = pDocShell->Get_Impl()->nStyleFilter;
/*N*/ 		 nAppFilter = pItem->GetValue();
/*N*/ 		 if(!pTreeBox)
/*N*/ 		 {
/*N*/ 			 UpdateStyles_Impl(UPDATE_FAMILY_LIST);
/*N*/ 		 }
/*N*/ 		 else
/*?*/ 			 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 FillTreeBox();
/*N*/ 	 }
/*N*/ 	 else
/*N*/ 	 {
/*N*/ 		 // anderer Filter fuer automatisch
/*N*/ 		 CheckItem( nActFamily, TRUE );
/*N*/ 		 const SfxStyleFamilyItem *pStyleItem =  GetFamilyItem_Impl();
/*N*/ #if OSL_DEBUG_LEVEL > 1
/*N*/ 		 SfxFilterTupel *pT = pStyleItem->GetFilterList().GetObject(nActFilter);
/*N*/ #endif
/*N*/ 		 if(0 == pStyleItem->GetFilterList().GetObject(nActFilter)->nFlags
/*N*/ 			&& nAppFilter != pItem->GetValue())
/*N*/ 		 {
/*?*/ 			 nAppFilter = pItem->GetValue();
/*?*/ 			 if(!pTreeBox)
/*?*/ 				 UpdateStyles_Impl(UPDATE_FAMILY_LIST);
/*?*/ 			 else
/*?*/ 				 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 FillTreeBox();
/*N*/ 		 }
/*N*/ 		 else
/*N*/ 			 nAppFilter = pItem->GetValue();
/*N*/ 	 }
/*N*/ 	 const String aStyle(pItem->GetStyleName());
/*N*/ 	 SelectStyle(aStyle);
/*N*/ 	 EnableDelete();
/*N*/ 	 EnableNew( bCanNew );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, TimeOut, Timer *, pTim )
/*N*/ {
/*N*/ 	if(!bDontUpdate)
/*N*/ 	{
/*N*/ 		bDontUpdate=TRUE;
/*N*/ 		if(!pTreeBox)
/*N*/ 			UpdateStyles_Impl(UPDATE_FAMILY_LIST);
/*N*/ 		else
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			FillTreeBox();
//STRIP001 /*?*/ 			SfxTemplateItem *pState = pFamilyState[nActFamily-1];
//STRIP001 /*?*/ 			if(pState)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				const String aStyle(pState->GetStyleName());
//STRIP001 /*?*/ 				SelectStyle(aStyle);
//STRIP001 /*?*/ 				EnableDelete();
//STRIP001 /*N*/ 			}
/*N*/ 		}
/*N*/ 		bDontUpdate=FALSE;
/*N*/ 		DELETEZ(pTimer);
/*N*/ 	}
/*N*/ 	else
/*?*/ 		pTimer->Start();
/*N*/ 	return 0;
/*N*/ }


//-------------------------------------------------------------------------
/*N*/ void SfxCommonTemplateDialog_Impl::SFX_NOTIFY(SfxBroadcaster& rBC, const TypeId& rBCType,
/*N*/ 										  const SfxHint& rHint, const TypeId& rHintType)
/*N*/ {
/*N*/ 	// Aktualisierung anstossen
/*N*/ 	if(rHint.Type() == TYPE(SfxSimpleHint))
/*N*/ 	{
/*N*/ 		switch(((SfxSimpleHint&) rHint ).GetId())
/*N*/ 		{
/*N*/ 		  case SFX_HINT_UPDATEDONE:
/*N*/ 			{
/*N*/ 				SfxViewFrame *pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
/*N*/ 				SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
/*N*/ 				if( bUpdate && (
/*N*/ 					!IsCheckedItem(SID_STYLE_WATERCAN) || pDocShell
/*N*/ 					&& pDocShell->GetStyleSheetPool() != pStyleSheetPool) )
/*N*/ 				{
/*N*/ 					bUpdate = FALSE;
/*N*/ 					Update_Impl();
/*N*/ 				}
/*N*/ 				else if ( bUpdateFamily )
/*N*/ 				{
/*?*/ 					UpdateFamily_Impl();
/*N*/ 				}
/*N*/ 
/*N*/ 				if( pStyleSheetPool )
/*N*/ 				{
/*N*/ 					String aStr = GetSelectedEntry();
/*N*/ 					if( aStr.Len() && pStyleSheetPool )
/*N*/ 					{
/*N*/ 						const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 						if( !pItem ) break;
/*N*/ 						const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 						SfxStyleSheetBase *pStyle =
/*N*/ 							pStyleSheetPool->Find(
/*N*/ 								aStr, eFam, SFXSTYLEBIT_ALL );
/*N*/ 						if( pStyle )
/*N*/ 							EnableEdit(
/*N*/ 								!(pStyle->GetMask() & SFXSTYLEBIT_READONLY) );
/*N*/ 						else
/*?*/ 							EnableEdit(FALSE);
/*N*/ 					}
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		// noetig, wenn zwichen Dokumenten umgeschaltet wird,
/*N*/ 		// aber in beiden Dokumenten die gleiche Vorlage gilt.
/*N*/ 		// Nicht sofort Update_Impl rufen, fr den Fall da\s eines
/*N*/ 		// der Dokumente ein internes InPlaceObjekt ist!
/*N*/ 		  case SFX_HINT_DOCCHANGED:
/*N*/ 			bUpdate = TRUE;
/*N*/ 			break;
/*N*/ 		  case SFX_HINT_DYING:
/*N*/ 		  {
/*?*/ 			EndListening(*pStyleSheetPool);
/*?*/ 			pStyleSheetPool=0;
/*N*/ 			break;
/*N*/ 		  }
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	// Timer nicht aufsetzen, wenn der StyleSheetPool in die Kiste geht, denn
/*N*/ 	// es kann sein, da\s sich ein neuer erst anmeldet, nachdem der Timer
/*N*/ 	// abgelaufen ist - macht sich schlecht in UpdateStyles_Impl() !
/*N*/ 
/*N*/ 	ULONG nId = ((SfxSimpleHint&) rHint).GetId();
/*N*/ 
/*N*/ 	if(!bDontUpdate && nId != SFX_HINT_DYING &&
/*N*/ 	   (rHint.Type() == TYPE(SfxStyleSheetPoolHint)||
/*N*/ 	   rHint.Type() == TYPE(SfxStyleSheetHint) ||
/*N*/ 	   rHint.Type() == TYPE( SfxStyleSheetHintExtended )))
/*N*/ 	{
/*N*/ 		if(!pTimer)
/*N*/ 		{
/*N*/ 			pTimer=new Timer;
/*N*/ 			pTimer->SetTimeout(500);
/*N*/ 			pTimer->SetTimeoutHdl(LINK(this,SfxCommonTemplateDialog_Impl,TimeOut));
/*N*/ 		}
/*N*/ 		pTimer->Start();
/*N*/ 
/*N*/ 	}
/*N*/ }


//-------------------------------------------------------------------------

// Anderer Filter; kann durch den Benutzer umgeschaltet werden
// oder als Folge von Neu oder Bearbeiten, wenn die aktuelle
// Vorlage einem anderen Filter zugewiesen wurde.
//STRIP001 void SfxCommonTemplateDialog_Impl::FilterSelect(
//STRIP001 				USHORT nEntry,                  // Idx des neuen Filters
//STRIP001 				BOOL bForce )                   // Aktualisierung erzwingen, auch wenn der neue Filter gleich dem aktuellen ist
//STRIP001 {
//STRIP001 	if( nEntry != nActFilter || bForce )
//STRIP001 	{
//STRIP001 		nActFilter = nEntry;
//STRIP001 		SfxViewFrame *pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
//STRIP001 		SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
//STRIP001 		if (pDocShell)
//STRIP001 			pDocShell->Get_Impl()->nStyleFilter = nActFilter;
//STRIP001 
//STRIP001 		SfxStyleSheetBasePool *pOldStyleSheetPool = pStyleSheetPool;
//STRIP001 		pStyleSheetPool = pDocShell? pDocShell->GetStyleSheetPool(): 0;
//STRIP001 		if ( pOldStyleSheetPool != pStyleSheetPool )
//STRIP001 		{
//STRIP001 			if ( pOldStyleSheetPool )
//STRIP001 				EndListening(*pOldStyleSheetPool);
//STRIP001 			if ( pStyleSheetPool )
//STRIP001 				StartListening(*pOldStyleSheetPool);
//STRIP001 		}
//STRIP001 
//STRIP001 		UpdateStyles_Impl(UPDATE_FAMILY_LIST);
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

// Intern: Ausf"uhren von Funktionen "uber den Dispatcher
//STRIP001 BOOL SfxCommonTemplateDialog_Impl::Execute_Impl(
//STRIP001 	USHORT nId, const String &rStr, const String& rRefStr, USHORT nFamily,
//STRIP001 	USHORT nMask, USHORT *pIdx, const USHORT* pModifier)
//STRIP001 {
//STRIP001     SfxDispatcher &rDispatcher = *SFX_APP()->GetDispatcher_Impl();
//STRIP001 	SfxStringItem aItem(nId, rStr);
//STRIP001 	SfxUInt16Item aFamily(SID_STYLE_FAMILY, nFamily);
//STRIP001 	SfxUInt16Item aMask( SID_STYLE_MASK, nMask );
//STRIP001 	SfxStringItem aUpdName(SID_STYLE_UPD_BY_EX_NAME, rStr);
//STRIP001 	SfxStringItem aRefName( SID_STYLE_REFERENCE, rRefStr );
//STRIP001 	const SfxPoolItem* pItems[ 6 ];
//STRIP001 	USHORT nCount = 0;
//STRIP001 	if( rStr.Len() )
//STRIP001 		pItems[ nCount++ ] = &aItem;
//STRIP001 	pItems[ nCount++ ] = &aFamily;
//STRIP001 	if( nMask )
//STRIP001 		pItems[ nCount++ ] = &aMask;
//STRIP001 	if(SID_STYLE_UPDATE_BY_EXAMPLE == nId)
//STRIP001 	{
//STRIP001 		//Sonderloesung fuer Numerierungsupdate im Writer
//STRIP001 		const String aTemplName(GetSelectedEntry());
//STRIP001 		aUpdName.SetValue(aTemplName);
//STRIP001 		pItems[ nCount++ ] = &aUpdName;
//STRIP001 	}
//STRIP001 	if ( rRefStr.Len() )
//STRIP001 		pItems[ nCount++ ] = &aRefName;
//STRIP001 
//STRIP001 	pItems[ nCount++ ] = 0;
//STRIP001 
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001 	USHORT nModi = pModifier ? *pModifier : 0;
//STRIP001 	pItem = rDispatcher.Execute(
//STRIP001 		nId, SFX_CALLMODE_SYNCHRON | SFX_CALLMODE_RECORD | SFX_CALLMODE_MODAL,
//STRIP001 		pItems, nModi );
//STRIP001 
//STRIP001 	if ( !pItem )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	if ( nId == SID_STYLE_NEW || SID_STYLE_EDIT == nId )
//STRIP001 	{
//STRIP001 		SfxUInt16Item *pFilterItem = PTR_CAST(SfxUInt16Item, pItem);
//STRIP001 		DBG_ASSERT(pFilterItem, "SfxUINT16Item erwartet");
//STRIP001 		USHORT nFilterFlags = pFilterItem->GetValue() & ~SFXSTYLEBIT_USERDEF;
//STRIP001 		if(!nFilterFlags)       // Benutzervorlage?
//STRIP001 			nFilterFlags = pFilterItem->GetValue();
//STRIP001 		const SfxStyleFamilyItem *pFamilyItem = GetFamilyItem_Impl();
//STRIP001 		const USHORT nCount = (USHORT) pFamilyItem->GetFilterList().Count();
//STRIP001 
//STRIP001 		for ( USHORT i = 0; i < nCount; ++i )
//STRIP001 		{
//STRIP001 			const SfxFilterTupel *pTupel =
//STRIP001 				pFamilyItem->GetFilterList().GetObject(i);
//STRIP001 
//STRIP001 			if ( ( pTupel->nFlags & nFilterFlags ) == nFilterFlags && pIdx )
//STRIP001 				*pIdx = i;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }

//-------------------------------------------------------------------------

// Handler der Listbox der Filter
/*N*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, FilterSelectHdl, ListBox *, pBox )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if ( pBox->GetSelectEntry() ==	String(SfxResId(STR_STYLE_FILTER_HIERARCHICAL)) )
//STRIP001 	{
//STRIP001 		if ( !bHierarchical )
//STRIP001 		{
//STRIP001 			// TreeView einschalten
//STRIP001 			bHierarchical=TRUE;
//STRIP001 			const String aSelectEntry( GetSelectedEntry());
//STRIP001 			aFmtLb.Hide();
//STRIP001 			// aFilterLb.Disable();
//STRIP001 
//STRIP001 			pTreeBox = new StyleTreeListBox_Impl(
//STRIP001 					this, WB_HASBUTTONS | WB_HASLINES |
//STRIP001 					WB_BORDER | WB_TABSTOP | WB_HASLINESATROOT |
//STRIP001 					WB_HASBUTTONSATROOT | WB_HIDESELECTION );
//STRIP001 			pTreeBox->SetFont( aFmtLb.GetFont() );
//STRIP001 
//STRIP001 			pTreeBox->SetPosSizePixel(aFmtLb.GetPosPixel(), aFmtLb.GetSizePixel());
//STRIP001 			pTreeBox->SetNodeDefaultImages();
//STRIP001 			pTreeBox->SetSelectHdl(
//STRIP001 				LINK(this, SfxCommonTemplateDialog_Impl, FmtSelectHdl));
//STRIP001 			((StyleTreeListBox_Impl*)pTreeBox)->
//STRIP001 				SetDoubleClickHdl(
//STRIP001 					LINK(this, SfxCommonTemplateDialog_Impl,  ApplyHdl));
//STRIP001 			((StyleTreeListBox_Impl*)pTreeBox)->
//STRIP001 				SetDropHdl(LINK(this, SfxCommonTemplateDialog_Impl,  DropHdl));
//STRIP001 			pTreeBox->SetIndent(10);
//STRIP001 
//STRIP001 			FillTreeBox();
//STRIP001 			SelectStyle(aSelectEntry);
//STRIP001 			pTreeBox->Show();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DELETEZ(pTreeBox);
//STRIP001 		aFmtLb.Show();
//STRIP001 		//                              aFilterLb.Enable();
//STRIP001 		// Falls bHierarchical, kann sich die Familie geaendert haben
//STRIP001         // minus one since hierarchical is inserted at the start
//STRIP001         FilterSelect(pBox->GetSelectEntryPos() - 1, bHierarchical );
//STRIP001 		bHierarchical=FALSE;
//STRIP001 //		UpdateStyles_Impl(UPDATE_FAMILY_LIST);  // Anzeige aktualisieren
//STRIP001 	}
//STRIP001 
/*N*/ 	return 0;
/*N*/ }

//-------------------------------------------------------------------------

// Select-Handler der Toolbox
/*N*/ void SfxCommonTemplateDialog_Impl::FamilySelect(USHORT nEntry)
/*N*/ {
/*N*/ 	USHORT nFamily = nActFamily;
/*N*/ 	if( nEntry != nActFamily )
/*N*/ 	{
/*N*/ 		CheckItem( nActFamily, FALSE );
/*N*/ 		nActFamily = nEntry;
/*N*/ 		SfxDispatcher* pDispat = pBindings->GetDispatcher_Impl();
/*N*/ 		SfxUInt16Item aItem( SID_STYLE_FAMILY, nEntry );
/*N*/ 		pDispat->Execute( SID_STYLE_FAMILY, SFX_CALLMODE_SYNCHRON, &aItem, 0L );
/*N*/ 		pBindings->Invalidate( SID_STYLE_FAMILY );
/*N*/ 		pBindings->Update( SID_STYLE_FAMILY );
/*N*/ 		UpdateFamily_Impl();
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 void SfxCommonTemplateDialog_Impl::ActionSelect(USHORT nEntry)
//STRIP001 {
//STRIP001 	String aEmpty;
//STRIP001 	switch(nEntry)
//STRIP001 	{
//STRIP001 		case SID_STYLE_WATERCAN:
//STRIP001 		{
//STRIP001 			const BOOL bState = IsCheckedItem(nEntry);
//STRIP001 			BOOL bCheck;
//STRIP001 			SfxBoolItem aBool;
//STRIP001 			// wenn eine Vorlage ausgewaehlt ist.
//STRIP001 			if(!bState && aFmtLb.GetSelectionCount())
//STRIP001 			{
//STRIP001 				const String aTemplName(
//STRIP001 					GetSelectedEntry());
//STRIP001 				Execute_Impl(
//STRIP001 					SID_STYLE_WATERCAN, aTemplName, aEmpty,
//STRIP001 					(USHORT)GetFamilyItem_Impl()->GetFamily() );
//STRIP001 				bCheck = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				Execute_Impl(SID_STYLE_WATERCAN, aEmpty, aEmpty, 0);
//STRIP001 				bCheck = FALSE;
//STRIP001 			}
//STRIP001 			CheckItem(nEntry, bCheck);
//STRIP001 			aBool.SetValue(bCheck);
//STRIP001 			SetWaterCanState(&aBool);
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 		{
//STRIP001 			if(pStyleSheetPool && nActFamily != 0xffff)
//STRIP001 			{
//STRIP001 				const SfxStyleFamily eFam=GetFamilyItem_Impl()->GetFamily();
//STRIP001 //pStyleSheetPool->GetSearchFamily();
//STRIP001 				const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
//STRIP001 				USHORT nFilter;
//STRIP001 				if(pItem&&nActFilter!=0xffff)
//STRIP001 				{
//STRIP001 					nFilter = pItem->GetFilterList().GetObject(
//STRIP001 						nActFilter)->nFlags;
//STRIP001 					if(!nFilter)    // automatisch
//STRIP001 						nFilter = nAppFilter;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nFilter=pStyleSheetPool->GetSearchMask();
//STRIP001 				pStyleSheetPool->SetSearchMask( eFam, SFXSTYLEBIT_USERDEF );
//STRIP001 
//STRIP001 				SfxNewStyleDlg *pDlg =
//STRIP001 					// FloatingWindow must not be parent of a modal dialog
//STRIP001 					new SfxNewStyleDlg(SFX_APP()->GetTopWindow(), *pStyleSheetPool);
//STRIP001 				if(RET_OK == pDlg->Execute())
//STRIP001 				{
//STRIP001 					pStyleSheetPool->SetSearchMask(eFam, nFilter);
//STRIP001 					const String aTemplName(pDlg->GetName());
//STRIP001 					Execute_Impl(SID_STYLE_NEW_BY_EXAMPLE,
//STRIP001 								 aTemplName, aEmpty,
//STRIP001 								 (USHORT)GetFamilyItem_Impl()->GetFamily(),
//STRIP001 								 nFilter);
//STRIP001 				}
//STRIP001 				pStyleSheetPool->SetSearchMask( eFam, nFilter );
//STRIP001 				delete pDlg;
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case SID_STYLE_UPDATE_BY_EXAMPLE:
//STRIP001 		{
//STRIP001 			Execute_Impl(SID_STYLE_UPDATE_BY_EXAMPLE,
//STRIP001 					aEmpty, aEmpty,
//STRIP001 					(USHORT)GetFamilyItem_Impl()->GetFamily());
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		default: DBG_ERROR("not implemented"); break;
//STRIP001 	}
//STRIP001 }


//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxCommonTemplateDialog_Impl, DropHdl, StyleTreeListBox_Impl *, pBox )
//STRIP001 {
//STRIP001 	bDontUpdate=TRUE;
//STRIP001 	const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
//STRIP001 	const SfxStyleFamily eFam = pItem->GetFamily();
//STRIP001 	long ret= pStyleSheetPool->SetParent(eFam,pBox->GetStyle(), pBox->GetParent())? 1L: 0L;
//STRIP001 	bDontUpdate=FALSE;
//STRIP001 	return ret;
//STRIP001 }

//-------------------------------------------------------------------------

// Handler des Neu-Buttons
//STRIP001 void SfxCommonTemplateDialog_Impl::NewHdl(void *)
//STRIP001 {
//STRIP001 	String aEmpty;
//STRIP001 	if ( nActFamily != 0xffff )
//STRIP001 	{
//STRIP001 		Window* pTmp;
//STRIP001 		pTmp = Application::GetDefDialogParent();
//STRIP001 		if ( ISA(SfxTemplateDialog_Impl) )
//STRIP001 			Application::SetDefDialogParent( pWindow->GetParent() );
//STRIP001 		else
//STRIP001 			Application::SetDefDialogParent( pWindow );
//STRIP001 
//STRIP001 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
//STRIP001 		const SfxStyleFamily eFam=pItem->GetFamily();
//STRIP001 		USHORT nMask;
//STRIP001 		if(pItem&&nActFilter!=0xffff)
//STRIP001 		{
//STRIP001 			nMask = pItem->GetFilterList().GetObject(
//STRIP001 				nActFilter)->nFlags;
//STRIP001 			if(!nMask)    // automatisch
//STRIP001 				nMask = nAppFilter;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nMask=pStyleSheetPool->GetSearchMask();
//STRIP001 
//STRIP001 		pStyleSheetPool->SetSearchMask(eFam,nMask);
//STRIP001 
//STRIP001 		Execute_Impl(SID_STYLE_NEW,
//STRIP001 					 aEmpty, GetSelectedEntry(),
//STRIP001 					 ( USHORT )GetFamilyItem_Impl()->GetFamily(),
//STRIP001 					 nMask);
//STRIP001 
//STRIP001 		Application::SetDefDialogParent( pTmp );
//STRIP001 
//STRIP001 /*              {
//STRIP001 			DBG_ASSERT(nFilter < aFilterLb.GetEntryCount(),
//STRIP001 					   "Filter ueberindiziert");
//STRIP001 
//STRIP001 			if(!pTreeBox)
//STRIP001 			{
//STRIP001 //                              aFilterLb.SelectEntryPos(nFilter);
//STRIP001 				FilterSelect(nActFilter, TRUE);
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				FillTreeBox();
//STRIP001 				SfxTemplateItem *pState = pFamilyState[nActFamily-1];
//STRIP001 				if(pState)
//STRIP001 				{
//STRIP001 					const String aStyle(pState->GetStyleName());
//STRIP001 					SelectStyle(aStyle);
//STRIP001 				}
//STRIP001 				EnableDelete();
//STRIP001 			}*/
//STRIP001 //              }
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

// Handler des Bearbeiten-Buttons
//STRIP001 void SfxCommonTemplateDialog_Impl::EditHdl(void *)
//STRIP001 {
//STRIP001 	if(IsInitialized() && HasSelectedStyle())
//STRIP001 	{
//STRIP001 		USHORT nFilter = nActFilter;
//STRIP001 		String aTemplName(GetSelectedEntry());
//STRIP001 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
//STRIP001 		const SfxStyleFamily eFam = pItem->GetFamily();
//STRIP001 		SfxStyleSheetBase *pStyle =
//STRIP001 			pStyleSheetPool->Find(aTemplName,eFam,SFXSTYLEBIT_ALL);
//STRIP001 		Window* pTmp;
//STRIP001 		//DefModalDialogParent setzen fuer
//STRIP001 		//Modalitaet der nachfolgenden Dialoge
//STRIP001 		pTmp = Application::GetDefDialogParent();
//STRIP001 		if ( ISA(SfxTemplateDialog_Impl) )
//STRIP001 			Application::SetDefDialogParent( pWindow->GetParent() );
//STRIP001 		else
//STRIP001 			Application::SetDefDialogParent( pWindow );
//STRIP001 		if ( Execute_Impl( SID_STYLE_EDIT, aTemplName, String(),
//STRIP001 						  (USHORT)GetFamilyItem_Impl()->GetFamily(), 0, &nFilter ) )
//STRIP001 		{
//STRIP001 //			DBG_ASSERT(nFilter < aFilterLb.GetEntryCount(), "Filter ueberindiziert");
//STRIP001 //			aTemplName = pStyle->GetName();
//STRIP001 // kann durch Bearbeiten umbenannt worden sein
//STRIP001 /*                      if(!pTreeBox)
//STRIP001 			{
//STRIP001 				//                              aFilterLb.SelectEntryPos(nFilter);
//STRIP001 				//                              FilterSelect(nFilter, TRUE);
//STRIP001 			}
//STRIP001 			else
//STRIP001 				FillTreeBox();*/
//STRIP001 		}
//STRIP001 		Application::SetDefDialogParent( pTmp );
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

// Handler des L"oschen-Buttons
//STRIP001 void SfxCommonTemplateDialog_Impl::DeleteHdl(void *)
//STRIP001 {
//STRIP001 	if ( IsInitialized() && HasSelectedStyle() )
//STRIP001 	{
//STRIP001 		const String aTemplName( GetSelectedEntry() );
//STRIP001 		const SfxStyleFamilyItem* pItem = GetFamilyItem_Impl();
//STRIP001 		SfxStyleSheetBase* pStyle =
//STRIP001 			pStyleSheetPool->Find( aTemplName, pItem->GetFamily(), SFXSTYLEBIT_ALL );
//STRIP001 		if ( pStyle )
//STRIP001 		{
//STRIP001 			String aMsg;
//STRIP001 			if ( pStyle->IsUsed() )
//STRIP001 				aMsg = String( SfxResId( STR_DELETE_STYLE_USED ) );
//STRIP001 			aMsg += String ( SfxResId( STR_DELETE_STYLE ) );
//STRIP001 			aMsg.SearchAndReplaceAscii( "$1", aTemplName );
//STRIP001 #if defined UNX
//STRIP001 			QueryBox aBox( SFX_APP()->GetTopWindow(), WB_YES_NO | WB_DEF_NO, aMsg );
//STRIP001 #else
//STRIP001 			QueryBox aBox( GetWindow(), WB_YES_NO | WB_DEF_NO , aMsg );
//STRIP001 #endif
//STRIP001 			if ( RET_YES == aBox.Execute() )
//STRIP001 			{
//STRIP001 				PrepareDeleteAction();
//STRIP001 
//STRIP001 				if ( pTreeBox ) // Damit die Treelistbox beim L"oschen nicht zuklappt
//STRIP001 				{
//STRIP001 					bDontUpdate = TRUE;
//STRIP001 				}
//STRIP001 				Execute_Impl( SID_STYLE_DELETE, aTemplName,
//STRIP001 						  	String(), (USHORT)GetFamilyItem_Impl()->GetFamily() );
//STRIP001 
//STRIP001 				if ( pTreeBox )
//STRIP001 				{
//STRIP001 					pTreeBox->RemoveParentKeepChilds( pTreeBox->FirstSelected() );
//STRIP001 					bDontUpdate = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ void    SfxCommonTemplateDialog_Impl::EnableDelete()
/*N*/ {
/*N*/ 	if(IsInitialized() && HasSelectedStyle())
/*N*/ 	{
/*N*/ 		DBG_ASSERT(pStyleSheetPool, "Kein StyleSheetPool");
/*N*/ 		const String aTemplName(GetSelectedEntry());
/*N*/ 		const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 		const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/         USHORT nFilter = 0;
/*N*/         if(pItem->GetFilterList().Count() > nActFilter)
/*N*/             nFilter = pItem->GetFilterList().GetObject(nActFilter)->nFlags;
/*N*/ 		if(!nFilter)    // automatisch
/*N*/ 			nFilter = nAppFilter;
/*N*/ 		const SfxStyleSheetBase *pStyle =
/*N*/ 			pStyleSheetPool->Find(aTemplName,eFam,
/*N*/ 								  pTreeBox? SFXSTYLEBIT_ALL: nFilter);
/*N*/ 		DBG_ASSERT(pStyle, "Style nicht gefunden");
/*N*/ 		if(pStyle && pStyle->IsUserDefined())
/*N*/ 		{
/*N*/ 			EnableDel(TRUE);
/*N*/ 		}
/*N*/ 		else
/*N*/ 		{
/*N*/ 			EnableDel(FALSE);
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		EnableDel(FALSE);
/*N*/ 	}
/*N*/ //	rBindings.Invalidate( SID_STYLE_DELETE );
/*N*/ //	rBindings.Update( SID_STYLE_DELETE );
/*N*/ }

//-------------------------------------------------------------------------

// nach Selektion eines Eintrags den Focus gfs. wieder auf das App-Fenster
// setzen
//STRIP001 void    SfxCommonTemplateDialog_Impl::ResetFocus()
//STRIP001 {
//STRIP001 	if(ISA(SfxTemplateDialog_Impl))
//STRIP001 	{
//STRIP001 		SfxViewFrame *pViewFrame = pBindings->GetDispatcher_Impl()->GetFrame();
//STRIP001 		SfxViewShell *pVu = pViewFrame->GetViewShell();
//STRIP001 		Window *pAppWin = pVu ? pVu->GetWindow(): 0;
//STRIP001 		if(pAppWin)
//STRIP001 			pAppWin->GrabFocus();
//STRIP001 	}
//STRIP001 }

//-------------------------------------------------------------------------

// Doppelclick auf ein StyleSheet in der ListBox, wird angewendet.
/*?*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, ApplyHdl, Control *, pControl )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 		// nur, wenn dieser Bereich erlaubt ist
//STRIP001 	if ( IsInitialized() && 0 != pFamilyState[nActFamily-1] &&
//STRIP001 		 GetSelectedEntry().Len() )
//STRIP001 	{
//STRIP001 		USHORT nModifier = aFmtLb.GetModifier();
//STRIP001 		Execute_Impl(SID_STYLE_APPLY,
//STRIP001 					 GetSelectedEntry(), String(),
//STRIP001 					 ( USHORT )GetFamilyItem_Impl()->GetFamily(),
//STRIP001 					 0, 0, &nModifier );
//STRIP001 		if(ISA(SfxTemplateCatalog_Impl))
//STRIP001 			((SfxTemplateCatalog_Impl*) this)->pReal->EndDialog(RET_OK);
//STRIP001     }
//STRIP001     ResetFocus();
//STRIP001 	return 0;
/*?*/ }

//-------------------------------------------------------------------------

// Selektion einer Vorlage w"ahrend des Watercan-Status
/*N*/ IMPL_LINK( SfxCommonTemplateDialog_Impl, FmtSelectHdl, SvTreeListBox *, pListBox )
/*N*/ {
/*N*/ 	// HilfePI antriggern, wenn von Call als Handler und Bereich erlaubt ist
/*N*/ 	if( !pListBox || pListBox->IsSelected( pListBox->GetHdlEntry() ) )
/*N*/ 	{
/*N*/ #ifdef WIR_KOENNEN_WIEDER_HILFE_FUER_STYLESHEETS
/*N*/ 		SfxHelpPI* pHelpPI = SFX_APP()->GetHelpPI();
/*N*/ 		if ( pHelpPI && pListBox && IsInitialized() &&
/*N*/ 			 GetSelectedEntry().Len() )
/*N*/ 		{
/*N*/ 			const SfxStyleFamilyItem *pItem = GetFamilyItem_Impl();
/*N*/ 			const SfxStyleFamily eFam = pItem->GetFamily();
/*N*/ 			DBG_ASSERT(pStyleSheetPool, "Kein Pool");
/*N*/ 			// SfxStyleSheetBase* pStyle = pStyleSheetPool
/*N*/ 			//		? pStyleSheetPool->Find( GetSelectedEntry(), eFam ) : 0;
/*N*/ 			SfxStyleSheetBase *pStyle;
/*N*/ 			if ( pStyleSheetPool )
/*N*/ 				pStyle = pStyleSheetPool->Find ( GetSelectedEntry(), eFam );
/*N*/ 			else
/*N*/ 				pStyle = 0;
/*N*/ 
/*N*/ 			if ( pStyle )
/*N*/ 			{
/*N*/ 				String aHelpFile;
/*N*/ 				ULONG nHelpId=pStyle->GetHelpId(aHelpFile);
/*N*/ 				if ( nHelpId )
/*N*/ 					pHelpPI->LoadTopic( nHelpId );
/*N*/ 			}
/*N*/ 		}
/*N*/ #endif
/*N*/ 
/*N*/ 		// nur, wenn Giesskanne an ist
/*N*/ 		if ( IsInitialized() &&
/*N*/ 			 IsCheckedItem(SID_STYLE_WATERCAN) &&
/*N*/ 			 // nur, wenn dieser Bereich erlaubt ist
/*N*/ 			 0 != pFamilyState[nActFamily-1] )
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			String aEmpty;
//STRIP001 /*?*/ 			Execute_Impl(SID_STYLE_WATERCAN,
//STRIP001 /*?*/ 						 aEmpty, aEmpty, 0);
//STRIP001 /*?*/ 			Execute_Impl(SID_STYLE_WATERCAN,
//STRIP001 /*?*/ 						 GetSelectedEntry(), aEmpty,
//STRIP001 /*?*/ 						 ( USHORT )GetFamilyItem_Impl()->GetFamily());
/*N*/ 		}
/*N*/ //		EnableEdit(TRUE);
/*N*/ 		EnableItem(SID_STYLE_WATERCAN, !bWaterDisabled);
/*N*/ 		EnableDelete();
/*N*/ 	}
/*N*/ 	if( pListBox )
/*N*/ 		SelectStyle( pListBox->GetEntryText( pListBox->GetHdlEntry() ));
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxCommonTemplateDialog_Impl, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	if( pMenu )
//STRIP001 	{
//STRIP001 		nLastItemId = pMenu->GetCurItemId();
//STRIP001 		Application::PostUserEvent(
//STRIP001 			LINK( this, SfxCommonTemplateDialog_Impl, MenuSelectHdl ), 0 );
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch(nLastItemId) {
//STRIP001 	case ID_NEW: NewHdl(0); break;
//STRIP001 	case ID_EDIT: EditHdl(0); break;
//STRIP001 	case ID_DELETE: DeleteHdl(0); break;
//STRIP001 	default: return FALSE;
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SfxCommonTemplateDialog_Impl::ExecuteContextMenu_Impl( const Point& rPos, Window* pWin )
//STRIP001 {
//STRIP001 	// Bug# 94152: This part should never be called, because before this happens, the TreeListBox should captured this!
//STRIP001 	DBG_ASSERT( FALSE, "+SfxCommonTemplateDialog_Impl::ExecuteContextMenu_Impl(): How could this happen? Please infirm developer ASAP!" );
//STRIP001 
//STRIP001 	PopupMenu* pMenu = CreateContextMenu();
//STRIP001 	pMenu->Execute( pWin, rPos );
//STRIP001 	delete pMenu;
//STRIP001 }

// -----------------------------------------------------------------------

/*N*/ SfxStyleFamily SfxCommonTemplateDialog_Impl::GetActualFamily() const
/*N*/ {
/*N*/ 	const SfxStyleFamilyItem *pFamilyItem = GetFamilyItem_Impl();
/*N*/ 	if( !pFamilyItem || nActFamily == 0xffff )
/*N*/ 		return SFX_STYLE_FAMILY_PARA;
/*N*/ 	else
/*N*/ 		return pFamilyItem->GetFamily();
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::EnableExample_Impl(USHORT nId, BOOL bEnable)
/*N*/ {
/*N*/ 	if( nId == SID_STYLE_NEW_BY_EXAMPLE )
/*N*/ 		bNewByExampleDisabled = !bEnable;
/*N*/ 	else if( nId == SID_STYLE_UPDATE_BY_EXAMPLE )
/*N*/ 		bUpdateByExampleDisabled = !bEnable;
/*N*/ 	EnableItem(nId, bEnable);
/*N*/ }

/*?*/ void SfxCommonTemplateDialog_Impl::PrepareDeleteAction()
/*?*/ {
/*?*/ }

// -----------------------------------------------------------------------

/*?*/ PopupMenu* SfxCommonTemplateDialog_Impl::CreateContextMenu( void )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return NULL;//STRIP001 
//STRIP001 	if ( bBindingUpdate )
//STRIP001 	{
//STRIP001 		pBindings->Invalidate( SID_STYLE_NEW, TRUE, FALSE );
//STRIP001 		pBindings->Update( SID_STYLE_NEW );
//STRIP001 		bBindingUpdate = FALSE;
//STRIP001 	}
//STRIP001 	PopupMenu* pMenu = new PopupMenu( SfxResId( MN_CONTEXT_TEMPLDLG ) );
//STRIP001 	pMenu->SetSelectHdl( LINK( this, SfxCommonTemplateDialog_Impl, MenuSelectHdl ) );
//STRIP001 	pMenu->EnableItem( ID_EDIT, bCanEdit );
//STRIP001 	pMenu->EnableItem( ID_DELETE, bCanDel );
//STRIP001 	pMenu->EnableItem( ID_NEW, bCanNew );
//STRIP001 
//STRIP001 	return pMenu;
/*?*/ }

// ------------------------------------------------------------------------

/*N*/ SfxTemplateDialog_Impl::SfxTemplateDialog_Impl(
/*N*/ 	Window* pParent, SfxBindings* pB, SfxTemplateDialog* pWindow ) :
/*N*/ 
/*N*/ 	SfxCommonTemplateDialog_Impl( pB, pWindow ),
/*N*/ 
/*N*/ 	m_pFloat			( pWindow ),
/*N*/ 	m_bZoomIn			( FALSE ),
/*N*/ 	m_aActionTbL		( pWindow ),
/*N*/ 	m_aActionTbR		( pWindow, ResId( TB_ACTION ) )
/*N*/ 
/*N*/ {
/*N*/ 
/*N*/ 	pWindow->FreeResource();
/*N*/ 	Initialize();
/*N*/ 
/*N*/ 	m_aActionTbL.SetSelectHdl(LINK(this, SfxTemplateDialog_Impl, ToolBoxLSelect));
/*N*/ 	m_aActionTbR.SetSelectHdl(LINK(this, SfxTemplateDialog_Impl, ToolBoxRSelect));
/*N*/ 	m_aActionTbL.Show();
/*N*/ 	m_aActionTbR.Show();
/*N*/ 	Font aFont=aFilterLb.GetFont();
/*N*/ 	aFont.SetWeight( WEIGHT_NORMAL );
/*N*/ 	aFilterLb.SetFont( aFont );
/*N*/ 	m_aActionTbL.SetHelpId( HID_TEMPLDLG_TOOLBOX_LEFT );
/*N*/ 
/*N*/     SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/     if ( pImgMgr )
/*N*/     {
/*N*/         pImgMgr->RegisterToolBox( &m_aActionTbL, SFX_TOOLBOX_CHANGEOUTSTYLE );
/*N*/         pImgMgr->RegisterToolBox( &m_aActionTbR, SFX_TOOLBOX_CHANGEOUTSTYLE );
/*N*/     }
/*N*/ }

// ------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::EnableFamilyItem( USHORT nId, BOOL bEnable )
/*N*/ {
/*N*/ 	m_aActionTbL.EnableItem( nId, bEnable );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::InsertFamilyItem(USHORT nId,const SfxStyleFamilyItem *pItem)
/*N*/ {
/*N*/ 	USHORT nHelpId = 0;
/*N*/ 	switch( (USHORT) pItem->GetFamily() )
/*N*/ 	{
/*N*/ 		case SFX_STYLE_FAMILY_CHAR: nHelpId = SID_STYLE_FAMILY1; break;
/*N*/ 		case SFX_STYLE_FAMILY_PARA: nHelpId = SID_STYLE_FAMILY2; break;
/*N*/ 		case SFX_STYLE_FAMILY_FRAME:nHelpId = SID_STYLE_FAMILY3; break;
/*N*/ 		case SFX_STYLE_FAMILY_PAGE: nHelpId = SID_STYLE_FAMILY4; break;
/*N*/ 		case SFX_STYLE_FAMILY_PSEUDO: nHelpId = SID_STYLE_FAMILY5; break;
/*N*/ 		default: DBG_ERROR("unbekannte StyleFamily"); break;
/*N*/ 	}
/*N*/ 	m_aActionTbL.InsertItem( nId, pItem->GetImage(), pItem->GetText(), 0, 0);
/*N*/ 	m_aActionTbL.SetHelpId( nId, nHelpId );
/*N*/ }

// ------------------------------------------------------------------------
/*N*/ void SfxTemplateDialog_Impl::updateFamilyImages()
/*N*/ {
/*N*/ 	if ( !m_pStyleFamiliesId )
/*N*/ 		// we do not have a resource id to load the new images from
/*N*/ 		return;
/*N*/ 
/*N*/ 	// let the families collection update the images
/*N*/ 	sal_Bool bIsHighContrast = m_pFloat->GetDisplayBackground().GetColor().IsDark();
/*N*/ 	pStyleFamilies->updateImages( *m_pStyleFamiliesId, bIsHighContrast ? BMP_COLOR_HIGHCONTRAST : BMP_COLOR_NORMAL );
/*N*/ 
/*N*/ 	// and set the new images on our toolbox
/*N*/ 	USHORT nLoop = pStyleFamilies->Count();
/*N*/ 	for( ; nLoop--; )
/*N*/ 	{
/*N*/ 		const SfxStyleFamilyItem *pItem = pStyleFamilies->GetObject( nLoop );
/*N*/ 		USHORT nId = SfxFamilyIdToNId( (USHORT) pItem->GetFamily() );
/*N*/ 		m_aActionTbL.SetItemImage( nId, pItem->GetImage() );
/*N*/ 	}
/*N*/ }

// ------------------------------------------------------------------------
/*N*/ void SfxTemplateDialog_Impl::updateNonFamilyImages()
/*N*/ {
/*N*/ 	m_aActionTbR.SetImageList( ImageList( SfxResId(
/*N*/ 		m_pFloat->GetDisplayBackground().GetColor().IsDark() ? IMG_LST_STYLE_DESIGNER_HC
/*N*/ 															 : DLG_STYLE_DESIGNER ) ) );
/*N*/ }

// ------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog_Impl::ClearFamilyList()
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	m_aActionTbL.Clear();
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxCommonTemplateDialog_Impl::InvalidateBindings()
/*N*/ {
/*N*/ 	pBindings->Invalidate(SID_STYLE_NEW_BY_EXAMPLE, TRUE, FALSE);
/*N*/ 	pBindings->Update( SID_STYLE_NEW_BY_EXAMPLE );
/*N*/ 	pBindings->Invalidate(SID_STYLE_UPDATE_BY_EXAMPLE, TRUE, FALSE);
/*N*/ 	pBindings->Update( SID_STYLE_UPDATE_BY_EXAMPLE );
/*N*/ 	pBindings->Invalidate( SID_STYLE_WATERCAN, TRUE, FALSE);
/*N*/ 	pBindings->Update( SID_STYLE_WATERCAN );
/*N*/ 	pBindings->Invalidate( SID_STYLE_NEW, TRUE, FALSE );
/*N*/ 	pBindings->Update( SID_STYLE_NEW );
/*N*/ 	pBindings->Invalidate( SID_STYLE_DRAGHIERARCHIE, TRUE, FALSE );
/*N*/ 	pBindings->Update( SID_STYLE_DRAGHIERARCHIE );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxTemplateDialog_Impl::~SfxTemplateDialog_Impl()
/*N*/ {
/*N*/     SfxImageManager* pImgMgr = pBindings->GetImageManager();
/*N*/     if ( pImgMgr )
/*N*/     {
/*N*/         pImgMgr->ReleaseToolBox( &m_aActionTbL );
/*N*/         pImgMgr->ReleaseToolBox( &m_aActionTbR );
/*N*/     }
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::LoadedFamilies()
/*N*/ {
/*N*/ 	updateFamilyImages();
/*N*/ 	Resize();
/*N*/ }

//-------------------------------------------------------------------------

// "Uberladener Resize-Handler ( StarView )
// Die Groesse der Listboxen wird angepasst
/*N*/ void SfxTemplateDialog_Impl::Resize()
/*N*/ {
/*N*/ 	FloatingWindow *pF = m_pFloat->GetFloatingWindow();
/*N*/ 	if ( pF )
/*N*/ 	{
/*N*/ // 		if(pF->IsZoomedIn() && m_bZoomIn==FALSE)
/*N*/ // 			pF->SetText(String(SfxResId( DLG_STYLE_DESIGNER )));
/*N*/ // 		if(!pF->IsZoomedIn() && m_bZoomIn==TRUE && GetFamilyItem_Impl())
/*N*/ // 			UpdateStyles_Impl(UPDATE_FAMILY); //Bereich wieder in Titel schreiben
/*N*/ 		m_bZoomIn = pF->IsRollUp();
/*N*/ 		if ( m_bZoomIn )
/*N*/ 			return;
/*N*/ 	}
/*N*/ 
/*N*/ 	Size aDlgSize=m_pFloat->PixelToLogic(m_pFloat->GetOutputSizePixel());
/*N*/ 	Size aSizeATL=m_pFloat->PixelToLogic(m_aActionTbL.CalcWindowSizePixel());
/*N*/ 	Size aSizeATR=m_pFloat->PixelToLogic(m_aActionTbR.CalcWindowSizePixel());
/*N*/ 	Size aMinSize = GetMinOutputSizePixel();
/*N*/ 
/*N*/ 	long nListHeight = m_pFloat->PixelToLogic( aFilterLb.GetSizePixel() ).Height();
/*N*/ 	long nWidth = aDlgSize.Width()- 2 * SFX_TEMPLDLG_HFRAME;
/*N*/ 
/*N*/ 	m_aActionTbL.SetPosSizePixel(m_pFloat->LogicToPixel(Point(SFX_TEMPLDLG_HFRAME,SFX_TEMPLDLG_VTOPFRAME)),
/*N*/ 								 m_pFloat->LogicToPixel(aSizeATL));
/*N*/ 
/*N*/ 	// Die Position der rechten Toolbox nur ver"andern, wenn das Fenster
/*N*/ 	// breit genug ist
/*N*/ 	Point aPosATR(aDlgSize.Width()-SFX_TEMPLDLG_HFRAME-aSizeATR.Width(),SFX_TEMPLDLG_VTOPFRAME);
/*N*/ 	if(aDlgSize.Width() >= aMinSize.Width())
/*N*/ 		m_aActionTbR.SetPosPixel(m_pFloat->LogicToPixel(aPosATR));
/*N*/ 	else
/*N*/ 		m_aActionTbR.SetPosPixel( m_pFloat->LogicToPixel(
/*N*/ 			Point( SFX_TEMPLDLG_HFRAME + aSizeATL.Width() + SFX_TEMPLDLG_MIDHSPACE,
/*N*/ 				   SFX_TEMPLDLG_VTOPFRAME ) ) );
/*N*/ 
/*N*/ 	m_aActionTbR.SetSizePixel(m_pFloat->LogicToPixel(aSizeATR));
/*N*/ 
/*N*/ 	Point aFilterPos(
/*N*/ 		m_pFloat->LogicToPixel(Point(SFX_TEMPLDLG_HFRAME,
/*N*/ 			aDlgSize.Height()-SFX_TEMPLDLG_VBOTFRAME-nListHeight)) );
/*N*/ 
/*N*/ 	Size aFilterSize(
/*N*/ 		m_pFloat->LogicToPixel(Size(nWidth,SFX_TEMPLDLG_FILTERHEIGHT)) );
/*N*/ 
/*N*/ 	Point aFmtPos(
/*N*/ 		m_pFloat->LogicToPixel(Point(SFX_TEMPLDLG_HFRAME, SFX_TEMPLDLG_VTOPFRAME +
/*N*/ 							SFX_TEMPLDLG_MIDVSPACE+aSizeATL.Height())) );
/*N*/ 	Size aFmtSize(
/*N*/ 		m_pFloat->LogicToPixel(Size(nWidth,
/*N*/ 					aDlgSize.Height() - SFX_TEMPLDLG_VBOTFRAME -
/*N*/ 					SFX_TEMPLDLG_VTOPFRAME - 2*SFX_TEMPLDLG_MIDVSPACE-
/*N*/ 					nListHeight-aSizeATL.Height())) );
/*N*/ 
/*N*/ 	// Die Position der Listboxen nur ver"andern, wenn das Fenster
/*N*/ 	// hoch genug ist
/*N*/ 	if(aDlgSize.Height() >= aMinSize.Height())
/*N*/ 	{
/*N*/ 		aFilterLb.SetPosPixel(aFilterPos);
/*N*/ 		aFmtLb.SetPosPixel(	aFmtPos );
/*N*/ 		if(pTreeBox)
/*?*/ 			pTreeBox->SetPosPixel(aFmtPos);
/*N*/ 	}
/*N*/ 	else
/*?*/ 		aFmtSize.Height() += aFilterSize.Height();
/*N*/ 
/*N*/ 	aFilterLb.SetSizePixel(aFilterSize);
/*N*/ 	aFmtLb.SetSizePixel( aFmtSize );
/*N*/ 	if(pTreeBox)
/*?*/ 		pTreeBox->SetSizePixel(aFmtSize);
/*N*/ }

// -----------------------------------------------------------------------


/*N*/ Size SfxTemplateDialog_Impl::GetMinOutputSizePixel()
/*N*/ {
/*N*/ 	Size aSizeATL=m_pFloat->PixelToLogic(m_aActionTbL.CalcWindowSizePixel());
/*N*/ 	Size aSizeATR=m_pFloat->PixelToLogic(m_aActionTbR.CalcWindowSizePixel());
/*N*/ 	Size aMinSize=Size(
/*N*/ 		aSizeATL.Width()+aSizeATR.Width()+
/*N*/ 		2*SFX_TEMPLDLG_HFRAME + SFX_TEMPLDLG_MIDHSPACE,
/*N*/ 		4*aSizeATL.Height()+2*SFX_TEMPLDLG_MIDVSPACE);
/*N*/ 	return aMinSize;
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ void SfxTemplateDialog_Impl::Command( const CommandEvent& rCEvt )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if(COMMAND_CONTEXTMENU  == rCEvt.GetCommand())
//STRIP001 		ExecuteContextMenu_Impl( rCEvt.GetMousePosPixel(), m_pFloat );
//STRIP001 	else
//STRIP001 		m_pFloat->Command(rCEvt);
/*?*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::EnableItem(USHORT nMesId, BOOL bCheck)
/*N*/ {
/*N*/ 	String aEmpty;
/*N*/ 	switch(nMesId)
/*N*/ 	{
/*N*/ 	  case SID_STYLE_WATERCAN :
/*N*/ 		  if(!bCheck && IsCheckedItem(SID_STYLE_WATERCAN))
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Execute_Impl(SID_STYLE_WATERCAN, aEmpty, aEmpty, 0);
/*N*/ 	  case SID_STYLE_NEW_BY_EXAMPLE:
/*N*/ 	  case SID_STYLE_UPDATE_BY_EXAMPLE:
/*N*/ 		m_aActionTbR.EnableItem(nMesId,bCheck);
/*N*/ 		break;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ void SfxTemplateDialog_Impl::CheckItem(USHORT nMesId, BOOL bCheck)
/*N*/ {
/*N*/ 	switch(nMesId)
/*N*/ 	{
/*N*/ 		case SID_STYLE_WATERCAN :
/*N*/ 			bIsWater=bCheck;
/*N*/ 			m_aActionTbR.CheckItem(SID_STYLE_WATERCAN,bCheck);
/*N*/ 			break;
/*N*/ 		default:
/*N*/ 			m_aActionTbL.CheckItem(nMesId,bCheck); break;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ BOOL SfxTemplateDialog_Impl::IsCheckedItem(USHORT nMesId)
/*N*/ {
/*N*/ 	switch(nMesId)
/*N*/ 	{
/*N*/ 		case SID_STYLE_WATERCAN :
/*N*/ 			return m_aActionTbR.GetItemState(SID_STYLE_WATERCAN)==STATE_CHECK;
/*N*/ 		default:
/*?*/ 			return m_aActionTbL.GetItemState(nMesId)==STATE_CHECK;
/*N*/ 	}
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ IMPL_LINK_INLINE_START( SfxTemplateDialog_Impl, ToolBoxLSelect, ToolBox *, pBox )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	const USHORT nEntry = pBox->GetCurItemId();
//STRIP001 	FamilySelect(nEntry);
//STRIP001 	return 0;
/*?*/ }
/*?*/ IMPL_LINK_INLINE_END( SfxTemplateDialog_Impl, ToolBoxLSelect, ToolBox *, pBox )

//-------------------------------------------------------------------------

/*?*/ IMPL_LINK_INLINE_START( SfxTemplateDialog_Impl, ToolBoxRSelect, ToolBox *, pBox )
/*?*/ {DBG_BF_ASSERT(0, "STRIP"); return 0;//STRIP001 
//STRIP001 	const USHORT nEntry = pBox->GetCurItemId();
//STRIP001 	ActionSelect(nEntry);
//STRIP001 	return 0;
/*?*/ }
/*?*/ IMPL_LINK_INLINE_END( SfxTemplateDialog_Impl, ToolBoxRSelect, ToolBox *, pBox )

//-------------------------------------------------------------------------

//STRIP001 SfxTemplateCatalog_Impl::SfxTemplateCatalog_Impl( Window* pParent, SfxBindings* pB,
//STRIP001 												  SfxTemplateCatalog* pWindow ) :
//STRIP001 
//STRIP001 	SfxCommonTemplateDialog_Impl( pB, pWindow ),
//STRIP001 
//STRIP001 	aOkBtn		( pWindow, SfxResId( BT_OK ) ),
//STRIP001 	aCancelBtn	( pWindow, SfxResId( BT_CANCEL ) ),
//STRIP001 	aNewBtn		( pWindow, SfxResId( BT_NEW ) ),
//STRIP001 	aChangeBtn	( pWindow, SfxResId( BT_EDIT ) ),
//STRIP001 	aDelBtn		( pWindow, SfxResId( BT_DEL ) ),
//STRIP001 	aHelpBtn	( pWindow, SfxResId( BT_HELP ) ),
//STRIP001 	aOrgBtn		( pWindow, SfxResId( BT_ORG ) ),
//STRIP001 	aFamList	( pWindow, SfxResId( BT_TOOL ) ),
//STRIP001 	pReal		( pWindow ),
//STRIP001 	aHelper		( pWindow )
//STRIP001 
//STRIP001 {
//STRIP001 	aNewBtn.Disable();
//STRIP001 	aDelBtn.Disable();
//STRIP001 	aChangeBtn.Disable();
//STRIP001 
//STRIP001 	SFX_APP()->Get_Impl()->pTemplateCommon = GetISfxTemplateCommon();
//STRIP001 	pWindow->FreeResource();
//STRIP001 
//STRIP001 	Initialize();
//STRIP001 
//STRIP001 	aFamList.SetSelectHdl(	LINK( this, SfxTemplateCatalog_Impl, FamListSelect ) );
//STRIP001 	aOkBtn.SetClickHdl(		LINK( this, SfxTemplateCatalog_Impl, OkHdl ) );
//STRIP001 	aCancelBtn.SetClickHdl(	LINK( this, SfxTemplateCatalog_Impl, CancelHdl ) );
//STRIP001 	aNewBtn.SetClickHdl(	LINK( this, SfxTemplateCatalog_Impl, NewHdl ) );
//STRIP001 	aDelBtn.SetClickHdl(	LINK( this, SfxTemplateCatalog_Impl, DelHdl ) );
//STRIP001 	aChangeBtn.SetClickHdl(	LINK( this, SfxTemplateCatalog_Impl, ChangeHdl ) );
//STRIP001 	aOrgBtn.SetClickHdl(	LINK( this, SfxTemplateCatalog_Impl, OrgHdl ) );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 SfxTemplateCatalog_Impl::~SfxTemplateCatalog_Impl()
//STRIP001 {
//STRIP001 	SFX_APP()->Get_Impl()->pTemplateCommon = 0;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxTemplateCatalog_Impl, OkHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	ApplyHdl( NULL );
//STRIP001 	pReal->EndDialog( RET_OK );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxTemplateCatalog_Impl, OkHdl, Button *, pButton )

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxTemplateCatalog_Impl, CancelHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	pReal->EndDialog( RET_CANCEL );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxTemplateCatalog_Impl, CancelHdl, Button *, pButton )

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxTemplateCatalog_Impl, NewHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	aCancelBtn.SetText( String( SfxResId( STR_CLOSE ) ) );
//STRIP001 	SfxCommonTemplateDialog_Impl::NewHdl( NULL );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxTemplateCatalog_Impl, NewHdl, Button *, pButton )

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxTemplateCatalog_Impl, ChangeHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	aCancelBtn.SetText( String( SfxResId( STR_CLOSE ) ) );
//STRIP001 	SfxCommonTemplateDialog_Impl::EditHdl( NULL );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxTemplateCatalog_Impl, ChangeHdl, Button *, pButton )

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxTemplateCatalog_Impl, DelHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	SfxCommonTemplateDialog_Impl::DeleteHdl( NULL );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxTemplateCatalog_Impl, DelHdl, Button *, pButton )

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SfxTemplateCatalog_Impl, OrgHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	aCancelBtn.SetText( String( SfxResId( STR_CLOSE ) ) );
//STRIP001 	SfxDocumentTemplates aTemplates;
//STRIP001 	aTemplates.Construct();
//STRIP001 	SfxTemplateOrganizeDlg* pDlg = new SfxTemplateOrganizeDlg( pReal, &aTemplates );
//STRIP001 	const short nRet = pDlg->Execute();
//STRIP001 	delete pDlg;
//STRIP001 	if ( RET_OK == nRet )
//STRIP001 		Update_Impl();
//STRIP001 	else if ( RET_EDIT_STYLE == nRet )
//STRIP001 		pReal->EndDialog( RET_CANCEL );
//STRIP001 	return 0;
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxTemplateCatalog_Impl::EnableEdit( BOOL bEnable )
//STRIP001 {
//STRIP001 	SfxCommonTemplateDialog_Impl::EnableEdit( bEnable );
//STRIP001 	aChangeBtn.Enable( bEnable );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxTemplateCatalog_Impl::EnableDel( BOOL bEnable )
//STRIP001 {
//STRIP001 	SfxCommonTemplateDialog_Impl::EnableDel( bEnable );
//STRIP001 	aDelBtn.Enable( bEnable );
//STRIP001 }

//STRIP001 void SfxTemplateCatalog_Impl::EnableNew(BOOL bEnable)
//STRIP001 {
//STRIP001 	SfxCommonTemplateDialog_Impl::EnableNew( bEnable );
//STRIP001 	aNewBtn.Enable( bEnable );
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SfxTemplateCatalog_Impl, FamListSelect, ListBox *, pList )
//STRIP001 {
//STRIP001 	const USHORT nEntry = aFamIds[pList->GetSelectEntryPos()];
//STRIP001 	FamilySelect(nEntry);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SfxTemplateCatalog_Impl, FamListSelect, ListBox *, pList )

//-------------------------------------------------------------------------

//STRIP001 void SfxTemplateCatalog_Impl::EnableItem( USHORT nMesId, BOOL bCheck )
//STRIP001 {
//STRIP001 	if ( nMesId == SID_STYLE_WATERCAN )
//STRIP001 		aOkBtn.Enable( bCheck );
//STRIP001 	if ( nMesId > SFX_STYLE_FAMILY_PSEUDO || nMesId < SFX_STYLE_FAMILY_CHAR )
//STRIP001 		return;
//STRIP001 
//STRIP001 /*      for(USHORT i=0;i<aFamIds.Count&&aFamIds[i]!=nMesId;i++);
//STRIP001 	if(i!=aFamIds.Count())
//STRIP001 		aFamList.SelectEntry(aFamIds[i]);
//STRIP001 	else
//STRIP001 		DBG_ERROR("Entry nicht gefunden");*/
//STRIP001 
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxTemplateCatalog_Impl::CheckItem(USHORT nMesId, BOOL bCheck)
//STRIP001 {
//STRIP001 	if ( nMesId > SFX_STYLE_FAMILY_PSEUDO || nMesId < SFX_STYLE_FAMILY_CHAR )
//STRIP001 		return;
//STRIP001 	USHORT i;
//STRIP001 	for ( i = 0; i < aFamIds.Count() && aFamIds[i] != nMesId; i++ );
//STRIP001 	aFamList.SelectEntryPos(i);
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 BOOL SfxTemplateCatalog_Impl::IsCheckedItem(USHORT nMesId)
//STRIP001 {
//STRIP001 	if ( nMesId > SFX_STYLE_FAMILY_PSEUDO || nMesId < SFX_STYLE_FAMILY_CHAR )
//STRIP001 		return FALSE;
//STRIP001 	USHORT i;
//STRIP001 	for ( i = 0; i < aFamIds.Count() && aFamIds[i] != nMesId; i++ )
//STRIP001 		;
//STRIP001 	return aFamList.IsEntrySelected( String::CreateFromInt32(i) );
//STRIP001 }

//-------------------------------------------------------------------------

// Der Katalog muss nur das Disablen beherrschen, da waehrend seiner
// Lebenszeit keine Selektionsaenderungen vorgenommen werden koennen
//STRIP001 void SfxTemplateCatalog_Impl::EnableFamilyItem( USHORT nId, BOOL bEnable )
//STRIP001 {
//STRIP001 	if ( !bEnable )
//STRIP001 		for ( USHORT nPos = aFamIds.Count(); nPos--; )
//STRIP001 			if ( aFamIds[ nPos ] == nId )
//STRIP001 			{
//STRIP001 				aFamIds.Remove( nPos );
//STRIP001 				aFamList.RemoveEntry( nPos );
//STRIP001 			}
//STRIP001 }

//STRIP001 void SfxTemplateCatalog_Impl::InsertFamilyItem( USHORT nId, const SfxStyleFamilyItem* pItem )
//STRIP001 {
//STRIP001 	if ( nId > SFX_STYLE_FAMILY_PSEUDO || nId < SFX_STYLE_FAMILY_CHAR )
//STRIP001 		return;
//STRIP001 	aFamList.InsertEntry( pItem->GetText(), 0 );
//STRIP001 	aFamIds.Insert( nId, 0 );
//STRIP001 }

//STRIP001 void SfxTemplateCatalog_Impl::ClearFamilyList()
//STRIP001 {
//STRIP001 	aFamList.Clear();
//STRIP001 	aFamIds.Remove( 0, aFamIds.Count() );
//STRIP001 }

//STRIP001 void SfxTemplateCatalog_Impl::PrepareDeleteAction()
//STRIP001 {
//STRIP001 	aDelBtn.Disable();
//STRIP001 	aCancelBtn.SetText( String( SfxResId( STR_CLOSE ) ) );
//STRIP001 }


/*N*/ void SfxCommonTemplateDialog_Impl::SetFamily( USHORT nId )
/*N*/ {
/*N*/ 	if ( nId != nActFamily )
/*N*/ 	{
/*?*/ 		if ( nActFamily != 0xFFFF )
/*?*/ 			CheckItem( nActFamily, FALSE );
/*?*/ 		nActFamily = nId;
/*?*/ 		if ( nId != 0xFFFF )
/*?*/ 			bUpdateFamily = TRUE;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxCommonTemplateDialog_Impl::UpdateFamily_Impl()
/*N*/ {
/*N*/ 	bUpdateFamily = FALSE;
/*N*/ 
/*N*/ 	SfxDispatcher* pDispat = pBindings->GetDispatcher_Impl();
/*N*/ 	SfxViewFrame *pViewFrame = pDispat->GetFrame();
/*N*/ 	SfxObjectShell *pDocShell = pViewFrame->GetObjectShell();
/*N*/ 
/*N*/ 	SfxStyleSheetBasePool *pOldStyleSheetPool = pStyleSheetPool;
/*N*/ 	pStyleSheetPool = pDocShell? pDocShell->GetStyleSheetPool(): 0;
/*N*/ 	if ( pOldStyleSheetPool != pStyleSheetPool )
/*N*/ 	{
/*?*/ 		if ( pOldStyleSheetPool )
/*?*/ 			EndListening(*pOldStyleSheetPool);
/*?*/ 		if ( pStyleSheetPool )
/*?*/ 			StartListening(*pOldStyleSheetPool);
/*N*/ 	}
/*N*/ 
/*N*/ 	bWaterDisabled = FALSE;
/*N*/ 	bCanNew = TRUE;
/*N*/ 	bTreeDrag = TRUE;
/*N*/ 	bUpdateByExampleDisabled = FALSE;
/*N*/ 
/*N*/ 	if ( pStyleSheetPool )
/*N*/ 	{
/*N*/ 		if(!pTreeBox)
/*N*/ 			UpdateStyles_Impl(UPDATE_FAMILY | UPDATE_FAMILY_LIST);
/*N*/ 		else
/*N*/ 		{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 			UpdateStyles_Impl(UPDATE_FAMILY);
//STRIP001 /*?*/ 			FillTreeBox();
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	InvalidateBindings();
/*N*/ 
/*N*/ 	if ( IsCheckedItem( SID_STYLE_WATERCAN ) &&
/*N*/ 		 // nur, wenn dieser Bereich erlaubt ist
/*N*/ 		 0 != pFamilyState[ nActFamily - 1 ] )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 Execute_Impl( SID_STYLE_APPLY, GetSelectedEntry(),
//STRIP001 /*?*/ 					  String(), (USHORT)GetFamilyItem_Impl()->GetFamily() );
/*N*/ }

/*N*/ void SfxTemplateDialog::StateChanged( StateChangedType nStateChange )
/*N*/ {
/*N*/ 	if ( nStateChange == STATE_CHANGE_INITSHOW )
/*N*/ 	{
/*N*/ 		SfxViewFrame *pFrame = GetBindings().GetDispatcher_Impl()->GetFrame();
/*N*/ 		Window* pEditWin = pFrame->GetViewShell()->GetWindow();
/*N*/ 
/*N*/ 		Size aSize = pEditWin->GetSizePixel();
/*N*/ 		Point aPoint = pEditWin->OutputToScreenPixel( pEditWin->GetPosPixel() );
/*N*/ 		aPoint = GetParent()->ScreenToOutputPixel( aPoint );
/*N*/ 		Size aWinSize = GetSizePixel();
/*N*/ 		aPoint.X() += aSize.Width() - aWinSize.Width() - 20;
/*N*/ 		aPoint.Y() += aSize.Height() / 2 - aWinSize.Height() / 2;
/*N*/ 		SetFloatingPos( aPoint );
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxDockingWindow::StateChanged( nStateChange );
/*N*/ }


}
