/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_msg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:44:26 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SFXITEMPOOL_HXX //autogen
#include <svtools/itempool.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#pragma hdrstop

#include "msg.hxx"
namespace binfilter {

//====================================================================

/*N*/ SfxSlotKind SfxSlot::GetKind() const
/*N*/ {
/*N*/ 	if( !nMasterSlotId && !nValue)
/*N*/ 		return (SfxSlotKind) SFX_KIND_STANDARD;
/*N*/ 	if ( nMasterSlotId && fnExec==0 && fnState==0 )
/*N*/ 	{
/*N*/ 		if ( pType->Type() == TYPE(SfxBoolItem) )
/*N*/ 			return (SfxSlotKind) SFX_KIND_ENUM;
/*N*/ 		else
/*N*/ 		{
/*N*/ 			DBG_ERROR( "invalid slot kind detected" );
/*N*/ 			return SFX_KIND_ENUM;
/*N*/ 		}
/*N*/ 	}
/*N*/ 	else
/*N*/ 		return (SfxSlotKind) SFX_KIND_ATTR;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ USHORT SfxSlot::GetWhich( const SfxItemPool &rPool ) const
/*N*/ {
/*N*/ 	if ( !nMasterSlotId || nMasterSlotId == USHRT_MAX )
/*N*/ 		((SfxSlot*) this) -> nMasterSlotId = rPool.GetWhich(nSlotId);
/*N*/ 	return nMasterSlotId;
/*N*/ }


}
