/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_outlnvsh.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:42:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "app.hrc"
#define ITEMID_HYPERLINK    SID_HYPERLINK_SETLINK
#ifndef _SVX_DLG_HYPERLINK_HXX //autogen
#include <bf_offmgr/hyprlink.hxx>
#endif
#ifndef _SVX_TAB_HYPERLINK_HXX
#include <bf_svx/hyperdlg.hxx>
#endif

// auto strip #ifndef _SOT_EXCHANGE_HXX //autogen
// auto strip #include <sot/exchange.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_RULE_HXX //autogen
// auto strip #include <bf_svx/ruler.hxx>
// auto strip #endif
#ifndef _SVX_ZOOMITEM_HXX //autogen
#include <bf_svx/zoomitem.hxx>
#endif
// auto strip #ifndef _EEITEM_HXX //autogen
// auto strip #include <bf_svx/eeitem.hxx>
// auto strip #endif

// auto strip #ifndef _PSTM_HXX
// auto strip #include <tools/pstm.hxx>
// auto strip #endif

// auto strip #ifndef _SFXPOOLITEM_HXX
// auto strip #include <svtools/poolitem.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_ITEMDATA_HXX
// auto strip #include <bf_svx/itemdata.hxx>
// auto strip #endif

// auto strip #ifndef _DATE_HXX
// auto strip #include <tools/date.hxx>
// auto strip #endif

// auto strip #ifndef _TOOLS_TIME_HXX
// auto strip #include <tools/time.hxx>
// auto strip #endif

#define ITEMID_FIELD    EE_FEATURE_FIELD
// auto strip #ifndef _SVX_FLDITEM_HXX //autogen
// auto strip #include <bf_svx/flditem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_SHELL_HXX //autogen
// auto strip #include <bf_sfx2/shell.hxx>
// auto strip #endif
#ifndef _SFX_TEMPLDLG_HXX //autogen
#include <bf_sfx2/templdlg.hxx>
#endif
#ifndef _VIEWFAC_HXX //autogen
#include <bf_sfx2/viewfac.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_HLNKITEM_HXX //autogen
// auto strip #include <bf_svx/hlnkitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDOTEXT_HXX //autogen
// auto strip #include <bf_svx/svdotext.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
// auto strip #ifndef _SV_SCRBAR_HXX //autogen
// auto strip #include <vcl/scrbar.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _EDITSTAT_HXX //autogen
// auto strip #include <bf_svx/editstat.hxx>
// auto strip #endif
// auto strip #ifndef _SFXITEMPOOL_HXX //autogen
// auto strip #include <svtools/itempool.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_TPLPITEM_HXX //autogen
// auto strip #include <bf_sfx2/tplpitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVDORECT_HXX //autogen
// auto strip #include <bf_svx/svdorect.hxx>
// auto strip #endif
// auto strip #ifndef _SOT_FORMATS_HXX //autogen
// auto strip #include <sot/formats.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_TOPFRM_HXX //autogen wg. SfxTopViewFrame
// auto strip #include <bf_sfx2/topfrm.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LINGUISTIC2_XTHESAURUS_HPP_
// auto strip #include <com/sun/star/linguistic2/XThesaurus.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HDL_
#include <com/sun/star/i18n/TransliterationModules.hdl>
#endif
// auto strip #ifndef _UNO_LINGU_HXX
// auto strip #include <bf_svx/unolingu.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _OUTLOBJ_HXX
// auto strip #include <bf_svx/outlobj.hxx>
// auto strip #endif
// auto strip #ifndef _SVTOOLS_CJKOPTIONS_HXX
// auto strip #include <svtools/cjkoptions.hxx>
// auto strip #endif
// auto strip #ifndef _CLIPLISTENER_HXX
// auto strip #include <svtools/cliplistener.hxx>
// auto strip #endif
// auto strip #ifndef _EEITEMID_HXX
// auto strip #include <bf_svx/eeitemid.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_SRCHITEM_HXX
// auto strip #include <bf_sfx2/srchitem.hxx>
// auto strip #endif

// auto strip #ifndef _SD_OPTSITEM_HXX
// auto strip #include "optsitem.hxx"
// auto strip #endif

#include "strings.hrc"
#include "glob.hrc"
#include "res_bmp.hrc"

// auto strip #include "sdoutl.hxx"
// auto strip #include "sdwindow.hxx"
// auto strip #include "drtxtob.hxx"
// auto strip #include "drawdoc.hxx"
#include "outlnvsh.hxx"
#include "sdresid.hxx"
// auto strip #include "sdpage.hxx"
// auto strip #include "fuoltext.hxx"
// auto strip #include "frmview.hxx"
// auto strip #include "zoomlist.hxx"
// auto strip #include "stlsheet.hxx"
//STRIP001 #include "preview.hxx"
#include "prevchld.hxx"
// auto strip #include "fuslshow.hxx"
#include "SdUnoOutlineView.hxx"

// auto strip #ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
// auto strip #include <com/sun/star/document/XEventListener.hpp>
// auto strip #endif

// auto strip #ifndef _SVX_ACCESSIBILITY_ACCESSIBLE_SHAPE_TREE_INFO_HXX
// auto strip #include <bf_svx/AccessibleShapeTreeInfo.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_ACCESSIBILITY_CHILDREN_MANAGER_HXX
// auto strip #include <bf_svx/ChildrenManager.hxx>
// auto strip #endif

// auto strip #ifndef _SD_ACCESSIBILITY_ACCESSIBLE_OUTLINE_VIEW_HXX
// auto strip #include "AccessibleOutlineView.hxx"
// auto strip #endif
namespace binfilter {

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::linguistic2;

#define MIN_ZOOM	       10       // Minimaler Zoomfaktor
#define MAX_ZOOM	     1000	    // Maximaler Zoomfaktor

/************************************************************************/


/*************************************************************************
|*
|* SFX-Slotmap und Standardinterface deklarieren
|*
\************************************************************************/

SFX_DECL_TYPE(13);

#define SdOutlineViewShell
#include "sdslots.hxx"

/*N*/ SFX_IMPL_INTERFACE(SdOutlineViewShell, SfxViewShell, SdResId(STR_OUTLINEVIEWSHELL))
/*N*/ {
//STRIP001 /*N*/ 	SFX_POPUPMENU_REGISTRATION( SdResId(RID_OUTLINE_POPUP) );
/*N*/ 	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_TOOLS | SFX_VISIBILITY_STANDARD |
/*N*/ 								SFX_VISIBILITY_FULLSCREEN | SFX_VISIBILITY_SERVER,
/*N*/ 								SdResId(RID_OUTLINE_TOOLBOX) );
/*N*/     SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_APPLICATION | SFX_VISIBILITY_DESKTOP | SFX_VISIBILITY_STANDARD | SFX_VISIBILITY_CLIENT | SFX_VISIBILITY_VIEWER | SFX_VISIBILITY_READONLYDOC,
/*N*/             					SdResId(RID_DRAW_VIEWER_TOOLBOX) );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SfxTemplateDialogWrapper::GetChildWindowId() );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SvxHyperlinkDlgWrapper::GetChildWindowId() );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SdPreviewChildWindow::GetChildWindowId() );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SvxHlinkDlgWrapper::GetChildWindowId() );
/*N*/ 	SFX_CHILDWINDOW_REGISTRATION( SID_SEARCH_DLG );
/*N*/ }

/*N*/ SFX_IMPL_VIEWFACTORY(SdOutlineViewShell, SdResId(STR_SPECIALVIEW) )
/*N*/ {
/*N*/ 	SFX_VIEW_REGISTRATION(SdDrawDocShell);
/*N*/ }

/*N*/ TYPEINIT1( SdOutlineViewShell, SdViewShell );


/*************************************************************************
|*
|* gemeinsamer Initialiserungsanteil der beiden Konstruktoren
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::Construct(SdDrawDocShell* pDocSh)
//STRIP001 {
//STRIP001 	BOOL bModified = pDoc->IsChanged();
//STRIP001 
//STRIP001 	Size aViewSize(Size(29700, 21000));
//STRIP001 	Point aWinPos (0, 0);
//STRIP001 	Point aViewOrigin(0, 0);
//STRIP001 	aOutlineBtn.Check(TRUE);
//STRIP001 	pWindow->SetMinZoomAutoCalc(FALSE);
//STRIP001 	pWindow->SetMinZoom( MIN_ZOOM );
//STRIP001 	pWindow->SetMaxZoom( MAX_ZOOM );
//STRIP001 	InitWindows(aViewOrigin, aViewSize, aWinPos);
//STRIP001 	pOlView = new SdOutlineView(pDocSh, pWindow, this);
//STRIP001 	pView = pOlView;			 // Pointer der Basisklasse SdViewShell
//STRIP001 
//STRIP001 	SetPool( &pDoc->GetPool() );
//STRIP001 
//STRIP001 	SetZoom(69);
//STRIP001 
//STRIP001 	// create uno view
//STRIP001 	pController = new SdUnoOutlineView(pView, this);
//STRIP001 
//STRIP001 	uno::Reference< awt::XWindow > aTmpRef;
//STRIP001 	GetViewFrame()->GetFrame()->GetFrameInterface()->setComponent( aTmpRef, pController );
//STRIP001 
//STRIP001 
//STRIP001 	// Shells fuer Object Bars erzeugen
//STRIP001 	SfxShell* pObjBarShell = new SdDrawTextObjectBar( this, pDoc->GetPool(), pOlView );
//STRIP001 	aShellTable.Insert( RID_DRAW_TEXT_TOOLBOX, pObjBarShell );
//STRIP001 
//STRIP001 	// ObjectBar einschalten
//STRIP001 	SwitchObjectBar(RID_DRAW_TEXT_TOOLBOX);
//STRIP001 
//STRIP001 	// Einstellungen der FrameView uebernehmen
//STRIP001 	ReadFrameViewData(pFrameView);
//STRIP001 
//STRIP001 	Outliner* pOutl = pOlView->GetOutliner();
//STRIP001 	pOutl->SetUpdateMode(TRUE);
//STRIP001 
//STRIP001 	if (!bModified)
//STRIP001 	{
//STRIP001 		pOutl->ClearModifyFlag();
//STRIP001 	}
//STRIP001 
//STRIP001 	pLastPage = GetActualPage();
//STRIP001 
//STRIP001 	String aName( RTL_CONSTASCII_USTRINGPARAM( "OutlineViewShell" ));
//STRIP001 	SetName (aName);
//STRIP001 
//STRIP001 	SetHelpId( SD_IF_SDOUTLINEVIEWSHELL );
//STRIP001 	pWindow->SetHelpId( SD_IF_SDOUTLINEVIEWSHELL );
//STRIP001 	pWindow->SetUniqueId( SD_IF_SDOUTLINEVIEWSHELL );
//STRIP001 }

/*************************************************************************
|*
|* Standard-Konstruktor, Fenster duerfen nicht automatisch zentrieren
|*
\************************************************************************/

//STRIP001 SdOutlineViewShell::SdOutlineViewShell(SfxViewFrame* pFrame, SfxViewShell* pOldShell) :
//STRIP001 	SdViewShell(pFrame, &pFrame->GetWindow(), FALSE),
//STRIP001 	pOlView(NULL),
//STRIP001 	pLastPage( NULL ),
//STRIP001 	pClipEvtLstnr(NULL),
//STRIP001 	bPastePossible(FALSE),
//STRIP001 	pController(NULL)
//STRIP001 {
//STRIP001 	if (pOldShell)
//STRIP001 	{
//STRIP001 		pFrameView = ( (SdViewShell*) pOldShell)->GetFrameView();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFrameView = new FrameView(pDoc);
//STRIP001 	}
//STRIP001 
//STRIP001 	pFrameView->Connect();
//STRIP001 
//STRIP001 	Construct(pDocSh);
//STRIP001 
//STRIP001 	// Editierfunktion starten
//STRIP001 	SfxRequest aReq( SID_EDIT_OUTLINER, 0, pDoc->GetItemPool() );
//STRIP001 	FuPermanent( aReq );
//STRIP001 }


/*************************************************************************
|*
|* Copy-Konstruktor
|*
\************************************************************************/

//STRIP001 SdOutlineViewShell::SdOutlineViewShell(SfxViewFrame* pFrame,
//STRIP001 								 const SdOutlineViewShell& rShell) :
//STRIP001 	SdViewShell(pFrame, rShell),
//STRIP001 	pOlView(NULL),
//STRIP001 	pLastPage( NULL ),
//STRIP001 	pClipEvtLstnr(NULL),
//STRIP001 	bPastePossible(FALSE),
//STRIP001 	pController(NULL)
//STRIP001 {
//STRIP001 	pFrameView = new FrameView(pDoc);
//STRIP001 	pFrameView->Connect();
//STRIP001 
//STRIP001 	Construct(pDocSh);
//STRIP001 }

/*************************************************************************
|*
|* Destruktor
|*
\************************************************************************/

//STRIP001 SdOutlineViewShell::~SdOutlineViewShell()
//STRIP001 {
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		if (pFuOld == pFuActual)
//STRIP001 			pFuOld = NULL;
//STRIP001 
//STRIP001 		pFuActual->Deactivate();
//STRIP001 		delete pFuActual;
//STRIP001 		pFuActual = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuOld)
//STRIP001 	{
//STRIP001 		delete pFuOld;
//STRIP001 		pFuOld = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	RemoveSubShell();
//STRIP001 
//STRIP001 	// Umschaltung der ObjectBarShells unterdruecken, sonst versucht die
//STRIP001 	// sterbende Funktion eventuell die ObjectBars zu wechseln. Die
//STRIP001 	// entsprechende Shell ist aber schon vom SFX vom Dispatcher-Stack
//STRIP001 	// genommen worden.
//STRIP001 	bObjectBarSwitchEnabled = FALSE;
//STRIP001 
//STRIP001 	delete pOlView;
//STRIP001 
//STRIP001 	pFrameView->Disconnect();
//STRIP001 
//STRIP001 	if ( pClipEvtLstnr )
//STRIP001 	{
//STRIP001 		pClipEvtLstnr->AddRemoveListener( GetActiveWindow(), FALSE );
//STRIP001 		pClipEvtLstnr->ClearCallbackLink();		// #103849# prevent callback if another thread is waiting
//STRIP001 		pClipEvtLstnr->release();
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Paint-Methode: das Ereignis wird vom Fenster pWindow an
|* die Viewshell und die aktuelle Funktion weitergeleitet
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::Paint(const Rectangle& rRect, SdWindow* pWin)
//STRIP001 {
//STRIP001 	if (pOlView)
//STRIP001 	{
//STRIP001 		pOlView->Paint(rRect, pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->Paint(rRect, pWin);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::InnerResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	SdViewShell::InnerResizePixel(rPos, rSize);
//STRIP001 }

/*************************************************************************
|*
|* Ersatz fuer AdjustPosSizePixel ab Sfx 248a
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::OuterResizePixel(const Point &rPos, const Size &rSize)
//STRIP001 {
//STRIP001 	SdViewShell::OuterResizePixel(rPos, rSize);
//STRIP001 }


/** This call is simply delegated to the base class.
*/
//STRIP001 void SdOutlineViewShell::AdjustPosSizePixel(const Point &rNewPos,
//STRIP001 											const Size &rNewSize)
//STRIP001 {
//STRIP001     SdViewShell::AdjustPosSizePixel (rNewPos, rNewSize);
//STRIP001 }


//STRIP001 void SdOutlineViewShell::ArrangeGUIElements ()
//STRIP001 {
//STRIP001     // Retrieve the current size (thickness) of the scroll bars.  That is
//STRIP001     // the width of the vertical and the height of the horizontal scroll
//STRIP001     // bar.
//STRIP001     int nScrollBarSize = GetViewFrame()->GetWindow().GetSettings().GetStyleSettings().GetScrollBarSize();
//STRIP001 	aScrBarWH = Size (nScrollBarSize, nScrollBarSize);
//STRIP001 
//STRIP001 	SdViewShell::ArrangeGUIElements ();
//STRIP001 
//STRIP001 	long nSizeX = aViewSize.Width() - aScrBarWH.Width();
//STRIP001 	long nSizeY = aViewSize.Height() - aScrBarWH.Height();
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			SdWindow* pWindow = pWinArray[nX][nY];
//STRIP001 
//STRIP001 			if (pWindow)
//STRIP001 			{
//STRIP001 				pWindow->SetMinZoomAutoCalc(FALSE);
//STRIP001 
//STRIP001 				// pWindow->SetPosSizePixel(rNewPos, Size(nSizeX, nSizeY));
//STRIP001 
//STRIP001 				// OutputArea der OutlinerView aendern
//STRIP001 				OutlinerView* pOutlinerView = pOlView->GetViewByWindow(pWindow);
//STRIP001 
//STRIP001 				Rectangle aWin(Point(0,0), pWindow->GetOutputSizePixel());
//STRIP001 				aWin = pWindow->PixelToLogic(aWin);
//STRIP001 				pOutlinerView->SetOutputArea(aWin);
//STRIP001 
//STRIP001 				Rectangle aVis = pOutlinerView->GetVisArea();
//STRIP001 
//STRIP001 				Rectangle aText = Rectangle(Point(0,0),
//STRIP001 											Size(pOlView->GetPaperWidth(),
//STRIP001 												 pOlView->GetOutliner()->GetTextHeight()));
//STRIP001 				aText.Bottom() += aWin.GetHeight();
//STRIP001 
//STRIP001 				if (!aWin.IsEmpty())			// nicht beim Oeffnen
//STRIP001 				{
//STRIP001 					InitWindows(Point(0,0), aText.GetSize(), Point(aVis.TopLeft()));
//STRIP001 					UpdateScrollBars();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Horizontales Lineal erzeugen
|*
\************************************************************************/

//STRIP001 SvxRuler* SdOutlineViewShell::CreateHRuler(SdWindow* pWin, BOOL bIsFirst)
//STRIP001 {
//STRIP001 	WinBits aWBits = WB_HSCROLL | WB_SVLOOK | WB_BORDER;
//STRIP001 	USHORT	nFlags = SVXRULER_SUPPORT_TABS | SVXRULER_SUPPORT_BORDERS |
//STRIP001 					 SVXRULER_SUPPORT_PARAGRAPH_MARGINS;
//STRIP001 
//STRIP001 	if ( bIsFirst )
//STRIP001 		aWBits |= WB_EXTRAFIELD;
//STRIP001 
//STRIP001 	SvxRuler* pRuler = new SvxRuler(&GetViewFrame()->GetWindow(), pWin,
//STRIP001 							nFlags, GetViewFrame()->GetBindings(), aWBits);
//STRIP001 	pRuler->SetExtraType(RULER_EXTRA_TAB, RULER_TAB_LEFT);
//STRIP001 	return pRuler;
//STRIP001 }

/*************************************************************************
|*
|* Horizontales Lineal aktualisieren
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::UpdateHRuler()
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* SfxRequests fuer Controller bearbeiten
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::ExecCtrl(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_MAIL_SCROLLBODY_PAGEDOWN:
//STRIP001 		{
//STRIP001             ExecReq( rReq );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_RELOAD:
//STRIP001 		{
//STRIP001 			// Normale Weiterleitung an ViewFrame zur Ausfuehrung
//STRIP001 			GetViewFrame()->ExecuteSlot(rReq);
//STRIP001 
//STRIP001 			// Muss sofort beendet werden
//STRIP001 			return;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PREVIEW_QUALITY_COLOR:
//STRIP001 		case SID_PREVIEW_QUALITY_GRAYSCALE:
//STRIP001 		case SID_PREVIEW_QUALITY_BLACKWHITE:
//STRIP001 		case SID_PREVIEW_QUALITY_CONTRAST:
//STRIP001 		{
//STRIP001             ExecReq( rReq );
//STRIP001             break;
//STRIP001 		}
//STRIP001 
//STRIP001 		case SID_OPT_LOCALE_CHANGED:
//STRIP001 		{
//STRIP001 			pOlView->GetOutliner()->UpdateFields();
//STRIP001 			UpdatePreview( GetActualPage() );
//STRIP001 			rReq.Done();
//STRIP001             break;
//STRIP001 		}
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Activate(), beim ersten Aufruf erfolgt ein Update der Felder
|*
\************************************************************************/
//STRIP001 void SdOutlineViewShell::Activate( BOOL bIsMDIActivate )
//STRIP001 {
//STRIP001 	SdViewShell::Activate( bIsMDIActivate );
//STRIP001 	pOlView->SetLinks();
//STRIP001 
//STRIP001 	if( bIsMDIActivate )
//STRIP001 	{
//STRIP001 		OutlinerView* pOutlinerView = pOlView->GetViewByWindow( pWindow );
//STRIP001 		Outliner* pOutl = pOutlinerView->GetOutliner();
//STRIP001 		pOutl->UpdateFields();
//STRIP001 
//STRIP001 		SfxBoolItem aItem(SID_PREVIEW_WIN, pFrameView->IsShowPreviewInOutlineMode() != 0 );
//STRIP001 		GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 			SID_PREVIEW_WIN, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L);
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Deactivate()
|*
\************************************************************************/
//STRIP001 void SdOutlineViewShell::Deactivate( BOOL bIsMDIActivate )
//STRIP001 {
//STRIP001     // #96416# Links must be kept also on deactivated viewshell, to allow drag'n'drop
//STRIP001     // to function properly
//STRIP001 	// pOlView->ResetLinks();
//STRIP001 
//STRIP001 	SdViewShell::Deactivate( bIsMDIActivate );
//STRIP001 }

/*************************************************************************
|*
|* Status von Controller-SfxSlots setzen
|*
\************************************************************************/
//STRIP001 void SdOutlineViewShell::GetCtrlState(SfxItemSet &rSet)
//STRIP001 {
//STRIP001 	if (rSet.GetItemState(SID_RELOAD) != SFX_ITEM_UNKNOWN)
//STRIP001 	{
//STRIP001 		// "Letzte Version" vom SFx en/disablen lassen
//STRIP001 		SfxViewFrame* pViewFrame = SFX_APP()->GetViewFrame();
//STRIP001 		if (pViewFrame->ISA(SfxTopViewFrame))
//STRIP001 		{
//STRIP001 			pViewFrame->GetSlotState (SID_RELOAD, NULL, &rSet);
//STRIP001 		}
//STRIP001 		else		// MI sagt: kein MDIFrame --> disablen
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_RELOAD);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_HYPERLINK_GETLINK))
//STRIP001 	{
//STRIP001 		SvxHyperlinkItem aHLinkItem;
//STRIP001 
//STRIP001 		OutlinerView* pOLV = pOlView->GetViewByWindow(pWindow);
//STRIP001 		if (pOLV)
//STRIP001 		{
//STRIP001 			const SvxFieldItem* pFieldItem = pOLV->GetFieldAtSelection();
//STRIP001 			if (pFieldItem)
//STRIP001 			{
//STRIP001                 ESelection aSel = pOLV->GetSelection();
//STRIP001                 if ( abs( aSel.nEndPos - aSel.nStartPos ) == 1 )
//STRIP001                 {
//STRIP001 				    const SvxFieldData* pField = pFieldItem->GetField();
//STRIP001 				    if ( pField->ISA(SvxURLField) )
//STRIP001 				    {
//STRIP001 					    aHLinkItem.SetName(((const SvxURLField*) pField)->GetRepresentation());
//STRIP001 					    aHLinkItem.SetURL(((const SvxURLField*) pField)->GetURL());
//STRIP001 					    aHLinkItem.SetTargetFrame(((const SvxURLField*) pField)->GetTargetFrame());
//STRIP001 				    }
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 		rSet.Put(aHLinkItem);
//STRIP001 	}
//STRIP001     rSet.Put( SfxBoolItem( SID_READONLY_MODE, GetDocSh()->IsReadOnly() ) );
//STRIP001 
//STRIP001 	// #49150#: Qualitaet des Previewfensters aendern, falls vorhanden
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_COLOR ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_GRAYSCALE ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_BLACKWHITE ) ||
//STRIP001         SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_QUALITY_CONTRAST ) )
//STRIP001 	{
//STRIP001 		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
//STRIP001 		if( GetViewFrame()->GetChildWindow( nId ) )
//STRIP001 		{
//STRIP001 			ULONG nMode = pFrameView->GetPreviewDrawMode();
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_COLOR, (BOOL)(nMode == PREVIEW_DRAWMODE_COLOR) ) );
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_GRAYSCALE, (BOOL)(nMode == PREVIEW_DRAWMODE_GRAYSCALE) ) );
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_BLACKWHITE, (BOOL)(nMode == PREVIEW_DRAWMODE_BLACKWHITE) ) );
//STRIP001 			rSet.Put( SfxBoolItem( SID_PREVIEW_QUALITY_CONTRAST, (BOOL)(nMode == PREVIEW_DRAWMODE_CONTRAST) ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_COLOR );
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_GRAYSCALE );
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_BLACKWHITE );
//STRIP001 			rSet.DisableItem( SID_PREVIEW_QUALITY_CONTRAST );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_MAIL_SCROLLBODY_PAGEDOWN) )
//STRIP001 		rSet.Put( SfxBoolItem( SID_MAIL_SCROLLBODY_PAGEDOWN, TRUE ) );
//STRIP001 
//STRIP001 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_TRANSLITERATE_HALFWIDTH) ||
//STRIP001 		 SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_TRANSLITERATE_FULLWIDTH) ||
//STRIP001 		 SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_TRANSLITERATE_HIRAGANA) ||
//STRIP001 		 SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_TRANSLITERATE_KATAGANA) )
//STRIP001 	{
//STRIP001         SvtCJKOptions aCJKOptions;
//STRIP001 		if( !aCJKOptions.IsChangeCaseMapEnabled() )
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_HALFWIDTH );
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_FULLWIDTH );
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_HIRAGANA );
//STRIP001 			rSet.DisableItem( SID_TRANSLITERATE_KATAGANA );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* SfxRequests fuer Support-Funktionen
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::FuSupport(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	if( rReq.GetSlot() == SID_STYLE_FAMILY && rReq.GetArgs())
//STRIP001 		pDocSh->SetStyleFamily(((SfxUInt16Item&)rReq.GetArgs()->Get( SID_STYLE_FAMILY )).GetValue());
//STRIP001 
//STRIP001 	BOOL bPreviewState = FALSE;
//STRIP001 	ULONG nSlot = rReq.GetSlot();
//STRIP001 	switch ( nSlot )
//STRIP001 	{
//STRIP001 		case SID_CUT:
//STRIP001 		{
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				pFuActual->DoCut();
//STRIP001 			}
//STRIP001 			else if (pOlView)
//STRIP001 			{
//STRIP001 				pOlView->DoCut();
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 			bPreviewState = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_COPY:
//STRIP001 		{
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				pFuActual->DoCopy();
//STRIP001 			}
//STRIP001 			else if (pOlView)
//STRIP001 			{
//STRIP001 				pOlView->DoCopy();
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 			bPreviewState = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_PASTE:
//STRIP001 		{
//STRIP001 			if (pFuActual)
//STRIP001 			{
//STRIP001 				pFuActual->DoPaste();
//STRIP001 			}
//STRIP001 			else if (pOlView)
//STRIP001 			{
//STRIP001 				pOlView->DoPaste();
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 			bPreviewState = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DELETE:
//STRIP001 		{
//STRIP001 			if( pOlView )
//STRIP001 			{
//STRIP001 				OutlinerView* pOutlView = pOlView->GetViewByWindow(pWindow);
//STRIP001 				if (pOutlView)
//STRIP001 				{
//STRIP001 					KeyCode  aKCode(KEY_DELETE);
//STRIP001 					KeyEvent aKEvt( 0, aKCode );
//STRIP001 					pOutlView->PostKeyEvent(aKEvt);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 			bPreviewState = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DRAWINGMODE:
//STRIP001 		case SID_NOTESMODE:
//STRIP001 		case SID_HANDOUTMODE:
//STRIP001 		{
//STRIP001 			if (rReq.GetSlot()==SID_DRAWINGMODE)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_STANDARD);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			else if (rReq.GetSlot()==SID_NOTESMODE)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_NOTES);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			else if (rReq.GetSlot()==SID_HANDOUTMODE)
//STRIP001 			{
//STRIP001 				pFrameView->SetPageKind(PK_HANDOUT);
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL0,
//STRIP001 							SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			}
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_DIAMODE:
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(SID_VIEWSHELL1,
//STRIP001 						SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD);
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_OUTLINEMODE:
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_RULER:
//STRIP001 			SetRuler( !HasRuler() );
//STRIP001 			Invalidate( SID_RULER );
//STRIP001 			rReq.Done();
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_PREV:
//STRIP001 		{
//STRIP001 			if (pZoomList->IsPreviousPossible())
//STRIP001 			{
//STRIP001 				// Vorheriges ZoomRect einstellen
//STRIP001 				SetZoomRect(pZoomList->GetPreviousZoomRect());
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ZOOM_NEXT:
//STRIP001 		{
//STRIP001 			if (pZoomList->IsNextPossible())
//STRIP001 			{
//STRIP001 				// Naechstes ZoomRect einstellen
//STRIP001 				SetZoomRect(pZoomList->GetNextZoomRect());
//STRIP001 			}
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_AUTOSPELL_CHECK:
//STRIP001 		{
//STRIP001 			pDoc->SetOnlineSpell(!pDoc->GetOnlineSpell());
//STRIP001 			rReq.Done ();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_TRANSLITERATE_UPPER:
//STRIP001 		case SID_TRANSLITERATE_LOWER:
//STRIP001 		case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 		case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 		case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 		case SID_TRANSLITERATE_KATAGANA:
//STRIP001 		{
//STRIP001 			OutlinerView* pOLV = pOlView->GetViewByWindow( pWindow );
//STRIP001 			if( pOLV )
//STRIP001 			{
//STRIP001 				using namespace ::com::sun::star::i18n;
//STRIP001 				sal_Int32 nType = 0;
//STRIP001 
//STRIP001 				switch( nSlot )
//STRIP001 				{
//STRIP001 					case SID_TRANSLITERATE_UPPER:
//STRIP001 						nType = TransliterationModules_LOWERCASE_UPPERCASE;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_LOWER:
//STRIP001 						nType = TransliterationModules_UPPERCASE_LOWERCASE;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_HALFWIDTH:
//STRIP001 						nType = TransliterationModules_FULLWIDTH_HALFWIDTH;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_FULLWIDTH:
//STRIP001 						nType = TransliterationModules_HALFWIDTH_FULLWIDTH;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_HIRAGANA:
//STRIP001 						nType = TransliterationModules_KATAKANA_HIRAGANA;
//STRIP001 						break;
//STRIP001 					case SID_TRANSLITERATE_KATAGANA:
//STRIP001 						nType = TransliterationModules_HIRAGANA_KATAKANA;
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				pOLV->TransliterateText( nType );
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.Done();
//STRIP001 			bPreviewState = TRUE;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		// #96090# added Undo/Redo handling
//STRIP001 		case SID_UNDO :
//STRIP001 		{
//STRIP001 			ImpSidUndo(FALSE, rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_REDO :
//STRIP001 		{
//STRIP001 			ImpSidRedo(FALSE, rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bPreviewState )
//STRIP001 		Invalidate( SID_PREVIEW_STATE );
//STRIP001 
//STRIP001 	Invalidate(SID_CUT);
//STRIP001 	Invalidate(SID_COPY);
//STRIP001 	Invalidate(SID_PASTE);
//STRIP001 }

/*************************************************************************
|*
|* SfxRequests fuer permanente Funktionen
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::FuPermanent(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		if (pFuOld == pFuActual)
//STRIP001 		{
//STRIP001 			pFuOld = NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		pFuActual->Deactivate();
//STRIP001 		delete pFuActual;
//STRIP001 		pFuActual = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001 		case SID_EDIT_OUTLINER:
//STRIP001 		{
//STRIP001 			// den an der Shell der TextObjectBar gesetzten UndoManager leeren
//STRIP001 			SfxUndoManager* pUndoMgr = GetSubShell(0)->GetUndoManager();
//STRIP001 			DBG_ASSERT(pUndoMgr, "UndoManager nicht gefunden");
//STRIP001 			pUndoMgr->Clear();
//STRIP001 
//STRIP001 			Outliner* pOutl = pOlView->GetOutliner();
//STRIP001 			pOutl->UpdateFields();
//STRIP001 
//STRIP001 			pFuActual = new FuOutlineText(this,pWindow,pOlView,pDoc,rReq);
//STRIP001 			rReq.Done();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	  default:
//STRIP001 	  break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuOld)
//STRIP001 	{
//STRIP001 		pFuOld->Deactivate();
//STRIP001 		delete pFuOld;
//STRIP001 		pFuOld = NULL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pFuActual)
//STRIP001 	{
//STRIP001 		pFuActual->Activate();
//STRIP001 		pFuOld = pFuActual;
//STRIP001 	}
//STRIP001 }


//STRIP001 IMPL_LINK( SdOutlineViewShell, ClipboardChanged, TransferableDataHelper*, pDataHelper )
//STRIP001 {
//STRIP001 	if ( pDataHelper )
//STRIP001 	{
//STRIP001 		bPastePossible = ( pDataHelper->GetFormatCount() != 0 &&
//STRIP001 							( pDataHelper->HasFormat( FORMAT_STRING ) ||
//STRIP001 							  pDataHelper->HasFormat( FORMAT_RTF ) ||
//STRIP001 							  pDataHelper->HasFormat( SOT_FORMATSTR_ID_HTML ) ) );
//STRIP001 
//STRIP001 		SfxBindings& rBindings = GetViewFrame()->GetBindings();
//STRIP001 		rBindings.Invalidate( SID_PASTE );
//STRIP001 		rBindings.Invalidate( SID_PASTE2 );
//STRIP001 		rBindings.Invalidate( SID_CLIPBOARD_FORMAT_ITEMS );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* Status (Enabled/Disabled) von Menue-SfxSlots setzen
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::GetMenuState( SfxItemSet &rSet )
//STRIP001 {
//STRIP001 	SdViewShell::GetMenuState(rSet);
//STRIP001 
//STRIP001 	if (pDocSh->IsPreview())
//STRIP001 	{
//STRIP001 		aPresentationBtn.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aPresentationBtn.Enable();
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) )
//STRIP001 	{
//STRIP001 		SfxChildWindow* pPreviewChildWindow = GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 		SdPreviewWin*	pPreviewWin = (SdPreviewWin*) ( pPreviewChildWindow ? pPreviewChildWindow->GetWindow() : NULL );
//STRIP001 		FuSlideShow*	pShow = pPreviewWin ? pPreviewWin->GetSlideShow() : NULL;
//STRIP001 
//STRIP001 		if ( (pShow && pShow->IsInputLocked()) ||
//STRIP001 			 pDocSh->IsPreview() )
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PRESENTATION );
//STRIP001 			aPresentationBtn.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Vorlagenkatalog darf nicht aufgerufen werden
//STRIP001 	rSet.DisableItem( SID_STYLE_CATALOG );
//STRIP001 
//STRIP001 	rSet.Put(SfxBoolItem(SID_DIAMODE, FALSE));
//STRIP001 	rSet.Put(SfxBoolItem(SID_DRAWINGMODE, FALSE));
//STRIP001 	rSet.Put(SfxBoolItem(SID_OUTLINEMODE, TRUE));
//STRIP001 	rSet.Put(SfxBoolItem(SID_NOTESMODE, FALSE));
//STRIP001 	rSet.Put(SfxBoolItem(SID_HANDOUTMODE, FALSE));
//STRIP001 
//STRIP001 	if (!pZoomList->IsNextPossible())
//STRIP001 	{
//STRIP001 	   rSet.DisableItem(SID_ZOOM_NEXT);
//STRIP001 	}
//STRIP001 	if (!pZoomList->IsPreviousPossible())
//STRIP001 	{
//STRIP001 	   rSet.DisableItem(SID_ZOOM_PREV);
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_IN ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ZOOM_OUT ) )
//STRIP001 	{
//STRIP001 		if( pWindow->GetZoom() <= pWindow->GetMinZoom() || pDocSh->IsUIActive() )
//STRIP001 			rSet.DisableItem( SID_ZOOM_IN );
//STRIP001 		if( pWindow->GetZoom() >= pWindow->GetMaxZoom() || pDocSh->IsUIActive() )
//STRIP001 			rSet.DisableItem( SID_ZOOM_OUT );
//STRIP001 	}
//STRIP001 
//STRIP001 	// 'Alles auswaehlen' zulassen?
//STRIP001 
//STRIP001 	Outliner* pOutl = pOlView->GetOutliner();
//STRIP001 	DBG_ASSERT(pOutl, "kein Outliner");
//STRIP001 	ULONG nParaCount = pOutl->GetParagraphCount();
//STRIP001 	BOOL bDisable = nParaCount == 0;
//STRIP001 	if (!bDisable && nParaCount == 1)
//STRIP001 	{
//STRIP001 		String aTest( pOutl->GetText( pOutl->GetParagraph( 0 ) ) );
//STRIP001 		if (aTest.Len() == 0)
//STRIP001 		{
//STRIP001 			bDisable = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	if (bDisable)
//STRIP001 		rSet.DisableItem(SID_SELECTALL);
//STRIP001 
//STRIP001 	// Status des Lineals setzen
//STRIP001 	rSet.Put( SfxBoolItem( SID_RULER, HasRuler() ) );
//STRIP001 
//STRIP001 	// Formatierung ein oder aus?
//STRIP001 	rSet.Put( SfxBoolItem( SID_OUTLINE_FORMAT, !pOutl->IsFlatMode() ) );
//STRIP001 
//STRIP001 	if( pOutl->IsFlatMode() )
//STRIP001 		rSet.DisableItem( SID_COLORVIEW );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Farbansicht ein/aus
//STRIP001 		ULONG nCntrl = pOutl->GetControlWord();
//STRIP001 		BOOL bNoColor = FALSE;
//STRIP001 		if (nCntrl & EE_CNTRL_NOCOLORS)
//STRIP001 			bNoColor = TRUE;
//STRIP001 
//STRIP001 		rSet.Put( SfxBoolItem( SID_COLORVIEW, bNoColor ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Buttons der Werkzeugleiste
//STRIP001 	// zunaechst selektionsabhaengige: COLLAPSE, EXPAND
//STRIP001 	BOOL bDisableCollapse = TRUE;
//STRIP001 	BOOL bDisableExpand   = TRUE;
//STRIP001 	BOOL bUnique		  = TRUE;
//STRIP001 	OutlinerView* pOutlinerView = pOlView->GetViewByWindow(pWindow);
//STRIP001 	List* pList = pOutlinerView->CreateSelectionList();
//STRIP001 	Paragraph* pPara = (Paragraph*)pList->First();
//STRIP001 
//STRIP001 	USHORT nDepth;
//STRIP001 	USHORT nTmpDepth = pOutl->GetDepth( (USHORT) pOutl->GetAbsPos( pPara ) );
//STRIP001 	while (pPara)
//STRIP001 	{
//STRIP001 		nDepth = pOutl->GetDepth( (USHORT) pOutl->GetAbsPos( pPara ) );
//STRIP001 
//STRIP001 		if( nDepth != nTmpDepth )
//STRIP001 			bUnique = FALSE;
//STRIP001 		if (!pOutl->IsExpanded(pPara) && pOutl->HasChilds(pPara))
//STRIP001 			bDisableExpand = FALSE;
//STRIP001 		if (pOutl->IsExpanded(pPara) && pOutl->HasChilds(pPara))
//STRIP001 			bDisableCollapse = FALSE;
//STRIP001 
//STRIP001 		pPara = (Paragraph*)pList->Next();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pList;
//STRIP001 
//STRIP001 	if (bDisableExpand)
//STRIP001 		rSet.DisableItem(SID_OUTLINE_EXPAND);
//STRIP001 	if (bDisableCollapse)
//STRIP001 		rSet.DisableItem(SID_OUTLINE_COLLAPSE);
//STRIP001 
//STRIP001 	// ergibt die Selektion ein eindeutiges Praesentationslayout?
//STRIP001 	// wenn nicht, duerfen die Vorlagen nicht bearbeitet werden
//STRIP001 	SfxItemSet aSet(*rSet.GetPool(), SID_STATUS_LAYOUT, SID_STATUS_LAYOUT);
//STRIP001 	GetStatusBarState(aSet);
//STRIP001 	String aTest(((SfxStringItem&)aSet.Get(SID_STATUS_LAYOUT)).GetValue());
//STRIP001 	if (aTest.Len() == 0)
//STRIP001 	{
//STRIP001 		bUnique = FALSE;
//STRIP001 		rSet.DisableItem(SID_PRESENTATION_TEMPLATES);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bUnique)
//STRIP001 		rSet.DisableItem( SID_PRESENTATIONOBJECT );
//STRIP001 
//STRIP001 	// jetzt die selektionsunabhaengigen: COLLAPSE_ALL, EXPAND_ALL
//STRIP001 	BOOL bDisableCollapseAll = TRUE;
//STRIP001 	BOOL bDisableExpandAll	 = TRUE;
//STRIP001 
//STRIP001 	// wenn schon die Selektion etwas kollabierbares/expandierbares enthaelt
//STRIP001 	if (!bDisableCollapse)
//STRIP001 		bDisableCollapseAll = FALSE;
//STRIP001 	if (!bDisableExpand)
//STRIP001 		bDisableExpandAll = FALSE;
//STRIP001 
//STRIP001 	// schade, so billig kommen wir nicht davon; alle Absaetze durchsuchen
//STRIP001 	if (bDisableCollapseAll || bDisableExpandAll)
//STRIP001 	{
//STRIP001 		ULONG nParaPos = 0;
//STRIP001 		pPara = pOutl->GetParagraph( nParaPos );
//STRIP001 		while (pPara && (bDisableCollapseAll || bDisableExpandAll))
//STRIP001 		{
//STRIP001 			if (!pOutl->IsExpanded(pPara) && pOutl->HasChilds(pPara))
//STRIP001 				bDisableExpandAll = FALSE;
//STRIP001 
//STRIP001 			if (pOutl->IsExpanded(pPara) && pOutl->HasChilds(pPara))
//STRIP001 				bDisableCollapseAll = FALSE;
//STRIP001 
//STRIP001 			pPara = pOutl->GetParagraph( ++nParaPos );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (bDisableExpandAll)
//STRIP001 		rSet.DisableItem(SID_OUTLINE_EXPAND_ALL);
//STRIP001 	if (bDisableCollapseAll)
//STRIP001 		rSet.DisableItem(SID_OUTLINE_COLLAPSE_ALL);
//STRIP001 
//STRIP001 
//STRIP001     /*	if ( pDocSh->GetActualFunction() )
//STRIP001 	{
//STRIP001 		rSet.ClearItem( SID_DRAWINGMODE );
//STRIP001 		rSet.DisableItem( SID_DRAWINGMODE );
//STRIP001 		aDrawBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_NOTESMODE );
//STRIP001 		rSet.DisableItem( SID_NOTESMODE );
//STRIP001 		aNotesBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_HANDOUTMODE );
//STRIP001 		rSet.DisableItem( SID_HANDOUTMODE );
//STRIP001 		aHandoutBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_OUTLINEMODE );
//STRIP001 		rSet.DisableItem( SID_OUTLINEMODE );
//STRIP001 		aOutlineBtn.Disable();
//STRIP001 
//STRIP001 		rSet.ClearItem( SID_DIAMODE );
//STRIP001 		rSet.DisableItem( SID_DIAMODE );
//STRIP001 		aSlideBtn.Disable();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001     */		aDrawBtn.Enable();
//STRIP001 		aNotesBtn.Enable();
//STRIP001 		aHandoutBtn.Enable();
//STRIP001 		aOutlineBtn.Enable();
//STRIP001 		aSlideBtn.Enable();
//STRIP001         //	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PASTE ) )
//STRIP001 	{
//STRIP001 		if ( !pClipEvtLstnr )
//STRIP001 		{
//STRIP001 			// create listener
//STRIP001 			pClipEvtLstnr = new TransferableClipboardListener( LINK( this, SdOutlineViewShell, ClipboardChanged ) );
//STRIP001 			pClipEvtLstnr->acquire();
//STRIP001 			pClipEvtLstnr->AddRemoveListener( GetActiveWindow(), TRUE );
//STRIP001 
//STRIP001 			// get initial state
//STRIP001 			TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( GetActiveWindow() ) );
//STRIP001 			bPastePossible = ( aDataHelper.GetFormatCount() != 0 &&
//STRIP001 								( aDataHelper.HasFormat( FORMAT_STRING ) ||
//STRIP001 								  aDataHelper.HasFormat( FORMAT_RTF ) ||
//STRIP001 								  aDataHelper.HasFormat( SOT_FORMATSTR_ID_HTML ) ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		if( !bPastePossible )
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PASTE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!pOlView->GetViewByWindow(pWindow)->HasSelection())
//STRIP001 	{
//STRIP001 		rSet.DisableItem(SID_CUT);
//STRIP001 		rSet.DisableItem(SID_COPY);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (pOlView->GetOutliner()->IsModified())
//STRIP001 	{
//STRIP001 		pDoc->SetChanged(TRUE);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Da berladen, muss hier der Status gesetzt werden
//STRIP001 	if( !pDocSh->IsModified() )
//STRIP001 	{
//STRIP001 		rSet.DisableItem( SID_SAVEDOC );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDocSh->IsReadOnly() )
//STRIP001 	{
//STRIP001 		rSet.DisableItem( SID_AUTOSPELL_CHECK );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if (pDoc->GetOnlineSpell())
//STRIP001 		{
//STRIP001 			rSet.Put(SfxBoolItem(SID_AUTOSPELL_CHECK, TRUE));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rSet.Put(SfxBoolItem(SID_AUTOSPELL_CHECK, FALSE));
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// PreviewWindow
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_WIN ) )
//STRIP001 	{
//STRIP001 		USHORT nId = SdPreviewChildWindow::GetChildWindowId();
//STRIP001 		rSet.Put( SfxBoolItem( SID_PREVIEW_WIN, GetViewFrame()->HasChildWindow( nId ) ) );
//STRIP001 	}
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PREVIEW_STATE ) )
//STRIP001 	{
//STRIP001 		BOOL bModified = pDoc->IsChanged();
//STRIP001 		UpdatePreview( GetActualPage() );
//STRIP001 		pDoc->SetChanged( bModified );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Feldbefehle
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_MODIFY_FIELD ) )
//STRIP001 	{
//STRIP001 		const SvxFieldItem* pFldItem = pOutlinerView->GetFieldAtSelection();
//STRIP001 
//STRIP001 		if( !( pFldItem && (pFldItem->GetField()->ISA( SvxDateField ) ||
//STRIP001 							pFldItem->GetField()->ISA( SvxAuthorField ) ||
//STRIP001 							pFldItem->GetField()->ISA( SvxExtFileField ) ||
//STRIP001 							pFldItem->GetField()->ISA( SvxExtTimeField ) ) ) )
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_MODIFY_FIELD );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_EXPAND_PAGE))
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT i = 0;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		pOlView->SetSelectedPages();
//STRIP001 
//STRIP001 		while (i < nCount && bDisable)
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_OUTLINE);
//STRIP001 
//STRIP001 				if (pObj && !pObj->IsEmptyPresObj())
//STRIP001 				{
//STRIP001 					bDisable = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bDisable)
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_EXPAND_PAGE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (SFX_ITEM_AVAILABLE == rSet.GetItemState(SID_SUMMARY_PAGE))
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT i = 0;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount(PK_STANDARD);
//STRIP001 		pOlView->SetSelectedPages();
//STRIP001 
//STRIP001 		while (i < nCount && bDisable)
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if (pPage->IsSelected())
//STRIP001 			{
//STRIP001 				SdrObject* pObj = pPage->GetPresObj(PRESOBJ_TITLE);
//STRIP001 
//STRIP001 				if (pObj && !pObj->IsEmptyPresObj())
//STRIP001 				{
//STRIP001 					bDisable = FALSE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			i++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (bDisable)
//STRIP001 		{
//STRIP001 			rSet.DisableItem(SID_SUMMARY_PAGE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_THESAURUS ) )
//STRIP001 	{
//STRIP001 		if ( !pOlView->IsTextEdit() )
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_THESAURUS );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			LanguageType            eLang = pDoc->GetLanguage( EE_CHAR_LANGUAGE );
//STRIP001 	        Reference< XThesaurus > xThesaurus( LinguMgr::GetThesaurus() );
//STRIP001 			Locale                  aLocale;
//STRIP001 			
//STRIP001 			SvxLanguageToLocale( aLocale, eLang );
//STRIP001 			
//STRIP001             if (!xThesaurus.is() || eLang == LANGUAGE_NONE || !xThesaurus->hasLocale(aLocale))
//STRIP001 				rSet.DisableItem( SID_THESAURUS );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Starten der Praesentation moeglich?
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_PRESENTATION ) )
//STRIP001 	{
//STRIP001 		BOOL bDisable = TRUE;
//STRIP001 		USHORT nCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 
//STRIP001 		for( USHORT i = 0; i < nCount && bDisable; i++ )
//STRIP001 		{
//STRIP001 			SdPage* pPage = pDoc->GetSdPage(i, PK_STANDARD);
//STRIP001 
//STRIP001 			if( !pPage->IsExcluded() )
//STRIP001 				bDisable = FALSE;
//STRIP001 		}
//STRIP001 		if( bDisable || pDocSh->IsPreview())
//STRIP001 		{
//STRIP001 			rSet.DisableItem( SID_PRESENTATION );
//STRIP001 			aPresentationBtn.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	//rSet.DisableItem( SID_PRINTDOC );
//STRIP001 	//rSet.DisableItem( SID_PRINTDOCDIRECT );
//STRIP001 	//rSet.DisableItem( SID_SETUPPRINTER );
//STRIP001 }

/*************************************************************************
|*
|* wird gerufen, wenn ScrollBar benutzt wird
|*
\************************************************************************/

//STRIP001 long SdOutlineViewShell::VirtHScrollHdl(ScrollBar* pHScroll)
//STRIP001 {
//STRIP001 	short nX = 0, nY = 0;
//STRIP001 
//STRIP001 	// Spalte der zu scrollenden Fenster bestimmen
//STRIP001 	while ( nX < MAX_HSPLIT_CNT &&	pHScroll != pHScrlArray[nX] )
//STRIP001 		++nX;
//STRIP001 
//STRIP001 	long   nThumb = pHScroll->GetThumbPos();
//STRIP001 	long   nRange = pHScroll->GetRange().Len();
//STRIP001 	double fX	  = (double) nThumb / nRange;
//STRIP001 
//STRIP001 	// alle Fenster der Spalte scrollen
//STRIP001 	while ( nY < MAX_VSPLIT_CNT && pWinArray[nX][nY] )
//STRIP001 	{
//STRIP001 		Window* 	  pWin			= pWinArray[nX][nY++];
//STRIP001 		OutlinerView* pOutlinerView = pOlView->GetViewByWindow(pWin);
//STRIP001 		long		  nViewWidth	= pWin->PixelToLogic(
//STRIP001 												pWin->GetSizePixel()).Width();
//STRIP001 		long		  nTextWidth	= pOlView->GetPaperWidth();
//STRIP001 		nViewWidth					= Max(nViewWidth, nTextWidth);
//STRIP001 		long		  nCurrentPos	= pOutlinerView->GetVisArea().Left();
//STRIP001 		long		  nTargetPos	= (long)(fX * nViewWidth);
//STRIP001 		long		  nDelta		= nTargetPos - nCurrentPos;
//STRIP001 
//STRIP001 		pOutlinerView->HideCursor();
//STRIP001 		pOutlinerView->Scroll(-nDelta, 0);
//STRIP001 		pOutlinerView->ShowCursor(FALSE);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* wird gerufen, wenn ScrollBar benutzt wird
|*
\************************************************************************/

//STRIP001 long SdOutlineViewShell::VirtVScrollHdl(ScrollBar* pVScroll)
//STRIP001 {
//STRIP001 	short nX = 0, nY = 0;
//STRIP001 
//STRIP001 	// Zeile der zu scrollenden Fenster bestimmen
//STRIP001 	while ( nY < MAX_VSPLIT_CNT &&	pVScroll != pVScrlArray[nY] )
//STRIP001 		++nY;
//STRIP001 
//STRIP001 	long nThumb = pVScroll->GetThumbPos();
//STRIP001 	long nRange = pVScroll->GetRange().Len();
//STRIP001 	double fY = (double) nThumb / nRange;
//STRIP001 
//STRIP001 	// alle Fenster der Zeile scrollen
//STRIP001 	while ( nX < MAX_HSPLIT_CNT && pWinArray[nX][nY] )
//STRIP001 	{
//STRIP001 		Window* 	  pWin			= pWinArray[nX++][nY];
//STRIP001 		OutlinerView* pOutlinerView = pOlView->GetViewByWindow(pWin);
//STRIP001 		long		  nViewHeight	= pWin->PixelToLogic(
//STRIP001 											pWin->GetSizePixel()).Height();
//STRIP001 		long		  nTextHeight	= pOlView->GetOutliner()->GetTextHeight();
//STRIP001 		nViewHeight 			   += nTextHeight;
//STRIP001 		long		  nCurrentPos	= pOutlinerView->GetVisArea().Top();
//STRIP001 		long		  nTargetPos	= (long)(fY * nViewHeight);
//STRIP001 		long		  nDelta		= nTargetPos - nCurrentPos;
//STRIP001 
//STRIP001 		pOutlinerView->HideCursor();
//STRIP001 		pOutlinerView->Scroll(0, -nDelta);
//STRIP001 		pOutlinerView->ShowCursor(FALSE);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

/*************************************************************************
|*
|* PrepareClose, wird gerufen, wenn die Shell zestoert werden soll,
|* leitet den Aufruf an die View weiter
|*
\************************************************************************/

//STRIP001 USHORT SdOutlineViewShell::PrepareClose( BOOL bUI, BOOL bForBrowsing )
//STRIP001 {
//STRIP001 	if( SdViewShell::PrepareClose(bUI, bForBrowsing) != TRUE )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	return pOlView == NULL || pOlView->PrepareClose(bUI);
//STRIP001 }


/*************************************************************************
|*
|* Zoomen mit Zoomfaktor, OutlinerView informieren
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::SetZoom(long nZoom)
//STRIP001 {
//STRIP001 	SdViewShell::SetZoom(nZoom);
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			SdWindow* pWindow = pWinArray[nX][nY];
//STRIP001 			if (pWindow)
//STRIP001 			{
//STRIP001 				// OutputArea der OutlinerView aendern
//STRIP001 				OutlinerView* pOutlinerView = pOlView->GetViewByWindow(pWindow);
//STRIP001 				Rectangle aWin(Point(0,0), pWindow->GetOutputSizePixel());
//STRIP001 				aWin = pWindow->PixelToLogic(aWin);
//STRIP001 				pOutlinerView->SetOutputArea(aWin);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	
//STRIP001 	// #106268#
//STRIP001 	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 }

/*************************************************************************
|*
|* Zoomen mit Zoomrechteck, OutlinerView informieren
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::SetZoomRect(const Rectangle& rZoomRect)
//STRIP001 {
//STRIP001 	SdViewShell::SetZoomRect(rZoomRect);
//STRIP001 
//STRIP001 	for (short nX = 0; nX < MAX_HSPLIT_CNT; nX++)
//STRIP001 	{
//STRIP001 		for (short nY = 0; nY < MAX_VSPLIT_CNT; nY++)
//STRIP001 		{
//STRIP001 			SdWindow* pWindow = pWinArray[nX][nY];
//STRIP001 			if (pWindow)
//STRIP001 			{
//STRIP001 				// OutputArea der OutlinerView aendern
//STRIP001 				OutlinerView* pOutlinerView = pOlView->GetViewByWindow(pWindow);
//STRIP001 				Rectangle aWin(Point(0,0), pWindow->GetOutputSizePixel());
//STRIP001 				aWin = pWindow->PixelToLogic(aWin);
//STRIP001 				pOutlinerView->SetOutputArea(aWin);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// #106268#
//STRIP001 	GetViewFrame()->GetBindings().Invalidate( SID_ATTR_ZOOM );
//STRIP001 }


/*************************************************************************
|*
|* Vorm Speichern das Model der Drawing Engine aktualisieren, dann den
|* Call weiterleiten an die ObjectShell.
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::Execute(SfxRequest& rReq)
//STRIP001 {
//STRIP001     bool bForwardCall = true;
//STRIP001 
//STRIP001 	switch(rReq.GetSlot())
//STRIP001 	{
//STRIP001 		case SID_SAVEDOC:
//STRIP001 		case SID_SAVEASDOC:
//STRIP001 			PrepareClose();
//STRIP001             break;
//STRIP001 
//STRIP001 		case SID_SEARCH_ITEM:
//STRIP001             // Forward this request to the the common (old) code of the
//STRIP001             // document shell.
//STRIP001             pDocSh->Execute (rReq);
//STRIP001             bForwardCall = false;
//STRIP001             break;
//STRIP001 
//STRIP001 		default:
//STRIP001             OSL_TRACE ("SdOutlineViewShell::Execute(): can not handle slot %d", rReq.GetSlot());
//STRIP001             break;
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001     if (bForwardCall)
//STRIP001         ((SdDrawDocShell*)GetViewFrame()->GetObjectShell())->ExecuteSlot( rReq );
//STRIP001 }

/*************************************************************************
|*
|* Read FrameViews data and set actual views data
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::ReadFrameViewData(FrameView* pView)
//STRIP001 {
//STRIP001 	Outliner* pOutl = pOlView->GetOutliner();
//STRIP001 
//STRIP001 	if ( pView->IsNoAttribs() )
//STRIP001 		pOutl->SetFlatMode( TRUE );   // Attribut-Darstellung ausschalten
//STRIP001 	else
//STRIP001 		pOutl->SetFlatMode( FALSE );  // Attribut-Darstellung einschalten
//STRIP001 
//STRIP001 	ULONG nCntrl = pOutl->GetControlWord();
//STRIP001 
//STRIP001 	if ( pView->IsNoColors() )
//STRIP001 		pOutl->SetControlWord(nCntrl | EE_CNTRL_NOCOLORS);   // Farbansicht ausschalten
//STRIP001 	else
//STRIP001 		pOutl->SetControlWord(nCntrl & ~EE_CNTRL_NOCOLORS);  // Farbansicht einschalten
//STRIP001 
//STRIP001 	USHORT nPage = pFrameView->GetSelectedPage();
//STRIP001 	pLastPage = pDoc->GetSdPage( nPage, PK_STANDARD );
//STRIP001 	pOlView->SetActualPage(pLastPage);
//STRIP001 }



/*************************************************************************
|*
|* Write actual views data to FrameView
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::WriteFrameViewData()
//STRIP001 {
//STRIP001 	Outliner* pOutl = pOlView->GetOutliner();
//STRIP001 
//STRIP001 	ULONG nCntrl = pOutl->GetControlWord();
//STRIP001 	BOOL bNoColor = FALSE;
//STRIP001 	if (nCntrl & EE_CNTRL_NOCOLORS)
//STRIP001 		bNoColor = TRUE;
//STRIP001 	pFrameView->SetNoColors(bNoColor);
//STRIP001 	pFrameView->SetNoAttribs( pOutl->IsFlatMode() );
//STRIP001 	SdPage* pActualPage = pOlView->GetActualPage();
//STRIP001     DBG_ASSERT(pActualPage, "No current page");
//STRIP001 	if( pActualPage )
//STRIP001         pFrameView->SetSelectedPage((pActualPage->GetPageNum() - 1) / 2);
//STRIP001 }


/*************************************************************************
|*
|* SfxRequests fuer StatusBar bearbeiten
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::ExecStatusBar(SfxRequest& rReq)
//STRIP001 {
//STRIP001 }

/*************************************************************************
|*
|* Statuswerte der Statusbar zurueckgeben
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::GetStatusBarState(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	// Zoom-Item
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_ATTR_ZOOM ) )
//STRIP001 	{
//STRIP001 		SvxZoomItem* pZoomItem;
//STRIP001 		UINT16 nZoom = (UINT16) pWindow->GetZoom();
//STRIP001 
//STRIP001 		pZoomItem = new SvxZoomItem( SVX_ZOOM_PERCENT, nZoom );
//STRIP001 
//STRIP001 		// Bereich einschraenken
//STRIP001 		USHORT nZoomValues = SVX_ZOOM_ENABLE_ALL;
//STRIP001 		nZoomValues &= ~SVX_ZOOM_ENABLE_OPTIMAL;
//STRIP001 		nZoomValues &= ~SVX_ZOOM_ENABLE_WHOLEPAGE;
//STRIP001 		nZoomValues &= ~SVX_ZOOM_ENABLE_PAGEWIDTH;
//STRIP001 
//STRIP001 		pZoomItem->SetValueSet( nZoomValues );
//STRIP001 		rSet.Put( *pZoomItem );
//STRIP001 		delete pZoomItem;
//STRIP001 	}
//STRIP001 
//STRIP001 	// Seitenanzeige und Layout
//STRIP001 	/*
//STRIP001 	if( SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_PAGE ) ||
//STRIP001 		SFX_ITEM_AVAILABLE == rSet.GetItemState( SID_STATUS_LAYOUT ) )
//STRIP001 	*/
//STRIP001 	USHORT	nPageCount = pDoc->GetSdPageCount( PK_STANDARD );
//STRIP001 	String	aPageStr, aLayoutStr;
//STRIP001 
//STRIP001 	SdWindow*		pWin		= GetActiveWindow();
//STRIP001 	OutlinerView*	pActiveView = pOlView->GetViewByWindow( pWin );
//STRIP001 	Outliner*       pOutliner   = pOlView->GetOutliner();
//STRIP001 	List*			pSelList	= (List*)pActiveView->CreateSelectionList();
//STRIP001 	Paragraph*		pFirstPara	= (Paragraph*)pSelList->First();
//STRIP001 	Paragraph*		pLastPara	= (Paragraph*)pSelList->Last();
//STRIP001 
//STRIP001 	if( pOutliner->GetDepth( (USHORT) pOutliner->GetAbsPos( pFirstPara ) ) > 0 )
//STRIP001 		pFirstPara = pOlView->GetPrevTitle( pFirstPara );
//STRIP001 
//STRIP001 	if( pOutliner->GetDepth( (USHORT) pOutliner->GetAbsPos( pLastPara ) ) > 0 )
//STRIP001 		pLastPara = pOlView->GetPrevTitle( pLastPara );
//STRIP001 
//STRIP001 	delete pSelList;				// die wurde extra fuer uns erzeugt
//STRIP001 
//STRIP001 	// nur eine Seite selektiert?
//STRIP001 	if( pFirstPara == pLastPara )
//STRIP001 	{
//STRIP001 		// wieviele Seiten sind vor der selektierten Seite?
//STRIP001 		ULONG nPos = 0L;
//STRIP001 		while( pFirstPara )
//STRIP001 		{
//STRIP001 			pFirstPara = pOlView->GetPrevTitle( pFirstPara );
//STRIP001 			if( pFirstPara )
//STRIP001 				nPos++;
//STRIP001 		}
//STRIP001 		SdrPage* pPage = pDoc->GetSdPage( (USHORT) nPos, PK_STANDARD );
//STRIP001 
//STRIP001 		aPageStr = String(SdResId( STR_SD_PAGE ));
//STRIP001 		aPageStr += sal_Unicode(' ');
//STRIP001 		aPageStr += String::CreateFromInt32( (sal_Int32)(nPos + 1) );	// ULONG -> sal_Int32
//STRIP001 		aPageStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM( " / " ));
//STRIP001 		aPageStr += String::CreateFromInt32( nPageCount );
//STRIP001 
//STRIP001 		aLayoutStr = pPage->GetLayoutName();
//STRIP001 		aLayoutStr.Erase( aLayoutStr.SearchAscii( SD_LT_SEPARATOR ) );
//STRIP001 	}
//STRIP001 	rSet.Put( SfxStringItem( SID_STATUS_PAGE, aPageStr ) );
//STRIP001 	rSet.Put( SfxStringItem( SID_STATUS_LAYOUT, aLayoutStr ) );
//STRIP001 }

/*************************************************************************
|*
|* Command event
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::Command( const CommandEvent& rCEvt, SdWindow* pWin )
//STRIP001 {
//STRIP001 	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		pWindow->ReleaseMouse();
//STRIP001 
//STRIP001 		OutlinerView* pOLV = pOlView->GetViewByWindow(pWindow);
//STRIP001 		Point aPos(rCEvt.GetMousePosPixel());
//STRIP001 
//STRIP001 		if (pOLV && pOLV->IsWrongSpelledWordAtPos(aPos))
//STRIP001 		{
//STRIP001 			// #91457# Popup for Online-Spelling now handled by SdDrawDocShell
//STRIP001 			// Link aLink = LINK(pDoc, SdDrawDocument, OnlineSpellCallback);
//STRIP001 			Link aLink = LINK(pDocSh, SdDrawDocShell, OnlineSpellCallback);
//STRIP001 
//STRIP001 			pOLV->ExecuteSpellPopup(aPos, &aLink);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 		   GetViewFrame()->GetDispatcher()->ExecutePopup(SdResId(RID_OUTLINE_POPUP));
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SdViewShell::Command( rCEvt, pWin );
//STRIP001 
//STRIP001 		// ggfs. Preview den neuen Kontext mitteilen
//STRIP001 		Invalidate( SID_PREVIEW_STATE );
//STRIP001 
//STRIP001 	}
//STRIP001 }


/*************************************************************************
|*
|* Keyboard event
|*
\************************************************************************/

//STRIP001 BOOL SdOutlineViewShell::KeyInput(const KeyEvent& rKEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (pWin == NULL && pFuActual)
//STRIP001 	{
//STRIP001 		bReturn = pFuActual->KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 
//STRIP001 	// nein, weiterleiten an Basisklasse
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bReturn = SdViewShell::KeyInput(rKEvt, pWin);
//STRIP001 	}
//STRIP001 
//STRIP001 	Invalidate(SID_STYLE_EDIT);
//STRIP001 	Invalidate(SID_STYLE_NEW);
//STRIP001 	Invalidate(SID_STYLE_DELETE);
//STRIP001 	Invalidate(SID_STYLE_UPDATE_BY_EXAMPLE);
//STRIP001 	Invalidate(SID_STYLE_NEW_BY_EXAMPLE);
//STRIP001 	Invalidate(SID_STYLE_WATERCAN);
//STRIP001 	Invalidate(SID_STYLE_FAMILY5);
//STRIP001 
//STRIP001 	// Pruefen und Unterscheiden von CursorBewegungs- oder Eingabe-Keys
//STRIP001 	KeyCode aKeyGroup( rKEvt.GetKeyCode().GetGroup() );
//STRIP001 	if( aKeyGroup != KEYGROUP_CURSOR && aKeyGroup != KEYGROUP_FKEYS ||
//STRIP001 		GetActualPage() != pLastPage )
//STRIP001 	{
//STRIP001 		Invalidate( SID_PREVIEW_STATE );
//STRIP001 	}
//STRIP001 
//STRIP001 	return(bReturn);
//STRIP001 }


/*************************************************************************
|*
|* Optimale Groesse zurueckgeben
|*
\************************************************************************/

//STRIP001 Size SdOutlineViewShell::GetOptimalSizePixel() const
//STRIP001 {
//STRIP001 	Size aResult(200, 200);
//STRIP001 	if (pOlView)
//STRIP001 	{
//STRIP001 		Outliner* pOutliner = pOlView->GetOutliner();
//STRIP001 		if (pOutliner)
//STRIP001 		{
//STRIP001 			Size aTemp = pOutliner->CalcTextSize();
//STRIP001 			aTemp = pWindow->LogicToPixel(aTemp);
//STRIP001 			aResult.Width() = Max(aResult.Width(), aTemp.Width());
//STRIP001 			aResult.Height() = Max(aResult.Height(), aTemp.Height());
//STRIP001 			if (4 * aResult.Height() > 3 * aResult.Width())
//STRIP001 			{
//STRIP001 				aResult.Height() = 3 * aResult.Width() / 4;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// und jetzt jetzt das Standardgelumpe draufaddieren
//STRIP001 	aResult.Width()  += pVScrlArray[0]->GetSizePixel().Width();
//STRIP001 	aResult.Height() += pHScrlArray[0]->GetSizePixel().Height();
//STRIP001 		//!!! +	System::GetMenuBarHeightPixel();  // statt Titlebar
//STRIP001 	return aResult;
//STRIP001 }


/*************************************************************************
|*
|* Text der Selektion zurueckgeben
|*
\************************************************************************/

//STRIP001 String SdOutlineViewShell::GetSelectionText(BOOL bCompleteWords)
//STRIP001 {
//STRIP001 	String aStrSelection;
//STRIP001 	Outliner* pOl = pOlView->GetOutliner();
//STRIP001 	OutlinerView* pOutlinerView = pOlView->GetViewByWindow( pWindow );
//STRIP001 
//STRIP001 	if (pOl && pOlView)
//STRIP001 	{
//STRIP001 		if (bCompleteWords)
//STRIP001 		{
//STRIP001 			ESelection aSel = pOutlinerView->GetSelection();
//STRIP001 			String aStrCurrentDelimiters = pOl->GetWordDelimiters();
//STRIP001 
//STRIP001 			pOl->SetWordDelimiters( String( RTL_CONSTASCII_USTRINGPARAM( " .,;\"'" )));
//STRIP001 			aStrSelection = pOl->GetWord( aSel.nEndPara, aSel.nEndPos );
//STRIP001 			pOl->SetWordDelimiters( aStrCurrentDelimiters );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aStrSelection = pOutlinerView->GetSelected();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return (aStrSelection);
//STRIP001 }


/*************************************************************************
|*
|* Ist etwas selektiert?
|*
\************************************************************************/

//STRIP001 BOOL SdOutlineViewShell::HasSelection(BOOL bText) const
//STRIP001 {
//STRIP001 	BOOL bReturn = FALSE;
//STRIP001 
//STRIP001 	if (bText)
//STRIP001 	{
//STRIP001 		OutlinerView* pOutlinerView = pOlView->GetViewByWindow( pWindow );
//STRIP001 
//STRIP001 		if (pOutlinerView && pOutlinerView->GetSelected().Len() != 0)
//STRIP001 		{
//STRIP001 			bReturn = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bReturn;
//STRIP001 }


/*************************************************************************
|*
|* Status der Attribut-Items
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::GetAttrState( SfxItemSet& rSet )
//STRIP001 {
//STRIP001 	SfxWhichIter  aIter( rSet );
//STRIP001 	USHORT        nWhich = aIter.FirstWhich();
//STRIP001 	SfxAllItemSet aAllSet( *rSet.GetPool() );
//STRIP001 
//STRIP001 	while ( nWhich )
//STRIP001 	{
//STRIP001 		USHORT nSlotId = SfxItemPool::IsWhich(nWhich)
//STRIP001 			? GetPool().GetSlotId(nWhich)
//STRIP001 			: nWhich;
//STRIP001 
//STRIP001 		switch ( nSlotId )
//STRIP001 		{
//STRIP001 			case SID_STYLE_FAMILY2:
//STRIP001 			{
//STRIP001 				rSet.DisableItem( nWhich );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_STYLE_FAMILY5:
//STRIP001 			{
//STRIP001 				SfxStyleSheet* pStyleSheet = pOlView->GetViewByWindow(pWindow)->GetStyleSheet();
//STRIP001 
//STRIP001 				if( pStyleSheet )
//STRIP001 				{
//STRIP001 					pStyleSheet = ((SdStyleSheet*)pStyleSheet)->GetPseudoStyleSheet();
//STRIP001 
//STRIP001 					if (pStyleSheet)
//STRIP001 					{
//STRIP001 						SfxTemplateItem aItem( nWhich, pStyleSheet->GetName() );
//STRIP001 						aAllSet.Put( aItem, aItem.Which()  );
//STRIP001 					}
//STRIP001 				}
//STRIP001 
//STRIP001 				if( !pStyleSheet )
//STRIP001 				{
//STRIP001 					SfxTemplateItem aItem( nWhich, String() );
//STRIP001 					aAllSet.Put( aItem, aItem.Which() );
//STRIP001 					// rSet.DisableItem( nWhich );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_STYLE_EDIT:
//STRIP001 			{
//STRIP001 				ISfxTemplateCommon* pTmplCommon = SFX_APP()->GetCurrentTemplateCommon(GetViewFrame()->GetBindings());
//STRIP001 
//STRIP001 				if (pTmplCommon && pTmplCommon->GetActualFamily() == SFX_STYLE_FAMILY_PSEUDO)
//STRIP001 				{
//STRIP001 					SfxItemSet aSet(*rSet.GetPool(), SID_STATUS_LAYOUT, SID_STATUS_LAYOUT);
//STRIP001 					GetStatusBarState(aSet);
//STRIP001 					String aRealStyle(((SfxStringItem&) aSet.Get(SID_STATUS_LAYOUT)).GetValue());
//STRIP001 
//STRIP001 					if (!aRealStyle.Len())
//STRIP001 					{
//STRIP001 						// Kein eindeutiger Layoutname gefunden
//STRIP001 						rSet.DisableItem(nWhich);
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_STYLE_UPDATE_BY_EXAMPLE:
//STRIP001 			{
//STRIP001 				SdWindow*     pActWin = GetActiveWindow();
//STRIP001 				OutlinerView* pOV = pOlView->GetViewByWindow(pActWin);
//STRIP001 				ESelection aESel(pOV->GetSelection());
//STRIP001 
//STRIP001 				if (aESel.nStartPara != aESel.nEndPara ||
//STRIP001 					aESel.nStartPos  != aESel.nEndPos)
//STRIP001 					// aufgespannte Selektion, also StyleSheet und/oder
//STRIP001 					// Attributierung nicht zwingend eindeutig
//STRIP001 					rSet.DisableItem(nWhich);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case SID_STYLE_NEW:
//STRIP001 			case SID_STYLE_DELETE:
//STRIP001 			case SID_STYLE_NEW_BY_EXAMPLE:
//STRIP001 			case SID_STYLE_WATERCAN:
//STRIP001 			{
//STRIP001 				rSet.DisableItem(nWhich);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 
//STRIP001 	rSet.Put( aAllSet, FALSE );
//STRIP001 }


/*************************************************************************
|*
|* MouseButtonUp event
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::MouseButtonUp(const MouseEvent& rMEvt, SdWindow* pWin)
//STRIP001 {
//STRIP001 	// Zuerst die Basisklasse
//STRIP001 	SdViewShell::MouseButtonUp(rMEvt, pWin);
//STRIP001 
//STRIP001 	Invalidate(SID_STYLE_EDIT);
//STRIP001 	Invalidate(SID_STYLE_NEW);
//STRIP001 	Invalidate(SID_STYLE_DELETE);
//STRIP001 	Invalidate(SID_STYLE_UPDATE_BY_EXAMPLE);
//STRIP001 	Invalidate(SID_STYLE_NEW_BY_EXAMPLE);
//STRIP001 	Invalidate(SID_STYLE_WATERCAN);
//STRIP001 	Invalidate(SID_STYLE_FAMILY5);
//STRIP001 
//STRIP001 	// ggfs. Preview den neuen Kontext mitteilen
//STRIP001 	if( GetActualPage() != pLastPage )
//STRIP001 		Invalidate( SID_PREVIEW_STATE );

	/*
	SfxChildWindow* pPreviewChildWindow =
		SFX_APP()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
	if (pPreviewChildWindow)
	{
		SdPreviewWin* pPreviewWin =
			(SdPreviewWin*)pPreviewChildWindow->GetWindow();
		if (pPreviewWin)
		{
			SdPage*	pPage = GetActualPage();
			if( pPage != pLastPage )
			{
				pLastPage = pPage;
				USHORT	nPage = (pPage->GetPageNum() - 1) / 2; // Sdr --> Sd

				pPreviewWin->SetContext( pDoc, nPage, pFrameView );
			}
		}
	}
	*/
//STRIP001 }

/*************************************************************************
|*
|* Liefert die erste selektierte Seite zurueck.
|* Wenn nichts selektiert ist, wird die erste Seite zurueckgeliefert.
|*
\************************************************************************/

//STRIP001 SdPage* SdOutlineViewShell::GetActualPage()
//STRIP001 {
	/* Code, der das gleiche Ergebnis liefert, gibt es schon in der
	   SdOutlinerView ! */
	/*
	Outliner* pOutl = pOlView->GetOutliner();
	DBG_ASSERT(pOutl, "kein Outliner");
	OutlinerView* pOutlinerView = pOlView->GetViewByWindow( pWindow );
	List* pList = pOutlinerView->CreateSelectionList();

	Paragraph* pSelPara = (Paragraph*)pList->First();
	USHORT nPara = 0;

	Paragraph* pPara = pOutl->First();
	BOOL bFound = pPara == pSelPara;
	while( !bFound )
	{
		BOOL bHasChilds = pOutl->HasChilds(pPara);
		if( bHasChilds )
		{
			pPara = pOutl->Next();
			while( pPara && pPara->GetDepth() != 0 && !bFound )
			{
				bFound = pPara == pSelPara;
				if( !bFound )
					pPara = pOutl->Next();
			}
		}
		if( !bFound )
		{
			if( !bHasChilds )
				pPara = pOutl->Next();
			bFound = pPara == pSelPara;
			nPara++;
		}
	}
	delete pList;

	SdPage* pPage = pDoc->GetSdPage( nPara, PK_STANDARD );
	*/
//STRIP001 	SdPage* pPage = pOlView->GetActualPage();
//STRIP001 
//STRIP001 	return( pPage );
//STRIP001 }


/*************************************************************************
|*
|* Retrieve range of marked pages
|*
\************************************************************************/

//STRIP001 String SdOutlineViewShell::GetPageRangeString()
//STRIP001 {
//STRIP001 	SdWindow*	   pWin 			= GetActiveWindow();
//STRIP001 	OutlinerView*  pActiveView		= pOlView->GetViewByWindow(pWin);
//STRIP001 	Outliner*      pOutl            = pActiveView->GetOutliner();
//STRIP001 	List*		   pSelList 		= (List*)pActiveView->CreateSelectionList();
//STRIP001 	Paragraph*	   pPara			= (Paragraph*)pSelList->First();
//STRIP001 
//STRIP001 	String aStrPageRange;
//STRIP001 	BOOL bFirstPageNo = TRUE;
//STRIP001 	BOOL bOpenRange = FALSE;
//STRIP001 	USHORT nLastPage;
//STRIP001 	USHORT nLastUsedPage = -1;
//STRIP001 
//STRIP001 	USHORT nPageCount = 0;
//STRIP001 	for( USHORT n = 0; n< pDoc->GetPageCount(); n++ )
//STRIP001 		if( ( (SdPage*)pDoc->GetPage( n ) )->GetPageKind() == PK_STANDARD )
//STRIP001 			nPageCount++;
//STRIP001 
//STRIP001 	while ( pPara )
//STRIP001 	{
//STRIP001 		if ( pOutl->GetDepth( (USHORT) pOutl->GetAbsPos( pPara ) ) > 0 )
//STRIP001 		{
//STRIP001 			pPara = pOlView->GetPrevTitle(pPara);
//STRIP001 		}
//STRIP001 		USHORT nPageToSelect = 0;
//STRIP001 		while(pPara)
//STRIP001 		{
//STRIP001 			pPara = pOlView->GetPrevTitle(pPara);
//STRIP001 			if (pPara)
//STRIP001 				nPageToSelect++;
//STRIP001 		}
//STRIP001 
//STRIP001 		if( bFirstPageNo )
//STRIP001 		{
//STRIP001 			bFirstPageNo = FALSE;
//STRIP001 			aStrPageRange = String::CreateFromInt32( sal_Int32( nPageToSelect+1 ) );
//STRIP001 			nLastUsedPage = nPageToSelect;
//STRIP001 			nPageCount--;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( nPageToSelect != nLastPage )
//STRIP001 			{
//STRIP001 				if( nPageToSelect == nLastPage+1 )
//STRIP001 				{
//STRIP001 					bOpenRange = TRUE;
//STRIP001 					nPageCount--;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					if( bOpenRange )
//STRIP001 					{
//STRIP001 						if( nLastPage == nLastUsedPage+1 )
//STRIP001 							aStrPageRange.Append( sal_Unicode(',') );
//STRIP001 						else
//STRIP001 							aStrPageRange.Append( sal_Unicode('-') );
//STRIP001 
//STRIP001 						aStrPageRange.Append( String::CreateFromInt32( sal_Int32( nLastPage+1 ) ) );
//STRIP001 					}
//STRIP001 					aStrPageRange.Append( sal_Unicode(',') );
//STRIP001 					aStrPageRange.Append( String::CreateFromInt32( sal_Int32( nPageToSelect+1 ) ) );
//STRIP001 					nLastUsedPage = nPageToSelect;
//STRIP001 					bOpenRange = FALSE;
//STRIP001 					nPageCount--;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		nLastPage = nPageToSelect;
//STRIP001 		pPara = (Paragraph*)pSelList->Next();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bOpenRange )
//STRIP001 	{
//STRIP001 		if( nLastPage == nLastUsedPage+1 )
//STRIP001 			aStrPageRange.Append( sal_Unicode(',') );
//STRIP001 		else
//STRIP001 			aStrPageRange.Append( sal_Unicode('-') );
//STRIP001 
//STRIP001 		aStrPageRange.Append( String::CreateFromInt32( sal_Int32( nLastPage+1 ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	if( nPageCount == 0 )
//STRIP001 		aStrPageRange.Erase();
//STRIP001 
//STRIP001 	delete pSelList;				// die wurde extra fuer uns erzeugt
//STRIP001 
//STRIP001 	return aStrPageRange;
//STRIP001 }

/*************************************************************************
|*
|* Update Preview
|*
\************************************************************************/

//STRIP001 void SdOutlineViewShell::UpdatePreview( SdPage* pPage, BOOL bInit )
//STRIP001 {
//STRIP001 	// vom ShowWindow der DiaShow?
//STRIP001 	// ggfs. Preview den neuen Kontext mitteilen
//STRIP001 	SfxChildWindow* pPreviewChildWindow =
//STRIP001 		GetViewFrame()->GetChildWindow(SdPreviewChildWindow::GetChildWindowId());
//STRIP001 	if (pPreviewChildWindow)
//STRIP001 	{
//STRIP001 		SdPreviewWin* pPreviewWin =
//STRIP001 			(SdPreviewWin*)pPreviewChildWindow->GetWindow();
//STRIP001 		if (pPreviewWin && ( bInit || pPreviewWin->GetDoc() == pDoc ) )
//STRIP001 		{
//STRIP001 			BOOL bNewObject = FALSE;
//STRIP001 
//STRIP001 			OutlinerView* pOutlinerView = pOlView->GetViewByWindow( pWindow );
//STRIP001 			Outliner* pOutliner = pOutlinerView->GetOutliner();
//STRIP001 			List* pList = pOutlinerView->CreateSelectionList();
//STRIP001 			Paragraph* pPara = (Paragraph*)pList->First();
//STRIP001 			delete pList;
//STRIP001 
//STRIP001 			BOOL bNewPage = pPage != pLastPage;
//STRIP001 			BOOL bTitleObject = pOutliner->GetDepth( (USHORT) pOutliner->GetAbsPos( pPara ) ) == 0;
//STRIP001 			if( !bTitleObject )
//STRIP001 				pPara = pOlView->GetPrevTitle( pPara );
//STRIP001 
//STRIP001 			// #96551# handle both updates when its an OutlineView
//STRIP001 			BOOL bOutlineView(FALSE);
//STRIP001 			if(OUTLINERMODE_OUTLINEVIEW == pOutliner->GetMode())
//STRIP001 				bOutlineView = TRUE;
//STRIP001 
//STRIP001 			if( bTitleObject || bNewPage || bOutlineView )
//STRIP001 			{
//STRIP001 				/*********************************************************************
//STRIP001 				|* Titeltextobjekt
//STRIP001 				\********************************************************************/
//STRIP001 				bNewObject = UpdateTitleObject( pPage, pPara );
//STRIP001 			}
//STRIP001 			if( !bTitleObject || bNewPage || bOutlineView )
//STRIP001 			{
//STRIP001 				/*********************************************************************
//STRIP001 				|* Gliederungstextobjekt
//STRIP001 				\********************************************************************/
//STRIP001 				bNewObject |= UpdateLayoutObject( pPage, pPara );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( bNewObject )
//STRIP001 			{
//STRIP001 				// das AutoLayout nochmal anwenden, damit neu eingefuegte Textobjekte
//STRIP001 				// die richtige Position/Groesse bekommen
//STRIP001 				pPage->SetAutoLayout(pPage->GetAutoLayout());
//STRIP001 			}
//STRIP001 			// In Preview neu darstellen (nur bei neuer Seite):
//STRIP001 			if( bNewPage || bNewObject || bInit )
//STRIP001 			{
//STRIP001 				pLastPage = pPage;
//STRIP001 				SdViewShell::UpdatePreview( pPage, TRUE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* Update Title
|*
\************************************************************************/

//STRIP001 BOOL SdOutlineViewShell::UpdateTitleObject( SdPage*	pPage, Paragraph* pPara )
//STRIP001 {
//STRIP001 	Outliner* 			pOutliner = pOlView->GetOutliner();
//STRIP001 	SdrTextObj* 		pTO  = pOlView->GetTitleTextObject( pPage );
//STRIP001 	OutlinerParaObject* pOPO = NULL;
//STRIP001 
//STRIP001 	String	aTest( pOutliner->GetText( pPara ) );
//STRIP001 	BOOL 	bText = aTest.Len() > 0;
//STRIP001 	BOOL 	bNewObject = FALSE;
//STRIP001 
//STRIP001 	// kein Seitenobjekt, Text im Outliner:
//STRIP001 	// entspr. Seitenobjekt erzeugen und einfuegen
//STRIP001 	if( !pTO && bText )
//STRIP001 	{
//STRIP001 		SfxStyleSheetBasePool* pSPool = pDoc->GetStyleSheetPool();
//STRIP001 
//STRIP001 		// Titelvorlage
//STRIP001 		String aFullName = pPage->GetLayoutName();
//STRIP001 		String aSep( RTL_CONSTASCII_USTRINGPARAM( SD_LT_SEPARATOR ));
//STRIP001 		USHORT n = aFullName.Search(aSep);
//STRIP001 		n += aSep.Len();
//STRIP001 		aFullName.Erase(n);
//STRIP001 		aFullName += String (SdResId(STR_LAYOUT_TITLE));
//STRIP001 		SfxStyleSheet* pTitleSheet = (SfxStyleSheet*)pSPool->
//STRIP001 										Find(aFullName, SD_LT_FAMILY);
//STRIP001 		DBG_ASSERT(pTitleSheet, "Titelvorlage nicht gefunden");
//STRIP001 
//STRIP001 
//STRIP001 		pTO  = new SdrRectObj( OBJ_TITLETEXT );
//STRIP001 		pOPO = pOutliner->CreateParaObject( (USHORT) pOutliner->GetAbsPos( pPara ), 1 );
//STRIP001 		pOPO->SetOutlinerMode( OUTLINERMODE_TITLEOBJECT );
//STRIP001 		pTO->SetOutlinerParaObject( pOPO );
//STRIP001 		pTO->SetEmptyPresObj( FALSE );
//STRIP001 
//STRIP001 		AutoLayout eLayout = pPage->GetAutoLayout();
//STRIP001 		if( eLayout == AUTOLAYOUT_VERTICAL_TITLE_TEXT_CHART       ||
//STRIP001 		    eLayout == AUTOLAYOUT_VERTICAL_TITLE_VERTICAL_OUTLINE )
//STRIP001 			pTO->SetVerticalWriting( TRUE );
//STRIP001 
//STRIP001 		// als Praesentationsobjekt anmelden
//STRIP001 		pTO->SetUserCall( pPage );
//STRIP001 		List* pPresObjList = pPage->GetPresObjList();
//STRIP001 		pPresObjList->Insert( pTO, LIST_APPEND );
//STRIP001 
//STRIP001 		pPage->InsertObject( pTO );
//STRIP001 					// TRUE: DontRemoveHardAttr
//STRIP001 		pTO->SetStyleSheet( pTitleSheet, TRUE );
//STRIP001 
//STRIP001 		// Nur Objekt painten
//STRIP001 		//pTO->SendRepaintBroadcast();
//STRIP001 		bNewObject = TRUE;
//STRIP001 	}
//STRIP001 	// Seitenobjekt, Text im Outliner:
//STRIP001 	// Titeltext uebernehmen
//STRIP001 	else if( pTO && bText )
//STRIP001 	{
//STRIP001 		pOPO = pOutliner->CreateParaObject( (USHORT) pOutliner->GetAbsPos( pPara ), 1 );
//STRIP001 		pOPO->SetOutlinerMode( OUTLINERMODE_TITLEOBJECT );
//STRIP001 		pOPO->SetVertical( pTO->IsVerticalWriting() );
//STRIP001 		pTO->SetOutlinerParaObject( pOPO );
//STRIP001 		pTO->SetEmptyPresObj( FALSE );
//STRIP001 
//STRIP001 		// Nur Objekt painten
//STRIP001 		pTO->SendRepaintBroadcast();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bNewObject );
//STRIP001 }

/*************************************************************************
|*
|* Update LayoutObject
|*
\************************************************************************/

//STRIP001 BOOL SdOutlineViewShell::UpdateLayoutObject( SdPage* pPage, Paragraph* pPara )
//STRIP001 {
//STRIP001 	Outliner* 			pOutliner = pOlView->GetOutliner();
//STRIP001 	OutlinerParaObject* pOPO = NULL;
//STRIP001 	SdrTextObj* 		pTO  = NULL;
//STRIP001 
//STRIP001 	BOOL bNewObject = FALSE;
//STRIP001 
//STRIP001 	sal_uInt16 eOutlinerMode = OUTLINERMODE_TITLEOBJECT;
//STRIP001 	pTO = (SdrTextObj*)pPage->GetPresObj( PRESOBJ_TEXT );
//STRIP001 	if( !pTO )
//STRIP001 	{
//STRIP001 		eOutlinerMode = OUTLINERMODE_OUTLINEOBJECT;
//STRIP001 		pTO = pOlView->GetLayoutTextObject( pPage );
//STRIP001 	}
//STRIP001 
//STRIP001 	// wieviele Absaetze in der Gliederung?
//STRIP001 	ULONG nTitlePara	 = pOutliner->GetAbsPos( pPara );
//STRIP001 	ULONG nPara          = nTitlePara + 1;
//STRIP001 	ULONG nParasInLayout = 0L;
//STRIP001 	pPara = pOutliner->GetParagraph( nPara );
//STRIP001 	while( pPara && pOutliner->GetDepth( (USHORT) pOutliner->GetAbsPos( pPara ) ) != 0 )
//STRIP001 	{
//STRIP001 		nParasInLayout++;
//STRIP001 		pPara = pOutliner->GetParagraph( ++nPara );
//STRIP001 	}
//STRIP001 	if( nParasInLayout == 0 )
//STRIP001 		return( FALSE );
//STRIP001 
//STRIP001 	// ein OutlinerParaObject erzeugen
//STRIP001 	pPara = pOutliner->GetParagraph( nTitlePara + 1 );
//STRIP001 	pOPO  = pOutliner->CreateParaObject( (USHORT) nTitlePara + 1, (USHORT) nParasInLayout );
//STRIP001 
//STRIP001 	// kein Seitenobjekt, aber Gliederung im Outliner
//STRIP001 	if( !pTO && pOPO )
//STRIP001 	{
//STRIP001 		pTO = new SdrRectObj( OBJ_OUTLINETEXT );
//STRIP001 		pTO->SetEmptyPresObj( FALSE );
//STRIP001 
//STRIP001 		// als Praesentationsobjekt anmelden
//STRIP001 		pTO->SetUserCall( pPage );
//STRIP001 		List* pPresObjList = pPage->GetPresObjList();
//STRIP001 		pPresObjList->Insert( pTO, LIST_APPEND );
//STRIP001 
//STRIP001 		pPage->InsertObject( pTO );
//STRIP001 		pOPO->SetOutlinerMode( eOutlinerMode );
//STRIP001 		pTO->SetOutlinerParaObject( pOPO );
//STRIP001 
//STRIP001 		AutoLayout eLayout = pPage->GetAutoLayout();
//STRIP001 		if( eLayout == AUTOLAYOUT_TITLE_VERTICAL_OUTLINE       ||
//STRIP001 		    eLayout == AUTOLAYOUT_VERTICAL_TITLE_VERTICAL_OUTLINE ||
//STRIP001 			eLayout == AUTOLAYOUT_TITLE_VERTICAL_OUTLINE_CLIPART )
//STRIP001 			pTO->SetVerticalWriting( TRUE );
//STRIP001 
//STRIP001 		// Linien- und Fuellattribute der Standardvorlage hart
//STRIP001 		// ueberschreiben
//STRIP001 		SfxItemSet aTempAttr( pDoc->GetPool() );
//STRIP001 		aTempAttr.Put( XLineStyleItem( XLINE_NONE ) );
//STRIP001 		aTempAttr.Put( XFillStyleItem( XFILL_NONE ) );
//STRIP001 		pTO->SetItemSetAndBroadcast(aTempAttr);
//STRIP001 
//STRIP001 		// Liste der Gliederungsvorlagen fuer Anmeldung als Listener
//STRIP001 		String aName = pPage->GetLayoutName();
//STRIP001 		String aFullName;
//STRIP001 		SfxStyleSheet* pSheet = NULL;
//STRIP001 		SfxStyleSheetBasePool* pStyleSheetPool = pDoc->GetStyleSheetPool();
//STRIP001 		for (USHORT i = 1; i < 10; i++)
//STRIP001 		{
//STRIP001 			aFullName  = aName;
//STRIP001 			aFullName += sal_Unicode(' ');
//STRIP001 			aFullName += String::CreateFromInt32( (sal_Int32)i );
//STRIP001 			pSheet = (SfxStyleSheet*) pStyleSheetPool->Find(aFullName, SD_LT_FAMILY);
//STRIP001 			pTO->StartListening( *pSheet );
//STRIP001 
//STRIP001 			if( i == 1 )
//STRIP001 				pTO->SetStyleSheet( pSheet, TRUE );
//STRIP001 		}
//STRIP001 
//STRIP001 		bNewObject = TRUE;
//STRIP001 	}
//STRIP001 	// Seitenobjekt, Gliederungstext im Outliner:
//STRIP001 	// Text uebernehmen
//STRIP001 	else if( pTO && pOPO )
//STRIP001 	{
//STRIP001 		pOPO->SetVertical( pTO->IsVerticalWriting() );
//STRIP001 		pOPO->SetOutlinerMode( eOutlinerMode );
//STRIP001 		pTO->SetOutlinerParaObject( pOPO );
//STRIP001 		pTO->SetEmptyPresObj( FALSE );
//STRIP001 
//STRIP001 		// Nur Objekt painten
//STRIP001 		pTO->SendRepaintBroadcast();
//STRIP001 	}
//STRIP001 	return( bNewObject );
//STRIP001 }


/*************************************************************************
|*
|* Outliner aus Stream fuellen
|*
\************************************************************************/

//STRIP001 ULONG SdOutlineViewShell::Read(SvStream& rInput, USHORT eFormat)
//STRIP001 {
//STRIP001 	Outliner* pOutl = pOlView->GetOutliner();
//STRIP001 
//STRIP001 	ULONG bRet = pOutl->Read( rInput, eFormat, pDocSh->GetHeaderAttributes() );
//STRIP001 
//STRIP001 	SdPage* pPage = pDoc->GetSdPage( pDoc->GetSdPageCount(PK_STANDARD) - 1, PK_STANDARD );;
//STRIP001 	SfxStyleSheet* pTitleSheet = pPage->GetStyleSheetForPresObj( PRESOBJ_TITLE );
//STRIP001 	SfxStyleSheet* pOutlSheet = pPage->GetStyleSheetForPresObj( PRESOBJ_OUTLINE );
//STRIP001 	ULONG nParaCount = pOutl->GetParagraphCount();
//STRIP001 
//STRIP001 	if ( nParaCount > 0 )
//STRIP001 	{
//STRIP001 		for ( ULONG nPara = 0; nPara < nParaCount; nPara++ )
//STRIP001 		{
//STRIP001 			USHORT nDepth = pOutl->GetDepth( (USHORT) nPara );
//STRIP001 
//STRIP001 			if( nDepth == 0 )
//STRIP001 			{
//STRIP001 				pOutl->SetStyleSheet( nPara, pTitleSheet );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				String aStyleSheetName( pOutlSheet->GetName() );
//STRIP001 				aStyleSheetName.Erase( aStyleSheetName.Len() - 1, 1 );
//STRIP001 				aStyleSheetName += String::CreateFromInt32( nDepth );
//STRIP001 				SfxStyleSheetBasePool* pStylePool = pDoc->GetStyleSheetPool();
//STRIP001 				SfxStyleSheet* pStyle = (SfxStyleSheet*) pStylePool->Find( aStyleSheetName, pOutlSheet->GetFamily() );
//STRIP001 				DBG_ASSERT( pStyle, "AutoStyleSheetName - Style not found!" );
//STRIP001 				if ( pStyle )
//STRIP001 					pOutl->SetStyleSheet( nPara, pStyle );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return( bRet );
//STRIP001 }

//STRIP001 void SdOutlineViewShell::WriteUserDataSequence ( ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	WriteFrameViewData();
//STRIP001 
//STRIP001 	SdViewShell::WriteUserDataSequence( rSequence, bBrowse );
//STRIP001 }

//STRIP001 void SdOutlineViewShell::ReadUserDataSequence ( const ::com::sun::star::uno::Sequence < ::com::sun::star::beans::PropertyValue >& rSequence, sal_Bool bBrowse )
//STRIP001 {
//STRIP001 	WriteFrameViewData();
//STRIP001 
//STRIP001 	SdViewShell::ReadUserDataSequence( rSequence, bBrowse );
//STRIP001 
//STRIP001 	ReadFrameViewData( pFrameView );
//STRIP001 }

//STRIP001 void SdOutlineViewShell::VisAreaChanged(const Rectangle& rRect)
//STRIP001 {
//STRIP001 	SdViewShell::VisAreaChanged( rRect );
//STRIP001 
//STRIP001 	if( pController )
//STRIP001 	{
//STRIP001 		pController->fireVisAreaChanged( rRect );
//STRIP001 	}
//STRIP001 }

/** If there is a valid controller then create a new instance of
    <type>AccessibleDrawDocumentView</type>.  Otherwise delegate this call
    to the base class to return a default object (probably an empty
    reference).
*/
//STRIP001 ::com::sun::star::uno::Reference<
//STRIP001     ::com::sun::star::accessibility::XAccessible>
//STRIP001     SdOutlineViewShell::CreateAccessibleDocumentView (SdWindow* pWindow)
//STRIP001 {
//STRIP001     if (GetController() != NULL)
//STRIP001     {
//STRIP001         ::accessibility::AccessibleOutlineView* pDocumentView = 
//STRIP001             new ::accessibility::AccessibleOutlineView (
//STRIP001                 pWindow,
//STRIP001                 this,
//STRIP001                 GetController(),
//STRIP001                 pWindow->GetAccessibleParentWindow()->GetAccessible());
//STRIP001         pDocumentView->Init();
//STRIP001         return ::com::sun::star::uno::Reference<
//STRIP001             ::com::sun::star::accessibility::XAccessible> 
//STRIP001             (static_cast< ::com::sun::star::uno::XWeak*>(pDocumentView), 
//STRIP001                 ::com::sun::star::uno::UNO_QUERY);
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         OSL_TRACE ("SdOutlineViewShell::CreateAccessibleDocumentView: no controller");
//STRIP001         return SdViewShell::CreateAccessibleDocumentView (pWindow);
//STRIP001     }
//STRIP001 }




//STRIP001 void SdOutlineViewShell::GetState (SfxItemSet& rSet)
//STRIP001 {
//STRIP001     // Iterate over all requested items in the set.
//STRIP001 	SfxWhichIter aIter( rSet );
//STRIP001 	USHORT nWhich = aIter.FirstWhich();
//STRIP001 	while (nWhich)
//STRIP001 	{
//STRIP001 		switch (nWhich)
//STRIP001 		{
//STRIP001 			case SID_SEARCH_ITEM:
//STRIP001 			case SID_SEARCH_OPTIONS:
//STRIP001                 // Call common (old) implementation in the document shell.
//STRIP001                 pDocSh->GetState (rSet);
//STRIP001                 break;
//STRIP001 			default:
//STRIP001                 OSL_TRACE ("SdOutlineViewShell::GetState(): can not handle which id %d", nWhich);
//STRIP001                 break;
//STRIP001         }
//STRIP001 		nWhich = aIter.NextWhich();
//STRIP001 	}
//STRIP001 }
}
