/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sd_navigatr.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 23:57:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
// auto strip #ifndef _UNOTOOLS_LOCALFILEHELPER_HXX
// auto strip #include <unotools/localfilehelper.hxx>
// auto strip #endif
// auto strip #ifndef _SFXIMGMGR_HXX //autogen
// auto strip #include <bf_sfx2/imgmgr.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_FCONTNR_HXX //autogen
// auto strip #include <bf_sfx2/fcontnr.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXSTRITEM_HXX //autogen
// auto strip #include <svtools/stritem.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_DOCFILT_HACK_HXX //autogen
// auto strip #include <bf_sfx2/docfilt.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
#include <bf_svx/svxids.hrc>
// auto strip #ifndef _SV_MENU_HXX //autogen
// auto strip #include <vcl/menu.hxx>
// auto strip #endif

// auto strip #ifndef _SFXDOCKWIN_HXX
// auto strip #include <bf_sfx2/dockwin.hxx>
// auto strip #endif

//STRIP001 #include "pres.hxx"
//STRIP001 #include "navigatr.hxx"
#include "navichld.hxx"
//STRIP001 #include "navigatr.hrc"
//STRIP001 #include "pgjump.hxx"
//STRIP001 #include "app.hrc"
#include "strings.hrc"
namespace binfilter {
//STRIP001 #include "res_bmp.hrc"
//STRIP001 #include "drawdoc.hxx"
//STRIP001 #include "docshell.hxx"
//STRIP001 #include "sdresid.hxx"
//STRIP001 #include "viewshel.hxx"
//STRIP001 #include "drviewsh.hxx"
//STRIP001 #include "fuslshow.hxx"
//STRIP001 #include "helpids.h"


/*N*/ SFX_IMPL_CHILDWINDOWCONTEXT( SdNavigatorChildWindow, SID_NAVIGATOR )
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*	SdNavigatorWin - FloatingWindow
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdNavigatorWin::SdNavigatorWin( Window* pParent,
//STRIP001 				SdNavigatorChildWindow* pChWinCtxt,
//STRIP001 				const SdResId& rSdResId, SfxBindings* pInBindings ) :
//STRIP001 		Window    		( pParent, rSdResId ),
//STRIP001 		aToolbox        ( this, SdResId( 1 ) ),
//STRIP001 		aTlbObjects     ( this, SdResId( TLB_OBJECTS ), TRUE ),
//STRIP001 		aLbDocs         ( this, SdResId( LB_DOCS ) ),
//STRIP001 		pBindings		( pInBindings ),
//STRIP001 		pChildWinContext( pChWinCtxt ),
//STRIP001 		maImageList		( SdResId( IL_NAVIGATR ) ),
//STRIP001 		maImageListH	( SdResId( ILH_NAVIGATR ) ),
//STRIP001 		// Bei Aenderung des DragTypes: SelectionMode der TLB anpassen!
//STRIP001 		eDragType		( NAVIGATOR_DRAGTYPE_EMBEDDED ),
//STRIP001 		bDocImported	( FALSE )
//STRIP001 {
//STRIP001 	aTlbObjects.SetViewFrame( pBindings->GetDispatcher()->GetFrame() );
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	pNavigatorCtrlItem = new SdNavigatorControllerItem( SID_NAVIGATOR_STATE, this, pBindings );
//STRIP001 	pPageNameCtrlItem = new SdPageNameControllerItem( SID_NAVIGATOR_PAGENAME, this, pBindings );
//STRIP001 	pDocList = new List();
//STRIP001 
//STRIP001 	aSize = GetOutputSizePixel();
//STRIP001 	// Da es jetzt kein SetMinOutputSizePixel mehr gibt:
//STRIP001 	aMinSize = aSize;
//STRIP001 	aMinSize.Height() -= 40;
//STRIP001 	((SfxDockingWindow*)GetParent())->SetMinOutputSizePixel( aMinSize );
//STRIP001 
//STRIP001 	// ToolBox (Groesse anpassen funktioniert sowieso nicht!)
//STRIP001 	Size aTbxSize( aToolbox.CalcWindowSizePixel() );
//STRIP001 	aTbxSize.Width() = aSize.Width() - 6; //Rand
//STRIP001 	aTbxSize.Height() += 1;  // AF: Work arround for #105145#
//STRIP001 	aToolbox.SetOutputSizePixel( aTbxSize );
//STRIP001 	aToolbox.SetSelectHdl( LINK( this, SdNavigatorWin, SelectToolboxHdl ) );
//STRIP001 	aToolbox.SetClickHdl( LINK( this, SdNavigatorWin, ClickToolboxHdl ) );
//STRIP001     pBindings->GetImageManager()->RegisterToolBox( &aToolbox, SFX_TOOLBOX_CHANGEOUTSTYLE );
//STRIP001 
//STRIP001 	// TreeListBox
//STRIP001 	aTlbObjects.SetDoubleClickHdl( LINK( this, SdNavigatorWin, ClickObjectHdl ) );
//STRIP001 	aTlbObjects.SetSelectionMode( SINGLE_SELECTION );
//STRIP001 
//STRIP001 	// DragTypeListBox
//STRIP001 	aLbDocs.SetSelectHdl( LINK( this, SdNavigatorWin, SelectDocumentHdl ) );
//STRIP001 
//STRIP001 	// InitTlb; Wird ueber Slot initiiert
//STRIP001 	SfxBoolItem aItem( SID_NAVIGATOR_INIT, TRUE );
//STRIP001 	pBindings->GetDispatcher()->Execute(
//STRIP001 		SID_NAVIGATOR_INIT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001 	ApplyImageList();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SdNavigatorWin::~SdNavigatorWin()
//STRIP001 {
//STRIP001     pBindings->GetImageManager()->ReleaseToolBox( &aToolbox );
//STRIP001 
//STRIP001 	delete pNavigatorCtrlItem;
//STRIP001 	delete pPageNameCtrlItem;
//STRIP001 
//STRIP001 	// Liste der DocInfos loeschen
//STRIP001 	long nCount = pDocList->Count();
//STRIP001 	while( nCount-- )
//STRIP001 		delete (NavDocInfo*) pDocList->Remove( (ULONG)0 );
//STRIP001 
//STRIP001 	delete pDocList;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdNavigatorWin::InitTreeLB( const SdDrawDocument* pDoc )
//STRIP001 {
//STRIP001 	SdDrawDocument* pNonConstDoc = (SdDrawDocument*) pDoc; // const as const can...
//STRIP001 	SdDrawDocShell* pDocShell = pNonConstDoc->GetDocSh();
//STRIP001 	String aDocShName( pDocShell->GetName() );
//STRIP001 
//STRIP001 	if( !aTlbObjects.IsEqualToDoc( pDoc ) )
//STRIP001 	{
//STRIP001 		String aDocName = pDocShell->GetMedium()->GetName();
//STRIP001 		aTlbObjects.Clear();
//STRIP001 		aTlbObjects.Fill( pDoc, (BOOL) FALSE, aDocName ); // Nur normale Seiten
//STRIP001 
//STRIP001 		RefreshDocumentLB();
//STRIP001 		aLbDocs.SelectEntry( aDocShName );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbDocs.SetNoSelection();
//STRIP001 		aLbDocs.SelectEntry( aDocShName );
//STRIP001 
//STRIP001 // auskommentiert um 30246 zu fixen
//STRIP001 //		  if( aLbDocs.GetSelectEntryCount() == 0 )
//STRIP001 		{
//STRIP001 			RefreshDocumentLB();
//STRIP001 			aLbDocs.SelectEntry( aDocShName );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	SdViewShell* pViewShell = pDocShell->GetViewShell();
//STRIP001 
//STRIP001 	( ( pViewShell && pViewShell->GetViewFrame() ) ? pViewShell->GetViewFrame() : SfxViewFrame::Current() )->
//STRIP001 		GetBindings().Invalidate(SID_NAVIGATOR_PAGENAME, TRUE, TRUE);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* DragType wird in Abhaengigkeit davon gesetzt, ob ein Drag ueberhaupt
//STRIP001 |* moeglich ist. Graphiken duerfen beispielsweise unter gewissen Umstaenden
//STRIP001 |* nicht gedragt werden (#31038#).
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 NavigatorDragType SdNavigatorWin::GetNavigatorDragType()
//STRIP001 {
//STRIP001 	NavigatorDragType   eDT = eDragType;
//STRIP001 	NavDocInfo*         pInfo = GetDocInfo();
//STRIP001 
//STRIP001 	if( ( eDT == NAVIGATOR_DRAGTYPE_LINK ) && ( ( pInfo && !pInfo->HasName() ) || !aTlbObjects.IsLinkableSelected() ) ) 
//STRIP001 		eDT = NAVIGATOR_DRAGTYPE_NONE;
//STRIP001 
//STRIP001 	return( eDT );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SdNavigatorWin, SelectToolboxHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	USHORT nId = aToolbox.GetCurItemId();
//STRIP001 	USHORT nSId = 0;
//STRIP001 	PageJump ePage = PAGE_NONE;
//STRIP001 
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case TBI_LIVE:
//STRIP001 		case TBI_PEN:
//STRIP001 		{
//STRIP001 			if( nId == TBI_LIVE )
//STRIP001 			{
//STRIP001 				nSId = SID_LIVE_PRESENTATION;
//STRIP001 				aToolbox.EnableItem( TBI_PEN, FALSE );
//STRIP001 			}
//STRIP001 			else if( nId == TBI_PEN )
//STRIP001 			{
//STRIP001 				nSId = SID_NAVIGATOR_PEN;
//STRIP001 				aToolbox.EnableItem( TBI_LIVE, FALSE );
//STRIP001 			}
//STRIP001 
//STRIP001 			if( nSId > 0 )
//STRIP001 			{
//STRIP001 				SfxBoolItem aItem( nSId, TRUE );
//STRIP001 				pBindings->GetDispatcher()->Execute(
//STRIP001 					nSId, SFX_CALLMODE_SLOT |SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case TBI_FIRST:
//STRIP001 		case TBI_PREVIOUS:
//STRIP001 		case TBI_NEXT:
//STRIP001 		case TBI_LAST:
//STRIP001 		{
//STRIP001 			if( nId == TBI_FIRST )
//STRIP001 				ePage = PAGE_FIRST;
//STRIP001 			else if( nId == TBI_PREVIOUS )
//STRIP001 				ePage = PAGE_PREVIOUS;
//STRIP001 			else if( nId == TBI_NEXT )
//STRIP001 				ePage = PAGE_NEXT;
//STRIP001 			else if( nId == TBI_LAST )
//STRIP001 				ePage = PAGE_LAST;
//STRIP001 
//STRIP001 			if( ePage != PAGE_NONE )
//STRIP001 			{
//STRIP001 				SfxUInt16Item aItem( SID_NAVIGATOR_PAGE, ePage );
//STRIP001 				pBindings->GetDispatcher()->Execute(
//STRIP001 					SID_NAVIGATOR_PAGE, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SdNavigatorWin, ClickToolboxHdl, ToolBox*, pBox )
//STRIP001 {
//STRIP001 	USHORT nId = aToolbox.GetCurItemId();
//STRIP001 
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case TBI_DRAGTYPE:
//STRIP001 		{
//STRIP001 			// Popup-Menu wird in Abhaengigkeit davon erzeugt, ob Dokument
//STRIP001 			// gespeichert ist oder nicht
//STRIP001 			PopupMenu *pMenu = new PopupMenu;
//STRIP001 
//STRIP001 			for( USHORT nID = NAVIGATOR_DRAGTYPE_URL;
//STRIP001 				 nID < NAVIGATOR_DRAGTYPE_COUNT;
//STRIP001 				 nID++ )
//STRIP001 			{
//STRIP001 				USHORT nRId = GetDragTypeSdResId( (NavigatorDragType)nID );
//STRIP001 				if( nRId > 0 )
//STRIP001 				{
//STRIP001 					pMenu->InsertItem( nID, String( SdResId( nRId ) ) );
//STRIP001 					pMenu->SetHelpId( nID, HID_SD_NAVIGATOR_MENU1 +
//STRIP001 											nID - NAVIGATOR_DRAGTYPE_URL );
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 			NavDocInfo* pInfo = GetDocInfo();
//STRIP001 
//STRIP001 			if( ( pInfo && !pInfo->HasName() ) || !aTlbObjects.IsLinkableSelected() )
//STRIP001 			{
//STRIP001 				pMenu->EnableItem( NAVIGATOR_DRAGTYPE_LINK, FALSE );
//STRIP001 				pMenu->EnableItem( NAVIGATOR_DRAGTYPE_URL, FALSE );
//STRIP001 				eDragType = NAVIGATOR_DRAGTYPE_EMBEDDED;
//STRIP001 			}
//STRIP001 
//STRIP001 			pMenu->CheckItem( eDragType );
//STRIP001 			pMenu->SetSelectHdl( LINK( this, SdNavigatorWin, MenuSelectHdl ) );
//STRIP001 
//STRIP001 			pMenu->Execute( this, aToolbox.GetItemRect( nId ).BottomLeft() );
//STRIP001 			pBox->EndSelection();
//STRIP001 			delete pMenu;
//STRIP001 			//pBox->Invalidate();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdNavigatorWin, ClickObjectHdl, void *, p )
//STRIP001 {
//STRIP001 	if( !bDocImported || aLbDocs.GetSelectEntryPos() != 0 )
//STRIP001 	{
//STRIP001 		NavDocInfo* pInfo = GetDocInfo();
//STRIP001 
//STRIP001 		// Nur wenn es sich um das aktive Fenster handelt, wird
//STRIP001 		// auf die Seite gesprungen
//STRIP001 		if( pInfo && pInfo->IsActive() )
//STRIP001 		{
//STRIP001 			String aStr( aTlbObjects.GetSelectEntry() );
//STRIP001 
//STRIP001 			if( aStr.Len() > 0 )
//STRIP001 			{
//STRIP001 				SfxStringItem aItem( SID_NAVIGATOR_OBJECT, aStr );
//STRIP001 				pBindings->GetDispatcher()->Execute(
//STRIP001 					SID_NAVIGATOR_OBJECT, SFX_CALLMODE_SLOT | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 
//STRIP001                 // #98821# moved here from SetGetFocusHdl. Reset the
//STRIP001                 // focus only if something has been selected in the
//STRIP001                 // document.
//STRIP001                 SfxViewShell* pCurSh = SfxViewShell::Current();
//STRIP001                 
//STRIP001                 if ( pCurSh )
//STRIP001                 {
//STRIP001                     Window* pShellWnd = pCurSh->GetWindow();
//STRIP001                     if ( pShellWnd )
//STRIP001                         pShellWnd->GrabFocus();
//STRIP001                 }
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( SdNavigatorWin, SelectDocumentHdl, void *, p )
//STRIP001 {
//STRIP001 	String aStrLb = aLbDocs.GetSelectEntry();
//STRIP001 	long   nPos = aLbDocs.GetSelectEntryPos();
//STRIP001 	BOOL   bFound = FALSE;
//STRIP001 	SdDrawDocShell* pDocShell = NULL;
//STRIP001 	NavDocInfo* pInfo = GetDocInfo();
//STRIP001 
//STRIP001 	// Handelt es sich um ein gedragtes Objekt?
//STRIP001 	if( bDocImported && nPos == 0 )
//STRIP001 	{
//STRIP001 		// Dokument in TLB aufbauen
//STRIP001 		InsertFile( aStrLb );
//STRIP001 	}
//STRIP001 	else if (pInfo)
//STRIP001 	{
//STRIP001 		pDocShell = pInfo->pDocShell;
//STRIP001 
//STRIP001 		bFound = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bFound )
//STRIP001 	{
//STRIP001 		/* z.Z. wird das Dokument nicht mehr aktiviert
//STRIP001 		SdViewShell* pViewShell = pDocShell->GetViewShell();
//STRIP001 		if( pViewShell )
//STRIP001 			pViewShell->GetViewFrame()->GetWindow().ToTop();
//STRIP001 		*/
//STRIP001 		SdDrawDocument* pDoc = pDocShell->GetDoc();
//STRIP001 		if( !aTlbObjects.IsEqualToDoc( pDoc ) )
//STRIP001 		{
//STRIP001 			SdDrawDocument* pNonConstDoc = (SdDrawDocument*) pDoc; // const as const can...
//STRIP001 			SdDrawDocShell* pDocShell = pNonConstDoc->GetDocSh();
//STRIP001 			String aDocName = pDocShell->GetMedium()->GetName();
//STRIP001 			aTlbObjects.Clear();
//STRIP001 			aTlbObjects.Fill( pDoc, (BOOL) FALSE, aDocName ); // Nur normale Seiten
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// Pruefen, ob Link oder URL moeglich ist
//STRIP001 	if( ( pInfo && !pInfo->HasName() ) || !aTlbObjects.IsLinkableSelected() || ( eDragType != NAVIGATOR_DRAGTYPE_EMBEDDED ) )
//STRIP001 	{
//STRIP001 		eDragType = NAVIGATOR_DRAGTYPE_EMBEDDED;
//STRIP001 		SetDragImage();
//STRIP001 	}
//STRIP001 
//STRIP001 	return( 0L );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* DrageType wird gesetzt und Image wird entspr. gesetzt.
//STRIP001 |* Sollte Handler mit NULL gerufen werden, so wird der Default (URL) gesetzt.
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 IMPL_LINK( SdNavigatorWin, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	USHORT nMenuId;
//STRIP001 	if( pMenu )
//STRIP001 		nMenuId = pMenu->GetCurItemId();
//STRIP001 	else
//STRIP001 		nMenuId = NAVIGATOR_DRAGTYPE_URL;
//STRIP001 
//STRIP001 	if( nMenuId != USHRT_MAX ) // Notwendig ?
//STRIP001 	{
//STRIP001 		NavigatorDragType eDT = (NavigatorDragType) nMenuId;
//STRIP001 		if( eDragType != eDT )
//STRIP001 		{
//STRIP001 			eDragType = eDT;
//STRIP001 			SetDragImage();
//STRIP001 
//STRIP001 			if( eDragType == NAVIGATOR_DRAGTYPE_URL )
//STRIP001 			{
//STRIP001 				// Fix, um Endlosschleife zu unterbinden
//STRIP001 				if( aTlbObjects.GetSelectionCount() > 1 )
//STRIP001 					aTlbObjects.SelectAll( FALSE );
//STRIP001 
//STRIP001 				aTlbObjects.SetSelectionMode( SINGLE_SELECTION );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aTlbObjects.SetSelectionMode( MULTIPLE_SELECTION );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return( 0 );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdNavigatorWin::Resize()
//STRIP001 {
//STRIP001 	Size aWinSize( GetOutputSizePixel() );
//STRIP001 	if( aWinSize.Height() >= aMinSize.Height() )
//STRIP001 		//aWinSize.Width() >= aMinSize.Width() )
//STRIP001 	{
//STRIP001 		Size aDiffSize;
//STRIP001 		aDiffSize.Width() = aWinSize.Width() - aSize.Width();
//STRIP001 		aDiffSize.Height() = aWinSize.Height() - aSize.Height();
//STRIP001 
//STRIP001 		// Umgroessern der Toolbox
//STRIP001 		Size aObjSize( aToolbox.GetOutputSizePixel() );
//STRIP001 		aObjSize.Width() += aDiffSize.Width();
//STRIP001 		aToolbox.SetOutputSizePixel( aObjSize );
//STRIP001 
//STRIP001 		// Umgroessern der TreeLB
//STRIP001 		aObjSize = aTlbObjects.Control::GetOutputSizePixel();
//STRIP001 		aObjSize.Width() += aDiffSize.Width();
//STRIP001 		aObjSize.Height() += aDiffSize.Height();
//STRIP001 		aTlbObjects.SetOutputSizePixel( aObjSize );
//STRIP001 
//STRIP001 		Point aPt( 0, aDiffSize.Height() );
//STRIP001 
//STRIP001 		// Verschieben der anderen Controls (DocumentLB)
//STRIP001 		aLbDocs.Hide();
//STRIP001 		aObjSize = aLbDocs.GetOutputSizePixel();
//STRIP001 		aObjSize.Width() += aDiffSize.Width();
//STRIP001 		aLbDocs.SetPosPixel( aLbDocs.GetPosPixel() + aPt );
//STRIP001 		aLbDocs.SetOutputSizePixel( aObjSize );
//STRIP001 		aLbDocs.Show();
//STRIP001 
//STRIP001 		aSize = aWinSize;
//STRIP001 	}
//STRIP001 	Window::Resize();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL SdNavigatorWin::InsertFile(const String& rFileName)
//STRIP001 {
//STRIP001 	INetURLObject	aURL( rFileName );
//STRIP001 	BOOL			bReturn = TRUE;
//STRIP001 
//STRIP001 	if( aURL.GetProtocol() == INET_PROT_NOT_VALID )
//STRIP001 	{
//STRIP001 		String aURLStr;
//STRIP001 		::utl::LocalFileHelper::ConvertPhysicalNameToURL( rFileName, aURLStr );
//STRIP001 		aURL = INetURLObject( aURLStr );
//STRIP001 	}
//STRIP001 
//STRIP001 	// get adjusted FileName
//STRIP001 	String aFileName( aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 	if (!aFileName.Len())
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Wieder aktuelles Dokument anzeigen
//STRIP001 		**********************************************************************/
//STRIP001 		aDropFileName = aFileName;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		/**********************************************************************
//STRIP001 		* Hineingedraggtes Dokument anzeigen
//STRIP001 		**********************************************************************/
//STRIP001 		const SfxFilter* pFilter = NULL;
//STRIP001 		ErrCode nErr = 0;
//STRIP001 
//STRIP001 		if (aFileName != aDropFileName)
//STRIP001 		{
//STRIP001 			SfxMedium aMed(aFileName, (STREAM_READ | STREAM_SHARE_DENYNONE), FALSE);
//STRIP001 			nErr = SFX_APP()->GetFilterMatcher().GuessFilter(aMed, &pFilter);
//STRIP001 
//STRIP001 			if (pFilter->GetFilterContainer() !=
//STRIP001 				SdDrawDocShell::Factory().GetFilterContainer())
//STRIP001 			{
//STRIP001 				pFilter = NULL;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if ((pFilter && !nErr) || aFileName == aDropFileName)
//STRIP001 		{
//STRIP001 			// Das Medium muss ggf. mit READ/WRITE geoeffnet werden, daher wird
//STRIP001 			// ersteinmal nachgeschaut, ob es einen Storage enthaelt
//STRIP001 			SfxMedium* pMedium = new SfxMedium( aFileName,
//STRIP001 												STREAM_READ | STREAM_NOCREATE,
//STRIP001 												TRUE);				  // Download
//STRIP001 
//STRIP001 			if (pMedium->IsStorage())
//STRIP001 			{
//STRIP001 				// Jetzt modusabhaengig:
//STRIP001 				// aTlbObjects.SetSelectionMode(MULTIPLE_SELECTION);
//STRIP001 				// Eigentuemeruebergabe von pMedium;
//STRIP001 				SdDrawDocument* pDropDoc = aTlbObjects.GetBookmarkDoc(pMedium);
//STRIP001 
//STRIP001 				if (pDropDoc)
//STRIP001 				{
//STRIP001 					aTlbObjects.Clear();
//STRIP001 					aDropFileName = aFileName;
//STRIP001 
//STRIP001 					if( !aTlbObjects.IsEqualToDoc( pDropDoc ) )
//STRIP001 					{
//STRIP001 						// Nur normale Seiten
//STRIP001 						aTlbObjects.Fill(pDropDoc, (BOOL) FALSE, aDropFileName);
//STRIP001 						RefreshDocumentLB( &aDropFileName );
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				bReturn = FALSE;
//STRIP001 				delete pMedium;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			bReturn = FALSE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return (bReturn);
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdNavigatorWin::RefreshDocumentLB( const String* pDocName )
//STRIP001 {
//STRIP001 	USHORT nPos = 0;
//STRIP001 
//STRIP001 	if( pDocName )
//STRIP001 	{
//STRIP001 		if( bDocImported )
//STRIP001 			aLbDocs.RemoveEntry( 0 );
//STRIP001 
//STRIP001 		aLbDocs.InsertEntry( *pDocName, 0 );
//STRIP001 		bDocImported = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nPos = aLbDocs.GetSelectEntryPos();
//STRIP001 		if( nPos == LISTBOX_ENTRY_NOTFOUND )
//STRIP001 			nPos = 0;
//STRIP001 
//STRIP001 		String aStr;
//STRIP001 		if( bDocImported )
//STRIP001 			aStr = aLbDocs.GetEntry( 0 );
//STRIP001 
//STRIP001 		aLbDocs.Clear();
//STRIP001 
//STRIP001 		// Liste der DocInfos loeschen
//STRIP001 		long nCount = pDocList->Count();
//STRIP001 		while( nCount-- )
//STRIP001 			delete (NavDocInfo*) pDocList->Remove( (ULONG)0 );
//STRIP001 
//STRIP001 		if( bDocImported )
//STRIP001 			aLbDocs.InsertEntry( aStr, 0 );
//STRIP001 
//STRIP001 		SdDrawDocShell* pCurrentDocShell = PTR_CAST( SdDrawDocShell, SfxObjectShell::Current() );
//STRIP001 		SfxObjectShell* pSfxDocShell = SfxObjectShell::GetFirst(0, FALSE);
//STRIP001 		while( pSfxDocShell )
//STRIP001 		{
//STRIP001 			SdDrawDocShell* pDocShell = PTR_CAST( SdDrawDocShell, pSfxDocShell );
//STRIP001 			if( pDocShell  && !pDocShell->IsInDestruction() && ( pDocShell->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED ) )
//STRIP001 			{
//STRIP001 				NavDocInfo* pInfo = new NavDocInfo();
//STRIP001 				pInfo->pDocShell = pDocShell;
//STRIP001 
//STRIP001 				aStr = pDocShell->GetMedium()->GetName();
//STRIP001 				if( aStr.Len() )
//STRIP001 					pInfo->SetName();
//STRIP001 				else
//STRIP001 					pInfo->SetName( FALSE );
//STRIP001 				// z.Z. wird wieder der Name der Shell genommen (also ohne Pfad)
//STRIP001 				// da Koose es als Fehler ansieht, wenn er Pfad in URL-Notation
//STRIP001 				// angezeigt wird!
//STRIP001 				aStr = pDocShell->GetName();
//STRIP001 
//STRIP001 				aLbDocs.InsertEntry( aStr, LISTBOX_APPEND );
//STRIP001 
//STRIP001 				//
//STRIP001 				if( pDocShell == pCurrentDocShell )
//STRIP001 					pInfo->SetActive();
//STRIP001 				else
//STRIP001 					pInfo->SetActive( FALSE );
//STRIP001 
//STRIP001 				pDocList->Insert( pInfo, LIST_APPEND );
//STRIP001 			}
//STRIP001 			pSfxDocShell = SfxObjectShell::GetNext( *pSfxDocShell, 0 , FALSE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	aLbDocs.SelectEntryPos( nPos );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 USHORT SdNavigatorWin::GetDragTypeSdResId( NavigatorDragType eDT, BOOL bImage )
//STRIP001 {
//STRIP001 	switch( eDT )
//STRIP001 	{
//STRIP001 		case NAVIGATOR_DRAGTYPE_NONE:
//STRIP001 				return( bImage ? 0 : STR_NONE );
//STRIP001 		case NAVIGATOR_DRAGTYPE_URL:
//STRIP001 				return( bImage ? TBI_HYPERLINK : STR_DRAGTYPE_URL );
//STRIP001 		case NAVIGATOR_DRAGTYPE_EMBEDDED:
//STRIP001 				return( bImage ? TBI_EMBEDDED : STR_DRAGTYPE_EMBEDDED );
//STRIP001 		case NAVIGATOR_DRAGTYPE_LINK:
//STRIP001 				return( bImage ? TBI_LINK : STR_DRAGTYPE_LINK );
//STRIP001 		default: DBG_ERROR( "Keine Resource fuer DragType vorhanden!" );
//STRIP001 	}
//STRIP001 	return( 0 );
//STRIP001 }
//STRIP001 
//STRIP001 //------------------------------------------------------------------------
//STRIP001 
//STRIP001 NavDocInfo* SdNavigatorWin::GetDocInfo()
//STRIP001 {
//STRIP001 	long nPos = aLbDocs.GetSelectEntryPos();
//STRIP001 
//STRIP001 	if( bDocImported )
//STRIP001 	{
//STRIP001 		if( nPos == 0 )
//STRIP001 		{
//STRIP001 			return( NULL );
//STRIP001 		}
//STRIP001 		nPos--;
//STRIP001 	}
//STRIP001 
//STRIP001 	NavDocInfo* pInfo = (NavDocInfo*)pDocList->GetObject( nPos );
//STRIP001 
//STRIP001 	return( pInfo );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* PreParentNotify
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 long SdNavigatorWin::ParentNotify(NotifyEvent& rNEvt)
//STRIP001 {
//STRIP001 	const KeyEvent* pKEvt = rNEvt.GetKeyEvent();
//STRIP001 	long			nOK = FALSE;
//STRIP001 
//STRIP001 	if( pKEvt )
//STRIP001 	{
//STRIP001 		if( KEY_ESCAPE == pKEvt->GetKeyCode().GetCode() )
//STRIP001 		{
//STRIP001 			if( SdPageObjsTLB::IsInDrag() )
//STRIP001 			{
//STRIP001 				// during drag'n'drop we just stop the drag but do not close the navigator
//STRIP001 				nOK = TRUE;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SdViewShell* pViewShell = (SdViewShell*) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
//STRIP001 
//STRIP001 				if( pViewShell )
//STRIP001 				{
//STRIP001 					FuSlideShow* pFuSlideShow = pViewShell->GetSlideShow();
//STRIP001 
//STRIP001 					if( pFuSlideShow )
//STRIP001 					{
//STRIP001 						nOK = TRUE;
//STRIP001 						pFuSlideShow->Terminate();
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     if( !nOK )
//STRIP001 		nOK = Window::Notify( rNEvt );
//STRIP001 
//STRIP001 	return( nOK );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* KeyInput: ESCAPE abfangen, um Show zu beenden
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 void SdNavigatorWin::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	long nOK = FALSE;
//STRIP001 
//STRIP001 	if (rKEvt.GetKeyCode().GetCode() == KEY_ESCAPE)
//STRIP001 	{
//STRIP001 		if( SdPageObjsTLB::IsInDrag() )
//STRIP001 		{
//STRIP001 			// during drag'n'drop we just stop the drag but do not close the navigator
//STRIP001 			nOK = TRUE;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			SdViewShell* pViewShell = (SdViewShell*) pBindings->GetDispatcher()->GetFrame()->GetViewShell();
//STRIP001 
//STRIP001 			if (pViewShell)
//STRIP001 			{
//STRIP001 				FuSlideShow* pFuSlideShow = pViewShell->GetSlideShow();
//STRIP001 
//STRIP001 				if (pFuSlideShow && !pFuSlideShow->IsLivePresentation())
//STRIP001 				{
//STRIP001 					// Im Native-Mode soll ESC die Prsentation beenden
//STRIP001 					nOK = TRUE;
//STRIP001 					pFuSlideShow->Terminate();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!nOK)
//STRIP001 	{
//STRIP001 		Window::KeyInput(rKEvt);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void SdNavigatorWin::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImageList();
//STRIP001 
//STRIP001     Window::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 void SdNavigatorWin::SetDragImage()
//STRIP001 {
//STRIP001 	aToolbox.SetItemImage( TBI_DRAGTYPE, aToolbox.GetImageList().GetImage( GetDragTypeSdResId( eDragType, TRUE ) ) );
//STRIP001 }
//STRIP001 
//STRIP001 void SdNavigatorWin::ApplyImageList()
//STRIP001 {
//STRIP001 	const bool bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001 
//STRIP001 	aToolbox.SetImageList( bHighContrast ? maImageListH : maImageList );
//STRIP001 
//STRIP001 	SetDragImage();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* Ableitung vom SfxChildWindowContext als "Behaelter" fuer Animator
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
SdNavigatorChildWindow::SdNavigatorChildWindow( Window* pParent,
														 USHORT nId,
														 SfxBindings* pBindings,
														 SfxChildWinInfo* pInfo ) :
	SfxChildWindowContext( nId )
{
DBG_BF_ASSERT(0, "STRIP");//STRIP001 	SdNavigatorWin* pNavWin = new SdNavigatorWin( pParent, this,
//STRIP001 										SdResId( FLT_NAVIGATOR ), pBindings );
//STRIP001 
//STRIP001 	SetWindow( pNavWin );
//STRIP001 	//pWindow = pNavWin;
//STRIP001 
//STRIP001 	//eChildAlignment = SFX_ALIGN_NOALIGNMENT;
//STRIP001 	//pNavWin->Initialize( pInfo );
}
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ControllerItem fuer Navigator
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdNavigatorControllerItem::SdNavigatorControllerItem( USHORT nId,
//STRIP001 								SdNavigatorWin* pNavWin,
//STRIP001 								SfxBindings*	pBindings) :
//STRIP001 	SfxControllerItem( nId, *pBindings ),
//STRIP001 	pNavigatorWin( pNavWin )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdNavigatorControllerItem::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( eState >= SFX_ITEM_AVAILABLE && nSId == SID_NAVIGATOR_STATE )
//STRIP001 	{
//STRIP001 		const SfxUInt32Item* pStateItem = PTR_CAST( SfxUInt32Item, pItem );
//STRIP001 		DBG_ASSERT( pStateItem, "SfxUInt16Item erwartet");
//STRIP001 		UINT32 nState = pStateItem->GetValue();
//STRIP001 
//STRIP001 		// Live
//STRIP001 		if( nState & NAVBTN_LIVE_ENABLED &&
//STRIP001 			!pNavigatorWin->aToolbox.IsItemEnabled( TBI_LIVE ) )
//STRIP001 			pNavigatorWin->aToolbox.EnableItem( TBI_LIVE );
//STRIP001 		if( nState & NAVBTN_LIVE_DISABLED &&
//STRIP001 			pNavigatorWin->aToolbox.IsItemEnabled( TBI_LIVE ) )
//STRIP001 			pNavigatorWin->aToolbox.EnableItem( TBI_LIVE, FALSE );
//STRIP001 		if( nState & NAVBTN_LIVE_CHECKED &&
//STRIP001 			!pNavigatorWin->aToolbox.IsItemChecked( TBI_LIVE ) )
//STRIP001 			pNavigatorWin->aToolbox.CheckItem( TBI_LIVE );
//STRIP001 		if( nState & NAVBTN_LIVE_UNCHECKED &&
//STRIP001 			pNavigatorWin->aToolbox.IsItemChecked( TBI_LIVE ) )
//STRIP001 			pNavigatorWin->aToolbox.CheckItem( TBI_LIVE, FALSE );
//STRIP001 
//STRIP001 		// Stift
//STRIP001 		if( nState & NAVBTN_PEN_ENABLED &&
//STRIP001 			!pNavigatorWin->aToolbox.IsItemEnabled( TBI_PEN ) )
//STRIP001 			pNavigatorWin->aToolbox.EnableItem( TBI_PEN );
//STRIP001 		if( nState & NAVBTN_PEN_DISABLED &&
//STRIP001 			pNavigatorWin->aToolbox.IsItemEnabled( TBI_PEN ) )
//STRIP001 			pNavigatorWin->aToolbox.EnableItem( TBI_PEN, FALSE );
//STRIP001 		if( nState & NAVBTN_PEN_CHECKED &&
//STRIP001 			!pNavigatorWin->aToolbox.IsItemChecked( TBI_PEN ) )
//STRIP001 			pNavigatorWin->aToolbox.CheckItem( TBI_PEN );
//STRIP001 		if( nState & NAVBTN_PEN_UNCHECKED &&
//STRIP001 			pNavigatorWin->aToolbox.IsItemChecked( TBI_PEN ) )
//STRIP001 			pNavigatorWin->aToolbox.CheckItem( TBI_PEN, FALSE );
//STRIP001 
//STRIP001 		// Nur wenn Doc in LB das Aktive ist
//STRIP001 		NavDocInfo* pInfo = pNavigatorWin->GetDocInfo();
//STRIP001 		if( pInfo && pInfo->IsActive() )
//STRIP001 		{
//STRIP001 			// First
//STRIP001 			if( nState & NAVBTN_FIRST_ENABLED &&
//STRIP001 				!pNavigatorWin->aToolbox.IsItemEnabled( TBI_FIRST ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_FIRST );
//STRIP001 			if( nState & NAVBTN_FIRST_DISABLED &&
//STRIP001 				pNavigatorWin->aToolbox.IsItemEnabled( TBI_FIRST ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_FIRST, FALSE );
//STRIP001 
//STRIP001 			// Prev
//STRIP001 			if( nState & NAVBTN_PREV_ENABLED &&
//STRIP001 				!pNavigatorWin->aToolbox.IsItemEnabled( TBI_PREVIOUS ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_PREVIOUS );
//STRIP001 			if( nState & NAVBTN_PREV_DISABLED &&
//STRIP001 				pNavigatorWin->aToolbox.IsItemEnabled( TBI_PREVIOUS ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_PREVIOUS, FALSE );
//STRIP001 
//STRIP001 			// Last
//STRIP001 			if( nState & NAVBTN_LAST_ENABLED &&
//STRIP001 				!pNavigatorWin->aToolbox.IsItemEnabled( TBI_LAST ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_LAST );
//STRIP001 			if( nState & NAVBTN_LAST_DISABLED &&
//STRIP001 				pNavigatorWin->aToolbox.IsItemEnabled( TBI_LAST ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_LAST, FALSE );
//STRIP001 
//STRIP001 			// Next
//STRIP001 			if( nState & NAVBTN_NEXT_ENABLED &&
//STRIP001 				!pNavigatorWin->aToolbox.IsItemEnabled( TBI_NEXT ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_NEXT );
//STRIP001 			if( nState & NAVBTN_NEXT_DISABLED &&
//STRIP001 				pNavigatorWin->aToolbox.IsItemEnabled( TBI_NEXT ) )
//STRIP001 				pNavigatorWin->aToolbox.EnableItem( TBI_NEXT, FALSE );
//STRIP001 
//STRIP001 			if( nState & NAVTLB_UPDATE )
//STRIP001 			{
//STRIP001 				// InitTlb; Wird ueber Slot initiiert
//STRIP001 				SfxBoolItem aItem( SID_NAVIGATOR_INIT, TRUE );
//STRIP001 				GetBindings().GetDispatcher()->Execute(
//STRIP001 					SID_NAVIGATOR_INIT, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 |*
//STRIP001 |* ControllerItem fuer Navigator, um die Seite in der TreeLB anzuzeigen
//STRIP001 |*
//STRIP001 \************************************************************************/
//STRIP001 
//STRIP001 SdPageNameControllerItem::SdPageNameControllerItem( USHORT nId,
//STRIP001 								SdNavigatorWin* pNavWin,
//STRIP001 								SfxBindings*	pBindings) :
//STRIP001 	SfxControllerItem( nId, *pBindings ),
//STRIP001 	pNavigatorWin( pNavWin )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SdPageNameControllerItem::StateChanged( USHORT nSId,
//STRIP001 						SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( eState >= SFX_ITEM_AVAILABLE && nSId == SID_NAVIGATOR_PAGENAME )
//STRIP001 	{
//STRIP001 		// Nur wenn Doc in LB das Aktive ist
//STRIP001 		NavDocInfo* pInfo = pNavigatorWin->GetDocInfo();
//STRIP001 		if( pInfo && pInfo->IsActive() )
//STRIP001 		{
//STRIP001 			const SfxStringItem* pStateItem = PTR_CAST( SfxStringItem, pItem );
//STRIP001 			DBG_ASSERT( pStateItem, "SfxStringItem erwartet");
//STRIP001 			String aPageName = pStateItem->GetValue();
//STRIP001 
//STRIP001 			if( !pNavigatorWin->aTlbObjects.HasSelectedChilds( aPageName ) )
//STRIP001 			{
//STRIP001 				if( pNavigatorWin->aTlbObjects.GetSelectionMode() == MULTIPLE_SELECTION )
//STRIP001 				{
//STRIP001 					// Weil sonst immer dazuselektiert wird
//STRIP001 					pNavigatorWin->aTlbObjects.SelectAll( FALSE );
//STRIP001 				}
//STRIP001 				pNavigatorWin->aTlbObjects.SelectEntry( aPageName );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }



}
