/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sch_AccessibleUniqueId.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 22:09:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "AccessibleUniqueId.hxx"

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif
namespace binfilter {

using ::rtl::OUString;
using ::rtl::OUStringBuffer;

namespace accessibility
{

AccessibleUniqueId::AccessibleUniqueId() :
        m_nId( 0 )
{}

AccessibleUniqueId::AccessibleUniqueId(
    sal_uInt16 nObjectId,
    sal_uInt16 nIndex1,      // default: 0
    sal_uInt16 nIndex2 ) :   // default: 0
        m_nId( static_cast< IdType >( nObjectId ) |
               ( static_cast< IdType >( nIndex1 ) << 16 ) |
               ( static_cast< IdType >( nIndex2 ) << 32 ) )
{}

bool AccessibleUniqueId::operator == ( const AccessibleUniqueId & rComp ) const
{
    return ( this->m_nId == rComp.m_nId );
}

AccessibleUniqueId::IdType AccessibleUniqueId::GetId() const
{
    return m_nId;
}

sal_uInt16 AccessibleUniqueId::GetObjectId() const
{
    return static_cast< sal_uInt16 >( m_nId & 0xffff );
}

sal_uInt16 AccessibleUniqueId::GetIndex1() const
{
    return static_cast< sal_uInt16 >( ( m_nId >> 16 ) & 0xffff );
}

sal_uInt16 AccessibleUniqueId::GetIndex2() const
{
    return static_cast< sal_uInt16 >( ( m_nId >> 32 ) & 0xffff );
}

bool AccessibleUniqueId::IsValid() const
{
    return ( m_nId != 0 );
}

OUString AccessibleUniqueId::toString() const
{
    OUStringBuffer aBuf( OUString( RTL_CONSTASCII_USTRINGPARAM( "Id( " )));
    aBuf.append( static_cast< sal_Int32 >( GetObjectId() ));
    aBuf.append( sal_Unicode( ',' ));
    aBuf.append( sal_Unicode( ' ' ));
    aBuf.append( static_cast< sal_Int32 >( GetIndex1() ));
    aBuf.append( sal_Unicode( ',' ));
    aBuf.append( sal_Unicode( ' ' ));
    aBuf.append( static_cast< sal_Int32 >( GetIndex2() ));
    aBuf.append( sal_Unicode( ' ' ));
    aBuf.append( sal_Unicode( ')' ));

    return aBuf.makeStringAndClear();
}


}       // namespace accessibility
}
