/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_undobase.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:05:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// INCLUDE ---------------------------------------------------------------

// auto strip #include <vcl/virdev.hxx>

#include "undobase.hxx"
// auto strip #include "refundo.hxx"
#include "docsh.hxx"
// auto strip #include "tabvwsh.hxx"
#include "undoolk.hxx"
#include "undodraw.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//STRIP001 TYPEINIT1(ScSimpleUndo,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScBlockUndo,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScMoveUndo,		SfxUndoAction);
//STRIP001 TYPEINIT1(ScUndoWrapper,    SfxUndoAction);

// -----------------------------------------------------------------------

/*N*/ ScSimpleUndo::ScSimpleUndo( ScDocShell* pDocSh ) :
/*N*/ 	pDocShell( pDocSh ),
/*N*/ 	pDetectiveUndo( NULL )
/*N*/ {
/*N*/ }

/*N*/ __EXPORT ScSimpleUndo::~ScSimpleUndo()
/*N*/ {
/*N*/ 	delete pDetectiveUndo;
/*N*/ }

/*N*/ BOOL __EXPORT ScSimpleUndo::Merge( SfxUndoAction *pNextAction )
/*N*/ {
/*N*/ 	//	Zu jeder Undo-Action kann eine SdrUndoGroup fuer das Aktualisieren
/*N*/ 	//	der Detektiv-Pfeile gehoeren.
/*N*/ 	//	DetectiveRefresh kommt immer hinterher, die SdrUndoGroup ist in
/*N*/ 	//	eine ScUndoDraw Action verpackt.
/*N*/ 	//	Nur beim automatischen Aktualisieren wird AddUndoAction mit
/*N*/ 	//	bTryMerg=TRUE gerufen.
/*N*/ 
/*N*/ 	if ( !pDetectiveUndo && pNextAction->ISA(ScUndoDraw) )
/*N*/ 	{
/*N*/ 		//	SdrUndoAction aus der ScUndoDraw Action uebernehmen,
/*N*/ 		//	ScUndoDraw wird dann vom UndoManager geloescht
/*N*/ 
/*N*/ 		ScUndoDraw* pCalcUndo = (ScUndoDraw*)pNextAction;
/*N*/ 		pDetectiveUndo = pCalcUndo->GetDrawUndo();
/*N*/ 		pCalcUndo->ForgetDrawUndo();
/*N*/ 		return TRUE;
/*N*/ 	}
/*N*/ 
/*N*/ 	return FALSE;
/*N*/ }

//STRIP001 void ScSimpleUndo::BeginUndo()
//STRIP001 {
//STRIP001 	pDocShell->SetInUndo( TRUE );
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->HideAllCursors();		// z.B. wegen zusammengefassten Zellen
//STRIP001 
//STRIP001 	//	detective updates happened last, must be undone first
//STRIP001 	if (pDetectiveUndo)
//STRIP001 		pDetectiveUndo->Undo();
//STRIP001 }

//STRIP001 void ScSimpleUndo::EndUndo()
//STRIP001 {
//STRIP001 	pDocShell->SetDocumentModified();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->UpdateAutoFillMark();
//STRIP001 		pViewShell->UpdateInputHandler();
//STRIP001 		pViewShell->ShowAllCursors();
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( FALSE );
//STRIP001 }

//STRIP001 void ScSimpleUndo::BeginRedo()
//STRIP001 {
//STRIP001 	pDocShell->SetInUndo( TRUE );	//! eigenes Flag fuer Redo?
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->HideAllCursors();		// z.B. wegen zusammengefassten Zellen
//STRIP001 }

//STRIP001 void ScSimpleUndo::EndRedo()
//STRIP001 {
//STRIP001 	if (pDetectiveUndo)
//STRIP001 		pDetectiveUndo->Redo();
//STRIP001 
//STRIP001 	pDocShell->SetDocumentModified();
//STRIP001 
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		pViewShell->UpdateAutoFillMark();
//STRIP001 		pViewShell->UpdateInputHandler();
//STRIP001 		pViewShell->ShowAllCursors();
//STRIP001 	}
//STRIP001 
//STRIP001 	pDocShell->SetInUndo( FALSE );
//STRIP001 }

//STRIP001 void ScSimpleUndo::ShowTable( USHORT nTab )			// static
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 		pViewShell->SetTabNo( nTab );
//STRIP001 }

//STRIP001 void ScSimpleUndo::ShowTable( const ScRange& rRange )			// static
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		USHORT nStart = rRange.aStart.Tab();
//STRIP001 		USHORT nEnd   = rRange.aEnd.Tab();
//STRIP001 		USHORT nTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		if ( nTab < nStart || nTab > nEnd )						// wenn nicht im Bereich:
//STRIP001 			pViewShell->SetTabNo( nStart );						// auf erste des Bereiches
//STRIP001 	}
//STRIP001 }


// -----------------------------------------------------------------------

/*N*/ ScBlockUndo::ScBlockUndo( ScDocShell* pDocSh, const ScRange& rRange,
/*N*/ 											ScBlockUndoMode eBlockMode ) :
/*N*/ 	ScSimpleUndo( pDocSh ),
/*N*/ 	aBlockRange( rRange ),
/*N*/ 	eMode( eBlockMode )
/*N*/ {
/*N*/ 	pDrawUndo = GetSdrUndoAction( pDocShell->GetDocument() );
/*N*/ }

/*N*/ __EXPORT ScBlockUndo::~ScBlockUndo()
/*N*/ {
/*N*/ 	DeleteSdrUndoAction( pDrawUndo );
/*N*/ }

//STRIP001 void ScBlockUndo::BeginUndo()
//STRIP001 {
//STRIP001 	ScSimpleUndo::BeginUndo();
//STRIP001 	EnableDrawAdjust( pDocShell->GetDocument(), FALSE );
//STRIP001 }

//STRIP001 void ScBlockUndo::EndUndo()
//STRIP001 {
//STRIP001 	if (eMode == SC_UNDO_AUTOHEIGHT)
//STRIP001 		AdjustHeight();
//STRIP001 
//STRIP001 	EnableDrawAdjust( pDocShell->GetDocument(), TRUE );
//STRIP001 	if (pDrawUndo)
//STRIP001 		DoSdrUndoAction( pDrawUndo );
//STRIP001 
//STRIP001 	ShowBlock();
//STRIP001 	ScSimpleUndo::EndUndo();
//STRIP001 }

/*
void ScBlockUndo::BeginRedo()
{
	ScSimpleUndo::BeginRedo();
}
*/

//STRIP001 void ScBlockUndo::EndRedo()
//STRIP001 {
//STRIP001 	if (eMode == SC_UNDO_AUTOHEIGHT)
//STRIP001 		AdjustHeight();
//STRIP001 
//STRIP001 	ShowBlock();
//STRIP001 	ScSimpleUndo::EndRedo();
//STRIP001 }

//STRIP001 BOOL ScBlockUndo::AdjustHeight()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 
//STRIP001 	VirtualDevice aVirtDev;
//STRIP001 	Fraction aZoomX( 1, 1 );
//STRIP001 	Fraction aZoomY = aZoomX;
//STRIP001 	double nPPTX, nPPTY;
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		ScViewData* pData = pViewShell->GetViewData();
//STRIP001 		nPPTX = pData->GetPPTX();
//STRIP001 		nPPTY = pData->GetPPTY();
//STRIP001 		aZoomX = pData->GetZoomX();
//STRIP001 		aZoomY = pData->GetZoomY();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	Zoom auf 100 lassen
//STRIP001 		nPPTX = ScGlobal::nScreenPPTX;
//STRIP001 		nPPTY = ScGlobal::nScreenPPTY;
//STRIP001 	}
//STRIP001 
//STRIP001 	BOOL bRet = pDoc->SetOptimalHeight( aBlockRange.aStart.Row(), aBlockRange.aEnd.Row(),
//STRIP001 /*!*/									aBlockRange.aStart.Tab(), 0, &aVirtDev,
//STRIP001 										nPPTX, nPPTY, aZoomX, aZoomY, FALSE );
//STRIP001 
//STRIP001 	if (bRet)
//STRIP001 		pDocShell->PostPaint( 0,      aBlockRange.aStart.Row(), aBlockRange.aStart.Tab(),
//STRIP001 							  MAXCOL, MAXROW,                   aBlockRange.aEnd.Tab(),
//STRIP001 							  PAINT_GRID | PAINT_LEFT );
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 void ScBlockUndo::ShowBlock()
//STRIP001 {
//STRIP001 	ScTabViewShell* pViewShell = ScTabViewShell::GetActiveViewShell();
//STRIP001 	if (pViewShell)
//STRIP001 	{
//STRIP001 		ShowTable( aBlockRange );		// bei mehreren Tabs im Range ist jede davon gut
//STRIP001 		pViewShell->MoveCursorAbs( aBlockRange.aStart.Col(), aBlockRange.aStart.Row(),
//STRIP001 								   SC_FOLLOW_JUMP, FALSE, FALSE );
//STRIP001 		USHORT nTab = pViewShell->GetViewData()->GetTabNo();
//STRIP001 		ScRange aRange = aBlockRange;
//STRIP001 		aRange.aStart.SetTab( nTab );
//STRIP001 		aRange.aEnd.SetTab( nTab );
//STRIP001 		pViewShell->MarkRange( aRange );
//STRIP001 
//STRIP001 		//	nicht per SetMarkArea an MarkData, wegen evtl. fehlendem Paint
//STRIP001 	}
//STRIP001 }


// -----------------------------------------------------------------------

//STRIP001 ScMoveUndo::ScMoveUndo( ScDocShell* pDocSh, ScDocument* pRefDoc, ScRefUndoData* pRefData,
//STRIP001 												ScMoveUndoMode eRefMode ) :
//STRIP001 	ScSimpleUndo( pDocSh ),
//STRIP001 	pRefUndoDoc( pRefDoc ),
//STRIP001 	pRefUndoData( pRefData ),
//STRIP001 	eMode( eRefMode )
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	if (pRefUndoData)
//STRIP001 		pRefUndoData->DeleteUnchanged(pDoc);
//STRIP001 	pDrawUndo = GetSdrUndoAction( pDoc );
//STRIP001 }

//STRIP001 __EXPORT ScMoveUndo::~ScMoveUndo()
//STRIP001 {
//STRIP001 	delete pRefUndoData;
//STRIP001 	delete pRefUndoDoc;
//STRIP001 	DeleteSdrUndoAction( pDrawUndo );
//STRIP001 }

//STRIP001 void ScMoveUndo::UndoRef()
//STRIP001 {
//STRIP001 	ScDocument* pDoc = pDocShell->GetDocument();
//STRIP001 	ScRange aRange(0,0,0, MAXCOL,MAXROW,pRefUndoDoc->GetTableCount()-1);
//STRIP001 	pRefUndoDoc->CopyToDocument( aRange, IDF_FORMULA, FALSE, pDoc, NULL, FALSE );
//STRIP001 	if (pRefUndoData)
//STRIP001 		pRefUndoData->DoUndo( pDoc, (eMode == SC_UNDO_REFFIRST) );
//STRIP001 		// #65055# HACK: ScDragDropUndo ist der einzige mit REFFIRST.
//STRIP001 		// Falls nicht, resultiert daraus evtl. ein zu haeufiges Anpassen
//STRIP001 		// der ChartRefs, nicht schoen, aber auch nicht schlecht..
//STRIP001 }

//STRIP001 void ScMoveUndo::BeginUndo()
//STRIP001 {
//STRIP001 	ScSimpleUndo::BeginUndo();
//STRIP001 
//STRIP001 	EnableDrawAdjust( pDocShell->GetDocument(), FALSE );
//STRIP001 
//STRIP001 	if (pRefUndoDoc && eMode == SC_UNDO_REFFIRST)
//STRIP001 		UndoRef();
//STRIP001 }

//STRIP001 void ScMoveUndo::EndUndo()
//STRIP001 {
//STRIP001 	if (pDrawUndo)					 //@17.12.97 Reihenfolge der Fkt.s geaendert
//STRIP001 		DoSdrUndoAction( pDrawUndo );
//STRIP001 
//STRIP001 	if (pRefUndoDoc && eMode == SC_UNDO_REFLAST)
//STRIP001 		UndoRef();
//STRIP001 
//STRIP001 	EnableDrawAdjust( pDocShell->GetDocument(), TRUE );
//STRIP001 
//STRIP001 	ScSimpleUndo::EndUndo();
//STRIP001 }

/*
void ScMoveUndo::BeginRedo()
{
	ScSimpleUndo::BeginRedo();
}
*/

/*
void ScMoveUndo::EndRedo()
{
	ScSimpleUndo::EndRedo();
}
*/

// -----------------------------------------------------------------------

//STRIP001 ScUndoWrapper::ScUndoWrapper( SfxUndoAction* pUndo ) :
//STRIP001     pWrappedUndo( pUndo )
//STRIP001 {
//STRIP001 }

//STRIP001 ScUndoWrapper::~ScUndoWrapper()
//STRIP001 {
//STRIP001     delete pWrappedUndo;
//STRIP001 }

//STRIP001 void ScUndoWrapper::ForgetWrappedUndo()
//STRIP001 {
//STRIP001     pWrappedUndo = NULL;    // don't delete in dtor - pointer must be stored outside
//STRIP001 }

//STRIP001 String ScUndoWrapper::GetComment() const
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         return pWrappedUndo->GetComment();
//STRIP001     else
//STRIP001         return String();
//STRIP001 }

//STRIP001 String ScUndoWrapper::GetRepeatComment(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         return pWrappedUndo->GetRepeatComment(rTarget);
//STRIP001     else
//STRIP001         return String();
//STRIP001 }

//STRIP001 USHORT ScUndoWrapper::GetId() const
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         return pWrappedUndo->GetId();
//STRIP001     else
//STRIP001         return 0;
//STRIP001 }

//STRIP001 BOOL ScUndoWrapper::IsLinked()
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         return pWrappedUndo->IsLinked();
//STRIP001     else
//STRIP001         return FALSE;
//STRIP001 }

//STRIP001 void ScUndoWrapper::SetLinked( BOOL bIsLinked )
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         pWrappedUndo->SetLinked(bIsLinked);
//STRIP001 }

//STRIP001 BOOL ScUndoWrapper::Merge( SfxUndoAction* pNextAction )
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         return pWrappedUndo->Merge(pNextAction);
//STRIP001     else
//STRIP001         return FALSE;
//STRIP001 }

//STRIP001 void ScUndoWrapper::Undo()
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         pWrappedUndo->Undo();
//STRIP001 }

//STRIP001 void ScUndoWrapper::Redo()
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         pWrappedUndo->Redo();
//STRIP001 }

//STRIP001 void ScUndoWrapper::Repeat(SfxRepeatTarget& rTarget)
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         pWrappedUndo->Repeat(rTarget);
//STRIP001 }

//STRIP001 BOOL ScUndoWrapper::CanRepeat(SfxRepeatTarget& rTarget) const
//STRIP001 {
//STRIP001     if (pWrappedUndo)
//STRIP001         return pWrappedUndo->CanRepeat(rTarget);
//STRIP001     else
//STRIP001         return FALSE;
//STRIP001 }


}
