/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_styledlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:03:31 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
#include "ui_pch.hxx"
#endif

#pragma hdrstop

//------------------------------------------------------------------

#include "scitems.hxx"
#include <bf_svx/align.hxx>
#include <bf_svx/backgrnd.hxx>
#include <bf_svx/border.hxx>
#include <bf_svx/chardlg.hxx>
#include <bf_svx/numfmt.hxx>
#include <bf_svx/page.hxx>
#include <bf_svx/paragrph.hxx>
#include <bf_sfx2/objsh.hxx>
#include <svtools/style.hxx>
#include <svtools/cjkoptions.hxx>

#include "styledlg.hxx"
#include "tabpages.hxx"		// Zellvorlagen
#include "tphf.hxx"			// Seitenvorlage: Kopf-/Fusszeilen
#include "tptable.hxx"		// Seitenvorlage: Tabelle
#include "scresid.hxx"
#include "bf_sc.hrc"
#include "styledlg.hrc"
namespace binfilter {

//==================================================================

ScStyleDlg::ScStyleDlg( Window*				pParent,
						SfxStyleSheetBase&	rStyleBase,
						USHORT				nRscId )

	:	SfxStyleDialog	( pParent,
						  ScResId( nRscId ),
						  rStyleBase,
						  FALSE ),
		nDlgRsc			( nRscId )
{
	switch ( nRscId )
	{
		case RID_SCDLG_STYLES_PAR:	// Zellformatvorlagen
			{
				SvtCJKOptions aCJKOptions;

				AddTabPage( TP_NUMBER, &SvxNumberFormatTabPage::Create, &SvxNumberFormatTabPage::GetRanges );
				AddTabPage( TP_FONT, &SvxCharNamePage::Create,		    &SvxCharNamePage::GetRanges );
				AddTabPage( TP_FONTEFF, &SvxCharEffectsPage::Create,		    &SvxCharEffectsPage::GetRanges );
				AddTabPage( TP_ALIGNMENT, &SvxAlignmentTabPage::Create,	&SvxAlignmentTabPage::GetRanges );
				if ( aCJKOptions.IsAsianTypographyEnabled() )
					AddTabPage( TP_ASIAN, &SvxAsianTabPage::Create,		&SvxAsianTabPage::GetRanges );
				else
					RemoveTabPage( TP_ASIAN );
				AddTabPage( TP_BORDER, &SvxBorderTabPage::Create,		&SvxBorderTabPage::GetRanges );
				AddTabPage( TP_BACKGROUND, &SvxBackgroundTabPage::Create,	&SvxBackgroundTabPage::GetRanges );
				AddTabPage( TP_PROTECTION, &ScTabPageProtection::Create,	&ScTabPageProtection::GetRanges );
			}
			break;

		case RID_SCDLG_STYLES_PAGE:	// Seitenvorlagen
			{
				AddTabPage( TP_PAGE_STD, &SvxPageDescPage::Create,	&SvxPageDescPage::GetRanges );
				AddTabPage( TP_BORDER, &SvxBorderTabPage::Create,	&SvxBorderTabPage::GetRanges );
				AddTabPage( TP_BACKGROUND, &SvxBackgroundTabPage::Create,	&SvxBackgroundTabPage::GetRanges );
				AddTabPage( TP_PAGE_HEADER, &ScHeaderPage::Create,	  	&ScHeaderPage::GetRanges );
				AddTabPage( TP_PAGE_FOOTER, &ScFooterPage::Create,	 	&ScFooterPage::GetRanges );
				AddTabPage( TP_TABLE, &ScTablePage::Create,		&ScTablePage::GetRanges );
			}
			break;

		default:
			DBG_ERROR( "Family not supported" );
	}

	//--------------------------------------------------------------------
	FreeResource();
}

// -----------------------------------------------------------------------

__EXPORT ScStyleDlg::~ScStyleDlg()
{
}

// -----------------------------------------------------------------------

void __EXPORT ScStyleDlg::PageCreated( USHORT nPageId, SfxTabPage& rTabPage )
{
	if ( nDlgRsc == RID_SCDLG_STYLES_PAR )
	{
		SfxObjectShell* pDocSh = SfxObjectShell::Current();

		switch ( nPageId )
		{
			case TP_NUMBER:
				{
					const SfxPoolItem* pInfoItem
						= pDocSh->GetItem( SID_ATTR_NUMBERFORMAT_INFO );

					DBG_ASSERT( pInfoItem, "NumberInfoItem nicht gefunden!" );

					((SvxNumberFormatTabPage&)rTabPage).
						SetNumberFormatList(
							(const SvxNumberInfoItem&)*pInfoItem ) ;
				}
				break;

			case TP_FONT:
				{
					const SfxPoolItem* pInfoItem
						= pDocSh->GetItem( SID_ATTR_CHAR_FONTLIST );

					DBG_ASSERT( pInfoItem, "FontListItem nicht gefunden!" );

					((SvxCharNamePage&)rTabPage).
						SetFontList(
							(const SvxFontListItem&)*pInfoItem );
				}
				break;

			default:
			break;
		}
	}
	else if ( nDlgRsc == RID_SCDLG_STYLES_PAGE )
	{
		switch ( nPageId )
		{
			case TP_PAGE_STD:
				((SvxPageDescPage&)rTabPage).SetMode( SVX_PAGE_MODE_CENTER );
				break;

			case TP_PAGE_HEADER:
			case TP_PAGE_FOOTER:
				((ScHFPage&)rTabPage).SetStyleDlg( this );
				((ScHFPage&)rTabPage).SetPageStyle( GetStyleSheet().GetName() );
				((ScHFPage&)rTabPage).DisableDeleteQueryBox();
				break;
			case TP_BACKGROUND:
					if( nDlgRsc == RID_SCDLG_STYLES_PAGE)
						((SvxBackgroundTabPage&)rTabPage).ShowSelector();
				break;

			default:
				break;
		}
	}
}


// -----------------------------------------------------------------------

const SfxItemSet* __EXPORT ScStyleDlg::GetRefreshedSet()
{
    SfxItemSet* pItemSet = GetInputSetImpl();
    pItemSet->ClearItem();
    pItemSet->SetParent( GetStyleSheet().GetItemSet().GetParent() );
    return pItemSet;
}



}
