/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sc_tpsort.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:03:41 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifdef PCH
// auto strip #include "ui_pch.hxx"
#endif

#pragma hdrstop

// auto strip #include <vcl/msgbox.hxx>
#include <tools/isolang.hxx>
// auto strip #include <svtools/collatorres.hxx>
// auto strip #include <unotools/collatorwrapper.hxx>
// auto strip #include <unotools/localedatawrapper.hxx>
// auto strip #include <comphelper/processfactory.hxx>

// auto strip #include "scitems.hxx"
// auto strip #include "uiitems.hxx"
// auto strip #include "viewdata.hxx"
// auto strip #include "document.hxx"
// auto strip #include "global.hxx"
// auto strip #include "dbcolect.hxx"
// auto strip #include "userlist.hxx"
// auto strip #include "rangeutl.hxx"
// auto strip #include "scresid.hxx"
#include "bf_sc.hrc"       // -> Slot IDs
#include "globstr.hrc"

// auto strip #include "sortdlg.hxx"
#include "sortdlg.hrc"

#define _TPSORT_CXX
// auto strip #include "tpsort.hxx"
#undef _TPSORT_CXX
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {
using namespace ::com::sun::star;

// STATIC DATA -----------------------------------------------------------

static USHORT pSortRanges[] =
{
	SID_SORT,
	SID_SORT,
	0
};

// -----------------------------------------------------------------------

/*
 * Da sich Einstellungen auf der zweiten TabPage (Optionen) auf
 * die erste TabPage auswirken, muss es die Moeglichkeit geben,
 * dies der jeweils anderen Seite mitzuteilen.
 *
 * Im Moment wird dieses Problem ueber zwei Datenmember des TabDialoges
 * geloest. Wird eine Seite Aktiviert/Deaktiviert, so gleicht sie diese
 * Datenmember mit dem eigenen Zustand ab (->Activate()/Deactivate()).
 *
 * 31.01.95:
 * Die Klasse SfxTabPage bietet mittlerweile ein Verfahren an:
 *
 * virtual BOOL HasExchangeSupport() const; -> return TRUE;
 * virtual void ActivatePage(const SfxItemSet &);
 * virtual int	DeactivatePage(SfxItemSet * = 0);
 *
 * muss noch geaendert werden!
 */

//========================================================================
//========================================================================
// Sortierkriterien-Tabpage:

//STRIP001 ScTabPageSortFields::ScTabPageSortFields( Window*			pParent,
//STRIP001 										  const SfxItemSet& rArgSet )
//STRIP001 
//STRIP001 	:	SfxTabPage		( pParent,
//STRIP001 						  ScResId( RID_SCPAGE_SORT_FIELDS ),
//STRIP001 						  rArgSet ),
//STRIP001 		//
//STRIP001         aFlSort1        ( this, ScResId( FL_SORT1  ) ),
//STRIP001 		aLbSort1		( this, ScResId( LB_SORT1  ) ),
//STRIP001         aBtnUp1         ( this, ScResId( BTN_UP1   ) ),
//STRIP001 		aBtnDown1		( this, ScResId( BTN_DOWN1 ) ),
//STRIP001 		//
//STRIP001         aFlSort2        ( this, ScResId( FL_SORT2  ) ),
//STRIP001 		aLbSort2		( this, ScResId( LB_SORT2  ) ),
//STRIP001         aBtnUp2         ( this, ScResId( BTN_UP2   ) ),
//STRIP001 		aBtnDown2		( this, ScResId( BTN_DOWN2 ) ),
//STRIP001 		//
//STRIP001         aFlSort3        ( this, ScResId( FL_SORT3  ) ),
//STRIP001 		aLbSort3		( this, ScResId( LB_SORT3  ) ),
//STRIP001         aBtnUp3         ( this, ScResId( BTN_UP3   ) ),
//STRIP001 		aBtnDown3		( this, ScResId( BTN_DOWN3 ) ),
//STRIP001 
//STRIP001 		aStrUndefined	( ScResId( SCSTR_UNDEFINED ) ),
//STRIP001 		aStrColumn		( ScResId( SCSTR_COLUMN ) ),
//STRIP001 		aStrRow 		( ScResId( SCSTR_ROW ) ),
//STRIP001 		//
//STRIP001 		pDlg			( (ScSortDlg*)(GetParent()->GetParent()) ),
//STRIP001 		nWhichSort		( rArgSet.GetPool()->GetWhich( SID_SORT ) ),
//STRIP001 		rSortData		( ((const ScSortItem&)
//STRIP001 						   rArgSet.Get( nWhichSort )).
//STRIP001 								GetSortData() ),
//STRIP001 		bHasHeader		( FALSE ),
//STRIP001 		bSortByRows 	( FALSE ),
//STRIP001 		nFieldCount 	( 0 ),
//STRIP001 		pViewData		( NULL )
//STRIP001 {
//STRIP001 	Init();
//STRIP001 	FreeResource();
//STRIP001 	SetExchangeSupport();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 __EXPORT ScTabPageSortFields::~ScTabPageSortFields()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ScTabPageSortFields::Init()
//STRIP001 {
//STRIP001 	const ScSortItem& rSortItem = (const ScSortItem&)
//STRIP001 								  GetItemSet().Get( nWhichSort );
//STRIP001 
//STRIP001 	pViewData = rSortItem.GetViewData();
//STRIP001 
//STRIP001 	DBG_ASSERT( pViewData, "ViewData not found!" );
//STRIP001 
//STRIP001 	nFieldArr[0] = nFirstCol = nFirstRow = 0;
//STRIP001 
//STRIP001 	aLbSort1.SetSelectHdl( LINK( this, ScTabPageSortFields, SelectHdl ) );
//STRIP001 	aLbSort2.SetSelectHdl( LINK( this, ScTabPageSortFields, SelectHdl ) );
//STRIP001 	aLbSort3.SetSelectHdl( LINK( this, ScTabPageSortFields, SelectHdl ) );
//STRIP001 	aLbSort1.Clear();
//STRIP001 	aLbSort2.Clear();
//STRIP001 	aLbSort3.Clear();
//STRIP001 
//STRIP001 	aSortLbArr[0]		= &aLbSort1;
//STRIP001 	aSortLbArr[1]		= &aLbSort2;
//STRIP001 	aSortLbArr[2]		= &aLbSort3;
//STRIP001 	aDirBtnArr[0][0]	= &aBtnUp1;
//STRIP001 	aDirBtnArr[0][1]	= &aBtnDown1;
//STRIP001 	aDirBtnArr[1][0]	= &aBtnUp2;
//STRIP001 	aDirBtnArr[1][1]	= &aBtnDown2;
//STRIP001 	aDirBtnArr[2][0]	= &aBtnUp3;
//STRIP001 	aDirBtnArr[2][1]	= &aBtnDown3;
//STRIP001     aFlArr[0]           = &aFlSort1;
//STRIP001     aFlArr[1]           = &aFlSort2;
//STRIP001     aFlArr[2]           = &aFlSort3;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT* __EXPORT ScTabPageSortFields::GetRanges()
//STRIP001 {
//STRIP001 	return pSortRanges;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* __EXPORT ScTabPageSortFields::Create( Window*	pParent,
//STRIP001 										 const SfxItemSet&	rArgSet )
//STRIP001 {
//STRIP001 	return ( new ScTabPageSortFields( pParent, rArgSet ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void __EXPORT ScTabPageSortFields::Reset( const SfxItemSet& rArgSet )
//STRIP001 {
//STRIP001 	bSortByRows = rSortData.bByRow;
//STRIP001 	bHasHeader	= rSortData.bHasHeader;
//STRIP001 
//STRIP001 	if ( aLbSort1.GetEntryCount() == 0 )
//STRIP001 		FillFieldLists();
//STRIP001 
//STRIP001 	// Selektieren der ListBoxen:
//STRIP001 
//STRIP001 	if ( rSortData.bDoSort[0] )
//STRIP001 	{
//STRIP001 		for ( USHORT i=0; i<3; i++ )
//STRIP001 		{
//STRIP001 			if ( rSortData.bDoSort[i] )
//STRIP001 			{
//STRIP001 				aSortLbArr[i]->SelectEntryPos(
//STRIP001 					 GetFieldSelPos( rSortData.nField[i] ) );
//STRIP001 
//STRIP001 				(rSortData.bAscending[i])
//STRIP001 					? aDirBtnArr[i][0]->Check() 	// Up
//STRIP001 					: aDirBtnArr[i][1]->Check();	// Down
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aSortLbArr[i]->SelectEntryPos( 0 ); // "keiner" selektieren
//STRIP001 				aDirBtnArr[i][0]->Check();			// Up
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		EnableField( 1 );
//STRIP001 		EnableField( 2 );
//STRIP001 		EnableField( 3 );
//STRIP001 		if ( aLbSort1.GetSelectEntryPos() == 0 )
//STRIP001 			DisableField( 2 );
//STRIP001 		if ( aLbSort2.GetSelectEntryPos() == 0 )
//STRIP001 			DisableField( 3 );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aLbSort1.SelectEntryPos( 1 );
//STRIP001 		aLbSort2.SelectEntryPos( 0 );
//STRIP001 		aLbSort3.SelectEntryPos( 0 );
//STRIP001 		aBtnUp1.Check();
//STRIP001 		aBtnUp2.Check();
//STRIP001 		aBtnUp3.Check();
//STRIP001 		EnableField ( 1 );
//STRIP001 		EnableField ( 2 );
//STRIP001 		DisableField( 3 );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDlg )
//STRIP001 	{
//STRIP001 		pDlg->SetByRows ( bSortByRows );
//STRIP001 		pDlg->SetHeaders( bHasHeader );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScTabPageSortFields::FillItemSet( SfxItemSet& rArgSet )
//STRIP001 {
//STRIP001 	ScSortParam theSortData = rSortData;
//STRIP001 	if (pDlg)
//STRIP001 	{
//STRIP001 		const SfxItemSet* pExample = pDlg->GetExampleSet();
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if ( pExample && pExample->GetItemState( nWhichSort, TRUE, &pItem ) == SFX_ITEM_SET )
//STRIP001 			theSortData = ((const ScSortItem*)pItem)->GetSortData();
//STRIP001 	}
//STRIP001 
//STRIP001 	USHORT	nSort1Pos = aLbSort1.GetSelectEntryPos();
//STRIP001 	USHORT	nSort2Pos = aLbSort2.GetSelectEntryPos();
//STRIP001 	USHORT	nSort3Pos = aLbSort3.GetSelectEntryPos();
//STRIP001 
//STRIP001 	DBG_ASSERT(    (nSort1Pos <= SC_MAXFIELDS)
//STRIP001 				&& (nSort2Pos <= SC_MAXFIELDS)
//STRIP001 				&& (nSort3Pos <= SC_MAXFIELDS),
//STRIP001 				"Array-Range Fehler!" );
//STRIP001 
//STRIP001 	if ( nSort1Pos == LISTBOX_ENTRY_NOTFOUND ) nSort1Pos = 0;
//STRIP001 	if ( nSort2Pos == LISTBOX_ENTRY_NOTFOUND ) nSort2Pos = 0;
//STRIP001 	if ( nSort3Pos == LISTBOX_ENTRY_NOTFOUND ) nSort3Pos = 0;
//STRIP001 
//STRIP001 	if ( nSort1Pos > 0 )
//STRIP001 	{
//STRIP001 		theSortData.bDoSort[0] = (nSort1Pos > 0);
//STRIP001 		theSortData.bDoSort[1] = (nSort2Pos > 0);
//STRIP001 		theSortData.bDoSort[2] = (nSort3Pos > 0);
//STRIP001 
//STRIP001 		// wenn auf Optionen-Seite "OK" gewaehlt wurde und
//STRIP001 		// dabei die Sortierrichtung umgestellt wurde, so
//STRIP001 		// wird das erste Feld der jeweiligen Richtung als
//STRIP001 		// Sortierkriterium gewaehlt (steht in nFieldArr[0]):
//STRIP001 		if ( bSortByRows != pDlg->GetByRows() )
//STRIP001 		{
//STRIP001 			theSortData.nField[0] =
//STRIP001 			theSortData.nField[1] =
//STRIP001 			theSortData.nField[2] = ( bSortByRows ? nFirstRow : nFirstCol );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			theSortData.nField[0] = nFieldArr[nSort1Pos];
//STRIP001 			theSortData.nField[1] = nFieldArr[nSort2Pos];
//STRIP001 			theSortData.nField[2] = nFieldArr[nSort3Pos];
//STRIP001 		}
//STRIP001 
//STRIP001 		theSortData.bAscending[0] = aBtnUp1.IsChecked();
//STRIP001 		theSortData.bAscending[1] = aBtnUp2.IsChecked();
//STRIP001 		theSortData.bAscending[2] = aBtnUp3.IsChecked();
//STRIP001 		//	bHasHeader ist in ScTabPageSortOptions::FillItemSet, wo es hingehoert
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		theSortData.bDoSort[0] =
//STRIP001 		theSortData.bDoSort[1] =
//STRIP001 		theSortData.bDoSort[2] = FALSE;
//STRIP001 	}
//STRIP001 
//STRIP001 	rArgSet.Put( ScSortItem( SCITEM_SORTDATA, NULL, &theSortData ) );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------

// fuer Datenaustausch ohne Dialog-Umweg: (! noch zu tun !)
// void ScTabPageSortFields::ActivatePage( const SfxItemSet& rSet )

//STRIP001 void __EXPORT ScTabPageSortFields::ActivatePage()
//STRIP001 {
//STRIP001 	if ( pDlg )
//STRIP001 	{
//STRIP001 		if (   bHasHeader  != pDlg->GetHeaders()
//STRIP001 			|| bSortByRows != pDlg->GetByRows()   )
//STRIP001 		{
//STRIP001 			USHORT	nCurSel1 = aLbSort1.GetSelectEntryPos();
//STRIP001 			USHORT	nCurSel2 = aLbSort2.GetSelectEntryPos();
//STRIP001 			USHORT	nCurSel3 = aLbSort3.GetSelectEntryPos();
//STRIP001 
//STRIP001 			bHasHeader	= pDlg->GetHeaders();
//STRIP001 			bSortByRows = pDlg->GetByRows();
//STRIP001 			FillFieldLists();
//STRIP001 			aLbSort1.SelectEntryPos( nCurSel1 );
//STRIP001 			aLbSort2.SelectEntryPos( nCurSel2 );
//STRIP001 			aLbSort3.SelectEntryPos( nCurSel3 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int __EXPORT ScTabPageSortFields::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	if ( pDlg )
//STRIP001 	{
//STRIP001 		if ( bHasHeader != pDlg->GetHeaders() )
//STRIP001 			pDlg->SetHeaders( bHasHeader );
//STRIP001 
//STRIP001 		if ( bSortByRows != pDlg->GetByRows() )
//STRIP001 			pDlg->SetByRows( bSortByRows );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSet )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return SfxTabPage::LEAVE_PAGE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ScTabPageSortFields::DisableField( USHORT nField )
//STRIP001 {
//STRIP001 	nField--;
//STRIP001 
//STRIP001 	if ( nField>=0 && nField<=2 )
//STRIP001 	{
//STRIP001 		aSortLbArr[nField]	 ->Disable();
//STRIP001 		aDirBtnArr[nField][0]->Disable();
//STRIP001 		aDirBtnArr[nField][1]->Disable();
//STRIP001         aFlArr[nField]       ->Disable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ScTabPageSortFields::EnableField( USHORT nField )
//STRIP001 {
//STRIP001 	nField--;
//STRIP001 
//STRIP001 	if ( nField>=0 && nField<=2 )
//STRIP001 	{
//STRIP001 		aSortLbArr[nField]	 ->Enable();
//STRIP001 		aDirBtnArr[nField][0]->Enable();
//STRIP001 		aDirBtnArr[nField][1]->Enable();
//STRIP001         aFlArr[nField]       ->Enable();
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ScTabPageSortFields::FillFieldLists()
//STRIP001 {
//STRIP001 	if ( pViewData )
//STRIP001 	{
//STRIP001 		ScDocument* pDoc = pViewData->GetDocument();
//STRIP001 
//STRIP001 		if ( pDoc )
//STRIP001 		{
//STRIP001 			aLbSort1.Clear();
//STRIP001 			aLbSort2.Clear();
//STRIP001 			aLbSort3.Clear();
//STRIP001 			aLbSort1.InsertEntry( aStrUndefined, 0 );
//STRIP001 			aLbSort2.InsertEntry( aStrUndefined, 0 );
//STRIP001 			aLbSort3.InsertEntry( aStrUndefined, 0 );
//STRIP001 
//STRIP001 			USHORT	nFirstCol	= rSortData.nCol1;
//STRIP001 			USHORT	nFirstRow	= rSortData.nRow1;
//STRIP001 			USHORT	nTab		= pViewData->GetTabNo();
//STRIP001 			USHORT	i			= 1;
//STRIP001 
//STRIP001 			if ( bSortByRows )
//STRIP001 			{
//STRIP001 				String	aFieldName;
//STRIP001 				USHORT	nMaxCol = rSortData.nCol2;
//STRIP001 				USHORT	col;
//STRIP001 
//STRIP001 				for ( col=nFirstCol; col<=nMaxCol && i<SC_MAXFIELDS; col++ )
//STRIP001 				{
//STRIP001 					pDoc->GetString( col, nFirstRow, nTab, aFieldName );
//STRIP001 					if ( !bHasHeader || (aFieldName.Len() == 0) )
//STRIP001 					{
//STRIP001 						aFieldName	= aStrColumn;
//STRIP001 						aFieldName += ' ';
//STRIP001 						aFieldName += ColToAlpha( col );
//STRIP001 					}
//STRIP001 					nFieldArr[i] = col;
//STRIP001 					aLbSort1.InsertEntry( aFieldName, i );
//STRIP001 					aLbSort2.InsertEntry( aFieldName, i );
//STRIP001 					aLbSort3.InsertEntry( aFieldName, i );
//STRIP001 					i++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				String	aFieldName;
//STRIP001 				USHORT	nMaxRow = rSortData.nRow2;
//STRIP001 				USHORT	row;
//STRIP001 
//STRIP001 				for ( row=nFirstRow; row<=nMaxRow && i<SC_MAXFIELDS; row++ )
//STRIP001 				{
//STRIP001 					pDoc->GetString( nFirstCol, row, nTab, aFieldName );
//STRIP001 					if ( !bHasHeader || (aFieldName.Len() == 0) )
//STRIP001 					{
//STRIP001 						aFieldName	= aStrRow;
//STRIP001 						aFieldName += ' ';
//STRIP001 						aFieldName += String::CreateFromInt32( row+1 );
//STRIP001 					}
//STRIP001 					nFieldArr[i] = row;
//STRIP001 					aLbSort1.InsertEntry( aFieldName, i );
//STRIP001 					aLbSort2.InsertEntry( aFieldName, i );
//STRIP001 					aLbSort3.InsertEntry( aFieldName, i );
//STRIP001 					i++;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			nFieldCount = i;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT ScTabPageSortFields::GetFieldSelPos( USHORT nField )
//STRIP001 {
//STRIP001 	USHORT	nFieldPos	= 0;
//STRIP001 	BOOL	bFound		= FALSE;
//STRIP001 
//STRIP001 	for ( USHORT n=1; n<nFieldCount && !bFound; n++ )
//STRIP001 	{
//STRIP001 		if ( nFieldArr[n] == nField )
//STRIP001 		{
//STRIP001 			nFieldPos = n;
//STRIP001 			bFound = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nFieldPos;
//STRIP001 }

// -----------------------------------------------------------------------
// Handler:
//---------

//STRIP001 IMPL_LINK( ScTabPageSortFields, SelectHdl, ListBox *, pLb )
//STRIP001 {
//STRIP001 	String aSelEntry = pLb->GetSelectEntry();
//STRIP001 
//STRIP001 	if ( pLb == &aLbSort1 )
//STRIP001 	{
//STRIP001 		if ( aSelEntry == aStrUndefined )
//STRIP001 		{
//STRIP001 			aLbSort2.SelectEntryPos( 0 );
//STRIP001 			aLbSort3.SelectEntryPos( 0 );
//STRIP001 
//STRIP001             if ( aFlSort2.IsEnabled() )
//STRIP001 				DisableField( 2 );
//STRIP001 
//STRIP001             if ( aFlSort3.IsEnabled() )
//STRIP001 				DisableField( 3 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             if ( !aFlSort2.IsEnabled() )
//STRIP001 				EnableField( 2 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pLb == &aLbSort2 )
//STRIP001 	{
//STRIP001 		if ( aSelEntry == aStrUndefined )
//STRIP001 		{
//STRIP001 			aLbSort3.SelectEntryPos( 0 );
//STRIP001             if ( aFlSort3.IsEnabled() )
//STRIP001 				DisableField( 3 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             if ( !aFlSort3.IsEnabled() )
//STRIP001 				EnableField( 3 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//========================================================================
// Sortieroptionen-Tabpage:
//========================================================================

//STRIP001 ScTabPageSortOptions::ScTabPageSortOptions( Window* 			pParent,
//STRIP001 											const SfxItemSet&	rArgSet )
//STRIP001 
//STRIP001 	:	SfxTabPage		( pParent,
//STRIP001 						  ScResId( RID_SCPAGE_SORT_OPTIONS ),
//STRIP001 						  rArgSet ),
//STRIP001 		//
//STRIP001 		aBtnCase		( this, ScResId( BTN_CASESENSITIVE ) ),
//STRIP001 		aBtnHeader		( this, ScResId( BTN_LABEL ) ),
//STRIP001 		aBtnFormats 	( this, ScResId( BTN_FORMATS ) ),
//STRIP001 		aBtnCopyResult	( this, ScResId( BTN_COPYRESULT ) ),
//STRIP001 		aLbOutPos		( this, ScResId( LB_OUTAREA ) ),
//STRIP001 		aEdOutPos		( this, ScResId( ED_OUTAREA ) ),
//STRIP001 		aBtnSortUser	( this, ScResId( BTN_SORT_USER ) ),
//STRIP001 		aLbSortUser 	( this, ScResId( LB_SORT_USER ) ),
//STRIP001         aFtLanguage     ( this, ScResId( FT_LANGUAGE ) ),
//STRIP001 		aLbLanguage		( this, ScResId( LB_LANGUAGE ) ),
//STRIP001         aFtAlgorithm    ( this, ScResId( FT_ALGORITHM ) ),
//STRIP001 		aLbAlgorithm	( this, ScResId( LB_ALGORITHM ) ),
//STRIP001 		aLineDirection	( this, ScResId( FL_DIRECTION ) ),
//STRIP001 		aBtnTopDown 	( this, ScResId( BTN_TOP_DOWN ) ),
//STRIP001 		aBtnLeftRight	( this, ScResId( BTN_LEFT_RIGHT ) ),
//STRIP001 		aFtAreaLabel	( this, ScResId( FT_AREA_LABEL ) ),
//STRIP001 //		aFtArea 		( this, ScResId( FT_AREA ) ),
//STRIP001 		//
//STRIP001 		aStrColLabel	( ScResId( STR_COL_LABEL ) ),
//STRIP001 		aStrRowLabel	( ScResId( STR_ROW_LABEL ) ),
//STRIP001 		aStrUndefined	( ScResId( SCSTR_UNDEFINED ) ),
//STRIP001 		aStrNoName		( ScGlobal::GetRscString(STR_DB_NONAME) ),
//STRIP001 		//
//STRIP001 		pDlg			( (ScSortDlg*)(GetParent()->GetParent()) ),
//STRIP001 		nWhichSort		( rArgSet.GetPool()->GetWhich( SID_SORT ) ),
//STRIP001 		rSortData		( ((const ScSortItem&)
//STRIP001 						  rArgSet.Get( nWhichSort )).GetSortData() ),
//STRIP001 		pViewData		( NULL ),
//STRIP001 		pDoc			( NULL ),
//STRIP001 		pColRes			( NULL ),
//STRIP001 		pColWrap		( NULL )
//STRIP001 {
//STRIP001 	Init();
//STRIP001 	FreeResource();
//STRIP001 	SetExchangeSupport();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 __EXPORT ScTabPageSortOptions::~ScTabPageSortOptions()
//STRIP001 {
//STRIP001 	USHORT nEntries = aLbOutPos.GetEntryCount();
//STRIP001 
//STRIP001 	for ( USHORT i=1; i<nEntries; i++ )
//STRIP001 		delete (String*)aLbOutPos.GetEntryData( i );
//STRIP001 
//STRIP001 	delete pColRes;
//STRIP001 	delete pColWrap;		//! not if from document
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ScTabPageSortOptions::Init()
//STRIP001 {
//STRIP001 	aStrAreaLabel = aFtAreaLabel.GetText();
//STRIP001 	aStrAreaLabel.Append( (sal_Unicode) ' ' );
//STRIP001 
//STRIP001 	//	CollatorRessource has user-visible names for sort algorithms
//STRIP001 	pColRes = new CollatorRessource();
//STRIP001 
//STRIP001 	//!	use CollatorWrapper from document?
//STRIP001 	pColWrap = new CollatorWrapper( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001 
//STRIP001 	const ScSortItem&	rSortItem = (const ScSortItem&)
//STRIP001 									GetItemSet().Get( nWhichSort );
//STRIP001 
//STRIP001 	aLbOutPos.SetSelectHdl	  ( LINK( this, ScTabPageSortOptions, SelOutPosHdl ) );
//STRIP001 	aBtnCopyResult.SetClickHdl( LINK( this, ScTabPageSortOptions, EnableHdl ) );
//STRIP001 	aBtnSortUser.SetClickHdl  ( LINK( this, ScTabPageSortOptions, EnableHdl ) );
//STRIP001 	aBtnTopDown.SetClickHdl	  ( LINK( this, ScTabPageSortOptions, SortDirHdl ) );
//STRIP001 	aBtnLeftRight.SetClickHdl ( LINK( this, ScTabPageSortOptions, SortDirHdl ) );
//STRIP001 	aLbLanguage.SetSelectHdl  ( LINK( this, ScTabPageSortOptions, FillAlgorHdl ) );
//STRIP001 
//STRIP001 	pViewData = rSortItem.GetViewData();
//STRIP001 	pDoc	  = pViewData ? pViewData->GetDocument() : NULL;
//STRIP001 
//STRIP001 	DBG_ASSERT( pViewData, "ViewData not found! :-/" );
//STRIP001 
//STRIP001 	if ( pViewData && pDoc )
//STRIP001 	{
//STRIP001 		String			theArea;
//STRIP001 		ScDBCollection* pDBColl 	= pDoc->GetDBCollection();
//STRIP001 		String			theDbArea;
//STRIP001 		String			theDbName	= aStrNoName;
//STRIP001 		const USHORT	nCurTab		= pViewData->GetTabNo();
//STRIP001 
//STRIP001 		aLbOutPos.Clear();
//STRIP001 		aLbOutPos.InsertEntry( aStrUndefined, 0 );
//STRIP001 		aLbOutPos.Disable();
//STRIP001 
//STRIP001 		ScAreaNameIterator aIter( pDoc );
//STRIP001 		String aName;
//STRIP001 		ScRange aRange;
//STRIP001 		String aRefStr;
//STRIP001 		while ( aIter.Next( aName, aRange ) )
//STRIP001 		{
//STRIP001 			USHORT nInsert = aLbOutPos.InsertEntry( aName );
//STRIP001 
//STRIP001 			aRange.aStart.Format( aRefStr, SCA_ABS_3D, pDoc );
//STRIP001 			aLbOutPos.SetEntryData( nInsert, new String( aRefStr ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		aLbOutPos.SelectEntryPos( 0 );
//STRIP001 		aEdOutPos.SetText( EMPTY_STRING );
//STRIP001 
//STRIP001 		/*
//STRIP001 		 * Ueberpruefen, ob es sich bei dem uebergebenen
//STRIP001 		 * Bereich um einen Datenbankbereich handelt:
//STRIP001 		 */
//STRIP001 
//STRIP001 		ScAddress aScAddress( rSortData.nCol1, rSortData.nRow1, nCurTab );
//STRIP001 		ScRange( aScAddress,
//STRIP001 				 ScAddress( rSortData.nCol2, rSortData.nRow2, nCurTab )
//STRIP001 			   ).Format( theArea, SCR_ABS, pDoc );
//STRIP001 
//STRIP001 		if ( pDBColl )
//STRIP001 		{
//STRIP001 			ScDBData* pDBData
//STRIP001 					= pDBColl->GetDBAtArea( nCurTab,
//STRIP001 											rSortData.nCol1, rSortData.nRow1,
//STRIP001 											rSortData.nCol2, rSortData.nRow2 );
//STRIP001 			if ( pDBData )
//STRIP001 			{
//STRIP001 				pDBData->GetName( theDbName );
//STRIP001 				aBtnHeader.Check( pDBData->HasHeader() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		theArea.AppendAscii(RTL_CONSTASCII_STRINGPARAM(" ("));
//STRIP001 		theArea += theDbName;
//STRIP001 		theArea += ')';
//STRIP001 
//STRIP001 		//aFtArea.SetText( theArea );
//STRIP001 		theArea.Insert( aStrAreaLabel, 0 );
//STRIP001 		aFtAreaLabel.SetText( theArea );
//STRIP001 
//STRIP001 		aBtnHeader.SetText( aStrColLabel );
//STRIP001 	}
//STRIP001 
//STRIP001 	FillUserSortListBox();
//STRIP001 
//STRIP001 	//	get available languages
//STRIP001 
//STRIP001     aLbLanguage.SetLanguageList( LANG_LIST_ALL | LANG_LIST_ONLY_KNOWN, FALSE );
//STRIP001 	aLbLanguage.InsertLanguage( LANGUAGE_SYSTEM );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT* __EXPORT ScTabPageSortOptions::GetRanges()
//STRIP001 {
//STRIP001 	return pSortRanges;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* __EXPORT ScTabPageSortOptions::Create(
//STRIP001 											Window*				pParent,
//STRIP001 											const SfxItemSet&	rArgSet )
//STRIP001 {
//STRIP001 	return ( new ScTabPageSortOptions( pParent, rArgSet ) );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void __EXPORT ScTabPageSortOptions::Reset( const SfxItemSet& rArgSet )
//STRIP001 {
//STRIP001 	if ( rSortData.bUserDef )
//STRIP001 	{
//STRIP001 		aBtnSortUser.Check( TRUE );
//STRIP001 		aLbSortUser.Enable();
//STRIP001 		aLbSortUser.SelectEntryPos( rSortData.nUserIndex );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnSortUser.Check( FALSE );
//STRIP001 		aLbSortUser.Disable();
//STRIP001 		aLbSortUser.SelectEntryPos( 0 );
//STRIP001 	}
//STRIP001 
//STRIP001 	aBtnCase.Check		( rSortData.bCaseSens );
//STRIP001 	aBtnFormats.Check	( rSortData.bIncludePattern );
//STRIP001 	aBtnHeader.Check	( rSortData.bHasHeader );
//STRIP001 
//STRIP001 	if ( rSortData.bByRow )
//STRIP001 	{
//STRIP001 		aBtnTopDown.Check();
//STRIP001 		aBtnHeader.SetText( aStrColLabel );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnLeftRight.Check();
//STRIP001 		aBtnHeader.SetText( aStrRowLabel );
//STRIP001 	}
//STRIP001 
//STRIP001 	LanguageType eLang = ConvertIsoNamesToLanguage(
//STRIP001 									rSortData.aCollatorLocale.Language,
//STRIP001 									rSortData.aCollatorLocale.Country );
//STRIP001 	if ( eLang == LANGUAGE_DONTKNOW )
//STRIP001 		eLang = LANGUAGE_SYSTEM;
//STRIP001 	aLbLanguage.SelectLanguage( eLang );
//STRIP001 	FillAlgorHdl( &aLbLanguage );				// get algorithms, select default
//STRIP001 	if ( rSortData.aCollatorAlgorithm.Len() )
//STRIP001 		aLbAlgorithm.SelectEntry( pColRes->GetTranslation( rSortData.aCollatorAlgorithm ) );
//STRIP001 
//STRIP001 	if ( pDoc && !rSortData.bInplace )
//STRIP001 	{
//STRIP001 		String aStr;
//STRIP001 		USHORT nFormat = (rSortData.nDestTab != pViewData->GetTabNo())
//STRIP001 							? SCR_ABS_3D
//STRIP001 							: SCR_ABS;
//STRIP001 
//STRIP001 		theOutPos.Set( rSortData.nDestCol,
//STRIP001 					   rSortData.nDestRow,
//STRIP001 					   rSortData.nDestTab );
//STRIP001 
//STRIP001 		theOutPos.Format( aStr, nFormat, pDoc );
//STRIP001 		aBtnCopyResult.Check();
//STRIP001 		aLbOutPos.Enable();
//STRIP001 		aEdOutPos.Enable();
//STRIP001 		aEdOutPos.SetText( aStr );
//STRIP001 		EdOutPosModHdl( &aEdOutPos );
//STRIP001 		aEdOutPos.GrabFocus();
//STRIP001 		aEdOutPos.SetSelection( Selection( 0, SELECTION_MAX ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aBtnCopyResult.Check( FALSE );
//STRIP001 		aLbOutPos.Disable();
//STRIP001 		aEdOutPos.Disable();
//STRIP001 		aEdOutPos.SetText( EMPTY_STRING );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL __EXPORT ScTabPageSortOptions::FillItemSet( SfxItemSet& rArgSet )
//STRIP001 {
//STRIP001 	ScSortParam theSortData = rSortData;
//STRIP001 	if (pDlg)
//STRIP001 	{
//STRIP001 		const SfxItemSet* pExample = pDlg->GetExampleSet();
//STRIP001 		const SfxPoolItem* pItem;
//STRIP001 		if ( pExample && pExample->GetItemState( nWhichSort, TRUE, &pItem ) == SFX_ITEM_SET )
//STRIP001 			theSortData = ((const ScSortItem*)pItem)->GetSortData();
//STRIP001 	}
//STRIP001 
//STRIP001 	theSortData.bByRow			= aBtnTopDown.IsChecked();
//STRIP001 	theSortData.bHasHeader		= aBtnHeader.IsChecked();
//STRIP001 	theSortData.bCaseSens		= aBtnCase.IsChecked();
//STRIP001 	theSortData.bIncludePattern = aBtnFormats.IsChecked();
//STRIP001 	theSortData.bInplace		= !aBtnCopyResult.IsChecked();
//STRIP001 	theSortData.nDestCol		= theOutPos.Col();
//STRIP001 	theSortData.nDestRow		= theOutPos.Row();
//STRIP001 	theSortData.nDestTab		= theOutPos.Tab();
//STRIP001 	theSortData.bUserDef		= aBtnSortUser.IsChecked();
//STRIP001 	theSortData.nUserIndex		= (aBtnSortUser.IsChecked())
//STRIP001 									? aLbSortUser.GetSelectEntryPos()
//STRIP001 									: 0;
//STRIP001 
//STRIP001 	// get locale
//STRIP001 	LanguageType eLang = aLbLanguage.GetSelectLanguage();
//STRIP001 	String sLangStr, sCountry;
//STRIP001 	if ( eLang != LANGUAGE_SYSTEM )
//STRIP001 		ConvertLanguageToIsoNames( eLang, sLangStr, sCountry );
//STRIP001 	lang::Locale aLocale( sLangStr, sCountry, ::rtl::OUString() );
//STRIP001 	theSortData.aCollatorLocale = aLocale;
//STRIP001 
//STRIP001 	// get algorithm
//STRIP001 	String sAlg;
//STRIP001 	if ( eLang != LANGUAGE_SYSTEM )
//STRIP001 	{
//STRIP001 		uno::Sequence<rtl::OUString> aAlgos = pColWrap->listCollatorAlgorithms( aLocale );
//STRIP001 		USHORT nSel = aLbAlgorithm.GetSelectEntryPos();
//STRIP001 		if ( nSel < aAlgos.getLength() )
//STRIP001 			sAlg = aAlgos[nSel];
//STRIP001 	}
//STRIP001 	theSortData.aCollatorAlgorithm = sAlg;
//STRIP001 
//STRIP001 	rArgSet.Put( ScSortItem( SCITEM_SORTDATA, &theSortData ) );
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// -----------------------------------------------------------------------

// fuer Datenaustausch ohne Dialog-Umweg: (! noch zu tun !)
// void ScTabPageSortOptions::ActivatePage( const SfxItemSet& rSet )
//STRIP001 void __EXPORT ScTabPageSortOptions::ActivatePage()
//STRIP001 {
//STRIP001 	if ( pDlg )
//STRIP001 	{
//STRIP001 		if ( aBtnHeader.IsChecked() != pDlg->GetHeaders() )
//STRIP001 		{
//STRIP001 			aBtnHeader.Check( pDlg->GetHeaders() );
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( aBtnTopDown.IsChecked() != pDlg->GetByRows() )
//STRIP001 		{
//STRIP001 			aBtnTopDown.Check( pDlg->GetByRows() );
//STRIP001 			aBtnLeftRight.Check( !pDlg->GetByRows() );
//STRIP001 		}
//STRIP001 
//STRIP001 		aBtnHeader.SetText( (pDlg->GetByRows())
//STRIP001 							? aStrColLabel
//STRIP001 							: aStrRowLabel );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 int __EXPORT ScTabPageSortOptions::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001 	BOOL bPosInputOk = TRUE;
//STRIP001 
//STRIP001 	if ( aBtnCopyResult.IsChecked() )
//STRIP001 	{
//STRIP001 		String		thePosStr = aEdOutPos.GetText();
//STRIP001 		ScAddress	thePos;
//STRIP001 		xub_StrLen	nColonPos = thePosStr.Search( ':' );
//STRIP001 
//STRIP001 		if ( STRING_NOTFOUND != nColonPos )
//STRIP001 			thePosStr.Erase( nColonPos );
//STRIP001 
//STRIP001 		if ( pViewData )
//STRIP001 		{
//STRIP001 			//	visible table is default for input without table
//STRIP001 			//	must be changed to GetRefTabNo when sorting has RefInput!
//STRIP001 			thePos.SetTab( pViewData->GetTabNo() );
//STRIP001 		}
//STRIP001 
//STRIP001 		USHORT nResult = thePos.Parse( thePosStr, pDoc );
//STRIP001 
//STRIP001 		bPosInputOk = ( SCA_VALID == (nResult & SCA_VALID) );
//STRIP001 
//STRIP001 		if ( !bPosInputOk )
//STRIP001 		{
//STRIP001 			ErrorBox( this, WinBits( WB_OK | WB_DEF_OK ),
//STRIP001 					 ScGlobal::GetRscString( STR_INVALID_TABREF )
//STRIP001 					).Execute();
//STRIP001 			aEdOutPos.GrabFocus();
//STRIP001 			aEdOutPos.SetSelection( Selection( 0, SELECTION_MAX ) );
//STRIP001 			theOutPos.Set(0,0,0);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aEdOutPos.SetText( thePosStr );
//STRIP001 			theOutPos = thePos;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pDlg && bPosInputOk )
//STRIP001 	{
//STRIP001 		pDlg->SetHeaders( aBtnHeader.IsChecked() );
//STRIP001 		pDlg->SetByRows ( aBtnTopDown.IsChecked() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSet && bPosInputOk )
//STRIP001 		FillItemSet( *pSet );
//STRIP001 
//STRIP001 	return bPosInputOk ? SfxTabPage::LEAVE_PAGE : SfxTabPage::KEEP_PAGE;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void ScTabPageSortOptions::FillUserSortListBox()
//STRIP001 {
//STRIP001 	ScUserList* pUserLists = ScGlobal::GetUserList();
//STRIP001 
//STRIP001 	aLbSortUser.Clear();
//STRIP001 	if ( pUserLists )
//STRIP001 	{
//STRIP001 		USHORT nCount = pUserLists->GetCount();
//STRIP001 		if ( nCount > 0 )
//STRIP001 			for ( USHORT i=0; i<nCount; i++ )
//STRIP001 				aLbSortUser.InsertEntry( (*pUserLists)[i]->GetString() );
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------
// Handler:

//STRIP001 IMPL_LINK( ScTabPageSortOptions, EnableHdl, CheckBox *, pBox )
//STRIP001 {
//STRIP001 	if ( pBox == &aBtnCopyResult )
//STRIP001 	{
//STRIP001 		if ( pBox->IsChecked() )
//STRIP001 		{
//STRIP001 			aLbOutPos.Enable();
//STRIP001 			aEdOutPos.Enable();
//STRIP001 			aEdOutPos.GrabFocus();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aLbOutPos.Disable();
//STRIP001 			aEdOutPos.Disable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if ( pBox == &aBtnSortUser )
//STRIP001 	{
//STRIP001 		if ( pBox->IsChecked() )
//STRIP001 		{
//STRIP001 			aLbSortUser.Enable();
//STRIP001 			aLbSortUser.GrabFocus();
//STRIP001 		}
//STRIP001 		else
//STRIP001 			aLbSortUser.Disable();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScTabPageSortOptions, SelOutPosHdl, ListBox *, pLb )
//STRIP001 {
//STRIP001 	if ( pLb == &aLbOutPos )
//STRIP001 	{
//STRIP001 		String	aString;
//STRIP001 		USHORT	nSelPos = aLbOutPos.GetSelectEntryPos();
//STRIP001 
//STRIP001 		if ( nSelPos > 0 )
//STRIP001 			aString = *(String*)aLbOutPos.GetEntryData( nSelPos );
//STRIP001 
//STRIP001 		aEdOutPos.SetText( aString );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScTabPageSortOptions, SortDirHdl, RadioButton *, pBtn )
//STRIP001 {
//STRIP001 	if ( pBtn == &aBtnTopDown )
//STRIP001 	{
//STRIP001 		aBtnHeader.SetText( aStrColLabel );
//STRIP001 	}
//STRIP001 	else if ( pBtn == &aBtnLeftRight )
//STRIP001 	{
//STRIP001 		aBtnHeader.SetText( aStrRowLabel );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void __EXPORT ScTabPageSortOptions::EdOutPosModHdl( Edit* pEd )
//STRIP001 {
//STRIP001 	if ( pEd == &aEdOutPos )
//STRIP001 	{
//STRIP001 		String	theCurPosStr = aEdOutPos.GetText();
//STRIP001 		USHORT	nResult = ScAddress().Parse( theCurPosStr, pDoc );
//STRIP001 
//STRIP001 		if ( SCA_VALID == (nResult & SCA_VALID) )
//STRIP001 		{
//STRIP001 			String*	pStr	= NULL;
//STRIP001 			BOOL	bFound	= FALSE;
//STRIP001 			USHORT	i		= 0;
//STRIP001 			USHORT	nCount	= aLbOutPos.GetEntryCount();
//STRIP001 
//STRIP001 			for ( i=2; i<nCount && !bFound; i++ )
//STRIP001 			{
//STRIP001 				pStr = (String*)aLbOutPos.GetEntryData( i );
//STRIP001 				bFound = (theCurPosStr == *pStr);
//STRIP001 			}
//STRIP001 
//STRIP001 			if ( bFound )
//STRIP001 				aLbOutPos.SelectEntryPos( --i );
//STRIP001 			else
//STRIP001 				aLbOutPos.SelectEntryPos( 0 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 IMPL_LINK( ScTabPageSortOptions, FillAlgorHdl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	aLbAlgorithm.SetUpdateMode( FALSE );
//STRIP001 	aLbAlgorithm.Clear();
//STRIP001 
//STRIP001 	LanguageType eLang = aLbLanguage.GetSelectLanguage();
//STRIP001 	if ( eLang == LANGUAGE_SYSTEM )
//STRIP001 	{
//STRIP001 		//	for LANGUAGE_SYSTEM no algorithm can be selected because
//STRIP001 		//	it wouldn't necessarily exist for other languages
//STRIP001 		//	-> leave list box empty if LANGUAGE_SYSTEM is selected
//STRIP001         aFtAlgorithm.Enable( FALSE );           // nothing to select
//STRIP001 		aLbAlgorithm.Enable( FALSE );			// nothing to select
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String sLangStr, sCountry;
//STRIP001 		ConvertLanguageToIsoNames( eLang, sLangStr, sCountry );
//STRIP001 
//STRIP001 		lang::Locale aLocale( sLangStr, sCountry, ::rtl::OUString() );
//STRIP001 		uno::Sequence<rtl::OUString> aAlgos = pColWrap->listCollatorAlgorithms( aLocale );
//STRIP001 
//STRIP001 		long nCount = aAlgos.getLength();
//STRIP001 		const ::rtl::OUString* pArray = aAlgos.getConstArray();
//STRIP001 		for (long i=0; i<nCount; i++)
//STRIP001 		{
//STRIP001 			String sAlg = pArray[i];
//STRIP001 			String sUser = pColRes->GetTranslation( sAlg );
//STRIP001 			aLbAlgorithm.InsertEntry( sUser, LISTBOX_APPEND );
//STRIP001 		}
//STRIP001 		aLbAlgorithm.SelectEntryPos( 0 );		// first entry is default
//STRIP001         aFtAlgorithm.Enable( nCount > 1 );      // enable only if there is a choice
//STRIP001 		aLbAlgorithm.Enable( nCount > 1 );		// enable only if there is a choice
//STRIP001 	}
//STRIP001 
//STRIP001 	aLbAlgorithm.SetUpdateMode( TRUE );
//STRIP001 	return 0;
//STRIP001 }


}
