package com.sun.star.help;

import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.util.*;
import com.sun.star.io.*;
import com.sun.star.lang.*;
import com.sun.star.ucb.*;
import com.sun.star.sdbc.*;
import com.sun.star.beans.*;
import com.sun.star.container.*;

import com.sun.xmlsearch.util.*;
import com.sun.xmlsearch.xml.qe.*;


// superclass for all resultsets

public abstract class HelpResultSetBase
	implements XComponent,com.sun.star.sdbc.XCloseable,XPropertySet,XContentAccess,XRow,XResultSet,XResultSetMetaDataSupplier
{

 	// Methods to be overwritten

	// Returns the URL of the document for the current Row; Sets ret();

	// Returns null, if no valid DocumentURL is found
	public abstract String getDocumentURL();
	public abstract int    getLength();
	public abstract Object getVal( int i );

 	private boolean      m_bWasNull;
	protected int          m_nRow = -1;
	private HelpProvider m_xProvider;
 	protected Property[]   m_xProperties;
  	protected HelpURLParameter m_xParameter;


 	public HelpResultSetBase( HelpProvider xProvider,Property[] xProperties,HelpURLParameter xParameter )
  	{
   		m_xProvider = xProvider;
     	m_xProperties = xProperties;
      	m_xParameter = xParameter;
   	}

   	// XComponent
	public void addEventListener(XEventListener p0) throws RuntimeException
 	{// ready
  	}


  	public void dispose() throws RuntimeException
   	{// ready
    }


  	public void removeEventListener(XEventListener p0) throws RuntimeException
   	{// ready
    }


    // XCloseable
    public void close() throws SQLException, RuntimeException
    {  // ready
    }


    // XPropertySet
  	public void addPropertyChangeListener(String p0, XPropertyChangeListener p1)
   		throws UnknownPropertyException, WrappedTargetException, RuntimeException
    {	// ready
    }


  	public void addVetoableChangeListener(String p0, XVetoableChangeListener p1)
   		throws UnknownPropertyException, WrappedTargetException, RuntimeException
	{	// ready
 	}


  	final class XPropertySetInfoImpl implements XPropertySetInfo
   	{//ready
  		public Property[] getProperties() throws com.sun.star.uno.RuntimeException
    	{
			Property props[] = new Property[2];
     		try
       		{
   				props[0] = getPropertyByName( "IsRowCountFinal" );
   				props[1] = getPropertyByName( "RowCount" );
       		}
         	catch( UnknownPropertyException e )
          	{
           		//
           	}
            return props;
     	}


  		public Property getPropertyByName(String p0) throws UnknownPropertyException,com.sun.star.uno.RuntimeException
    	{
//       		try
//         		{
			if( p0.equals( "IsRowCountFinal" ) )
				return new Property( p0,-1,new Type( TypeClass.BOOLEAN ),PropertyAttribute.READONLY );
			else if( p0.equals( "RowCount" ) )
				return new Property( p0,-1,new Type( TypeClass.LONG ),PropertyAttribute.READONLY );
			else
				throw new UnknownPropertyException();
	//	}
//  		catch( com.sun.star.uno.Exception e )
//            	{
//             	}
		// return new Property();
     	}


  		public boolean hasPropertyByName(String p0) throws com.sun.star.uno.RuntimeException
    	{
     		if( p0.equals( "IsRowCountFinal" ) )
       			return true;
          	else if( p0.equals( "RowCount" ) )
           		return true;
			else
   				return false;
     	}
    }


  	public synchronized XPropertySetInfo getPropertySetInfo()
   		throws RuntimeException
    {//ready
    	return new XPropertySetInfoImpl();
    }


  	public synchronized Object getPropertyValue(String p0)
   		throws UnknownPropertyException, WrappedTargetException, RuntimeException
    {//ready
    	if( p0.equals( "RowCount" ) )
     		return new Integer( getLength() );
       	else if( p0.equals( "IsRowCountFinal" ) )
        	return new Boolean( true );
        else
        	throw new UnknownPropertyException( p0 );
    }


  	public synchronized void removePropertyChangeListener(String p0, XPropertyChangeListener p1)
   		throws UnknownPropertyException, WrappedTargetException, RuntimeException
    {//ready
    }


  	public synchronized void removeVetoableChangeListener(String p0, XVetoableChangeListener p1)
   		throws UnknownPropertyException, WrappedTargetException, RuntimeException
    {//ready
    }


  	public synchronized void setPropertyValue(String p0, Object p1)
   		throws UnknownPropertyException, PropertyVetoException, com.sun.star.lang.IllegalArgumentException, WrappedTargetException, RuntimeException
    {//ready
    }


    // XContentAccess
  	public synchronized XContent queryContent()
   		throws RuntimeException
    {//ready
      	HelpContentIdentifier id = ( HelpContentIdentifier ) queryContentIdentifier();
       	if( id == null )
        	return null;
        else
    		return new HelpContent( m_xProvider,id );
    }


  	public synchronized String queryContentIdentifierString() throws RuntimeException
   	{//ready
    	String str = getDocumentURL();
		return str;
    }


  	public synchronized XContentIdentifier queryContentIdentifier() throws RuntimeException
   	{//ready
		HelpContentIdentifier id = null;
    	try
     	{
         	String doc = getDocumentURL();
			if( doc != null )
				id = new HelpContentIdentifier( doc,m_xParameter.get_language() );
        }
        catch( IllegalIdentifierException e )
        {
        }
		return id;
    }


 	// XRow
  	public synchronized XArray getArray(int p0) throws SQLException, RuntimeException
    {
		XArray val;
  		try
    	{
	  		val = ( XArray ) getVal( --p0 );
     	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


  	public synchronized XInputStream getBinaryStream(int p0) throws SQLException, RuntimeException
    {
		XInputStream val;
  		try
    	{
    		val = ( XInputStream ) getVal( --p0 );
      	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized XBlob getBlob(int p0) throws SQLException, RuntimeException
    {
		XBlob val;
  		try
    	{
    		val = ( XBlob ) getVal( --p0 );
      	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized boolean getBoolean(int p0) throws SQLException, RuntimeException
    {
		Boolean val;
  		try
    	{
     		val = ( Boolean ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return false;
        else
    		return val.booleanValue();
    }


   	public synchronized byte getByte(int p0) throws SQLException, RuntimeException
    {
		Byte val;
  		try
    	{
     		val = ( Byte ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return ( byte ) 0;
        else
    		return val.byteValue();
    }


   	public synchronized byte[] getBytes(int p0) throws SQLException, RuntimeException
    {
		byte[] val;
  		try
    	{
     		val = ( byte[] ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized XInputStream getCharacterStream(int p0) throws SQLException, RuntimeException
    {
		XInputStream val;
  		try
    	{
     		val = ( XInputStream ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized XClob getClob(int p0) throws SQLException, RuntimeException
    {
    	XClob val;
    	try
     	{
			val = ( XClob ) getVal( --p0 );
   		}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized Date getDate(int p0) throws SQLException, RuntimeException
    {
		Date val;
  		try
    	{
     		val = ( Date ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized double getDouble(int p0) throws SQLException, RuntimeException
    {
		Double val;
  		try
    	{
     		val = ( Double ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return ( double ) 0;
        else
    		return val.doubleValue();
    }


   	public synchronized float getFloat(int p0) throws SQLException, RuntimeException
    {
		Float val;
  		try
    	{
     		val = ( Float ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return ( float ) 0;
        else
    		return val.floatValue();
    }


  	public synchronized int getInt(int p0) throws SQLException, RuntimeException
   	{
    	Integer val;
    	try
     	{
			val = ( Integer ) getVal( --p0 );
   		}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return ( int ) 0;
        else
    		return val.intValue();
    }


   	public synchronized long getLong(int p0) throws SQLException, RuntimeException
    {
		Long val;
  		try
    	{
     		val = ( Long ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return ( long ) 0;
        else
    		return val.longValue();
    }


   	public synchronized Object getObject(int p0, XNameAccess p1) throws SQLException, RuntimeException
    {
		Object val = getVal( --p0 );
  		m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized XRef getRef(int p0) throws SQLException, RuntimeException
    {
		XRef val;
  		try
    	{
     		val = ( XRef ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized short getShort(int p0) throws SQLException, RuntimeException
    {
		Short val;
  		try
    	{
     		val = ( Short ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
     	if( m_bWasNull )
      		return ( short ) 0;
      	else
    		return val.shortValue();
    }


   	public synchronized String getString(int p0) throws SQLException, RuntimeException
    {
		try
  		{
    		String val = ( String ) getVal( --p0 );
    		m_bWasNull = ( val == null );
     		if( m_bWasNull )
      			return new String();
    		return val;
      	}
       	catch( Exception e )
        {
        	m_bWasNull = true;
         	return new String();
        }
    }


   	public synchronized Time getTime(int p0) throws SQLException, RuntimeException
    {
		Time val;
  		try
    	{
     		val = ( Time ) getVal( --p0 );
       	}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
		if( m_bWasNull = ( val == null ) )
			return new Time();
		else
			return val;
    }


   	public synchronized DateTime getTimestamp(int p0) throws SQLException, RuntimeException
    {
    	DateTime val;
    	try
     	{
			val = ( DateTime ) getVal( --p0 );
   		}
      	catch( java.lang.ClassCastException e )
       	{
        	val = null;
        }
    	m_bWasNull = ( val == null );
    	return val;
    }


   	public synchronized boolean wasNull() throws SQLException, RuntimeException
    {
    	return m_bWasNull;
    }


    // XResultSet
  	public synchronized boolean absolute(int p0) throws SQLException, RuntimeException// Done
   	{
		m_nRow = p0;
  		if( m_nRow < -1 ) m_nRow = -1;
    	if( m_nRow > getLength() ) m_nRow = getLength();
     	return ret();
    }


  	public synchronized void afterLast() throws SQLException, RuntimeException        // Done
   	{
    	m_nRow = getLength();
     	if( m_nRow == 0 ) m_nRow = -1;
    }

  	public synchronized void beforeFirst() throws SQLException, RuntimeException      // Done
   	{
    	m_nRow = -1;
    }

  	public synchronized boolean first() throws SQLException, RuntimeException         // Done
   	{
    	if( getLength() > 0 )
    		m_nRow = 0;
    	return ret();
    }

  	public synchronized int getRow() throws SQLException, RuntimeException            // Done
   	{
    	if( ret() )
     		return m_nRow + 1;
       	else
        	throw new SQLException();
    }

  	public synchronized Object getStatement() throws SQLException, RuntimeException   // Done
   	{
    	return null;
    }

  	public synchronized boolean isAfterLast() throws SQLException, RuntimeException   // Done
   	{
    	return m_nRow == getLength();
    }

  	public synchronized boolean isBeforeFirst() throws SQLException, RuntimeException // Done
   	{
    	return m_nRow == -1;
    }

  	public synchronized boolean isFirst() throws SQLException, RuntimeException       // Done
   	{
    	return m_nRow == 0;
    }

  	public synchronized boolean isLast() throws SQLException, RuntimeException        // Done
   	{
    	return m_nRow == ( getLength() - 1 ) && m_nRow != -1;
    }

  	public synchronized boolean last() throws SQLException, RuntimeException          // Done
   	{
    	m_nRow = getLength() - 1;
     	return ret();
    }

  	public synchronized boolean next() throws SQLException, RuntimeException          // Done
   	{
		if( ++m_nRow > getLength() )
  			m_nRow = getLength();
  		return ret();
    }

  	public synchronized boolean previous() throws SQLException, RuntimeException      // Done
   	{
    	if( --m_nRow < -1 ) m_nRow = -1;
		return ret();
    }

  	public synchronized void refreshRow() throws SQLException, RuntimeException       // Done
   	{
    }

  	public synchronized boolean relative(int p0) throws SQLException, RuntimeException// Done
   	{
    	m_nRow += p0;
		if( m_nRow < -1 )  m_nRow = -1;
  		if( m_nRow > getLength() )
    		m_nRow = getLength();
    	return ret();
    }

  	public synchronized boolean rowDeleted() throws SQLException, RuntimeException    // Done
   	{
    	return false;
    }

  	public synchronized boolean rowInserted() throws SQLException, RuntimeException   // Done
   	{
    	return false;
    }

  	public synchronized boolean rowUpdated() throws SQLException, RuntimeException    // Done
   	{
    	return false;
    }


    // XResultSetMetaData

    private final class XResultSetMetaDataImpl implements XResultSetMetaData
    {
		public XResultSetMetaDataImpl()
  		{

		}

  		public String getCatalogName(int p0) throws SQLException, RuntimeException
    	{
     		return new String( "Result of help query" );
     	}


  		public int getColumnCount() throws SQLException, RuntimeException
    	{
     		return m_xProperties.length;
     	}

  		public int getColumnDisplaySize(int p0) throws SQLException, RuntimeException
  		{
    		return 10;
		}

  		public String getColumnLabel(int p0) throws SQLException, RuntimeException
  		{
    		return m_xProperties[--p0].Name;
		}

  		public String getColumnName(int p0) throws SQLException, RuntimeException
  		{
    		return m_xProperties[--p0].Name;
		}

  		public String getColumnServiceName(int p0) throws SQLException, RuntimeException
  		{
			return new String( "" );
		}

  		public int getColumnType(int p0) throws SQLException, RuntimeException
  		{
			return m_xProperties[--p0].Type.hashCode();   // definetly not very sensitive
		}

  		public String getColumnTypeName(int p0) throws SQLException, RuntimeException
  		{
			return m_xProperties[--p0].Type.getTypeName();
		}

  		public int getPrecision(int p0) throws SQLException, RuntimeException
  		{
    		return 0;
		}

  		public int getScale(int p0) throws SQLException, RuntimeException
  		{
			return 0;
		}

  		public String getSchemaName(int p0) throws SQLException, RuntimeException
  		{
    		return new String( "" );
		}

  		public String getTableName(int p0) throws SQLException, RuntimeException
  		{
    		return m_xProperties[--p0].Name;
		}

  		public boolean isAutoIncrement(int p0) throws SQLException, RuntimeException
  		{
    		return false;
		}

  		public boolean isCaseSensitive(int p0) throws SQLException, RuntimeException
  		{
    		return true;
		}

  		public boolean isCurrency(int p0) throws SQLException, RuntimeException
  		{
    		return false;
		}

  		public boolean isDefinitelyWritable(int p0) throws SQLException, RuntimeException
  		{
    		return false;
		}

  		public int isNullable(int p0) throws SQLException, RuntimeException
  		{
    		return 0;
		}

  		public boolean isReadOnly(int p0) throws SQLException, RuntimeException
  		{
    		return true;
		}

  		public boolean isSearchable(int p0) throws SQLException, RuntimeException
  		{
    		return false;
		}

  		public boolean isSigned(int p0) throws SQLException, RuntimeException
  		{
    		return false;
		}

  		public boolean isWritable(int p0) throws SQLException, RuntimeException
  		{
    		return false;
		}
    }

    public synchronized XResultSetMetaData getMetaData() throws SQLException,RuntimeException
    {
    	return new XResultSetMetaDataImpl();
    }

    protected synchronized boolean ret()                                                 //Done
    {
    	return ( 0 <= m_nRow && m_nRow < getLength() );
    }

}
